<?php

namespace App\Http\Controllers;

use App\Brands;
use App\Business;
use App\Category;
use App\Product;
use App\ProductVariation;
use App\PurchaseLine;
use App\Transaction;
use App\Unit;
use App\Variation;
use App\VariationLocationDetails;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ShopifyControllerUdb extends Controller
{
    public function auth(Request $request)
    {
        // dd($request->all());
        $product_locations = array($request->input('product_locations')); 
        if(empty($product_locations)) {
          return response()->json([
            'message' => 'Location must be selected',
            'data' => null
          ]);
        }       
        $checkmarks = $request->input('checkmarks');
        if(empty($checkmarks)) {
            return response()->json([
                'message' => 'Please Selected Sync Item First',
                'data' => null
            ]);
        }
        
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

        $array_empty = [];
        $array_insert = [];
                
        /* $e_commerce_settings = json_decode($business->e_commerce_settings);

        if($e_commerce_settings->shopify_api_url) {
          // $SHOPIFY_URL = getenv("SHOPIFY_URL");
          $SHOPIFY_URL = $e_commerce_settings->shopify_api_url;
          // $SHOPIFY_CRED = getenv("SHOPIFY_CRED");        
          // $SHOPIFY_CRED = $e_commerce_settings->shopify_api_access_token;        
        } else {
          return 'Url and Access Token Shopify Not Found';
        } */

        $SHOPIFY_URL1 = 'https://used-book-depot-com.myshopify.com';
        $SHOPIFY_URL2 = 'https://cheapbookdepots.myshopify.com';
        $SHOPIFY_CRED1 = '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';
        $SHOPIFY_CRED2 = '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';
        $STORE1 = 'UsedBookDepot';
        $STORE2 = 'CheapBookDepot';
    
        for ($i=1; $i <= 2; $i++) { 
          # code...          
          // dd(${'SHOPIFY_URL'.$i}, ${'SHOPIFY_CRED'.$i});
          try 
          {
              $curl = curl_init();
              curl_setopt_array(
                  $curl,
                  array(
                  CURLOPT_URL => ${'SHOPIFY_URL'.$i} . "/admin/api/2022-10/products.json?limit=200",
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => "",
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 0,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => "GET",
                  CURLOPT_HTTPHEADER => array(
                      'Content-Type: application/json',
                      'X-Shopify-Access-Token: '. ${'SHOPIFY_CRED'.$i}
                  )
              
                  )
              );
              
              // call back function to parse Headers and get Next Page Link
              curl_setopt(
                $curl,
                CURLOPT_HEADERFUNCTION,
                function($curl, $header) use (&$nextPage) {
                    $len = strlen($header);
                    $header = explode(':', $header, 2);
  
                    if (count($header) < 2) // ignore invalid headers
                    return $len;
  
                    if (trim($header[0]) === "Link" && strpos($header[1], 'next') !== false) {
                        $links = explode(',', $header[1], 2);
  
                        $link = count($links) === 2 ? $links[1] : $links[0];
                        if (preg_match('/<(.*?)>/', $link, $match) === 1) $nextPage = $match[1];
                    }
  
                    return $len;
                }
              );
  
              $response = curl_exec($curl);            
              
              if (curl_errno($curl)) {
                $error_msg = curl_error($curl);
                print_r($error_msg);
                $log = fopen('../sample/sresult.json','a');
                fwrite($log,"\ncurl_error81\n");
                fclose($log);
              }
  
              $parsedResponse = json_decode($response);            
              // dd($parsedResponse->products[0]);
              $products = json_decode(json_encode($parsedResponse->products), true);
              // return $products;
              $randomNumber = $this->generateRandomString(10);            
              // dd($products); 
              // return $products;                     
              $responseSaveProducts = $this->saveProducts($products, $randomNumber, $product_locations, $checkmarks, ${'STORE'.$i}, $request);  
              array_push($array_insert, $responseSaveProducts); 
              // var_dump()       
  
  
            while ($nextPage !== NULL) 
            {
              // dd($nextPage, CURLOPT_URL, $curl);
              curl_setopt($curl, CURLOPT_URL, $nextPage);
              $parsedResponse->products = [];
              $nextPage = NULL;
  
              $response = curl_exec($curl);
              $parsedResponse = json_decode($response);
              
              if (curl_errno($curl)) {
                  $error_msg = curl_error($curl);
                  print_r($error_msg);
                  // $log = fopen('../sample/sresult.json','a');
                  // fwrite($log,"\ncurl_error102\n");
                  // fclose($log);
              } else {
                  //$result = array_merge($result, $parsedResponse->products);
                  $products = json_decode(json_encode($parsedResponse->products), true);
                  //echo "Product count : " . count($products) . "\n";
                  $randomNumber = $this->generateRandomString(10); 
                  $responseSaveProducts = $this->saveProducts($products, $randomNumber, $product_locations, $checkmarks, ${'STORE'.$i}, $request);
                  array_push($array_insert, $responseSaveProducts);
                  sleep(2);
              }
            };
  
            curl_close($curl);
            // return $products;                                              
          } catch (Exception $err) {
            // dd($err);
            return response()->json([
              'message' => $err->getMessage(),
              // 'message' => __('messages.something_went_wrong'),
              'data' => null
            ]);
          }
        }

        $body['shopify_checkbox'] = json_encode($checkmarks);  
        $business = Business::find($business_id);         
        $business->fill($body);
        $business->save();
        if($array_insert) {
          return response()->json([
              'message' => 'Recevied Data Success',
              'data' => $array_insert
          ]);
        } else {
            return response()->json([
                'message' => 'Data Not Found',
                'data' => null
            ]);
        }

    }

    public static function saveProducts($products, $randomNumber, $product_locations, $checkmarks, $name, Request $request) 
    {
      $column = 'products.cheap_book_id';
      if($name == 'UsedBookDepot') {
        $column = 'products.used_book_id';
      }
      DB::beginTransaction();
      $business_id = request()->session()->get('user.business_id');
      /* $checkProductLocation = Product::join('variation_location_details as vld', 'vld.product_id', '=', 'products.id')
      ->join('business_locations as bl', 'bl.id', '=', 'vld.location_id')
      ->whereNotNull($column)
      ->select('products.id', 'products.name', 'bl.id as location_id', 'vld.variation_id')
      ->first();
      if(!empty($checkProductLocation) && $checkProductLocation->location_id != $product_locations[0]) {
          $deleteTransactions = DB::select("delete transactions from transactions join products on products.id = transactions.opening_stock_product_id and transactions.location_id = ? where ".$column." is not null", [$checkProductLocation->location_id]);                    
          $deleteVariationLocationDetails = DB::select("delete variation_location_details from variation_location_details join products on products.id = variation_location_details.product_id and variation_location_details.location_id = ? where ".$column." is not null", [$checkProductLocation->location_id]);                  
          DB::select("delete purchase_lines from purchase_lines join products on products.id = purchase_lines.product_id where ".$column." is not null");          
          DB::select("delete product_locations from product_locations join products on products.id = product_locations.product_id where ".$column." is not null");          
          DB::select("delete variations from variations join products on products.id = variations.product_id where ".$column." is not null");          
          DB::select("delete from products where ".$column." is not null");
      } */
      if($products) {
        $no = 0;
        $arr = [];
        $status = '';        
        try {
          //code...
          foreach ($products as $key => $value) {
            //echo "Coming product shopify id : " . $value['id'] . ' - ';
            
            # code...
            $checkBrand = Brands::whereRaw("lower(name) = ?", $value['vendor'])->where('business_id', $business_id)->first();
            if($checkBrand == null) {
              $b = new Brands();
              $b->business_id = $business_id;
              $b->name = $value['vendor'];
              $b->description = null;
              $b->created_by = auth()->user()->id;
              if($name == 'UsedBookDepot') {
                $b->used_book_id = $value['id'];
              } else {
                $b->cheap_book_id = $value['id'];
              }
              $b->save();
  
              $brandId = $b->id;
            } else {
              $brandId = $checkBrand->id;
            }
  
            $checkCategory = Category::whereRaw("lower(name) = ?", $value['product_type'])->where('business_id', $business_id)->first();
            if($checkCategory == null) {
              $c = new Category();
              $c->name = $value['product_type'];
              $c->business_id = $business_id;
              $c->parent_id = 0;
              $c->created_by = auth()->user()->id;
              $c->category_type = 'product';
              if($name == 'UsedBookDepot') {
                $c->used_book_id = $value['id'];
              } else {
                $c->cheap_book_id = $value['id'];
              }
              $c->save();
              $categoryId = $c->id;
            } else {  
              $categoryId = $checkCategory->id;
            }
  
            $checkUnit = Unit::whereRaw("lower(actual_name) = ?", $value['variants'][0]['weight_unit'])->where('business_id', $business_id)->first();
            if($checkUnit == null) {
              $u = new Unit();
              $u->business_id = $business_id;
              $u->actual_name = $value['variants'][0]['weight_unit'];
              $u->short_name = $value['variants'][0]['weight_unit'];
              $u->created_by = auth()->user()->id;
              $u->save();
              $unitId = $u->id;
            } else {
              $unitId = $checkUnit->id;
            }     
            
            $checkProduct = Product::where('shopify_id', $value['id'])->first();
            if($checkProduct == null) {
              $p = new Product();
              $p->name = $value['title'];
              $p->business_id = $business_id;
              $p->type = 'single';
              $p->enable_stock = 1;
              $p->tax_type = 'exclusive';
              $p->unit_id = $unitId;
              $p->brand_id = $brandId;
              $p->category_id = $categoryId;
              $p->alert_quantity = 1;
              $p->sku = $value['variants'][0]['sku'] ? $value['variants'][0]['sku'] : ' ';
              $p->barcode = $value['variants'][0]['barcode'] ? $value['variants'][0]['barcode'] : ' ';
              $p->created_by = auth()->user()->id;
              $p->product_description = $value['body_html'];
              if($name == 'UsedBookDepot') {
                $p->used_book_id = $value['id'];
              } else {
                $p->cheap_book_id = $value['id'];
              }              
              $p->image = $value['image'] ? $value['image']['src'] : null;
              $p->save();
  
              if(! empty($product_locations)) {
                $p->product_locations()->sync($product_locations);
              }
  
              $pv = new ProductVariation();
              $pv->name = $value['variants'][0]['title'];
              $pv->product_id = $p->id;
              $pv->is_dummy = 0;
              $pv->created_at = Carbon::now();
              $pv->save();
  
              $v = new Variation();
              $v->name = $value['variants'][0]['title'];
              $v->product_id = $p->id;
              $v->sub_sku = $value['variants'][0]['sku'];
              $v->product_variation_id = $pv->id;
              $v->default_sell_price = $value['variants'][0]['price'];
              $v->sell_price_inc_tax = $value['variants'][0]['price'];
              $v->save();
              
              if(! empty($product_locations)) {
                if(count($product_locations) > 1) {
                  $qty_divide = $value['variants'][0]['inventory_quantity'] / 1;
                  foreach ($product_locations as $val) {
                    # code...
                    $vld = new VariationLocationDetails();
                    $vld->product_id = $p->id;
                    $vld->product_variation_id = $pv->id;
                    $vld->variation_id = $v->id;
                    $vld->location_id = $val;
                    $vld->qty_available = $qty_divide;
                    $vld->save();
  
                    $transaction = new Transaction();
                    $transaction->business_id = $business_id;
                    $transaction->location_id = $val;
                    $transaction->type = 'opening_stock';
                    $transaction->status = 'received';
                    $transaction->is_quotation = 0;
                    $transaction->payment_status = 'paid';
                    $transaction->transaction_date = Carbon::now();
                    $transaction->total_before_tax = 0;
                    $transaction->tax_amount = 0;
                    $transaction->discount_amount = 0;
                    $transaction->rp_redeemed = 0;
                    $transaction->rp_redeemed_amount = 0;
                    $transaction->shipping_charges = 0;
                    $transaction->is_export = 0;
                    $transaction->round_off_amount = 0;
                    $transaction->additional_expense_value_1 = 0;
                    $transaction->additional_expense_value_2 = 0;
                    $transaction->additional_expense_value_3 = 0;
                    $transaction->additional_expense_value_4 = 0;
                    $transaction->final_total = 0;
                    $transaction->is_direct_sale = 0;
                    $transaction->is_suspend = 0;
                    $transaction->exchange_rate = 1;
                    $transaction->opening_stock_product_id = $p->id;
                    $transaction->created_by = auth()->user()->id;
                    $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                    $transaction->is_created_from_api = 1;
                    $transaction->rp_earned = 0;
                    $transaction->is_recurring = 0;
  
                    $transaction->save();
  
                    $purchase_lines = new PurchaseLine();
                    $purchase_lines->transaction_id = $transaction->id;
                    $purchase_lines->product_id = $p->id;
                    $purchase_lines->variation_id = $v->id;
                    $purchase_lines->quantity = $qty_divide;
                    $purchase_lines->purchase_price = 0;
                    $purchase_lines->save();
                  }
                } else {
                  $vld = new VariationLocationDetails();
                  $vld->product_id = $p->id;
                  $vld->product_variation_id = $pv->id;
                  $vld->variation_id = $v->id;
                  $vld->location_id = $product_locations[0];
                  $vld->qty_available = $value['variants'][0]['inventory_quantity'];
                  $vld->save();
  
                  $transaction = new Transaction();
                  $transaction->business_id = $business_id;
                  $transaction->location_id = $product_locations[0];
                  $transaction->type = 'opening_stock';
                  $transaction->status = 'received';
                  $transaction->is_quotation = 0;
                  $transaction->payment_status = 'paid';
                  $transaction->transaction_date = Carbon::now();
                  $transaction->total_before_tax = 0;
                  $transaction->tax_amount = 0;
                  $transaction->discount_amount = 0;
                  $transaction->rp_redeemed = 0;
                  $transaction->rp_redeemed_amount = 0;
                  $transaction->shipping_charges = 0;
                  $transaction->is_export = 0;
                  $transaction->round_off_amount = 0;
                  $transaction->additional_expense_value_1 = 0;
                  $transaction->additional_expense_value_2 = 0;
                  $transaction->additional_expense_value_3 = 0;
                  $transaction->additional_expense_value_4 = 0;
                  $transaction->final_total = 0;
                  $transaction->is_direct_sale = 0;
                  $transaction->is_suspend = 0;
                  $transaction->exchange_rate = 1;
                  $transaction->opening_stock_product_id = $p->id;
                  $transaction->created_by = auth()->user()->id;
                  $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                  $transaction->is_created_from_api = 1;
                  $transaction->rp_earned = 0;
                  $transaction->is_recurring = 0;
  
                  $transaction->save();
  
                  $purchase_lines = new PurchaseLine();
                  $purchase_lines->transaction_id = $transaction->id;
                  $purchase_lines->product_id = $p->id;
                  $purchase_lines->variation_id = $v->id;
                  $purchase_lines->quantity = $value['variants'][0]['inventory_quantity'];
                  $purchase_lines->purchase_price = 0;
                  $purchase_lines->save();
                }
              }
  
              $no++;
              $status = 1;
              array_push($arr, [
                  'number' => $no,
                  'status' => $status
              ]);
            } else {            
              $checkmarks_arr = [];
              foreach ($checkmarks as $key => $val) {
                array_push($checkmarks_arr, $val['value']);
              }
              
                $nameProduct =  $checkProduct->name == $value['title'] ? $checkProduct->name : $value['title'];
                $brand_id =  $checkProduct->brand_id == $brandId ? $checkProduct->brand_id : $brandId;
                $category_id = $checkProduct->category_id == $categoryId ? $checkProduct->category_id : $categoryId;
                $alert_qty = $checkProduct->alert_quantity == $value['variants'][0]['inventory_quantity'] ? $checkProduct->alert_quantity : $value['variants'][0]['inventory_quantity'];
                $description = $checkProduct->product_description == $value['body_html'] ? $checkProduct->product_description : $value['body_html'];            
                $valueSku = $value['variants'][0]['sku'] ? $value['variants'][0]['sku'] : ' ';
                $sku = $checkProduct->sku == $valueSku ? $checkProduct->sku : $valueSku;
                $valueBarcode = $value['variants'][0]['barcode'] ? $value['variants'][0]['barcode'] : ' ';
                $barcode = $checkProduct->barcode == $valueBarcode ? $checkProduct->barcode : $valueBarcode;
                $image = $value['image'] ? $value['image']['src'] : null;           
                
                $checkVariation = Variation::where('product_id', $checkProduct->id)->first(); 
                $statusVariation = null;                             
                if($checkVariation) {
                  $nameVariation = $checkVariation->name == $value['variants'][0]['title'] ? $checkVariation->name : $value['variants'][0]['title'];
                  $subSku = $checkVariation->sub_sku == $value['variants'][0]['sku'] ? $checkVariation->sub_sku : $value['variants'][0]['sku'];
                  $price = $checkVariation->default_sell_price == $value['variants'][0]['price'] ? $checkVariation->default_sell_price : $value['variants'][0]['price'];
      
                  /* $variation = Variation::where('product_id', $checkProduct->id)->update([
                    'name' => $nameVariation,
                    'sub_sku' => $subSku,
                    'default_sell_price' => $price,
                    'sell_price_inc_tax' => $price
                  ]); */
  
                  $variation = Variation::find($checkVariation->id);
                  $variation->name = $nameVariation;
                  $variation->sub_sku = $subSku;
                  if(in_array("default_sell_price", $checkmarks_arr)) {
                      $variation->default_sell_price = $price;
                      $variation->sell_price_inc_tax = $price;
                  }
                  
                  $variation->save();

                  $statusVariation = $variation->wasChanged();
                  
                }
                
                if($product_locations) {                
                  // if(count($product_locations) != count($checkProductQty)) {
                    // VariationLocationDetails::where('product_id', $checkProduct->id)->delete();
                    if(! empty($product_locations)) {
                      $productVariation = ProductVariation::where('product_id', $checkProduct->id)->select('id')->first();                    
                      foreach ($product_locations as $locval) {                      
                          # code...
                          $checkProductQty = VariationLocationDetails::where('product_id', $checkProduct->id)->where('location_id', $locval)->first();                        
                          $qty_divide = $value['variants'][0]['inventory_quantity'] / 1;
                          if($checkProductQty) {                                                    
                            if($checkProductQty->qty_available != $qty_divide) {
                              $vld = VariationLocationDetails::find($checkProductQty->id);
                              $vld->qty_available = $qty_divide;
                              $vld->save();               

                              $checkPurcasheLine = PurchaseLine::where('variation_id', $checkProductQty->variation_id)->where('product_id', $checkProduct->id)->first();
                              if($checkPurcasheLine == null) {
                                $transaction = new Transaction();
                                $transaction->business_id = $business_id;
                                $transaction->location_id = $locval;
                                $transaction->type = 'opening_stock';
                                $transaction->status = 'received';
                                $transaction->is_quotation = 0;
                                $transaction->payment_status = 'paid';
                                $transaction->transaction_date = Carbon::now();
                                $transaction->total_before_tax = 0;
                                $transaction->tax_amount = 0;
                                $transaction->discount_amount = 0;
                                $transaction->rp_redeemed = 0;
                                $transaction->rp_redeemed_amount = 0;
                                $transaction->shipping_charges = 0;
                                $transaction->is_export = 0;
                                $transaction->round_off_amount = 0;
                                $transaction->additional_expense_value_1 = 0;
                                $transaction->additional_expense_value_2 = 0;
                                $transaction->additional_expense_value_3 = 0;
                                $transaction->additional_expense_value_4 = 0;
                                $transaction->final_total = 0;
                                $transaction->is_direct_sale = 0;
                                $transaction->is_suspend = 0;
                                $transaction->exchange_rate = 1;
                                $transaction->opening_stock_product_id = $checkProduct->id;
                                $transaction->created_by = auth()->user()->id;
                                $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                $transaction->is_created_from_api = 1;
                                $transaction->rp_earned = 0;
                                $transaction->is_recurring = 0;
      
                                $transaction->save();
      
                                $purchase_lines = new PurchaseLine();
                                $purchase_lines->transaction_id = $transaction->id;
                                $purchase_lines->product_id = $checkProduct->id;
                                $purchase_lines->variation_id = $variation->id;
                                $purchase_lines->quantity = $qty_divide;
                                $purchase_lines->purchase_price = 0;
                                $purchase_lines->save();
                              } else {                                
                                $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                $purchase_lines->exp_date = null;
                                $purchase_lines->quantity = $qty_divide;
                                $purchase_lines->save();
                              }
                            }
                          } else {                     
                            /* $getTransactionPurchaseLinesLast = PurchaseLine::join('transactions as t', 't.id', '=', 'purchase_lines.transaction_id')
                                    ->where('purchase_lines.product_id', $checkProduct->id)
                                    ->where('purchase_lines.variation_id', $checkVariation->id)
                                    ->where('t.type', '=', 'opening_stock')
                                    ->where('t.business_id', $business_id)
                                    ->where('t.location_id', '<>', $locval)
                                    ->select('purchase_lines.*')
                                    ->orderBy('t.created_at', 'desc')->first();                                                    
                            if($getTransactionPurchaseLinesLast) {
                              $purchase_lines = PurchaseLine::find($getTransactionPurchaseLinesLast->id);
                              $purchase_lines->exp_date = Carbon::now()->subDays(30);
                              $purchase_lines->save();
                            } */   
                             
                            $vld = new VariationLocationDetails();
                            $vld->product_id = $checkProduct->id;
                            $vld->product_variation_id = $productVariation->id;
                            $vld->variation_id = $checkVariation->id;
                            $vld->location_id = $locval;
                            $vld->qty_available = $qty_divide;
                            $vld->save();
                      
                            $transaction = new Transaction();
                            $transaction->business_id = $business_id;
                            $transaction->location_id = $locval;
                            $transaction->type = 'opening_stock';
                            $transaction->status = 'received';
                            $transaction->is_quotation = 0;
                            $transaction->payment_status = 'paid';
                            $transaction->transaction_date = Carbon::now();
                            $transaction->total_before_tax = 0;
                            $transaction->tax_amount = 0;
                            $transaction->discount_amount = 0;
                            $transaction->rp_redeemed = 0;
                            $transaction->rp_redeemed_amount = 0;
                            $transaction->shipping_charges = 0;
                            $transaction->is_export = 0;
                            $transaction->round_off_amount = 0;
                            $transaction->additional_expense_value_1 = 0;
                            $transaction->additional_expense_value_2 = 0;
                            $transaction->additional_expense_value_3 = 0;
                            $transaction->additional_expense_value_4 = 0;
                            $transaction->final_total = 0;
                            $transaction->is_direct_sale = 0;
                            $transaction->is_suspend = 0;
                            $transaction->exchange_rate = 1;
                            $transaction->opening_stock_product_id = $checkProduct->id;
                            $transaction->created_by = auth()->user()->id;
                            $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                            $transaction->is_created_from_api = 1;
                            $transaction->rp_earned = 0;
                            $transaction->is_recurring = 0;
                            $transaction->save();
    
                            $purchase_lines = new PurchaseLine();
                            $purchase_lines->transaction_id = $transaction->id;
                            $purchase_lines->product_id = $checkProduct->id;
                            $purchase_lines->variation_id = $variation->id;
                            $purchase_lines->quantity = $qty_divide;
                            $purchase_lines->purchase_price = 0;
                            $purchase_lines->save();                                                      
                          }                       
                      }                    
                    }
                  // }
                }                                       
  
                // $product = Product::where('shopify_id', $value['id'])->update([
                //   'product_description' => $description,
                //   'brand_id' => $brand_id,
                //   'alert_quantity' => $alert_qty,
                //   'name' => $nameProduct,
                //   'category_id' => $category_id,
                //   'sku' => $sku,
                //   'barcode' => $barcode,
                // ]);    
  
                $product = Product::find($checkProduct->id);              
                $product->alert_quantity = $alert_qty;              
                if(in_array("product_description", $checkmarks_arr)) {
                  $product->product_description = $description;
                }                    
                if(in_array("name", $checkmarks_arr)) {
                    $product->name = $nameProduct;
                }
                if(in_array("category_id", $checkmarks_arr)) {
                    $product->category_id = $category_id;
                }
                if(in_array("brand_id", $checkmarks_arr)) {
                    $product->brand_id = $brand_id;
                }
                if(in_array("sku", $checkmarks_arr)) {
                    $product->sku = $sku;
                }
                if(in_array("barcode", $checkmarks_arr)) {
                    $product->barcode = $barcode;
                }
                if($image) {
                  $product->image = $image;
                }
                $product->save();
                
                
                if($product->wasChanged() || $statusVariation) {                  
                  $no++;
                  $status = 2;
                  array_push($arr, [
                    'number' => $no,
                    'status' => $status,
                    'product_changed' => $product->wasChanged(),
                    'statusVariation' => $statusVariation,
                    'product_name' => $value['title'],
                    'shopify_id' => $value['id']
                  ]);
                }
  
                if(! empty($product_locations)) {
                  $checkProduct->product_locations()->sync($product_locations);
                }        
              // }
            }
            
          }
          DB::commit();
          return $arr;
        } catch (\Exception $err) {
          //throw $th;
          DB::rollBack();
          // return $err->getMessage();
          return response()->json([
            'message' => $err->getMessage(),
            // 'message' => __('messages.something_went_wrong'),
            'data' => null
          ]);
        }
        // return 'Received Data Success';
      } else {        
        $arr = [];
        return $arr;
        // return 'Data Not Found';
      }
    }

    private static function generateRandomString($length = 10) {
      // $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
      $characters = '0123456789';
      $charactersLength = strlen($characters);
      $randomString = '';
      for ($i = 0; $i < $length; $i++) {
          $randomString .= $characters[random_int(0, $charactersLength - 1)];
      }
      return $randomString;
  }
}
