<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\VhaiFeedback;

class VhaiFeedbackController extends Controller
{
    
    public function feedback(Request $request)
    {
        //I want to get business_id and user_id from the request
        $business_id = $request->business_id;
        $user_id = $request->user_id;

        $validatedData = $request->validate([
            'business_id' => 'required|string',
            'user_id' => 'required|string',
            'prompt' => 'required|string',
            'answer' => 'required|string',
            'feedback' => 'required|string',
        ]);

        //I want to save the feedback to the database
        $vhai = VhaiFeedback::create($validatedData);

        return response()->json(['message' => 'Feedback added successfully', 'data' => $vhai]);

        // $vhai = Vhai::create($validatedData);
        // return response()->json(['message' => 'Feedback added successfully', 'data' => $vhai]);
    }

    //add store function
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'business_id' => 'required|string',
            'user_id' => 'required|string',
            'prompt' => 'required|string',
            'answer' => 'required|string',
            'feedback' => 'required|string',
        ]);

        $vhai = VhaiFeedback::create($validatedData);

        return response()->json(['message' => 'Feedback added successfully', 'data' => $vhai]);
    }
}
