<?php

namespace App\Http\Controllers;

use App\Brands;
use App\BrandWoocommerce;
use App\Business;
use App\Category;
use App\CategoryWoocommerce;
use App\Product;
use App\ProductVariation;
use App\PurchaseLine;
use App\Transaction;
use App\Variation;
use App\VariationLocationDetails;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WooCommerceController extends Controller
{
    //
    public function auth(Request $request)
    {
        // dd($request->all());
        $product_locations = array($request->input('product_locations')); 
        if(empty($product_locations)) {
          return response()->json([
            'message' => 'Location must be selected',
            'data' => null
          ]);
        }       
        $checkmarks = $request->input('checkmarks');
        // dd($checkmarks);
        if(empty($checkmarks)) {
            return response()->json([
                'message' => 'Please Selected Sync Item First',
                'data' => null
            ]);
        }
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

        $array_empty = [];
        $array_insert = [];

        $e_commerce_settings = json_decode($business->e_commerce_settings);

        if($e_commerce_settings->woo_commerce_api_url && $e_commerce_settings->woo_commerce_api_key && $e_commerce_settings->woo_commerce_api_secret) {
          // $SHOPIFY_URL = getenv("SHOPIFY_URL");
          $WOO_COMMERCE_URL = $e_commerce_settings->woo_commerce_api_url;
          $WOO_COMMERCE_KEY = $e_commerce_settings->woo_commerce_api_key;        
          $WOO_COMMERCE_SECRET = $e_commerce_settings->woo_commerce_api_secret;        
        } else {
          return 'Url, Key and Secret Woo Commerce Not Found';
        }
        try 
        {
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                CURLOPT_URL => $WOO_COMMERCE_URL . "/products?per_page=100&consumer_key=".$WOO_COMMERCE_KEY."&consumer_secret=".$WOO_COMMERCE_SECRET  ,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    // 'Authorization: Basic ' . base64_encode($WOO_COMMERCE_KEY.':'.$WOO_COMMERCE_SECRET)
                )
            
                )
            );
            
            // call back function to parse Headers and get Next Page Link
            curl_setopt(
              $curl,
              CURLOPT_HEADERFUNCTION,
              function($curl, $header) use (&$nextPage) {
                  $len = strlen($header);
                  $header = explode(':', $header, 2);

                  if (count($header) < 2) // ignore invalid headers
                  return $len;

                  if (trim($header[0]) === "Link" && strpos($header[1], 'next') !== false) {
                      $links = explode(',', $header[1], 2);

                      $link = count($links) === 2 ? $links[1] : $links[0];
                      if (preg_match('/<(.*?)>/', $link, $match) === 1) $nextPage = $match[1];
                  }

                  return $len;
              }
            );

            $response = curl_exec($curl);            

            if (curl_errno($curl)) {
              $error_msg = curl_error($curl);
              print_r($error_msg);
              $log = fopen('../sample/sresult.json','a');
              fwrite($log,"\ncurl_error81\n");
              fclose($log);
            }

            $parsedResponse = json_decode($response);            
            // dd($parsedResponse);
            $products = json_decode(json_encode($parsedResponse), true);
            
            // $randomNumber = $this->generateRandomString(10);            
            $responseSaveProducts = $this->saveProducts($products, $product_locations, $checkmarks);  
            array_push($array_insert, $responseSaveProducts);             

          while ($nextPage !== NULL) 
          {
            // dd($nextPage, CURLOPT_URL, $curl);
            curl_setopt($curl, CURLOPT_URL, $nextPage);
            $parsedResponse = [];
            $nextPage = NULL;

            $response = curl_exec($curl);
            $parsedResponse = json_decode($response);
            
            if (curl_errno($curl)) {
                $error_msg = curl_error($curl);
                print_r($error_msg);
                // $log = fopen('../sample/sresult.json','a');
                // fwrite($log,"\ncurl_error102\n");
                // fclose($log);
            } else {
                $products = json_decode(json_encode($parsedResponse), true);
                // dd($products);
                // $randomNumber = $this->generateRandomString(10); 
                $responseSaveProducts = $this->saveProducts($products, $product_locations, $checkmarks);
                array_push($array_insert, $responseSaveProducts);
                sleep(2);
            }
          };

          curl_close($curl);                    
          $body['woo_commerce_checkbox'] = json_encode($checkmarks); 
          $business = Business::find($business_id);         
          $business->fill($body);
          $business->save();
          // return $products;          
          if(is_array($array_insert)) {            
            return response()->json([
                'message' => 'Recevied Data Success',
                'data' => $array_insert
            ]);
        } else {
            return response()->json([
                'message' => $array_insert,
                'data' => null
            ]);
        }
            
        } catch (Exception $err) {
            // return $err->getMessage();
            return response()->json([
                'message' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        }
    }

    public function saveProducts($products, $product_locations, $checkmarks) 
    {      
      DB::beginTransaction();
      $business_id = request()->session()->get('user.business_id');
      $checkProductLocation = Product::join('variation_location_details as vld', 'vld.product_id', '=', 'products.id')
        ->join('business_locations as bl', 'bl.id', '=', 'vld.location_id')
        ->whereNotNull('products.woo_commerce_id')
        ->select('products.id', 'products.name', 'bl.id as location_id', 'vld.variation_id')
        ->first();
        if(!empty($checkProductLocation) && $checkProductLocation->location_id != $product_locations[0]) {
            $deleteTransactions = DB::select("delete transactions from transactions join products on products.id = transactions.opening_stock_product_id and transactions.location_id = ? where products.woo_commerce_id is not null", [$checkProductLocation->location_id]);                    
            $deleteVariationLocationDetails = DB::select("delete variation_location_details from variation_location_details join products on products.id = variation_location_details.product_id and variation_location_details.location_id = ? where products.woo_commerce_id is not null", [$checkProductLocation->location_id]);                  
            DB::select("delete purchase_lines from purchase_lines join products on products.id = purchase_lines.product_id where products.woo_commerce_id is not null");          
            DB::select("delete product_locations from product_locations join products on products.id = product_locations.product_id where products.woo_commerce_id is not null");          
            DB::select("delete variations from variations join products on products.id = variations.product_id where products.woo_commerce_id is not null");          
            DB::select("delete from products where woo_commerce_id is not null");
        }
      // dd($products);
      if($products) {
        $no = 0;
        $arr = [];
        $status = '';
        try {
          //code...
          foreach ($products as $key => $value) {
            //echo "Coming product shopify id : " . $value['id'] . ' - ';
            
            # code...
            if($value['brands']) {
              $checkBrand = Brands::whereRaw("lower(name) = ?", $value['brands'][0]['name'])->where('business_id', $business_id)->first();
              if($checkBrand == null) {
                $b = new Brands();
                $b->business_id = $business_id;
                $b->name = $value['brands'][0]['name'];
                $b->description = null;
                $b->created_by = auth()->user()->id;
                $b->id = $value['brands'][0]['id'];
                $b->save();
    
                $brandId = $b->id;
              } else {
                // $b = Brands::find($checkBrand->id);
                // $b->woo_commerce_id = $value['brands'][0]['id'];
                // $b->save();
                $brandId = $checkBrand->id;
              }
            } else {
              $brandId = null;
            }
  
            if($value['categories']) {
              $checkCategory = Category::whereRaw("lower(name) = ?", $value['categories'][0]['name'])->where('business_id', $business_id)->first();
              if($checkCategory == null) {
                $c = new Category();
                $c->name = $value['categories'][0]['name'];
                $c->business_id = $business_id;
                $c->parent_id = 0;
                $c->created_by = auth()->user()->id;
                $c->category_type = 'product';
                $c->id = $value['categories'][0]['id'];
                $c->save();
                $categoryId = $c->id;
              } else {  
                // $c = Category::find($checkCategory->id);
                // $c->woo_commerce_id = $value['categories'][0]['id'];
                // $c->save();
                $categoryId = $checkCategory->id;
              }
            } else {
              $categoryId = null;
            } 
            
            $checkProduct = Product::where('woo_commerce_id', $value['id'])->first();
            if($checkProduct == null) {
              $p = new Product();
              $p->name = $value['name'];
              $p->business_id = $business_id;
              $p->type = $value['type'] == 'variable' ? 'variable' : 'single';
              $p->enable_stock = 1;            
              $p->tax_type = 'exclusive';
              $p->brand_id = $brandId;
              $p->category_id = $categoryId;
              $p->alert_quantity = 1;
              $p->sku = $value['sku'] ? $value['sku'] : ' ';
              $p->barcode = $value['sku'] ? $value['sku'] : ' ';
              $p->created_by = auth()->user()->id;
              $p->product_description = $value['description'];
              $p->woo_commerce_id = $value['id'];
              if(!empty($value['images'])) {
                $p->image = $value['images'][0]['src'];
              }
              $p->save();
  
              if(! empty($product_locations)) {
                $p->product_locations()->sync($product_locations);
              }
  
              $pv = 0;
              $v = 0;
              if(!empty($value['variations'])) {
                foreach ($value['variations'] as $kVariation => $valVariation) {
                  # code...
                  $getVariations = $this->getVariationAPI($value['id'], $valVariation);
                  $pv = new ProductVariation();
                  $pv->name = $value['attributes'][$kVariation]['name'];
                  $pv->product_id = $p->id;
                  $pv->is_dummy = 0;
                  $pv->created_at = Carbon::now();
                  $pv->save();
      
                  $v = new Variation();
                  $v->name = $value['attributes'][$kVariation]['name'];
                  $v->product_id = $p->id;
                  $v->sub_sku = $getVariations->sku;
                  $v->product_variation_id = $pv->id;
                  $v->default_sell_price = $getVariations->regular_price ? $getVariations->regular_price : $getVariations->price;
                  $v->sell_price_inc_tax = $getVariations->regular_price ? $getVariations->regular_price : $getVariations->price;                  
                  $v->save();
                }
              } else {            
                $attributes = $value['attributes'] ? $value['attributes'][0]['name'] : "default_variation";
                $pv = new ProductVariation();
                $pv->name = $attributes;
                $pv->product_id = $p->id;
                $pv->is_dummy = 0;
                $pv->created_at = Carbon::now();
                $pv->save();
    
                $v = new Variation();
                $v->name = $attributes;
                $v->product_id = $p->id;
                $v->sub_sku = $value['sku'];
                $v->product_variation_id = $pv->id;
                $v->default_sell_price = $value['regular_price'] ? $value['regular_price'] : $value['price'];
                $v->sell_price_inc_tax = $value['regular_price'] ? $value['regular_price'] : $value['price'];
                $v->save();
              }
              
              if(! empty($product_locations)) {
                if(count($product_locations) > 1) {
                  foreach ($product_locations as $val) {
                    # code...
                    $vld = new VariationLocationDetails();
                    $vld->product_id = $p->id;
                    $vld->product_variation_id = $pv->id;
                    $vld->variation_id = $v->id;
                    $vld->location_id = $val;
                    $vld->qty_available = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                    $vld->save();
  
                    $transaction = new Transaction();
                    $transaction->business_id = $business_id;
                    $transaction->location_id = $val;
                    $transaction->type = 'opening_stock';
                    $transaction->status = 'received';
                    $transaction->is_quotation = 0;
                    $transaction->payment_status = 'paid';
                    $transaction->transaction_date = Carbon::now();
                    $transaction->total_before_tax = 0;
                    $transaction->tax_amount = 0;
                    $transaction->discount_amount = 0;
                    $transaction->rp_redeemed = 0;
                    $transaction->rp_redeemed_amount = 0;
                    $transaction->shipping_charges = 0;
                    $transaction->is_export = 0;
                    $transaction->round_off_amount = 0;
                    $transaction->additional_expense_value_1 = 0;
                    $transaction->additional_expense_value_2 = 0;
                    $transaction->additional_expense_value_3 = 0;
                    $transaction->additional_expense_value_4 = 0;
                    $transaction->final_total = 0;
                    $transaction->is_direct_sale = 0;
                    $transaction->is_suspend = 0;
                    $transaction->exchange_rate = 1;
                    $transaction->opening_stock_product_id = $p->id;
                    $transaction->created_by = auth()->user()->id;
                    $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                    $transaction->is_created_from_api = 1;
                    $transaction->rp_earned = 0;
                    $transaction->is_recurring = 0;
  
                    $transaction->save();
  
                    $purchase_lines = new PurchaseLine();
                    $purchase_lines->transaction_id = $transaction->id;
                    $purchase_lines->product_id = $p->id;
                    $purchase_lines->variation_id = $v->id;
                    $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                    $purchase_lines->purchase_price = 0;
                    $purchase_lines->save();
                  }
                } else {
                  $vld = new VariationLocationDetails();
                  $vld->product_id = $p->id;
                  $vld->product_variation_id = $pv->id;
                  $vld->variation_id = $v->id;
                  $vld->location_id = $product_locations[0];
                  $vld->qty_available = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                  $vld->save();
                  $transaction = new Transaction();
                            $transaction->business_id = $business_id;
                            $transaction->location_id = $product_locations[0];
                            $transaction->type = 'opening_stock';
                            $transaction->status = 'received';
                            $transaction->is_quotation = 0;
                            $transaction->payment_status = 'paid';
                            $transaction->transaction_date = Carbon::now();
                            $transaction->total_before_tax = 0;
                            $transaction->tax_amount = 0;
                            $transaction->discount_amount = 0;
                            $transaction->rp_redeemed = 0;
                            $transaction->rp_redeemed_amount = 0;
                            $transaction->shipping_charges = 0;
                            $transaction->is_export = 0;
                            $transaction->round_off_amount = 0;
                            $transaction->additional_expense_value_1 = 0;
                            $transaction->additional_expense_value_2 = 0;
                            $transaction->additional_expense_value_3 = 0;
                            $transaction->additional_expense_value_4 = 0;
                            $transaction->final_total = 0;
                            $transaction->is_direct_sale = 0;
                            $transaction->is_suspend = 0;
                            $transaction->exchange_rate = 1;
                            $transaction->opening_stock_product_id = $p->id;
                            $transaction->created_by = auth()->user()->id;
                            $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                            $transaction->is_created_from_api = 1;
                            $transaction->rp_earned = 0;
                            $transaction->is_recurring = 0;
  
                            $transaction->save();
  
                            $purchase_lines = new PurchaseLine();
                            $purchase_lines->transaction_id = $transaction->id;
                            $purchase_lines->product_id = $p->id;
                            $purchase_lines->variation_id = $v->id;
                            $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                            $purchase_lines->purchase_price = 0;
                            $purchase_lines->save();
                }
              }
  
              $no++;
              $status = 1;
              array_push($arr, [
                  'number' => $no,
                  'status' => $status
              ]);
            } else {
              $checkmarks_arr = [];                        
              foreach ($checkmarks as $key => $val) {
                array_push($checkmarks_arr, $val['value']);
              }
                $nameProduct =  $checkProduct->name == $value['name'] ? $checkProduct->name : $value['name'];
                $brand_id =  $checkProduct->brand_id == $brandId ? $checkProduct->brand_id : $brandId;
                $category_id = $checkProduct->category_id == $categoryId ? $checkProduct->category_id : $categoryId;
                $description = $checkProduct->product_description == $value['description'] ? $checkProduct->product_description : $value['description'];            
                $valueSku = $value['sku'] ? $value['sku'] : ' ';
                $sku = $checkProduct->sku == $valueSku ? $checkProduct->sku : $valueSku;
                $valueBarcode = $value['sku'] ? $value['sku'] : ' ';
                $barcode = $checkProduct->barcode == $valueBarcode ? $checkProduct->barcode : $valueBarcode;
                $image = null;       
                if(!empty($value['images'])) {
                  $image = $value['images'][0]['src'];
                }    
                              
                $statusVariation = null;            
                if($value['type'] == 'variable') {
                  if(!empty($value['variations'])) {
                    foreach ($value['variations'] as $keyVariation => $valVariation) {
                      # code...
                      $getVariations = $this->getVariationAPI($value['id'], $valVariation);
                      $checkVariation = Variation::where('sub_sku', $getVariations->sku)->first();
                      if($checkVariation) {
                        $attributes = $value['attributes'] ? $value['attributes'][0]['name'] : "default_variation";
                        $nameVariation = $checkVariation->name == $attributes ? $checkVariation->name : $attributes;
                        $subSku = $checkVariation->sub_sku == $value['sku'] ? $checkVariation->sub_sku : $value['sku'];
                        $price = $checkVariation->default_sell_price == $getVariations->regular_price ? $checkVariation->default_sell_price : $getVariations->regular_price;
            
                        /* $variation = Variation::where('product_id', $checkProduct->id)->update([
                          'name' => $nameVariation,
                          'sub_sku' => $subSku,
                          'default_sell_price' => $price,
                          'sell_price_inc_tax' => $price
                        ]); */
        
                        $variation = Variation::find($checkVariation->id);
                        $variation->name = $nameVariation;
                        $variation->sub_sku = $subSku;
                        if(in_array("default_sell_price", $checkmarks_arr)) {
                            $variation->default_sell_price = $price;
                            $variation->sell_price_inc_tax = $price;
                        }
                        
                        $variation->save();
                        
                        $statusVariation = $variation->wasChanged();
                      } else {
                        $pv = new ProductVariation();
                        $pv->name = $value['attributes'][$keyVariation]['name'];
                        $pv->product_id = $checkProduct->id;
                        $pv->is_dummy = 0;
                        $pv->created_at = Carbon::now();
                        $pv->save();
            
                        $v = new Variation();
                        $v->name = $value['attributes'][$keyVariation]['name'];
                        $v->product_id = $checkProduct->id;
                        $v->sub_sku = $getVariations->sku;
                        $v->product_variation_id = $pv->id;
                        $v->default_sell_price = $getVariations->regular_price ? $getVariations->regular_price : $getVariations->price;
                        $v->sell_price_inc_tax = $getVariations->regular_price ? $getVariations->regular_price : $getVariations->price;
                        $v->save();
  
                        if(! empty($product_locations)) {
                          if(count($product_locations) > 1) {
                            foreach ($product_locations as $val) {
                              # code...
                              $vld = new VariationLocationDetails();
                              $vld->product_id = $checkProduct->id;
                              $vld->product_variation_id = $pv->id;
                              $vld->variation_id = $v->id;
                              $vld->location_id = $val;
                              $vld->qty_available = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                              $vld->save();
            
                              $transaction = new Transaction();
                              $transaction->business_id = $business_id;
                              $transaction->location_id = $val;
                              $transaction->type = 'opening_stock';
                              $transaction->status = 'received';
                              $transaction->is_quotation = 0;
                              $transaction->payment_status = 'paid';
                              $transaction->transaction_date = Carbon::now();
                              $transaction->total_before_tax = 0;
                              $transaction->tax_amount = 0;
                              $transaction->discount_amount = 0;
                              $transaction->rp_redeemed = 0;
                              $transaction->rp_redeemed_amount = 0;
                              $transaction->shipping_charges = 0;
                              $transaction->is_export = 0;
                              $transaction->round_off_amount = 0;
                              $transaction->additional_expense_value_1 = 0;
                              $transaction->additional_expense_value_2 = 0;
                              $transaction->additional_expense_value_3 = 0;
                              $transaction->additional_expense_value_4 = 0;
                              $transaction->final_total = 0;
                              $transaction->is_direct_sale = 0;
                              $transaction->is_suspend = 0;
                              $transaction->exchange_rate = 1;
                              $transaction->opening_stock_product_id = $checkProduct->id;
                              $transaction->created_by = auth()->user()->id;
                              $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                              $transaction->is_created_from_api = 1;
                              $transaction->rp_earned = 0;
                              $transaction->is_recurring = 0;
            
                              $transaction->save();
            
                              $purchase_lines = new PurchaseLine();
                              $purchase_lines->transaction_id = $transaction->id;
                              $purchase_lines->product_id = $checkProduct->id;
                              $purchase_lines->variation_id = $v->id;
                              $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                              $purchase_lines->purchase_price = 0;
                              $purchase_lines->save();
                            }
                          } else {
                            $vld = new VariationLocationDetails();
                            $vld->product_id = $checkProduct->id;
                            $vld->product_variation_id = $pv->id;
                            $vld->variation_id = $v->id;
                            $vld->location_id = $product_locations[0];
                            $vld->qty_available = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                            $vld->save();
                            $transaction = new Transaction();
                            $transaction->business_id = $business_id;
                            $transaction->location_id = $product_locations[0];
                            $transaction->type = 'opening_stock';
                            $transaction->status = 'received';
                            $transaction->is_quotation = 0;
                            $transaction->payment_status = 'paid';
                            $transaction->transaction_date = Carbon::now();
                            $transaction->total_before_tax = 0;
                            $transaction->tax_amount = 0;
                            $transaction->discount_amount = 0;
                            $transaction->rp_redeemed = 0;
                            $transaction->rp_redeemed_amount = 0;
                            $transaction->shipping_charges = 0;
                            $transaction->is_export = 0;
                            $transaction->round_off_amount = 0;
                            $transaction->additional_expense_value_1 = 0;
                            $transaction->additional_expense_value_2 = 0;
                            $transaction->additional_expense_value_3 = 0;
                            $transaction->additional_expense_value_4 = 0;
                            $transaction->final_total = 0;
                            $transaction->is_direct_sale = 0;
                            $transaction->is_suspend = 0;
                            $transaction->exchange_rate = 1;
                            $transaction->opening_stock_product_id = $checkProduct->id;
                            $transaction->created_by = auth()->user()->id;
                            $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                            $transaction->is_created_from_api = 1;
                            $transaction->rp_earned = 0;
                            $transaction->is_recurring = 0;
  
                            $transaction->save();
  
                            $purchase_lines = new PurchaseLine();
                            $purchase_lines->transaction_id = $transaction->id;
                            $purchase_lines->product_id = $checkProduct->id;
                            $purchase_lines->variation_id = $v->id;
                            $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                            $purchase_lines->purchase_price = 0;
                            $purchase_lines->save();
                          }
                        }
                      }
                    }
                  }
                } else {
                  $checkVariation = Variation::where('sub_sku', $value['sku'])->first();
                  if($checkVariation) {
                    $variation = Variation::find($checkVariation->id);
                    $attributes = $value['attributes'] ? $value['attributes'][0]['name'] : "default_variation";
                    $nameVariation = $checkVariation->name == $attributes ? $checkVariation->name : $attributes;
                    $subSku = $checkVariation->sub_sku == $value['sku'] ? $checkVariation->sub_sku : $value['sku'];
                    $price = $checkVariation->default_sell_price == $value['regular_price'] ? $checkVariation->default_sell_price : $value['regular_price'];
                    $variation->name = $nameVariation;
                    $variation->sub_sku = $subSku;
                    if(in_array("default_sell_price", $checkmarks_arr)) {
                        $variation->default_sell_price = $price;
                        $variation->sell_price_inc_tax = $price;
                    }
                    
                    $variation->save();
                    $statusVariation = $variation->wasChanged();
                  } else {
                    $pv = new ProductVariation();
                    $pv->name = $value['attributes'] ? $value['attributes'][0]['name'] : "default_variation"; 
                    $pv->product_id = $checkProduct->id;
                    $pv->is_dummy = 0;
                    $pv->created_at = Carbon::now();
                    $pv->save();
        
                    $v = new Variation();
                    $v->name = $value['attributes'] ? $value['attributes'][0]['name'] : "default_variation"; 
                    $v->product_id = $checkProduct->id;
                    $v->sub_sku = $value['sku'];
                    $v->product_variation_id = $pv->id;
                    $v->default_sell_price = $value['regular_price'] ? $value['regular_price'] : $value['price'];
                    $v->save();
    
                    if(! empty($product_locations)) {
                      if(count($product_locations) > 1) {
                        foreach ($product_locations as $val) {
                          # code...
                          $vld = new VariationLocationDetails();
                          $vld->product_id = $checkProduct->id;
                          $vld->product_variation_id = $pv->id;
                          $vld->variation_id = $v->id;
                          $vld->location_id = $val;
                          $vld->qty_available = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                          $vld->save();
        
                          $transaction = new Transaction();
                          $transaction->business_id = $business_id;
                          $transaction->location_id = $val;
                          $transaction->type = 'opening_stock';
                          $transaction->status = 'received';
                          $transaction->is_quotation = 0;
                          $transaction->payment_status = 'paid';
                          $transaction->transaction_date = Carbon::now();
                          $transaction->total_before_tax = 0;
                          $transaction->tax_amount = 0;
                          $transaction->discount_amount = 0;
                          $transaction->rp_redeemed = 0;
                          $transaction->rp_redeemed_amount = 0;
                          $transaction->shipping_charges = 0;
                          $transaction->is_export = 0;
                          $transaction->round_off_amount = 0;
                          $transaction->additional_expense_value_1 = 0;
                          $transaction->additional_expense_value_2 = 0;
                          $transaction->additional_expense_value_3 = 0;
                          $transaction->additional_expense_value_4 = 0;
                          $transaction->final_total = 0;
                          $transaction->is_direct_sale = 0;
                          $transaction->is_suspend = 0;
                          $transaction->exchange_rate = 1;
                          $transaction->opening_stock_product_id = $checkProduct->id;
                          $transaction->created_by = auth()->user()->id;
                          $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                          $transaction->is_created_from_api = 1;
                          $transaction->rp_earned = 0;
                          $transaction->is_recurring = 0;
        
                          $transaction->save();
        
                          $purchase_lines = new PurchaseLine();
                          $purchase_lines->transaction_id = $transaction->id;
                          $purchase_lines->product_id = $checkProduct->id;
                          $purchase_lines->variation_id = $v->id;
                          $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                          $purchase_lines->purchase_price = 0;
                          $purchase_lines->save();
                        }
                      } else {
                        $vld = new VariationLocationDetails();
                        $vld->product_id = $checkProduct->id;
                        $vld->product_variation_id = $pv->id;
                        $vld->variation_id = $v->id;
                        $vld->location_id = $product_locations[0];
                        $vld->qty_available = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                        $vld->save();
                        $transaction = new Transaction();
                        $transaction->business_id = $business_id;
                        $transaction->location_id = $product_locations[0];
                        $transaction->type = 'opening_stock';
                        $transaction->status = 'received';
                        $transaction->is_quotation = 0;
                        $transaction->payment_status = 'paid';
                        $transaction->transaction_date = Carbon::now();
                        $transaction->total_before_tax = 0;
                        $transaction->tax_amount = 0;
                        $transaction->discount_amount = 0;
                        $transaction->rp_redeemed = 0;
                        $transaction->rp_redeemed_amount = 0;
                        $transaction->shipping_charges = 0;
                        $transaction->is_export = 0;
                        $transaction->round_off_amount = 0;
                        $transaction->additional_expense_value_1 = 0;
                        $transaction->additional_expense_value_2 = 0;
                        $transaction->additional_expense_value_3 = 0;
                        $transaction->additional_expense_value_4 = 0;
                        $transaction->final_total = 0;
                        $transaction->is_direct_sale = 0;
                        $transaction->is_suspend = 0;
                        $transaction->exchange_rate = 1;
                        $transaction->opening_stock_product_id = $checkProduct->id;
                        $transaction->created_by = auth()->user()->id;
                        $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                        $transaction->is_created_from_api = 1;
                        $transaction->rp_earned = 0;
                        $transaction->is_recurring = 0;
    
                        $transaction->save();
    
                        $purchase_lines = new PurchaseLine();
                        $purchase_lines->transaction_id = $transaction->id;
                        $purchase_lines->product_id = $checkProduct->id;
                        $purchase_lines->variation_id = $v->id;
                        $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                        $purchase_lines->purchase_price = 0;
                        $purchase_lines->save();
                      }
                    }
                  }
                }              
  
                $checkProductQty = VariationLocationDetails::where('product_id', $checkProduct->id)->get()->toArray();
                $qtyChanged = null;
                if(empty($checkProductQty)) {
                    if($product_locations) {                
                    // if(count($product_locations) != count($checkProductQty)) {
                        // VariationLocationDetails::where('product_id', $checkProduct->id)->delete();
                        if(! empty($product_locations)) {
                        $productVariation = ProductVariation::where('product_id', $checkProduct->id)->select('id')->first();
                        if(count($product_locations) > 1) {
                            foreach ($product_locations as $val) {
                              # code...
                              $vld = new VariationLocationDetails();
                              $vld->product_id = $checkProduct->id;
                              $vld->product_variation_id = $productVariation->id;
                              $vld->variation_id = $checkVariation->id;
                              $vld->location_id = $val;
                              $vld->qty_available = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                              $vld->save();
  
                              $checkPurcasheLine = PurchaseLine::where('variation_id', $variation->id)->first();
                              if($checkPurcasheLine == null) {
                                $transaction = new Transaction();
                                $transaction->business_id = $business_id;
                                $transaction->location_id = $product_locations[0];
                                $transaction->type = 'opening_stock';
                                $transaction->status = 'received';
                                $transaction->is_quotation = 0;
                                $transaction->payment_status = 'paid';
                                $transaction->transaction_date = Carbon::now();
                                $transaction->total_before_tax = 0;
                                $transaction->tax_amount = 0;
                                $transaction->discount_amount = 0;
                                $transaction->rp_redeemed = 0;
                                $transaction->rp_redeemed_amount = 0;
                                $transaction->shipping_charges = 0;
                                $transaction->is_export = 0;
                                $transaction->round_off_amount = 0;
                                $transaction->additional_expense_value_1 = 0;
                                $transaction->additional_expense_value_2 = 0;
                                $transaction->additional_expense_value_3 = 0;
                                $transaction->additional_expense_value_4 = 0;
                                $transaction->final_total = 0;
                                $transaction->is_direct_sale = 0;
                                $transaction->is_suspend = 0;
                                $transaction->exchange_rate = 1;
                                $transaction->opening_stock_product_id = $checkProduct->id;
                                $transaction->created_by = auth()->user()->id;
                                $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                $transaction->is_created_from_api = 1;
                                $transaction->rp_earned = 0;
                                $transaction->is_recurring = 0;
  
                                $transaction->save();
  
                                $purchase_lines = new PurchaseLine();
                                $purchase_lines->transaction_id = $transaction->id;
                                $purchase_lines->product_id = $checkProduct->id;
                                $purchase_lines->variation_id = $variation->id;
                                $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                                $purchase_lines->purchase_price = 0;
                                $purchase_lines->save();
                              } else {
                                $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                                $purchase_lines->save();
                              }
                            }
                        } else {
                            $vld = new VariationLocationDetails();
                            $vld->product_id = $checkProduct->id;
                            $vld->product_variation_id = $productVariation->id;
                            $vld->variation_id = $checkVariation->id;
                            $vld->location_id = $product_locations[0];
                            $vld->qty_available = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                            $vld->save();
  
                            $checkPurcasheLine = PurchaseLine::where('variation_id', $variation->id)->first();
                            if($checkPurcasheLine == null) {
  
                              $transaction = new Transaction();
                              $transaction->business_id = $business_id;
                              $transaction->location_id = $product_locations[0];
                              $transaction->type = 'opening_stock';
                              $transaction->status = 'received';
                              $transaction->is_quotation = 0;
                              $transaction->payment_status = 'paid';
                              $transaction->transaction_date = Carbon::now();
                              $transaction->total_before_tax = 0;
                              $transaction->tax_amount = 0;
                              $transaction->discount_amount = 0;
                              $transaction->rp_redeemed = 0;
                              $transaction->rp_redeemed_amount = 0;
                              $transaction->shipping_charges = 0;
                              $transaction->is_export = 0;
                              $transaction->round_off_amount = 0;
                              $transaction->additional_expense_value_1 = 0;
                              $transaction->additional_expense_value_2 = 0;
                              $transaction->additional_expense_value_3 = 0;
                              $transaction->additional_expense_value_4 = 0;
                              $transaction->final_total = 0;
                              $transaction->is_direct_sale = 0;
                              $transaction->is_suspend = 0;
                              $transaction->exchange_rate = 1;
                              $transaction->opening_stock_product_id = $checkProduct->id;
                              $transaction->created_by = auth()->user()->id;
                              $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                              $transaction->is_created_from_api = 1;
                              $transaction->rp_earned = 0;
                              $transaction->is_recurring = 0;
  
                              $transaction->save();
  
                              $purchase_lines = new PurchaseLine();
                              $purchase_lines->transaction_id = $transaction->id;
                              $purchase_lines->product_id = $checkProduct->id;
                              $purchase_lines->variation_id = $variation->id;
                              $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                              $purchase_lines->purchase_price = 0;
                              $purchase_lines->save();
                            } else {
                              $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                                $purchase_lines->save();
                            }
                        }
                        }
                    // }
                    }                         
                } else {
                    foreach ($checkProductQty as $kQty => $vQty) {
                    # code...
                    if($vQty['qty_available'] != $value['stock_quantity']) {
                        $vld = VariationLocationDetails::find($vQty['id']);
                        $vld->qty_available = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                        $vld->save();
                        $qtyChanged = $vld->wasChanged();
                        $checkPurcasheLine = PurchaseLine::where('variation_id', $variation->id)->first();
                        if($checkPurcasheLine == null) {
                          $transaction = new Transaction();
                          $transaction->business_id = $business_id;
                          $transaction->location_id = $product_locations[0];
                          $transaction->type = 'opening_stock';
                          $transaction->status = 'received';
                          $transaction->is_quotation = 0;
                          $transaction->payment_status = 'paid';
                          $transaction->transaction_date = Carbon::now();
                          $transaction->total_before_tax = 0;
                          $transaction->tax_amount = 0;
                          $transaction->discount_amount = 0;
                          $transaction->rp_redeemed = 0;
                          $transaction->rp_redeemed_amount = 0;
                          $transaction->shipping_charges = 0;
                          $transaction->is_export = 0;
                          $transaction->round_off_amount = 0;
                          $transaction->additional_expense_value_1 = 0;
                          $transaction->additional_expense_value_2 = 0;
                          $transaction->additional_expense_value_3 = 0;
                          $transaction->additional_expense_value_4 = 0;
                          $transaction->final_total = 0;
                          $transaction->is_direct_sale = 0;
                          $transaction->is_suspend = 0;
                          $transaction->exchange_rate = 1;
                          $transaction->opening_stock_product_id = $checkProduct->id;
                          $transaction->created_by = auth()->user()->id;
                          $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                          $transaction->is_created_from_api = 1;
                          $transaction->rp_earned = 0;
                          $transaction->is_recurring = 0;
  
                          $transaction->save();
  
                          $purchase_lines = new PurchaseLine();
                          $purchase_lines->transaction_id = $transaction->id;
                          $purchase_lines->product_id = $checkProduct->id;
                          $purchase_lines->variation_id = $variation->id;
                          $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                          $purchase_lines->purchase_price = 0;
                          $purchase_lines->save();
                        } else {
                          $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                $purchase_lines->quantity = $value['stock_quantity'] ? $value['stock_quantity'] : 0;
                                $purchase_lines->save();
                        }
                    } 
                    }
                }
  
                // $product = Product::where('shopify_id', $value['id'])->update([
                //   'product_description' => $description,
                //   'brand_id' => $brand_id,
                //   'alert_quantity' => $alert_qty,
                //   'name' => $nameProduct,
                //   'category_id' => $category_id,
                //   'sku' => $sku,
                //   'barcode' => $barcode,
                // ]);    
  
                $product = Product::find($checkProduct->id);              
                // $product->alert_quantity = $alert_qty;              
                if(in_array("product_description", $checkmarks_arr)) {
                  $product->product_description = $description;
                }                    
                if(in_array("name", $checkmarks_arr)) {
                    $product->name = $nameProduct;
                }
                if(in_array("category_id", $checkmarks_arr)) {
                    $product->category_id = $category_id;
                }
                if(in_array("brand_id", $checkmarks_arr)) {
                    $product->brand_id = $brand_id;
                }
                if(in_array("sku", $checkmarks_arr)) {
                    $product->sku = $sku;
                }
                if(in_array("barcode", $checkmarks_arr)) {
                    $product->barcode = $barcode;
                }
                if($image) {
                  $product->image = $image;
                }
                $product->save();
                
                // dd($product->wasChanged(), $statusVariation);              
                
                if($product->wasChanged() || $statusVariation) {
                  $no++;
                  $status = 2;
                  array_push($arr, [
                    'number' => $no,
                    'status' => $status,
                    'productName' => $value['name'],
                    'productId' => $value['id']
                  ]);
                }
                if(! empty($product_locations)) {
                  $checkProduct->product_locations()->sync($product_locations);
                }        
                
              // }
            }
            
          }
          // dd($arr);
          DB::commit();
          return $arr;
        } catch (\Exception $err) {
          //throw $th;
          DB::rollBack();
          // return $err->getMessage();
          return __('messages.something_went_wrong');
          
        }
        
        // return 'Received Data Success';
      } else {        
        $arr = [];
        return $arr;
        // return 'Data Not Found';
      }
    }

    public function getVariationAPI($product_id, $variation_id)
    {
      $business_id = request()->session()->get('user.business_id');
      $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

      $e_commerce_settings = json_decode($business->e_commerce_settings);

      if($e_commerce_settings->woo_commerce_api_url && $e_commerce_settings->woo_commerce_api_key && $e_commerce_settings->woo_commerce_api_secret) {
        // $SHOPIFY_URL = getenv("SHOPIFY_URL");
        $WOO_COMMERCE_URL = $e_commerce_settings->woo_commerce_api_url;
        $WOO_COMMERCE_KEY = $e_commerce_settings->woo_commerce_api_key;        
        $WOO_COMMERCE_SECRET = $e_commerce_settings->woo_commerce_api_secret;        
      } else {
        return 'Url, Key and Secret Shopify Not Found';
      }

      try 
        {
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                CURLOPT_URL => $WOO_COMMERCE_URL . "/products/".$product_id."/variations/".$variation_id."?consumer_key=".$WOO_COMMERCE_KEY."&consumer_secret=".$WOO_COMMERCE_SECRET  ,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    // 'Authorization: Basic ' . base64_encode($WOO_COMMERCE_KEY.':'.$WOO_COMMERCE_SECRET)
                )
            
                )
            );

            $response = curl_exec($curl);
            $data = json_decode($response);            
            // dd($parsedResponse);
            // $data = json_decode(json_encode($parsedResponse), true);
            // dd($data);
            return $data;
            curl_close($curl);  
        } catch (Exception $err) {
          return $err->getMessage();
          // return __('messages.something_went_wrong');
      }
    }
}
