<?php

namespace App\Services;

use GuzzleHttp\Client;

class EtsyService
{
    protected $client;
    protected $apiKey;
    protected $accessToken;
    protected $shopId;

    public function __construct()
    {
        $this->client = new Client([
            'base_uri' => 'https://openapi.etsy.com/v3/application/',
            'headers' => [
                'x-api-key' => env('ETSY_API_KEY'),
                'Authorization' => 'Bearer ' . env('ETSY_ACCESS_TOKEN'),
                'Accept' => 'application/json',
            ],
        ]);

        $this->shopId = env('ETSY_SHOP_ID');
    }

    public function auth()
    {
        $client = new Client();
        $response = $client->post('https://api.etsy.com/v3/public/oauth/token', [
            'form_params' => [
                'grant_type'    => 'authorization_code',
                'client_id'     => env('ETSY_API_KEY'),
                'redirect_uri'  => env('ETSY_REDIRECT_URI'),
                'code'          => env('ETSY_ACCESS_CODE'),
                'code_verifier' => env('ETSY_CODE_VERIFIER'),
            ],
            'headers' => [
                'Content-Type' => 'application/x-www-form-urlencoded',
            ],
        ]);

        $token = json_decode($response->getBody(), true);
        //I want to save the token in .env ETSY_ACCESS_TOKEN
        
        dd($token);
    }

    public function getProducts()
    {
        try {
            $response = $this->client->get("shops/{$this->shopId}/listings/active");

            return json_decode($response->getBody()->getContents(), true);
        } catch (\Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }
}
