<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class KeepaService
{
    protected $apiKey;
    protected $baseUrl;

    public function __construct()
    {
        $this->apiKey = config('services.keepa.api_key');
        $this->baseUrl = config('services.keepa.base_url');
    }

    public function getProduct($asin)
    {
        $response = Http::get($this->baseUrl . 'product', [
            'key' => $this->apiKey,
            'domain' => 1,
            'asin' => $asin,
        ]);

        return $response->json();
    }

    public function getAsins($store)
    {
        $response = Http::get($this->baseUrl . 'seller', [
            'key' => $this->apiKey,
            'domain' => 1,
            'type' => 'csv',
            'storefront' => 1,
            'seller' => $store,
        ]);

        return $response->body();
    }
}
