<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('keepas', function (Blueprint $table) {
            $table->id();
            $table->integer('productType');
            $table->string('asin');
            $table->integer('domainId'); 
            $table->string('title');
            $table->integer('trackingSince');
            $table->integer('listedSince');
            $table->integer('lastUpdate');
            $table->integer('lastRatingUpdate');
            $table->integer('lastPriceChange');
            $table->integer('lastEbayUpdate');
            $table->integer('lastStockUpdate');
            $table->string('imagesCSV');
            $table->integer('rootCategory');
            $table->json('categories');
            $table->json('categoryTree');
            $table->string('parentAsin');
            $table->json('parentAsinHistory');
            $table->json('frequentlyBoughtTogether');
            $table->json('eanList');
            $table->json('upcList');
            $table->string('manufacturer');
            $table->string('brand');
            $table->string('brandStoreName');
            $table->string('brandStoreUrl');
            $table->string('brandStoreUrlName');
            $table->string('productGroup');
            $table->string('type');
            $table->string('partNumber');
            $table->string('binding');
            $table->string('scent');
            $table->string('shortDescription');
            $table->string('activeIngredients');
            $table->string('specialIngredients');
            $table->string('itemForm');
            $table->string('itemTypeKeyword');
            $table->string('recommendedUsesForProduct');
            $table->string('pattern');
            $table->json('specificUsesForProduct');
            $table->integer('businessDiscount');
            $table->integer('lastBusinessDiscountUpdate');
            $table->string('safetyWarning');
            $table->string('productBenefit');
            $table->boolean('batteriesRequired');
            $table->boolean('batteriesIncluded');
            $table->string('targetAudienceKeyword');
            $table->string('style');
            $table->string('includedComponents');
            $table->string('material');
            $table->integer('numberOfItems');
            $table->integer('numberOfPages');
            $table->integer('publicationDate');
            $table->integer('releaseDate');
            $table->json('contributors');
            $table->json('languages');
            $table->string('model');
            $table->string('color');
            $table->string('size');
            $table->string('edition');
            $table->string('format');
            $table->json('features');
            $table->string('description');
            $table->json('hazardousMaterials');
            $table->integer('packageHeight');
            $table->integer('packageLength');
            $table->integer('packageWidth');
            $table->integer('packageWeight');
            $table->integer('packageQuantity');
            $table->integer('itemHeight');
            $table->integer('itemLength');
            $table->integer('itemWidth');
            $table->integer('itemWeight');
            $table->integer('availabilityAmazon');
            $table->json('availabilityAmazonDelay');
            $table->json('buyBoxEligibleOfferCounts');
            $table->integer('competitivePriceThreshold');
            $table->integer('suggestedLowerPrice');
            $table->json('ebayListingIds');
            $table->boolean('isAdultProduct');
            $table->boolean('isHeatSensitive');
            $table->boolean('isMerchOnDemand');
            $table->boolean('isHaul');
            $table->boolean('launchpad');
            $table->string('audienceRating');
            $table->string('ingredients');
            $table->string('urlSlug');
            $table->integer('returnRate');
            $table->boolean('newPriceIsMAP');
            $table->boolean('isEligibleForTradeIn');
            $table->boolean('isEligibleForSuperSaverShipping');
            $table->json('fbaFees');
            $table->integer('variableClosingFee');
            $table->double('referralFeePercentage');
            $table->json('variations');
            $table->json('coupon');
            $table->json('couponHistory');
            $table->json('promotions');
            $table->json('unitCount');
            $table->json('stats');
            $table->bigInteger('salesRankReference');
            $table->json('salesRankReferenceHistory');
            $table->json('salesRanks');
            $table->integer('lastSoldUpdate');
            $table->integer('monthlySold');
            $table->json('monthlySoldHistory');
            $table->string('rentalDetails');
            $table->string('rentalSellerId');
            $table->json('rentalPrices');
            $table->json('reviews');
            $table->json('offers');
            $table->json('liveOffersOrder');
            $table->json('buyBoxSellerIdHistory');
            $table->json('buyBoxUsedHistory');
            $table->boolean('isRedirectASIN');
            $table->boolean('isSNS');
            $table->boolean('offersSuccessful');
            $table->json('csv');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('keepas');
    }
};
