<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('keepas', function (Blueprint $table) {
            $table->decimal('current_price', 10, 2)->nullable();
            $table->decimal('highest_price', 10, 2)->nullable();
            $table->decimal('lowest_price', 10, 2)->nullable();
            $table->string('image')->nullable();
            $table->string('category')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('keepas', function (Blueprint $table) {
            $table->dropColumn('current_price');
            $table->dropColumn('highest_price');
            $table->dropColumn('lowest_price');
            $table->dropColumn('image');
            $table->dropColumn('category');
        });
    }
};
