// Function to escape HTML special characters
function sanitizeQuery(unsafe) {
    return unsafe
        .replace(/\\/g, '\\\\')   // Escape backslashes
        .replace(/"/g, "'")       // Convert double quotes to single quotes
        .replace(/'/g, "\\'")     // Escape single quotes for JavaScript
        .replace(/;/g, '')        // Remove semicolons
        .replace(/--/g, '');       // Remove SQL comments
}

function escapeForOnclick(str) {
    return str
        .replace(/\\/g, '\\\\')  // Escape backslashes
        .replace(/"/g, '&quot;'); // Replace double quotes with HTML-safe equivalent
}


// Chat window toggle function
window.toggleChatWindow = function() {
    const chatWindow = document.getElementById('chatWindow');
    if (chatWindow.style.display === 'none' || chatWindow.style.display === '') {
        chatWindow.style.display = 'block';
    } else {
        chatWindow.style.display = 'none';
    }
};

// Handle messages from iframe
function displayTablePage(page) {
    let table = "<p style='font-size:small; color:darkcyan;'>Your question: " + pt + "</p><table class='table table-bordered'><thead><tr>";

    let columns = Object.keys(dt[0] || {});
    columns.forEach(col => table += `<th>${col}</th>`);
    table += "</tr></thead><tbody>";

    let start = (page - 1) * rowsPerPage;
    let end = start + rowsPerPage;
    let paginatedData = dt.slice(start, end);

    paginatedData.forEach(row => {
        table += "<tr>";
        columns.forEach(col => table += `<td style="font-size:small;">${row[col]}</td>`);
        table += "</tr>";
    });

    table += "</tbody></table>";

    let sanitizedPt = escapeForOnclick(sanitizeQuery(pt));
    let sanitizedAns = escapeForOnclick(sanitizeQuery(ans));

    table += "<div class='pagination' style='margin-top: 10px;'>";
    for (let i = 1; i <= Math.ceil(dt.length / rowsPerPage); i++) {
        let activeClass = (i === page) ? 'btn-primary' : 'btn-light';
        table += `<button class='btn ${activeClass}' style='background-color: ${i === page ? '#007bff !important' : '#f8f9fa !important'}; color: ${i === page ? '#fff !important' : '#000 !important'};' onclick='displayTablePage(${i})'>${i}</button>`;
    }
    /*
    table += `<button class='btn btn-success' 
    onclick='sendFeedback(1, "${sanitizedPt}", "${sanitizedAns}", "${ans_id}")' 
    style='font-size:small; background-color:aliceblue !important'>Yes</button>`;
    */
    table += "</div>";
    table += "<p style='font-size:small; color:darkcyan;'>Do you like this answer?</p>";
    table += `<button class='btn btn-success' 
    onclick='sendFeedback(1, "${sanitizedPt}", "${ans_id}")' 
    style='font-size:small; background-color:aliceblue !important'>Yes</button>`;
    table += `<button class='btn btn-success' 
    onclick='sendFeedback(0, "${sanitizedPt}", "${ans_id}")' 
    style='font-size:small; background-color:aliceblue !important'>No</button>`;

    queryResults.innerHTML = table;
}

window.addEventListener('message', function(event) {
    console.log('Message received 1:', event.data);
    
    if (event.data && event.data.type === 'showQueryModal') {
        var queryResults = document.getElementById('queryResults');
        var resultModal = document.getElementById('resultModal');
        
        if (event.data.data) {
            dt = event.data.data;
            pt = event.data.prompt;
            ans = event.data.answer;
            ans_id = event.data.id;

            currentPage = 1;
            rowsPerPage = 5;

            displayTablePage(currentPage);
            $(resultModal).modal('show');
        } else if (event.data.error) {
            queryResults.textContent = "Error: " + event.data.error;
            $(resultModal).modal('show');
        }
    }
});

// Here I want sendFeedback unction. I want to save yes or no feedback to database. I also want to save the question and answer to database.
// I will use ajax to send the data to the server.
function sendFeedback(feedback, prompt, answer) {
    //before sending the feedback, I want to show a message to the user that the feedback is being saved.
    let resultModal = document.getElementById('resultModal');
    let queryResults = document.getElementById('queryResults');
    queryResults.innerHTML = "<p style='font-size:small; color:darkcyan;'>Saving feedback...</p>";

    let data = {
        "feedback": feedback,
        "prompt": prompt,
        "answer": answer,
        "business_id": "1",//businessId, // I will get businessId from the server
        "user_id": "1" //userId // I will get userId from the server
    };

    $.ajax({
        type: "POST",
        url: "/vhai-feedback",
        data: data,
        success: function(response) {
            console.log(response);
            queryResults.innerHTML = "<p style='font-size:small; color:darkcyan;'>Feedback saved successfully.</p>";
            //$(resultModal).modal('hide');
        },
        error: function(error) {
            console.error(error);
        }
    });
}

