function initChatListener() {
    if (typeof $ === 'undefined') {
        console.error('jQuery not loaded');
        return;
    }

    window.addEventListener('message', function(event) {
        console.log('Message received 2:', event.data);
        
        if (event.data && event.data.type === 'showQueryModal') {
            if (event.data.data) {
                // Handle success case
                $('#queryResults').html(JSON.stringify(event.data.data, null, 2));
                $('#resultModal').modal('show');
            } else if (event.data.error) {
                // Handle error case
                $('#queryResults').html("Error: " + event.data.error);
                $('#resultModal').modal('show');
            }
        }
    });
}

// Try to initialize immediately if jQuery is already loaded
if (typeof $ !== 'undefined') {
    initChatListener();
} else {
    // Otherwise wait for jQuery to load
    window.addEventListener('load', function() {
        if (typeof $ !== 'undefined') {
            initChatListener();
        }
    });
}
