$(document).ready(function() {
    // Handle events from iframe
    $(window).on('showQueryModal', function(event, data) {
        console.log('Event received:', data);
        
        if (data.data) {
            let dt = JSON.parse(data.data);
            console.log(dt);
            let table = "<table class='table table-bordered'><thead><tr>";

            // Generate table headers dynamically
            let columns = Object.keys(dt[0] || {});
            columns.forEach(col => table += `<th>${col}</th>`);
            table += "</tr></thead><tbody>";

            dt.forEach(row => {
                table += "<tr>";
                columns.forEach(col => table += `<td>${row[col]}</td>`);
                table += "</tr>";
            });

            table += "</tbody></table>";


            //$('#queryResults').html(JSON.stringify(data.data, null, 2));
            $('#queryResults').html(table);
            $('#resultModal').modal('show');
        } else if (data.error) {
            // Handle error case
            $('#queryResults').html("Error: " + data.error);
            $('#resultModal').modal('show');
        }
    });
});
