$(document).ready(function() {
    $('table#product_table tbody').find('.label-date-picker').each( function(){
        $(this).datepicker({
            autoclose: true
        });
    });
    //Add products
    if ($('#search_product_for_label').length > 0) {
        $('#search_product_for_label')
            .autocomplete({
                source: '/purchases/get_products?check_enable_stock=false',
                minLength: 2,
                response: function(event, ui) {
                    if (ui.content.length == 1) {
                        ui.item = ui.content[0];
                        $(this)
                            .data('ui-autocomplete')
                            ._trigger('select', 'autocompleteselect', ui);
                        $(this).autocomplete('close');
                    } else if (ui.content.length == 0) {
                        swal(LANG.no_products_found);
                    }
                },
                select: function(event, ui) {
                    $(this).val(null);
                    get_label_product_row(ui.item.product_id, ui.item.variation_id);
                },
            })
            .autocomplete('instance')._renderItem = function(ul, item) {
            return $('<li>')
                .append('<div>' + item.text + '</div>')
                .appendTo(ul);
        };
    }

    $('input#is_show_price').change(function() {
        if ($(this).is(':checked')) {
            $('div#price_type_div').show();
        } else {
            $('div#price_type_div').hide();
        }
    });

    $('i.label_remove_row').on('click', function(e) {
        $('table#product_table tbody').html('');
    });

    $('button#labels_preview').click(function() {
        if ($('form#preview_setting_form table#product_table tbody tr').length > 0) {
            var url = base_path + '/labels/preview?' + $('form#preview_setting_form').serialize();

            window.open(url, 'newwindow');

            // $.ajax({
            //     method: 'get',
            //     url: '/labels/preview',
            //     dataType: 'json',
            //     data: $('form#preview_setting_form').serialize(),
            //     success: function(result) {
            //         if (result.success) {
            //             $('div.display_label_div').removeClass('hide');
            //             $('div#preview_box').html(result.html);
            //             __currency_convert_recursively($('div#preview_box'));
            //         } else {
            //             toastr.error(result.msg);
            //         }
            //     },
            // });
        } else {
            swal(LANG.label_no_product_error).then(value => {
                $('#search_product_for_label').focus();
            });
        }
    });

    $(document).on('click', 'button#print_label', function() {
        window.print();
    });

    $('#labels_update_settings').on('click', function() {
        var product_name_size = $('#product_name_size').val();
        var product_variation_size = $('#product_variation_size').val();
        var product_price_size = $('#product_price_size').val();
        var business_name_size = $('#business_name_size').val();
        var print_packing_date_size = $('#print_packing_date_size').val();
        var print_expiry_date_size = $('#print_expiry_date_size').val();
        var print_lot_number_size = $('#print_lot_number_size').val();
        var barcode_setting = $('#barcode_setting').val();
        $.ajax({
            method: 'POST',
            url: '/labels/update-settings',
            dataType: 'json',
            data: { product_name_size: product_name_size, product_variation_size: product_variation_size, product_price_size: product_price_size, business_name_size: business_name_size, print_packing_date_size: print_packing_date_size, print_expiry_date_size: print_expiry_date_size, print_lot_number_size: print_lot_number_size, barcode_setting: barcode_setting },
            success: function(result) {                
                if(result.rc == 1) {
                    toastr.success(result.rm);
                } else {
                    toastr.error(result.rm);
                }
            },
        });
    })
});

function label_remove_row(index) {
    $('#tr_row_index_'+index).remove();
}

function get_label_product_row(product_id, variation_id) {
    if (product_id) {
        var row_count = $('table#product_table tbody tr').length;
        $.ajax({
            method: 'GET',
            url: '/labels/add-product-row',
            dataType: 'html',
            data: { product_id: product_id, row_count: row_count, variation_id: variation_id },
            success: function(result) {
                $('table#product_table tbody').append(result);

                $('table#product_table tbody').find('.label-date-picker').each( function(){
                    $(this).datepicker({
                        autoclose: true
                    });
                });
            },
        });
    }
}
