$(document).ready(function() {
    $(document).on('change', '.purchase_quantity', function() {
        update_table_total($(this).closest('table'));
    });
    $(document).on('change', '.unit_price', function() {
        update_table_total($(this).closest('table'));
    });

    $('.os_exp_date').datepicker({
        autoclose: true,
        format: datepicker_date_format,
    });

    $(document).on('click', '.add_stock_row', function() {
        var tr = $(this).data('row-html');
        var key = parseInt($(this).data('sub-key'));
        tr = tr.replace(/\__subkey__/g, key);
        $(this).data('sub-key', key + 1);

        $(tr)
            .insertAfter($(this).closest('tr'))
            .find('.os_exp_date')
            .datepicker({
                autoclose: true,
                format: datepicker_date_format,
            });
            
            $(this).closest('tr').next('tr').find('.os_date').datetimepicker({
                format: moment_date_format + ' ' + moment_time_format,
                ignoreReadonly: true,
            });
    });

    $(document).on('click', '.add-opening-stock', function(e) {
        e.preventDefault();
        $.ajax({
            url: $(this).data('href'),
            dataType: 'html',
            success: function(result) {
                $('#opening_stock_modal')
                    .html(result)
                    .modal('show');
            },
        });
    });
});

//Re-initialize data picker on modal opening
 $('#opening_stock_modal').on('shown.bs.modal', function(e) {
    $('#opening_stock_modal .os_exp_date').datepicker({
        autoclose: true,
        format: datepicker_date_format,
    });
    $('#opening_stock_modal .os_date').datetimepicker({
        format: moment_date_format + ' ' + moment_time_format,
        ignoreReadonly: true,
        widgetPositioning: {
            horizontal: 'right',
            vertical: 'bottom'
        }
    });
 });

 $('#savestock').on('click', function() {
    $('#pos-loader').css('display', 'inline-flex');
 })

$(document).on('click', 'button#add_opening_stock_btn', function(e) {
    e.preventDefault();
    var btn = $(this);
    var data = $('form#add_opening_stock_form').serialize();

    $.ajax({
        method: 'POST',
        url: $('form#add_opening_stock_form').attr('action'),
        dataType: 'json',
        data: data,
        beforeSend: function(xhr) {
            __disable_submit_button(btn);
            $('#pos-loader').css('display', 'inline-flex');
        },
        success: function(result) {
            $('#pos-loader').css('display', 'none')
            if (result.success == true) {
                $('#opening_stock_modal').modal('hide');
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
    });
    return false;
});

function update_table_total(table) {
    var total_subtotal = 0;
    table.find('tbody tr').each(function() {
        var qty = __read_number($(this).find('.purchase_quantity'));
        var unit_price = __read_number($(this).find('.unit_price'));
        var row_subtotal = qty * unit_price;
        $(this)
            .find('.row_subtotal_before_tax')
            .text(__number_f(row_subtotal));
        total_subtotal += row_subtotal;
    });
    table.find('tfoot tr #total_subtotal').text(__currency_trans_from_en(total_subtotal, true));
    table.find('tfoot tr #total_subtotal_hidden').val(total_subtotal);
}

var pattern_product = ['0','0','0','.','0','0'];
var arr_pattern_product = [];
var typeCashProduct = null;
var old_numpad_name_product = null;
function show_product_opening_numpad(e, name, type_numpad = 'amount') {
    e.preventDefault();    
    $('#add_opening_stock_numpad_div').removeClass('hide');
    old_numpad_name_product = name;
    if(type_numpad == 'amount') {
        var pattern_product = ['0', '0', '0', '.', '0', '0'];
        $(document).on('click', '.numPadCashAddOpening', function(e) {
            // var index = $(this).parent().parent().parent().parent().parent().parent().data('index');    
            // var valueindex = $(this).parent().parent().parent().parent().parent().parent().data('valueindex');    
            // var index00 = $(this).parent().parent().parent().parent().parent().parent().parent().data('index')
            // var valueindex00 = $(this).parent().parent().parent().parent().parent().parent().parent().data('valueindex')
            // // product_variation[0][variations][0][default_purchase_price]  
            // pattern_product = arr_pattern_product[valueindex] ? arr_pattern_product[valueindex] : arr_pattern_product[valueindex00] ? arr_pattern_product[valueindex00] : ['0','0','0','.','0','0']; 
            // name_input = 'single_dpp';
            e.preventDefault();
            let type = $(this).data('type');
            // empty_denomination()
            let curValue;
            switch ($(this).text()) {
                case '00':            
                    if(pattern_product[0] == '0' && pattern_product[1] == '0') {                
                        pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                        pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];
                        pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];
                        pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                        pattern_product[pattern_product.length - 1] = '0';            
                        
                        pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                        pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];
                        pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];
                        pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                        pattern_product[pattern_product.length - 1] = '0';                                            
                    }
        
                    //// console.log("pattern_product");
                    //// console.log(pattern_product);
        
                    curValue = pattern_product.join('');         
                    if(old_numpad_name_product == name) {   
                        if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                            //// console.log("basta 2 sifir");
                            $('input[name="'+name+'"').val(curValue.substring(2));
                        } else if (pattern_product[0] == '0') {
                            //// console.log("basta 1 sifir");
                            $('input[name="'+name+'"').val(curValue.substring(1));
                        } else {
                            // console.log('pattern_product[0] != 0');
                            //$("input[name="['+name+'""_"+row_index).val(curValue);
                            let row_index = $('#payment_row_index').val();
                            $('input[name="'+name+'"').val(curValue);
                        }
                    }
        
                    // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
        
                    // calculate_balance_due();
                    // $('input.pos_unit_price').trigger('change');
                    // arr_pattern_product.splice(valueindex00, 1, pattern_product);
                    // console.log(arr_pattern_product);
                    
                    $('input[name="'+name+'"').trigger('change');
                    break;
        
                default:            
                    if (!$('input[name="'+name+'"').val()) {
                        let last = pattern_product.findLastIndex((element) => (element = '0'));
                        pattern_product[last] = document.getElementsByClassName('payment-amount').innerText;
                        // console.log('pattern_product[last] : ' + pattern_product[last]);
                        curValue = pattern_product.join('');
                        if(old_numpad_name_product == name) {
                            if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                                // console.log('basta 2 sifir');
                                $('input[name="'+name+'"').val(curValue.substring(2));
                            } else if (pattern_product[0] == '0') {
                                // console.log('basta 1 sifir');
                                $('input[name="'+name+'"').val(curValue.substring(1));
                            } else {
                                // console.log('pattern_product[0] != 0');
                                $('input[name="'+name+'"').val(curValue);
                            }
                            // calculate_balance_due();
                            $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                            // calculate_balance_due();
                            // arr_pattern_product.splice(valueindex, 1, pattern_product);
                            // console.log(arr_pattern_product);
                            $('input[name="'+name+'"').trigger('change');
                        }
                    } else {
                        // // console.log('2541');
                        if(old_numpad_name_product == name) {
                            if(type == 'top') {                    
                                pattern_product[pattern_product.length - 6] = '0';
                                pattern_product[pattern_product.length - 5] = '0';
                                pattern_product[pattern_product.length - 4] = $(this).text();
                                pattern_product[pattern_product.length - 2] = '0';
                                pattern_product[pattern_product.length - 1] = '0';    
                                typeCashProduct = 'top';                                                                            
                            } else {         
                                if(typeCashProduct == 'top') {                                              
                                    pattern_product[pattern_product.length - 6] = 0;
                                    pattern_product[pattern_product.length - 5] = 0;
                                    pattern_product[pattern_product.length - 4] = 0;                        
                                } else {                        
                                    pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                                    pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];                        
                                    pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];                        
                                }
                                pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                                pattern_product[pattern_product.length - 1] = $(this).text();
                                typeCashProduct = 'middle';       
                            }
            
                            curValue = pattern_product.join('');                
                            if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                                // console.log('basta 2 sifir');
                                //$("#amount_"+row_index).val(curValue.substring(2));
            
                                $('input[name="'+name+'"').val(curValue.substring(2));
                            } else if (pattern_product[0] == '0') {
                                $('input[name="'+name+'"').val(curValue.substring(1));
                            } else {
                                $('input[name="'+name+'"').val(curValue);
                            }
                            // calculate_balance_due();
                            $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                            // calculate_balance_due();                
                            // arr_pattern_product.splice(valueindex, 1, pattern_product);
                            // console.log(arr_pattern_product);
                            $('input[name="'+name+'"').trigger('change');
                        }
                    }
        
                break;
            }
        
            $('input#single_dpp').trigger('change');
        })
        
        $(document).on('click', '.numPadCashAddOpeningDel', function (e) {
            //PALIGU
            e.preventDefault();
            let curValue;
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
            // var index = $(this).parent().parent().parent().parent().parent().parent().parent().data('index')
            // var valueindex = $(this).parent().parent().parent().parent().parent().parent().parent().data('valueindex')
           
            // pattern_product = arr_pattern_product[valueindex] ? arr_pattern_product[valueindex] : ['0','0','0','.','0','0']; 
            // name_input = 'single_dpp';   
            // let type = $(this).data('type');
            if(old_numpad_name_product == name) {
                pattern_product[pattern_product.length - 1] = pattern_product[pattern_product.length - 2];
                pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 4];
                pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 5];
                pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 6];
                pattern_product[pattern_product.length - 6] = '0';
            
                curValue = pattern_product.join('');
                if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                    //// console.log("basta 2 sifir");
                    $('input[name="'+name+'"').val(curValue.substring(2));
                } else if (pattern_product[0] == '0') {
                    //// console.log("basta 1 sifir");
                    $('input[name="'+name+'"').val(curValue.substring(1));
                } else {
                    //// console.log("pattern_product[0] != 0");
                    $('input[name="'+name+'"').val(curValue);
                }
                
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                if (Number(curValue) == 0) {        
                    let total = "0.00";
                    $('input[name="'+name+'"').val(total);        
                    // calculate_balance_due();
                    // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
                }
                // calculate_balance_due();
                // $('input.pos_unit_price').trigger('change');
                // arr_pattern_product.splice(valueindex, 1, pattern_product);
                // console.log(arr_pattern_product);
                $('input[name="'+name+'"').trigger('change');
            }
        });
        
        $(document).on('click', '.numPadCashAddOpeningClear', function (e) {
            //PALIGU    
            e.preventDefault();
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type'); 
            // var index = $(this).parent().parent().parent().parent().parent().parent().parent().data('index')
            // var valueindex = $(this).parent().parent().parent().parent().parent().parent().parent().data('valueindex')
            // pattern_product = arr_pattern_product[valueindex] ? arr_pattern_product[valueindex] : ['0','0','0','.','0','0']; 
            if(old_numpad_name_product == name) {
                name_input = 'single_dpp';
                total = "0.00";    
                let type = $(this).data('type');
                // let initValue = __read_number($('input.pos_unit_price').val());
                // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
                
                $('input[name="'+name+'"').val(total);
                // calculate_balance_due();
                // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
                // calculate_balance_due();    
                // $('input.pos_unit_price').trigger('change');
                
                pattern_product = ['0', '0', '0', '.', '0', '0'];
                // arr_pattern_product.splice(valueindex, 1, pattern_product);            
                $('input[name="'+name+'"').trigger('change');
            }
        });
    } else {        
        var pattern_qty = ['0','0','0','0'];      
        $(document).on('click', '.numPadCashAddOpening', function(e) {
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().data('type');    
            name_input = name;    
            // let type = $(this).data('type');            
            let curValue;
            if(old_numpad_name_product == name) {
                switch ($(this).text()) {            
                    default:            
                        if (!$('input[name="'+name_input+'"').val()) {
                            // let last = pattern_qty.findLastIndex((element) => (element = '0'));
                            // pattern_qty[last] = document.getElementsByClassName('payment-amount').innerText;
                            // // console.log('pattern_qty[last] : ' + pattern_qty[last]);
                            curValue = pattern_qty.join('');
                            // console.log("curValue if")
                            // console.log(curValue)
                            if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                                // // console.log('basta 2 sifir');
                                $('input[name="'+name_input+'"]').val(curValue.substring(2));
                            } else if (pattern_qty[0] == '0') {
                                // // console.log('basta 1 sifir');
                                $('input[name="'+name_input+'"]').val(curValue.substring(1));
                            } else {
                                // // console.log('pattern_qty[0] != 0');
                                $('input[name="'+name_input+'"]').val(curValue);
                            }
                            // calculate_balance_due();
                            // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                            // // calculate_balance_due();
                            // $('input.pos_unit_price').trigger('change');
                            old_numpad_name_product = name;
                        } else {
                            // // // console.log('2541');
                            if(old_numpad_name_product == name) {
                                if(type == 'top') {                    
                                    pattern_qty[pattern_qty.length - 4] = '0';
                                    pattern_qty[pattern_qty.length - 3] = '0';
                                    pattern_qty[pattern_qty.length - 2] = '0';                        
                                    pattern_qty[pattern_qty.length - 1] = $(this).text();                        
                                    typeCashProduct = 'top';                                                                            
                                } else {         
                                    if(typeCashProduct == 'top') {                                              
                                        pattern_qty[pattern_qty.length - 4] = 0;
                                        pattern_qty[pattern_qty.length - 3] = 0;                        
                                        pattern_qty[pattern_qty.length - 2] = 0;                        
                                    } else {                                                                
                                        pattern_qty[pattern_qty.length - 4] = pattern_qty[pattern_qty.length - 3];
                                        pattern_qty[pattern_qty.length - 3] = pattern_qty[pattern_qty.length - 2];                        
                                        pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 1];                        
                                    }
                                    // pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 1];
                                    pattern_qty[pattern_qty.length - 1] = $(this).text();
                                    typeCashProduct = 'middle';       
                                }
                                // // console.log("pattern_qty");
                                // // console.log(pattern_qty);        
                                curValue = pattern_qty.join(''); 
                                console.log(pattern_qty);
                                if(type_numpad == 'quantity_with_zero') {
                                    // if (pattern_qty[0] == '0' && pattern_qty[1] == '0' && pattern_qty[1] == '0') {
                                    //     // // console.log('basta 2 sifir');
                                    //     //$("#amount_"+row_index).val(curValue.substring(2));
                    
                                    //     $('input[name="'+name_input+'"]').val(curValue.substring(3));
                                    // } else if(pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                                    //     $('input[name="'+name_input+'"]').val(curValue.substring(2));
                                    // } else if(pattern_qty[0] == '0') {
                                    //     $('input[name="'+name_input+'"]').val(curValue.substring(1));
                                    // } else {
                                        $('input[name="'+name_input+'"]').val(curValue);
                                    // }
                                } else {
                                    if (pattern_qty[0] == '0' && pattern_qty[1] == '0' && pattern_qty[2] == '0') {
                                        // // console.log('basta 2 sifir');
                                        //$("#amount_"+row_index).val(curValue.substring(2));
                    
                                        $('input[name="'+name_input+'"]').val(curValue.substring(3));
                                    } else if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                                        $('input[name="'+name_input+'"]').val(curValue.substring(2));
                                    } else if (pattern_qty[0] == '0') {
                                        $('input[name="'+name_input+'"]').val(curValue.substring(1));
                                    } else {
                                        $('input[name="'+name_input+'"]').val(curValue);
                                    }
                                }
                                // calculate_balance_due();
                                // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                                // calculate_balance_due();
                                // $('input.pos_unit_price').trigger('change');
                                old_numpad_name_product = name;
                            }
                        }
            
                    break;
                }
            }
        })
        
        $(document).on('click', '.numPadCashAddOpeningDel', function (e) {
            //PALIGU
            let curValue;
            if(old_numpad_name_product == name) {
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
                name_input = name;   
                let type = $(this).data('type');
                
                pattern_qty[pattern_qty.length - 1] = pattern_qty[pattern_qty.length - 2];
                pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 3];
                pattern_qty[pattern_qty.length - 3] = pattern_qty[pattern_qty.length - 4];
                pattern_qty[pattern_qty.length - 4] = '0';
                
            
                curValue = pattern_qty.join('');
                // // console.log("curValue del")
                // // console.log(curValue)
                if (pattern_qty[0] == '0' && pattern_qty[1] == '0' && pattern_qty[2] == '0') {
                    // // console.log('basta 2 sifir');
                    //$("#amount_"+row_index).val(curValue.substring(2));
            
                    $('input[name="'+name_input+'"]').val(curValue.substring(3));
                } else if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                    $('input[name="'+name_input+'"]').val(curValue.substring(2));
                } else if (pattern_qty[0] == '0') {
                    $('input[name="'+name_input+'"]').val(curValue.substring(1));
                } else {
                    $('input[name="'+name_input+'"]').val(curValue);
                }
                
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                if (Number(curValue) == 0) {        
                    let total = "0";
                    $('input[name="'+name_input+'"]').val(total);        
                    // calculate_balance_due();
                    // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
                }
                // calculate_balance_due();
                // $('input.pos_unit_price').trigger('change');
                old_numpad_name_product = name;
            }
        });
        
        $(document).on('click', '.numPadCashAddOpeningClear', function (e) {
            //PALIGU    
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');    
            if(old_numpad_name_product == name) {
                name_input = name;
                if(type_numpad == 'qty') {
                    total = $('#quantity_remaining_old').val();    
                } else {
                    total = 0;
                }
                let type = $(this).data('type');
                // let initValue = __read_number($('input.pos_unit_price').val());
                // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
                
                $('input[name="'+name_input+'"]').val(total);
                // calculate_balance_due();
                // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
                // calculate_balance_due();    
                // $('input.pos_unit_price').trigger('change');
                
                pattern_qty = ['0', '0', '0', '0'];
                old_numpad_name_product = name;
            }
        });
    }
}