// Global state management
const POS = {
    selectedPaymentData: [],
    cardTransactionResult: "",
    cart: [],
    typeCash: null,
    selectedState: [],
    arr_pattern: [],
    old_numpad_name: null,
    config: {
        currency_precision: __currency_precision,
        amount_rounding_method: $('#amount_rounding_method').val() || 0
    }
};

// Cache commonly used selectors
const SELECTORS = {
    searchProduct: '#search_product',
    posTable: '#pos_table',
    customerSelect: '#customer_id',
    locationSelect: '#select_location_id',
    finalTotal: '#final_total_input',
    modalPayment: '#modal_payment'
};

// Initialize POS system
$(document).ready(function() {
    initializeEventHandlers();
    initializeDefaultState();
    // Auto-focus search product field
    $('body').on('keypress', function(event) {
        const $searchProduct = $(SELECTORS.searchProduct);
        $searchProduct.focus();
        if ($searchProduct.val().length < 1) {
            $searchProduct.val(event.key);
        }
    });
    
    $('[data-toggle="tooltip"]').tooltip({
        trigger : 'hover',
        delay: { show: 'show', hide: 500 }
    }) 

    $('#pos_type').val('pos');
    $('#product_display').select2({
        placeholder: "Display Option"
    });    

    $('#product_category').multiselect({
        nonSelectedText:'Category Options',
        selectAllValue: 'multiselect-all',
        // enableCaseInsensitiveFiltering: true,
        // enableFiltering: true,
        maxHeight: '300',
        buttonWidth: '235',
        onChange: function(element, checked) {
            var brands = $('#multiselect1 option:selected');
            var selected = [];
            $(brands).each(function(index, brand){
                selected.push([$(this).val()]);
            });

            // // // console.logselected);
        }
    });


    localStorage.setItem('cart', JSON.stringify([]));
    
    customer_set = false;
    //Prevent enter key function except texarea
    $('form').on('keyup keypress', function (e) {
        var keyCode = e.keyCode || e.which;

        if (keyCode === 13 && e.target.tagName != 'TEXTAREA') {
            e.preventDefault();
            return false;
        }
    });

    var urlRegisterFirst = $('#register_details').data('href');
    $('#register_details').data(
        'href',
        urlRegisterFirst + '?cash_register_list_id=' + $('#id_cash_register').val()
    );

    var urlCloseRegisterFirst = $('#close_register').data('href');
    $('#close_register').data('href', urlCloseRegisterFirst + '/' + $('#id_cash_register').val());

    //For edit pos form
    if ($('form#edit_pos_sell_form').length > 0) {
        pos_total_row();
        pos_form_obj = $('form#edit_pos_sell_form');
    } else {
        pos_form_obj = $('form#add_pos_sell_form');
    }
    if ($('form#edit_pos_sell_form').length > 0 || $('form#add_pos_sell_form').length > 0) {
        initialize_printer();
    }

    var temp_location = [{
        'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
        'sales_tax': $('#order_tax').html(),
        'items': $('.total_quantity').html(),
        'sub_total': $('.price_total').html(),
        'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
        'location_name': $('select#select_location_id').find(':selected').text(),
        'total': $('#final_total_input').val(),
        'promotion_slider_speed': $('#promotion_slider_speed').val(),
        'required_signature': $('#required_signature').val(),
    }]
    localStorage.setItem('location_picture', JSON.stringify(temp_location));
    localStorage.setItem('signature-customer', JSON.stringify([]));

    $('select#select_location_id').change(function () {
        reset_pos_form();

        var default_price_group = $(this).find(':selected').data('default_price_group');
        if (default_price_group) {
            if ($("#price_group option[value='" + default_price_group + "']").length > 0) {
                $('#price_group').val(default_price_group);
                $('#price_group').change();
            }
        }

        //Set default invoice scheme for location
        if ($('#invoice_scheme_id').length) {
            let invoice_scheme_id = $(this).find(':selected').data('default_invoice_scheme_id');
            $('#invoice_scheme_id').val(invoice_scheme_id).change();
        }

        //Set default invoice layout for location
        if ($('#invoice_layout_id').length) {
            let invoice_layout_id = $(this).find(':selected').data('default_invoice_layout_id');
            $('#invoice_layout_id').val(invoice_layout_id).change();
        }

        //Set default price group
        if ($('#default_price_group').length) {
            var dpg = default_price_group ? default_price_group : 0;
            $('#default_price_group').val(dpg);
        }

        // // // // console.log$(this).find(':selected').data('default_picture'));

        
        $('#default_picture').val($(this).find(':selected').data('default_picture'))
        $('#promotion_slider_speed').val($(this).find(':selected').data('promotion_slider_speed'))
        $('#required_signature').val($(this).find(':selected').data('required_signature'))
        
        $('#tax_calculation_amount').val($(this).find(':selected').data('default_tax_amount'))
        if($(this).find(':selected').data('show_numpad') == 1) {
            $('section.content').append(`
                <div class="numpad_div col-xs-12 hide" id="product_numpad_div1" data-type="cash" style="			
                    /* display: flex; */
                    /* align-items: center; */
                    /* justify-content: center; */
                    /* padding-right: 25px; */
                    position: absolute;
                    ">							
                    <div class="form-group">									
                        <div class="easy-numpad-number-container">
                            <table id="product_numpad1">
                                <thead>						
                                    <tr>
                                        
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">1</a></td>
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">2</a></td>
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">3</a></td>							
                                    </tr>
                                    <tr>
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">4</a></td>
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">5</a></td>
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">6</a></td>
                                    </tr>
                                    <tr>
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">7</a></td>
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">8</a></td>
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">9</a></td>
                                    </tr>						
                                    <tr>
                                        <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">0</a></td>														
                                        <td style="padding: 10px;"><a href="#" class="numPadCashOtherClear" id="numPadCashOtherClear" style="padding: 10px ; width: 90px !important; height: 70px !important;">Clr</a></td>
                                        <td style="padding: 10px;"><a href="#" class="numPadCashOtherDel" id="numPadCashOtherDel" style="padding: 10px ; width: 90px !important; height: 70px !important;">DEL</a></td>									
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="padding: 10px;"><a href="#" class="numPadCashAddProductClose" id="numPadCashAddProductClose" onclick="event.preventDefault(); $('#product_numpad_div1').addClass('hide')" style="padding: 10px !important; width: calc(100% + -10px); margin-top:2px; height: 50px;">CLOSE</a></td>									
                                    </tr>
                                </thead>
                            </table>
                        </div>									
                    </div>							
                </div>
            `)
        } else {
            $('#product_numpad_div1').remove();
        }
        
        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }]
        localStorage.setItem('location_picture', JSON.stringify(temp_location));      
        localStorage.setItem('signature-customer', JSON.stringify([]));      
        localStorage.setItem('cart', JSON.stringify([]));

        set_payment_type_dropdown();

        if ($('#types_of_service_id').length && $('#types_of_service_id').val()) {
            $('#types_of_service_id').change();
        }
    });

    // get open cash register list
    $('select#select_cash_registers_list').change(function () {
        checkCashRegister(
            $('#select_cash_registers_list').val(),
            $('#select_location_id').val(),
            $('#id_cash_register').val()
        );
    });

    //get customer
    $('select#customer_id').select2({
        ajax: {
            url: '/contacts/customers',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page,
                };
            },
            processResults: function (data) {
                return {
                    results: data,
                };
            },
        },
        templateResult: function (data) {
            var template = '';
            if (data.supplier_business_name) {
                template += data.supplier_business_name + '<br>';
            }
            template += data.text + '<br>' + LANG.mobile + ': ' + data.mobile;

            if (typeof data.total_rp != 'undefined') {
                var rp = data.total_rp ? data.total_rp : 0;
                template += "<br><i class='fa fa-gift text-success'></i> " + rp;
            }

            return template;
        },
        minimumInputLength: 1,
        language: {
            noResults: function () {
                var name = $('#customer_id').data('select2').dropdown.$search.val();
                return (
                    '<button type="button" data-name="' +
                    name +
                    '" class="btn btn-link add_new_customer"><i class="fa fa-plus-circle fa-lg" aria-hidden="true"></i>&nbsp; ' +
                    __translate('add_name_as_new_customer', { name: name }) +
                    '</button>'
                );
            },
        },
        escapeMarkup: function (markup) {
            return markup;
        },
    });
    $('#customer_id').on('select2:select', function (e) {
        var data = e.params.data;
        if (data.pay_term_number) {
            $('input#pay_term_number').val(data.pay_term_number);
        } else {
            $('input#pay_term_number').val('');
        }

        if (data.pay_term_type) {
            $('#add_sell_form select[name="pay_term_type"]').val(data.pay_term_type);
            $('#edit_sell_form select[name="pay_term_type"]').val(data.pay_term_type);
        } else {
            $('#add_sell_form select[name="pay_term_type"]').val('');
            $('#edit_sell_form select[name="pay_term_type"]').val('');
        }

        update_shipping_address(data);
        $('#advance_balance_text').text(__currency_trans_from_en(data.balance), true);
        $('#advance_balance').val(data.balance);

        if (data.price_calculation_type == 'selling_price_group') {
            $('#price_group').val(data.selling_price_group_id);
            $('#price_group').change();
        } else {
            $('#price_group').val('');
            $('#price_group').change();
        }
        if ($('.contact_due_text').length) {
            $('#id_contact').val(data.id)
            get_contact_due(data.id);
        }
        var promises = [];
        $('#pos_table tbody')
        .find('tr')
        .each(function () {
            var d = new $.Deferred;
            var discount_percent = data.discount_percent ? data.discount_percent : 0;
            var price_calculation_type = data.price_calculation_type ? data.price_calculation_type : 'fixed';
            $(this).find('.row_discount_amount').val(discount_percent);
            $(this).find('.row_discount_type').val(price_calculation_type);
            $('input.row_discount_amount').trigger('change');
            pos_each_row($(this));
            d.resolve(true);
            promises.push(d.promise());
        });
        $.when.apply($, promises).done(function(){
            pos_total_row();
        });
    });

    set_default_customer();

    if ($('#search_product').length) {

        var date_exp = new Date();
        // // // // console.logdate_exp_arr);
        //Add Product
        $('#search_product')
            .autocomplete({
                delay: 1000,
                source: function (request, response) {
                    var price_group = '';
                    var search_fields = [];
                    $('.search_fields:checked').each(function (i) {
                        search_fields[i] = $(this).val();
                    });

                    if ($('#price_group').length > 0) {
                        price_group = $('#price_group').val();
                    }
                    $.getJSON(
                        '/products/list',
                        {
                            price_group: price_group,
                            location_id: $('input#location_id').val(),
                            term: request.term,
                            not_for_selling: 0,
                            search_fields: search_fields,
                            check_qty: $('input#is_overselling_allowed').val() == 1 ? false : true,
                        },
                        response
                    );
                },
                minLength: 2,
                response: function (event, ui) {
                    if (ui.content.length == 1) {
                        ui.item = ui.content[0];

                        var is_overselling_allowed = false;                        
                        if ($('#is_overselling_allowed').val()) {                        
                            is_overselling_allowed = true;
                        }
                        var for_so = false;
                        if ($('#sale_type').length && $('#sale_type').val() == 'sales_order') {
                            for_so = true;
                        }

                        if (
                            (ui.item.enable_stock == 1 && ui.item.qty_available > 0) ||
                            ui.item.enable_stock == 0 ||
                            is_overselling_allowed ||
                            for_so
                        ) {
                            $(this)
                                .data('ui-autocomplete')
                                ._trigger('select', 'autocompleteselect', ui);
                            $(this).autocomplete('close');
                        }
                    } else if (ui.content.length == 0) {
                        toastr.error(LANG.no_products_found);
                        $('input#search_product').select();
                    }
                },
                focus: function (event, ui) {
                    if (ui.item.qty_available <= 0) {
                        return false;
                    }
                },
                select: function (event, ui) {
                    var searched_term = $(this).val();
                    var is_overselling_allowed = false;                    
                    if ($('#is_overselling_allowed').val()) {                        
                        is_overselling_allowed = true;
                    }
                    var for_so = false;
                    if ($('#sale_type').length && $('#sale_type').val() == 'sales_order') {
                        for_so = true;
                    }

                    var is_draft = false;
                    if (
                        $('input#status') &&
                        ($('input#status').val() == 'quotation' ||
                            $('input#status').val() == 'draft')
                    ) {
                        var is_draft = true;
                    }
                    
                    // // // console.logui.item)
                    if(isAfter(ui.item.exp_date, date_exp) || ui.item.exp_date == null) {
                        if (
                            ui.item.enable_stock != 1 ||
                            ui.item.qty_available > 0 ||
                            is_overselling_allowed ||
                            for_so ||
                            is_draft                        
                        ) {
                            $(this).val(null);                        
                            //Pre select lot number only if the searched term is same as the lot number
                            var purchase_line_id =
                                ui.item.purchase_line_id && searched_term == ui.item.lot_number
                                    ? ui.item.purchase_line_id
                                    : null;                                            
                            
                            var other_id = null;
                            if(ui.item.vhomni_type == 'shopify') {
                                other_id = ui.item.shopify_id;
                            } else if(ui.item.vhomni_type == 'bigcommerce') {
                                other_id = ui.item.big_commerce_id;
                            } else if(ui.item.vhomni_type == 'woocommerce') {
                                other_id = ui.item.woo_commerce_id;
                            }
    
                            pos_product_row(ui.item.variation_id, purchase_line_id, null, 1, ui.item.vhomni_type, other_id);
                        } else {
                            toast.error(LANG.out_of_stock);
                        }
                    } else {
                        var expired_text = LANG.available_stock_expired;
                        toastr.error(expired_text);
                    }
                },
            })
            .autocomplete('instance')._renderItem = function (ul, item) {
            var is_overselling_allowed = false;            
            if ($('#is_overselling_allowed').val()) {
                is_overselling_allowed = true;
            }

            var for_so = false;
            if ($('#sale_type').length && $('#sale_type').val() == 'sales_order') {
                for_so = true;
            }
            var is_draft = false;
            if (
                $('input#status') &&
                ($('input#status').val() == 'quotation' || $('input#status').val() == 'draft')
            ) {
                var is_draft = true;
            }                      
            if (
                item.enable_stock == 1 &&
                item.qty_available <= 0 &&
                !is_overselling_allowed &&
                !for_so &&
                !is_draft &&
                (isBefore(item.exp_date, date_exp) || 
                    item.exp_date == null)
            ) {
                var string = '<li class="ui-state-disabled">' + item.name;
                if (item.type == 'variable') {
                    string += '-' + item.variation;
                }
                var selling_price = item.selling_price;
                if (item.variation_group_price) {
                    selling_price = item.variation_group_price;
                }
                string +=
                    ' (' +
                    item.sub_sku +
                    ')' +
                    '<br> ' +
                    selling_price +
                    ' (Out of stock) </li>';
                            
                return $(string).appendTo(ul);
            } else {
                var string = '<div>' + item.name;
                if (item.type == 'variable') {
                    string += ' - ' + item.variation;
                }

                var selling_price = item.selling_price;
                if (item.variation_group_price) {
                    selling_price = item.variation_group_price;
                }

                string += ' (' + item.sub_sku + ')' + '<br>';
                if (item.enable_stock == 1) {
                    var qty_available = __currency_trans_from_en(
                        item.qty_available,
                        false,
                        false,
                        __currency_precision,
                        true
                    );
                    // string += '<span style="margin: 0 float-right;">'  + ' ' + item.unit;
                    string += 'Remaining Quantity: '+ qty_available +'<span style="margin: 0;">';
                }
                string += '<span style="font-size: 20px;font-weight: 600;float: right;"> '+ __currency_trans_from_en(selling_price, true, false, __currency_precision, false) +'</span></span></div>';
                

                return $('<li>').append(string).appendTo(ul);
            }
        };
    }

    //Update line total and check for quantity not greater than max quantity
    $('table#pos_table tbody').on('change', 'input.pos_quantity', function () {
        if (sell_form_validator) {
            sell_form.valid();
        }
        if (pos_form_validator) {
            pos_form_validator.element($(this));
        }
        // var max_qty = parseFloat($(this).data('rule-max'));
        var entered_qty = __read_number($(this));

        var tr = $(this).parents('tr');

        // var unit_price_inc_tax = __read_number(tr.find('input.pos_unit_price'));
        var unit_price_inc_tax = calculate_discounted_unit_price(tr); 
        var line_total = entered_qty * unit_price_inc_tax;        
        
        __write_number(tr.find('input.pos_line_total'), line_total, false, 2);
        tr.find('span.pos_line_total_text').text(__currency_trans_from_en(line_total, true));

        //Change modifier quantity
        tr.find('.modifier_qty_text').each(function () {
            $(this).text(__currency_trans_from_en(entered_qty, false));
        });
        tr.find('.modifiers_quantity').each(function () {
            $(this).val(entered_qty);
        });

        pos_total_row();

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }

            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));

        adjustComboQty(tr);
    });

    //If change in unit price update price including tax and line total
    $('table#pos_table tbody').on('change', 'input.pos_unit_price', function () {
        var unit_price = __read_number($(this));
        var tr = $(this).parents('tr');

        //calculate discounted unit price
        var discounted_unit_price = calculate_discounted_unit_price(tr);

        var tax_rate = tr.find('select.tax_id').find(':selected').data('rate');
        var quantity = __read_number(tr.find('input.pos_quantity'));

        // var unit_price_inc_tax = __add_percent(discounted_unit_price, tax_rate);
        var unit_price_inc_tax = $(this).val();
        var line_total = quantity * unit_price_inc_tax;        
        __write_number(tr.find('input.pos_unit_price_inc_tax'), unit_price_inc_tax);
        __write_number(tr.find('input.pos_line_total'), line_total);
        tr.find('span.pos_line_total_text').text(__currency_trans_from_en(line_total, true));
        pos_each_row(tr);
        pos_total_row();

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }

            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));
        round_row_to_iraqi_dinnar(tr);
    });

    //If change in tax rate then update unit price according to it.
    $('table#pos_table tbody').on('change', 'select.tax_id', function () {
        var tr = $(this).parents('tr');

        var tax_rate = tr.find('select.tax_id').find(':selected').data('rate');
        var unit_price_inc_tax = __read_number(tr.find('input.pos_unit_price_inc_tax'));        
        var discounted_unit_price = __get_principle(unit_price_inc_tax, tax_rate);
        var unit_price = get_unit_price_from_discounted_unit_price(tr, discounted_unit_price);
        __write_number(tr.find('input.pos_unit_price'), unit_price);
        pos_each_row(tr);
    });

    //If change in unit price including tax, update unit price
    $('table#pos_table tbody').on('change', 'input.pos_unit_price_inc_tax', function () {
        var unit_price_inc_tax = __read_number($(this));

        if (iraqi_selling_price_adjustment) {
            unit_price_inc_tax = round_to_iraqi_dinnar(unit_price_inc_tax);
            __write_number($(this), unit_price_inc_tax);
        }

        var tr = $(this).parents('tr');

        var tax_rate = tr.find('select.tax_id').find(':selected').data('rate');
        var quantity = __read_number(tr.find('input.pos_quantity'));

        var line_total = quantity * unit_price_inc_tax;
        var discounted_unit_price = __get_principle(unit_price_inc_tax, tax_rate);
        var unit_price = get_unit_price_from_discounted_unit_price(tr, discounted_unit_price);

        __write_number(tr.find('input.pos_unit_price'), unit_price);
        __write_number(tr.find('input.pos_line_total'), line_total, false, 2);
        tr.find('span.pos_line_total_text').text(__currency_trans_from_en(line_total, true));

        pos_each_row(tr);
        pos_total_row();

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }

            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));
    });

    //Change max quantity rule if lot number changes
    $('table#pos_table tbody').on('change', 'select.lot_number', function () {
        var qty_element = $(this).closest('tr').find('input.pos_quantity');

        var tr = $(this).closest('tr');
        var multiplier = 1;
        var unit_name = '';
        var sub_unit_length = tr.find('select.sub_unit').length;
        if (sub_unit_length > 0) {
            var select = tr.find('select.sub_unit');
            multiplier = parseFloat(select.find(':selected').data('multiplier'));
            unit_name = select.find(':selected').data('unit_name');
        }
        var allow_overselling = qty_element.data('allow-overselling');
        if ($(this).val() && !allow_overselling) {
            var lot_qty = $('option:selected', $(this)).data('qty_available');
            var max_err_msg = $('option:selected', $(this)).data('msg-max');

            if (sub_unit_length > 0) {
                lot_qty = lot_qty / multiplier;
                var lot_qty_formated = __number_f(lot_qty, false);
                max_err_msg = __translate('lot_max_qty_error', {
                    max_val: lot_qty_formated,
                    unit_name: unit_name,
                });
            }

            qty_element.attr('data-rule-max-value', lot_qty);
            qty_element.attr('data-msg-max-value', max_err_msg);

            qty_element.rules('add', {
                'max-value': lot_qty,
                messages: {
                    'max-value': max_err_msg,
                },
            });
        } else {
            var default_qty = qty_element.data('qty_available');
            var default_err_msg = qty_element.data('msg_max_default');
            if (sub_unit_length > 0) {
                default_qty = default_qty / multiplier;
                var lot_qty_formated = __number_f(default_qty, false);
                default_err_msg = __translate('pos_max_qty_error', {
                    max_val: lot_qty_formated,
                    unit_name: unit_name,
                });
            }

            qty_element.attr('data-rule-max-value', default_qty);
            qty_element.attr('data-msg-max-value', default_err_msg);

            qty_element.rules('add', {
                'max-value': default_qty,
                messages: {
                    'max-value': default_err_msg,
                },
            });
        }
        qty_element.trigger('change');
    });

    //Change in row discount type or discount amount
    $('table#pos_table tbody').on(
        'change',
        'select.row_discount_type, input.row_discount_amount',
        function () {
            var tr = $(this).parents('tr');

            //calculate discounted unit price
            var discounted_unit_price = calculate_discounted_unit_price(tr);

            // var tax_rate = tr.find('select.tax_id').find(':selected').data('rate');
            var tax_rate = __read_number(tr.find('tax_rete'));
            var quantity = __read_number(tr.find('input.pos_quantity'));

            var unit_price_inc_tax = __add_percent(discounted_unit_price, tax_rate);
            var line_total = quantity * unit_price_inc_tax;

            __write_number(tr.find('input.pos_unit_price_inc_tax'), unit_price_inc_tax);
            __write_number(tr.find('input.pos_line_total'), line_total, false, 2);
            tr.find('span.pos_line_total_text').text(__currency_trans_from_en(line_total, true));
            pos_each_row(tr);
            pos_total_row();

            var temp_cart = [];
            $('table#pos_table tr.product_row').each(function() {
                var cart_item = {
                    'product': $(this).find('span.cursor-pointer').html(),
                    'qty': $(this).find('.pos_quantity').val(),
                    'subtotal': $(this).find('.pos_line_total_text').html()
                }

                temp_cart.push(cart_item)
                // // // // console.log$(this).find('span.cursor-pointer').html);
            });
            cart = temp_cart;                
            localStorage.setItem('cart', JSON.stringify(cart))

            var temp_location = [{
                'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
                'sales_tax': $('#order_tax').html(),
                'items': $('.total_quantity').html(),
                'sub_total': $('.price_total').html(),
                'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
                'location_name': $('select#select_location_id').find(':selected').text(),
                'total': $('#final_total_input').val(),
                'promotion_slider_speed': $('#promotion_slider_speed').val(),
                'required_signature': $('#required_signature').val(),
            }];
            localStorage.setItem('location_picture', JSON.stringify(temp_location));
            localStorage.setItem('signature-customer', JSON.stringify([]));
            round_row_to_iraqi_dinnar(tr);
        }
    );

    //Remove row on click on remove row
    $('table#pos_table tbody').on('click', 'i.pos_remove_row', function () {
        // // // // console.log$(this).parents('tr').html());
        $(this).parents('tr').remove();    
        var temp_cart = [];
     
        var no = 0;
        $('table#pos_table tr.product_row').each(function() {
            no++;
        });
        if(no == 0) {
            $('input#discount_amount_modal').val(0);
            $('input#discount_amount').val(0);
        }
        // $('input#discount_amount_modal').val();
        pos_total_row();
        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }
            
            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));

    });

    //Cancel the invoice
    $('button#pos-cancel').click(function () {
        swal({
            title: LANG.sure,
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        }).then((confirm) => {
            if (confirm) {
                // // console.log'masuk cancel')
                localStorage.setItem('cart', JSON.stringify([]));

                $('#pos-loader').css('display', 'inline-flex')
                reset_pos_form();                      
            }
        });
    });

    //Save invoice as draft
    $('button#pos-draft').click(function () {
        //Check if product is present or not.
        if ($('table#pos_table tbody').find('.product_row').length <= 0) {
            toastr.warning(LANG.no_products_added);
            return false;
        }

        var is_valid = isValidPosForm();
        if (is_valid != true) {
            return;
        }

        var data = pos_form_obj.serialize();
        data = data + '&status=draft';
        var url = pos_form_obj.attr('action');

        disable_pos_form_actions();
        $.ajax({
            method: 'POST',
            url: url,
            data: data,
            dataType: 'json',
            success: function (result) {
                enable_pos_form_actions();
                if (result.success == 1) {
                    reset_pos_form();
                    toastr.success(result.msg);
                } else {
                    toastr.error(result.msg);
                }
            },
        });
    });

    //Save invoice as Quotation
    $('button#pos-quotation').click(function () {
        //Check if product is present or not.
        if ($('table#pos_table tbody').find('.product_row').length <= 0) {
            toastr.warning(LANG.no_products_added);
            return false;
        }

        var is_valid = isValidPosForm();
        if (is_valid != true) {
            return;
        }

        var data = pos_form_obj.serialize();
        data = data + '&status=quotation';
        var url = pos_form_obj.attr('action');

        disable_pos_form_actions();
        $.ajax({
            method: 'POST',
            url: url,
            data: data,
            dataType: 'json',
            success: function (result) {
                enable_pos_form_actions();
                if (result.success == 1) {
                    reset_pos_form();
                    toastr.success(result.msg);

                    //Check if enabled or not
                    if (result.receipt.is_enabled) {
                        pos_print(result.receipt);
                    }
                } else {
                    toastr.error(result.msg);
                }
            },
        });
    });

    //Finalize invoice, open payment modal
    $('button#pos-finalize').click(function () {
        //Check first Cash Register is Pick or not
        var select_cash_registers_list = $('#select_cash_registers_list').val() ? $('#select_cash_registers_list').val() : $('#cash_register_list_id').val(); 
        var signature = JSON.parse(localStorage.getItem('signature-customer'));   
        var required_signature = $('#required_signature').val();     
        var total_payable = $('span#total_payable').html();        
        if(select_cash_registers_list) {
            if(total_payable >= 0) {
                //Check if product is present or not.
                if ($('table#pos_table tbody').find('.product_row').length <= 0) {
                    toastr.warning(LANG.no_products_added);
                    return false;
                }
                goahead = true;
                if(required_signature == 1) {
                    if(signature.length > 0) {
                        goahead = true;
                    } else {
                        goahead = false;
                        toastr.warning('The customer has not signed');
                    }
                } else {
                    goahead = true;
                }
    
                if(goahead) {
                    if ($('#reward_point_enabled').length) {
                        var validate_rp = isValidatRewardPoint();
                        if (!validate_rp['is_valid']) {
                            toastr.error(validate_rp['msg']);
                            return false;
                        }
                    }
                    // var default_location_id = $('#default_location').val();
                    var location_id = $('#select_location_id').val();
                    var id_cash_register = $('#cash_register_list_id').val();
                    $.ajax({
                        method: 'get',
                        url: /check-cash-register-open/ + id_cash_register,
                        success: function(result) {
                            if (result.count == 1) {
                                if ($('table#pos_table tbody').find('.product_row').length <= 0) {
                                    toastr.warning(LANG.no_products_added);
                                    return false;
                                }
                    
                                if ($('#reward_point_enabled').length) {
                                    var validate_rp = isValidatRewardPoint();
                                    if (!validate_rp['is_valid']) {
                                        toastr.error(validate_rp['msg']);
                                        return false;
                                    }
                                }
                                $('body').off('keypress');
                                // reset_pos_form()
                                $('#modal_payment')
                                    .find('.remove_payment_row')
                                    .each(function () {
                                        $(this).closest('.payment_row').remove();
                                    });
                                $('#total_row_payment').val(1);                        
                                $('#modal_payment').modal('show');
                                $('#info-payment').css('top', '-60px');
    
                                $('div.payment_details_div[data-type=card]').addClass('hide');
                                $('div.payment_details_div[data-type=cash]').css('display', 'none');
                                $('div.payment_details_div[data-type=cash]').addClass('hide');
                                $('div.payment_details_div[data-type=debit]').addClass('hide');
    
                                $("#amount_0").removeAttr('readonly');
                                $('#method_0').removeAttr('disabled');
                                $('#add-payment-row').addClass('hide');
                                $('input#method_0').each(function() { 
                                    if($(this).val()) {
                                        // console.log$(this).parent());
                                        $(this).parent().removeClass('hide');
                                        $(this).parent().css('display', '');                    
                                    }                                              
                                }); 
                            } else {
                                alert('You have to open the register');
                            }
                        }
                    });
                }
            } else {
                toastr.error("Amount can't be minus");
            }
        } else {
            toastr.warning('You have to choose the register')
        }

    });


    $('#modal_payment').on('shown.bs.modal', function () {
        // // // // console.log'modal_payment on');
        // $('#modal_payment').find('input').filter(':visible:first').focus().select();
        $('#amount_0').val(__read_number($('input#final_total_input')));
        // pattern = ['0','0','0','.','0','0'];
        calculate_balance_due();
        $('body').off('keypress');
        if ($('form#edit_pos_sell_form').length == 0) {
            $(this).find('#method_0').change();
        }
    });

    $('#modal_payment').on('hidden.bs.modal', function () {
        $('#modal_payment')
            .find('.remove_payment_row')
            .each(function () {
                $(this).closest('.payment_row').remove();
            });
        $('#total_payment_row').val(1);
        $('#amount_0').val(__read_number($('input#final_total_input')));
        calculate_balance_due();
        pattern = ['0','0','0','.','0','0'];
        $('.payment-method-now input[type="radio"]').prop('checked', false);
        $('.payment-method-now input[type="radio"]').attr('checked', false);
        $('body').on('keypress', function (event) {
            document.getElementById('search_product').focus();
            var text = $('#search_product').val();
            if (text.length < 1) {
                $('#search_product').val(event.keyup);
            }
        });
        selectedPaymentData = [];
        // console.logselectedPaymentData);
    });

    //Finalize without showing payment options
    $('button.pos-express-finalize').click(function () {
        // // // // console.log"Hold clicked");
        //Check if product is present or not.
        if ($('table#pos_table tbody').find('.product_row').length <= 0) {
            toastr.warning(LANG.no_products_added);
            return false;
        }

        if ($('#reward_point_enabled').length) {
            var validate_rp = isValidatRewardPoint();
            if (!validate_rp['is_valid']) {
                toastr.error(validate_rp['msg']);
                return false;
            }
        }

        var pay_method = $(this).data('pay_method');        
        // // // // console.logpay_method)

        //If pay method is credit sale submit form
        if (pay_method == 'credit_sale') {
            $('#is_credit_sale').val(1);
            pos_form_obj.submit();
            return true;
        } else {
            if ($('#is_credit_sale').length) {
                $('#is_credit_sale').val(0);
            }
        }

        //Check for remaining balance & add it in 1st payment row
        var total_payable = __read_number($('input#final_total_input'));
        var total_paying = __read_number($('input#total_paying_input'));
        if (total_payable > total_paying) {
            var bal_due = total_payable - total_paying;

            var first_row = $('#payment_rows_div').find('.payment-amount').first();
            var first_row_val = __read_number(first_row);
            first_row_val = first_row_val + bal_due;
            __write_number(first_row, first_row_val);
            first_row.trigger('change');
        }

   
        if (pay_method == 'card' || pay_method == 'debit') {
            $('div#card_details_modal').modal('show');
        } else if (pay_method == 'suspend') {            
            $('div#confirmSuspendModal').modal('show');
        } else {
            pos_form_obj.submit();
        }
    });

    $('div#card_details_modal').on('shown.bs.modal', function (e) {
        $('input#card_number').focus();
    });

    $('div#confirmSuspendModal').on('shown.bs.modal', function (e) {
        $('#confirmSuspendModal')
            .find('textarea')
            .filter(':visible:first')
            .focus()
            .select();        
        $('body').off('keypress');
        $('#is_suspend').val(1)
    });

    $('div#confirmSuspendModal').on('hidden.bs.modal', function(e) {
        $('body').on('keypress', function (event) {
            document.getElementById('search_product').focus();
            var text = $('#search_product').val();
            if (text.length < 1) {
                $('#search_product').val(event.keyup);
            }
        });
    })

    //on save card details
    $('button#pos-save-card').click(function () {
        $('input#card_number_0').val($('#card_number').val());
        $('input#card_holder_name_0').val($('#card_holder_name').val());
        $('input#card_transaction_number_0').val($('#card_transaction_number').val());
        $('select#card_type_0').val($('#card_type').val());
        $('input#card_month_0').val($('#card_month').val());
        $('input#card_year_0').val($('#card_year').val());
        $('input#card_security_0').val($('#card_security').val());

        $('div#card_details_modal').modal('hide');
        pos_form_obj.submit();
    });

   
    $('button#pos-suspend').click(function () {
        $('input#is_suspend').val(1);
        $('div#confirmSuspendModal').modal('hide');
        pos_form_obj.submit();
        $('input#is_suspend').val(0);
    });

    //fix select2 input issue on modal
    $('#modal_payment')
        .find('.select2')
        .each(function () {
            $(this).select2({
                dropdownParent: $('#modal_payment'),
            });
        });

    $('button#add-payment-row').click(function () {
        if(selectedPaymentData.length == 0) {
            swal({
                title: 'Warning',
                text: 'Please select payment method first',
                icon: 'warning',
            })
        } else {
            setSelectedPaymentData(); // PALIGU
            var row_index = $('#payment_row_index').val();
            // // // // console.log'row_index : ' + row_index);
            var location_id = $('input#location_id').val();
            $.ajax({
                method: 'POST',
                url: '/sells/pos/get_payment_row',
                data: { row_index: row_index, location_id: location_id, selectedPaymentData: selectedPaymentData },
                dataType: 'html',
                success: function (result) {
                    var total_payment_row = $('#total_payment_row').val();
                    var first_method = $('#method_0').val();
                    $('#amount_0').removeAttr('readonly')
                    if (total_payment_row < 2) {
                        if (result) {                                               
                            var appended = $('#payment_rows_div').append(result);

                            var total_payable = __read_number($('input#final_total_input'));
                            var total_paying = __read_number($('input#total_paying_input'));
                            var b_due = total_payable - total_paying;
                            $(appended).find('input.payment-amount').focus();
                            $(appended)
                                .find('input.payment-amount')
                                .last()
                                .val(__currency_trans_from_en(b_due, false))
                                .change()
                                .select();
                            __select2($(appended).find('.select2'));
                            $(appended)
                                .find('#method_' + row_index)
                                .change();
                            $('#payment_row_index').val(parseInt(row_index) + 1);
                            $('#total_payment_row').val(parseInt(total_payment_row) + 1);
                           
                            
                        }
                        $('#total_payment_row').val(parseInt(total_payment_row) + 1);
                        total_payment_row = $('#total_payment_row').val();
                        if (total_payment_row > 1) {
                            var elements = document.getElementsByClassName('payment-amount');
                            // for (var i = 0; i < elements.length; i++) {
                            $('#amount_0').attr('readonly', true);
                            // // console.log'mantap');
                            $('input#method_0').each(function() {
                                if(!$(this).is(':checked')) {                                                                        
                                    $(this).parent().addClass('hide');
                                    $(this).parent().css('display', 'none');
                                }
                            });
                            
                            $('#add-payment-row').addClass('hide');                            
                            // $('.easy-numpad-number-container').css('display', 'none')
                            // $('input[id="method_0"]').attr('disabled', 'disabled');
                            // }
                            // $('.numPadCash').css('pointer-events', 'none');
                            // $('.numPadCashClear').css('pointer-events', 'none');
                            // $('.numPadCashDel').css('pointer-events', 'none');
                            // $('.numPadCash').css('cursor', 'none');
                            // $('.numPadCashClear').css('cursor', 'none');
                            // $('.numPadCashDel').css('cursor', 'none');
                        } else {
                            // $('.numPadCash').css('pointer-events', 'auto');
                            // $('.numPadCashClear').css('pointer-events', 'auto');
                            // $('.numPadCashDel').css('pointer-events', 'auto');
                            // $('.numPadCash').css('cursor', 'pointer');
                            // $('.numPadCashClear').css('cursor', 'pointer');
                            // $('.numPadCashDel').css('cursor', 'pointer');
                            $('#amount_0').removeAttr('readonly');
                            $('input[id="method_0"]').removeAttr('disabled');  
                            // $('input[id="method_0"]').attr('disabled', 'disabled');                      
                        }
                    } else {
                        // alert('Can only use two payment row');
                        alert('You can only user two payment rows');
                    }
                },
            });
        }
    });

    $(document).on('click', '.remove_payment_row', function () {
        setSelectedPaymentData(); // PALIGU
        swal({
            title: LANG.sure,
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                var total_payment_row = $('#total_payment_row').val();
                $(this).closest('.payment_row').remove();                
                calculate_balance_due();
                $('#total_payment_row').val(parseInt(total_payment_row) - 1);                
                $('.numPadCash').css('pointer-events', 'auto');
                $('.numPadCashClear').css('pointer-events', 'auto');
                $('.numPadCashDel').css('pointer-events', 'auto');
                $('.numPadCash').css('cursor', 'pointer');
                $('.numPadCashClear').css('cursor', 'pointer');
                $('.numPadCashDel').css('cursor', 'pointer');
                $('#amount_0').removeAttr('readonly');
                $('input[id="method_0"]').removeAttr('disabled');  
                // $('#amount_0').val(__read_number($('input#final_total_input')));
                $('.easy-numpad-number-container').css('display', 'block');
                // pattern = ['0','0','0','.','0','0'];
                var amount_normal = $('span#total_payable').html();                
                $('#amount_0').val(amount_normal);   
                $('input#method_0').each(function() { 
                    if($(this).val()) {
                        // console.log$(this).parent());
                        $(this).parent().removeClass('hide');
                        $(this).parent().css('display', '');                    
                    }                                              
                });                 
                calculate_balance_due();
                var length_row_payment = $('input.payment-amount');
                if(length_row_payment.length > 1) {
                    $('#add-payment-row').addClass('hide');
                } else {        
                    if($('#in_balance_due').val() == '0.00' || $('#in_balance_due').val() == 0) {
                        $('#add-payment-row').addClass('hide');
                    } else {
                        $('#add-payment-row').removeClass('hide');
                    }
                }
                $('#pos-save').removeAttr('disabled');
            }
        });
    });

    pos_form_validator = pos_form_obj.validate({
        submitHandler: function (form) {                                     
            var cnf = true;
            var retrefCard = null;
            var promises = [];
            $.each(selectedPaymentData, function(k,v) {
                // console.log(v)
                if(parseFloat(v.amount) <= 0) {                             
                    swal({
                        title: 'Warning',
                        text: 'Amount cannot be minus',
                        icon: 'warning'
                    });
                    cnf = false;
                    return false;
                }
            })


            if(cnf) {
                //Ignore if the difference is less than 0.5
                if ($('input#in_balance_due').val() >= 0.5) {
                    cnf = confirm(LANG.paid_amount_is_less_than_payable);
                    
                }

                var total_advance_payments = 0;
                
                                    
                $.each(selectedPaymentData, function(k,v) {
                    var d = new $.Deferred;
                    if(v.method == 'card' || v.method == 'debit') {
                        // alert(v.amount)
                        let sessionKey = '';
                        let branch_id = $('input#location_id').val();
                        let pos_id = $('input#cash_register_list_id').val();
                        let credit_or_debit = 'credit';

                        if (window.localStorage.hasOwnProperty('localClientTime')) {
                            var dateTimeNow = new Date();
                            var localClientSessionStartTime = new Date(
                                window.localStorage.getItem('localClientTime').toString()
                            );
                            var diff = (dateTimeNow.getTime() - localClientSessionStartTime.getTime()) / 1000;
                            diff /= 60;
                            //// // // console.log'Diff : ' + diff);
                            if (diff >= 9) {
                                sessionKey = 'Request New Session Key';
                                window.localStorage.setItem('localClientTime', dateTimeNow);
                            } else {
                                if (!window.localStorage.getItem('sessionKey')) {
                                    window.localStorage.setItem('localClientTime', dateTimeNow);
                                    sessionKey = 'Request New Session Key';
                                    window.localStorage.removeItem('sessionKey');
                                } else {
                                    // // // // console.log'found session key!');
                                    sessionKey = window.localStorage.getItem('sessionKey').toString();
                                }
                            }
                        } else {
                            var localClientTime = new Date();
                            window.localStorage.setItem('localClientTime', localClientTime);
                            sessionKey = 'Request New Session Key';
                        }
                        //END- Check if session is valid or expired

                        //START- Gateway Transaction
                        // // // // console.log'1993, ajax will start');
                        // // // // console.log'sessionKey');
                        // // // // console.logsessionKey);
                        // console.log"Ajax will start");
                        $.ajax({
                            type: 'POST',
                            url: '/sells/pos/card_pointe_authCard',
                            data: {
                                amount: v.amount,
                                sessionKey: sessionKey,
                                branch_id: branch_id,
                                pos_id: pos_id,
                                credit_or_debit: credit_or_debit,
                            },
                            beforeSend: function() {
                                $('#pos-loader').css('display', 'inline-flex')
                            },
                            success: function (result) {
                                $('#pos-loader').css('display', 'none')
                                // // console.log"success");
                                // // console.logresult);
                                let resultArray = result.split('#');
                                let sessionHeader = resultArray[0];
                                //console.log('resultArray[1]');
                                //console.log(resultArray[1]);
                                if(sessionHeader != 'session not expired' && sessionHeader.length > 2) {										
                                    // // // // console.logsessionHeader);
                                    let resultSession = sessionHeader.split(': ');
                                    // // // // console.logresultSession[1]);
                                    let resultSessionValue = resultSession[1].split(';');
                                    // // // // console.logresultSessionValue[0]);
                                    localStorage.setItem('sessionKey', resultSessionValue[0]);
                                } else {
                                    localStorage.removeItem('sessionKey');
                                }
                                if(resultArray[1].length < 2) {
                                    if(resultArray[1]) {
                                        saveCardTransactionResult(JSON.parse(resultArray[1], false, v.amount)); // save failed transaction details to database
                                    } else {
                                        var result_fake = '{"amount": "'+v.amount+'","resptext": "No result from gateway","respcode": "999"}';
                                        saveCardTransactionResult(JSON.parse(result_fake, false, v.amount)); // save failed transaction details to database
                                    }                            
                                    d.resolve({
                                        'rc' : 500,
                                        'data' : null,
                                        'msg' : 'There is an error with transaction, please contact VHPOS'
                                    });
                                } else {											
                                let jsonResult = JSON.parse(resultArray[1]);
                                //CHECK IF PAYMENT PROCESSED SUCCESSFULLY
                                if (jsonResult.errorMessage) {
                                    saveCardTransactionResult(jsonResult, false, v.amount);
                                    if (jsonResult.errorMessage === 'Operation Cancelled') {
                                        transactionResult = 'Operation Cancelled';
                                        cardTransactionResult = "Customer has cancelled the transaction!";
                                    } else if (jsonResult.errorMessage === 'Command Cancelled') {
                                        transactionResult = 'Command Cancelled';
                                        cardTransactionResult = "Customer not accepted the amount!";
                                    } else {
                                        const errTime = Date.now();
                                        window.localStorage.setItem(
                                            errTime + '_jsonResult.errorMessage',
                                            jsonResult.errorMessage
                                        );
                                    }
                                    // alert(jsonResult.errorMessage)
                                    // swal('Information', jsonResult.errorMessage, 'warning');
                                    swal({
                                        title: jsonResult.errorMessage,
                                        icon: 'warning',
                                        // buttons: true,
                                        dangerMode: true,
                                    })
                                    d.resolve({
                                        'rc' : 500,
                                        'data' : null,
                                        'msg' : jsonResult.errorMessage
                                    })
                                    $('#pos-save').removeAttr('disabled')
                                    stop();
                                } else {
                                    // No error message
                                    //START- SAVE TRANSACTION INFORMATION TO cardTransactions TABLE
                                    if(jsonResult.respcode) {
                                        //console.log('jsonResult.respcode');
                                        //console.log(jsonResult.respcode);
                                        if (jsonResult.respcode == '000' || jsonResult.respcode == '002' || jsonResult.respcode == '003' || jsonResult.respcode == '00' || jsonResult.respcode == '0' || jsonResult.respcode == '10' || jsonResult.respcode == 'A00') {
                                            //console.log('1901');
                                            let token = '';
                                            let expiry = '';
                                            let name = '';
                                            let retref = '';
                                            let respproc = '';
                                            let amount = '';
                                            let resptext = '';
                                            let authcode = '';
                                            let respcode = '';
                                            let merchid = '';
                                            let PIN = '';
                                            let signature = '';
                                            let networkLabel = '';
                                            let applicationPreferredName = '';
                                            let AID = '';
                                            let applicationLabel = '';
                                            let entrymode = '';
                                            let country = '';
                                            let bin = '';
                                            let issuer = '';

                                            try {
                                                let creditCardData = jsonResult;
                                                let emvTagData, binInfo;

                                                if (creditCardData.emvTagData) {
                                                    emvTagData = JSON.parse(creditCardData.emvTagData);
                                                    PIN = emvTagData.PIN;
                                                    signature = emvTagData.Signature;
                                                    networkLabel = emvTagData['Network Label'];
                                                    applicationPreferredName =
                                                        emvTagData['Application Preferred Name'];
                                                    AID = emvTagData.AID;
                                                    applicationLabel = emvTagData['Application Label'];
                                                }

                                                if (creditCardData.binInfo) {
                                                    binInfo = creditCardData.binInfo;
                                                    country = binInfo.country;
                                                    bin = binInfo.bin;
                                                    issuer = binInfo.issuer;
                                                }
                                                if (creditCardData.token) {
                                                    token = creditCardData.token;
                                                }
                                                if (creditCardData.expiry) {
                                                    expiry = creditCardData.expiry;
                                                }
                                                if (creditCardData.name) {
                                                    name = creditCardData.name;
                                                }
                                                if (creditCardData.retref) {
                                                    retref = creditCardData.retref;
                                                    retrefCard = retref;
                                                }
                                                if (creditCardData.respproc) {
                                                    respproc = creditCardData.respproc;
                                                }
                                                if (creditCardData.amount) {
                                                    amount = creditCardData.amount;
                                                }
                                                if (creditCardData.resptext) {
                                                    resptext = creditCardData.resptext;
                                                }
                                                if (creditCardData.authcode) {
                                                    authcode = creditCardData.authcode;
                                                }
                                                if (creditCardData.respcode) {
                                                    respcode = creditCardData.respcode;
                                                }
                                                if (creditCardData.merchid) {
                                                    merchid = creditCardData.merchid;
                                                }
                                                if (creditCardData.entrymode) {
                                                    entrymode = creditCardData.entrymode;
                                                }

                                                let carData = {
                                                    token: token,
                                                    expiry: expiry,
                                                    name: name,
                                                    retref: retref,
                                                    respproc: respproc,
                                                    amount: amount,
                                                    resptext: resptext,
                                                    authcode: authcode,
                                                    respcode: respcode,
                                                    merchid: merchid,
                                                    PIN: PIN,
                                                    signature: signature,
                                                    networkLabel: networkLabel,
                                                    applicationPreferredName: applicationPreferredName,
                                                    AID: AID,
                                                    applicationLabel: applicationLabel,
                                                    // invoiceid : invoiceid,
                                                    entrymode: entrymode,
                                                    country: country,
                                                    bin: bin,
                                                    issuer: issuer,
                                                };
                                                // // // // console.log'carData :');
                                                // // // // console.logcarData);
                                                $.ajax({
                                                    type: 'POST',
                                                    url: '/sells/pos/card_pointe_saveTransaction',
                                                    data: carData,
                                                    success: function (result) {
                                                        // // // // console.log'save transaction');
                                                        // // // // console.logresult);
                                                    },
                                                    error: function (error) {
                                                        // // // // console.logerror);
                                                        d.resolve({
                                                            'rc' : 500,
                                                            'data' : null,
                                                            'msg' : error
                                                        })
                                                    },
                                                });
                                                d.resolve({
                                                    'rc' : 200,
                                                    'data' : jsonResult,
                                                    'msg' : 'success'
                                                })
                                            } catch (error) {
                                                d.resolve({
                                                    'rc' : 500,
                                                    'data' : null,
                                                    'msg' : error
                                                })
                                                // // // // console.logerror);
                                            }

                                            
                                        } else {
                                            //console.log('2037');
                                            saveCardTransactionResult(jsonResult, false, v.amount);
                                            if(jsonResult.resptext) {
                                                /* swal({
                                                    title: jsonResult.resptext,
                                                    icon: 'warning',
                                                    // buttons: true,
                                                    dangerMode: true,
                                                }) */
                                                d.resolve({
                                                    'rc' : 500,
                                                    'data' : null,
                                                    'msg' : jsonResult.resptext
                                                })
                                            } else {
                                                /* swal({
                                                    title: 'Problem with credit card',
                                                    icon: 'warning',
                                                    // buttons: true,
                                                    dangerMode: true,
                                                }) */
                                                d.resolve({
                                                    'rc' : 500,
                                                    'data' : null,
                                                    'msg' : 'Problem with credit card'
                                                })
                                            }
                                            //d.resolve(false)
                                            $('#pos-save').removeAttr('disabled')
                                            stop();
                                        }
                                    } else { 
                                        d.resolve({
                                            'rc' : 500,
                                            'data' : null,
                                            'msg' : 'There is an error with transaction please contact VHPOS'
                                        })                                             
                                        $('#pos-save').removeAttr('disabled')
                                        stop();
                                    }
                                    //END- SAVE TRANSACTION INFORMATION TO cardTransactions TABLE
                                    cardTransactionResult = 'card payment done';
                                }    
                                }										
                            },
                            error: function (error) {
                                // console.log"error");
                                // console.logerror);
                                $('#pos-loader').css('display', 'none')
                                const errTime = Date.now();
                                window.localStorage.setItem(errTime + '_error381', error);
                                cardTransactionResult = error;
                                // console.error('error');
                                // console.error(error);    
                                d.resolve({
                                    'rc' : 500,
                                    'data' : null,
                                    'msg' : error
                                }) 
                                $('#pos-save').removeAttr('disabled')
                                stop();                                                                            
                                // if there is an error i should stop here and the showing message error to user
                            },
                        });
                        // console.log'under ajax');                    
                    } else {
                        // console.log'masuk sini rc 200')                        
                        d.resolve({
                            'rc': 200,
                            'data': null,
                            'msg': 'success'
                        });
                    }
                    // d.resolve({
                    //     'rc': 200,
                    //     'data': null,
                    //     'msg': 'success'
                    // });
                    promises.push(d.promise());
                })
                
                $.when.apply($, promises).done(function() {    
                    // console.logarguments);                                      
                    let result = arguments[0].rc;
                    let message_result = arguments[0].msg;
                    if(arguments.length > 1) {
                        result = arguments[1] ? arguments[1].rc : result;
                        message_result = arguments[1] ? arguments[1].msg : message_result;
                    }

                    if(result == 200) {
                        // // // console.log'message check payment method')
                        // // // console.log'Payment Success')
                        // // // // console.logcnf)
                        // if(cnf) { // // // console.logtrue) } else { // // // console.logfalse) };     
                        if (total_advance_payments > 1) {
                            alert(LANG.advance_payment_cannot_be_more_than_once);
                            return false;
                        }
            
                        var is_msp_valid = true;
                        //Validate minimum selling price if hidden
                        $('.pos_unit_price_inc_tax').each(function () {
                            if (!$(this).is(':visible') && $(this).data('rule-min-value')) {
                                var val = __read_number($(this));
                                var error_msg_td = $(this)
                                    .closest('tr')
                                    .find('.pos_line_total_text')
                                    .closest('td');
                                if (val > $(this).data('rule-min-value')) {
                                    is_msp_valid = false;
                                    error_msg_td.append(
                                        '<label class="error">' + $(this).data('msg-min-value') + '</label>'
                                    );
                                } else {
                                    error_msg_td.find('label.error').remove();
                                }
                            }
                        });
            
                        if (!is_msp_valid) {
                            return false;
                        }
            
                        // // // // console.log'cnf akhir: ' + cnf)
                        if (cnf) {
                            disable_pos_form_actions();
            
                            var signature = JSON.parse(localStorage.getItem('signature-customer'));
                                    
                            var data = $(form).serialize();
                            var data_form = $(form).serializeArray();
                            data = data + '&status=final&signature_customer='+signature;                        
                            var url = $(form).attr('action');
                            /* $.each(data_form, function(k,v) {
                                if(v.payment) {
                                    $.each(v.payment, function(kp,vp) {
                                        vp['method'] = $('#method_' + kp).is(':checked').val();
                                    });
                                }
                            })  
                            data_form['status'] = 'final';
                            data_form['signature_customer'] = signature;
                            // console.logdata_form); */
                            // // console.logurl)
                            $.ajax({
                                method: 'POST',
                                url: url,
                                data: data,                            
                                dataType: 'json',
                                beforeSend: function() {
                                    $('#pos-loader').css('display', 'inline-flex')
                                },
                                success: function (result) {
                                    $('#pos-loader').css('display', 'none')
                                    // // // // console.logresult);                        
                                    if (result.success == 1) {
                                        if(retrefCard) {
                                            $.ajax({
                                                type: 'POST',
                                                url: '/sells/pos/card_pointe_updateTransaction',
                                                data: {
                                                    invoiceid: result.invoiceid,
                                                    retref: retrefCard
                                                },
                                                success: function (result) {
                                                    // // // // console.log'save transaction');
                                                    // // // // console.logresult);
                                                },
                                                error: function (error) {
                                                    // // // // console.logerror);
                                                },
                                            });
                                        }
                                        if (result.whatsapp_link) {
                                            window.open(result.whatsapp_link);
                                        }
                                        $('#modal_payment').modal('hide');
                                        toastr.success(result.msg);
            
                                        reset_pos_form();
            
                                        localStorage.setItem('cart', JSON.stringify([]));
                                        var temp_location = [{
                                            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
                                            'sales_tax': $('#order_tax').html(),
                                            'items': $('.total_quantity').html(),
                                            'sub_total': $('.price_total').html(),
                                            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
                                            'location_name': $('select#select_location_id').find(':selected').text(),
                                            'total': $('#final_total_input').val(),
                                            'promotion_slider_speed': $('#promotion_slider_speed').val(),
                                            'required_signature': $('#required_signature').val(),
                                        }];
                                        localStorage.setItem('location_picture', JSON.stringify(temp_location));
                                        localStorage.setItem('signature-customer', JSON.stringify([]));
                                                    
                                        var objectForm = serializeObject(data_form);                                        
                                        if(objectForm.is_suspend[0] == 1) {
                                            toastr.success(result.msg);
                                        } else {
                                            swal({
                                                title: 'Payment Received',
                                                icon: 'success',
                                                // buttons: true,
                                                // dangerMode: true,
                                            }).then((confirm) => {                                
                                                //Check if enabled or not
                                                $.ajax({
                                                    method: 'GET',
                                                    url: base_path + '/sells/' + result.transactionid + '/print?check_location=true',                                                                                        
                                                    beforeSend: function() {                                                
                                                    },
                                                    success: function (result) {
                                                        if (result.receipt.is_enabled) {
                                                            pos_print(result.receipt);                                                                                        
                                                        }
                                                    },
                                                    error: function() {
                                                        // $('#pos-loader').css('display', 'none')
                                                    }
                                                });
                                                
                                            });
                                        }
                                    } else {
                                        toastr.error(result.msg);
                                    }
            
                                    enable_pos_form_actions();
                                },
                                error: function() {
                                    $('#pos-loader').css('display', 'none')
                                }
                            });
                        }       
                        return false;
                    } else {
                        // // // console.log'message check payment method')
                        // // // console.logarguments[0].msg)
                        swal({
                            title: 'Information',
                            text: message_result,
                            icon: 'warning',
                            // buttons: true,
                            dangerMode: true,
                        })
                    }
                    
                    promises = [];
                })
            }             
        },
    });

    $(document).on('change', '.payment-amount', function () {
        if($(this).val() > 0) {
            calculate_balance_due();
            setSelectedPaymentData(); // PALIGU
            var length_row_payment = $('input.payment-amount');
            if(length_row_payment.length > 1) {
                $('#add-payment-row').addClass('hide');
            } else {        
                if($('#in_balance_due').val() == '0.00' || $('#in_balance_due').val() == 0) {
                    $('#add-payment-row').addClass('hide');
                } else {
                    $('#add-payment-row').removeClass('hide');
                }
            }
            $('#pos-save').removeAttr('disabled');
            $('#error-payment-amount').remove();
        } else if($(this).val() <= 0) {  
            calculate_balance_due();    
            $('#pos-save').attr('disabled', true);      
            if($('#error-payment-amount').length == 0) {                
                $(this).parent().parent().append('<label class="error" id="error-payment-amount">Amount cannot be minus or zero</label>')
            }
        }
    });

    //Update discount
    $('button#posEditDiscountModalUpdate').click(function () {
        $('#posEditDiscountModal')
        .find('.remove_payment_row')
        .each(function () {
            $(this).closest('.payment_row').remove();
        });
        //if discount amount is not valid return false
        if (!$('#discount_amount_modal').valid()) {
            return false;
        }
        //Close modal
        $('div#posEditDiscountModal').modal('hide');

        //Update values
        $('input#discount_type').val($('select#discount_type_modal').val());
        __write_number($('input#discount_amount'), __read_number($('input#discount_amount_modal')));

        if ($('#reward_point_enabled').length) {
            var reward_validation = isValidatRewardPoint();
            if (!reward_validation['is_valid']) {
                toastr.error(reward_validation['msg']);
                $('#rp_redeemed_modal').val(0);
                $('#rp_redeemed_modal').change();
            }
            updateRedeemedAmount();
        }

        pos_total_row();

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }

            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));
    });

    $('#posEditDiscountModal').on('shown.bs.modal', function() {        
        $('#posEditDiscountModal')
            .find('input')
            .filter(':visible:first')
            .focus()
            .select();        
        $('body').off('keypress');         
    });

    $('#posEditDiscountModal').on('hidden.bs.modal', function() {
        $('body').on('keypress', function (event) {
            document.getElementById('search_product').focus();
            var text = $('#search_product').val();
            if (text.length < 1) {
                $('#search_product').val(event.keyup);
            }
        });
    });    

    //Shipping
    $('button#posShippingModalUpdate').click(function () {
        //Close modal
        $('div#posShippingModal').modal('hide');

        //update shipping details
        $('input#shipping_details').val($('#shipping_details_modal').val());

        $('input#shipping_address').val($('#shipping_address_modal').val());
        $('input#shipping_status').val($('#shipping_status_modal').val());
        $('input#delivered_to').val($('#delivered_to_modal').val());

        //Update shipping charges
        __write_number(
            $('input#shipping_charges'),
            __read_number($('input#shipping_charges_modal'))
        );

        //$('input#shipping_charges').val(__read_number($('input#shipping_charges_modal')));

        pos_total_row();

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }

            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));
    });

    $('#posShippingModal').on('shown.bs.modal', function () {
        $('#posShippingModal')
            .find('#shipping_details_modal')
            .filter(':visible:first')
            .focus()
            .select();
    });

    $(document).on('shown.bs.modal', '.row_edit_product_price_model', function () {
        $('.row_edit_product_price_model').find('input').filter(':visible:first').focus().select();
        /* $(this)
            .find('input')
            .filter(':visible:first')
            .focus()
            .select(); */
        $(this).find('input.pos_unit_price').click();
        $('body').off('keypress')
    });

    $(document).on('hidden.bs.modal', '.row_edit_product_price_model', function() {
        $('#product_numpad_div1').addClass('hide');
        $('body').on('keypress', function (event) {
            document.getElementById('search_product').focus();
            var text = $('#search_product').val();
            if (text.length < 1) {
                $('#search_product').val(event.keyup);
            }
        });
    })

    //Update Order tax
    $('button#posEditOrderTaxModalUpdate').click(function () {
        //Close modal
        $('div#posEditOrderTaxModal').modal('hide');

        var tax_obj = $('select#order_tax_modal');
        var tax_id = tax_obj.val();
        var tax_rate = tax_obj.find(':selected').data('rate');

        $('input#tax_rate_id').val(tax_id);

        __write_number($('input#tax_calculation_amount'), tax_rate);
        pos_total_row();

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }

            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));
    });

    $(document).on('click', '.add_new_customer', function () {
        $('#customer_id').select2('close');
        var name = $(this).data('name');
        $('.contact_modal').find('input#name').val(name);
        $('.contact_modal')
            .find('select#contact_type')
            .val('customer')
            .closest('div.contact_type_div')
            .addClass('hide');        
        $('.contact_modal').modal('show');
    });
    $('form#quick_add_contact')
        .submit(function (e) {
            e.preventDefault();
        })
        .validate({
            rules: {
                contact_id: {
                    remote: {
                        url: '/contacts/check-contacts-id',
                        type: 'post',
                        data: {
                            contact_id: function () {
                                return $('#contact_id').val();
                            },
                            hidden_id: function () {
                                if ($('#hidden_id').length) {
                                    return $('#hidden_id').val();
                                } else {
                                    return '';
                                }
                            },
                        },
                    },
                },
            },
            messages: {
                contact_id: {
                    remote: LANG.contact_id_already_exists,
                },
            },
            submitHandler: function (form) {
                $.ajax({
                    method: 'POST',
                    url: base_path + '/check-mobile',
                    dataType: 'json',
                    data: {
                        contact_id: function () {
                            return $('#hidden_id').val();
                        },
                        mobile_number: function () {
                            return $('#mobile').val();
                        },
                    },
                    beforeSend: function (xhr) {
                        __disable_submit_button($(form).find('button[type="submit"]'));
                    },
                    success: function (result) {
                        if (result.is_mobile_exists == true) {
                            swal({
                                title: LANG.sure,
                                text: result.msg,
                                icon: 'warning',
                                buttons: true,
                                dangerMode: true,
                            }).then((willContinue) => {
                                if (willContinue) {
                                    submitQuickContactForm(form);
                                } else {
                                    $('#mobile').select();
                                }
                            });
                        } else {
                            submitQuickContactForm(form);
                        }
                    },
                });
            },
        });

    $('.contact_modal').on('shown.bs.modal', function() {
        $(this)
            .find('input')
            .filter(':visible:first')
            .focus()
            .select();        
        $('body').off('keypress');
    })

    $('.contact_modal').on('hidden.bs.modal', function () {
        $('form#quick_add_contact').find('button[type="submit"]').removeAttr('disabled');
        $('form#quick_add_contact')[0].reset();
        $('body').on('keypress', function (event) {
            document.getElementById('search_product').focus();
            var text = $('#search_product').val();
            if (text.length < 1) {
                $('#search_product').val(event.keyup);
            }
        });
    });

    //Updates for add sell
    $(
        'select#discount_type, input#discount_amount, input#shipping_charges, \
        input#rp_redeemed_amount'
    ).change(function () {
        pos_total_row();

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }

            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));
    });
    $('select#tax_rate_id').change(function () {
        var tax_rate = $(this).find(':selected').data('rate');
        __write_number($('input#tax_calculation_amount'), tax_rate);
        pos_total_row();

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }

            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));
    });
    //Datetime picker
    $('#transaction_date').datetimepicker({
        format: moment_date_format + ' ' + moment_time_format,
        ignoreReadonly: true,
    });

    //Direct sell submit
    sell_form = $('form#add_sell_form');
    if ($('form#edit_sell_form').length) {
        sell_form = $('form#edit_sell_form');
        pos_total_row();

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }

            temp_cart.push(cart_item)
            // // // // console.log$(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))

        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
            'promotion_slider_speed': $('#promotion_slider_speed').val(),
            'required_signature': $('#required_signature').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
        localStorage.setItem('signature-customer', JSON.stringify([]));
    }
    sell_form_validator = sell_form.validate();

    $('button#submit-sell, button#save-and-print').click(function (e) {
        //Check if product is present or not.
        if ($('table#pos_table tbody').find('.product_row').length <= 0) {
            toastr.warning(LANG.no_products_added);
            return false;
        }

        var is_msp_valid = true;
        //Validate minimum selling price if hidden
        $('.pos_unit_price_inc_tax').each(function () {
            if (!$(this).is(':visible') && $(this).data('rule-min-value')) {
                var val = __read_number($(this));
                var error_msg_td = $(this).closest('tr').find('.pos_line_total_text').closest('td');
                if (val > $(this).data('rule-min-value')) {
                    is_msp_valid = false;
                    error_msg_td.append(
                        '<label class="error">' + $(this).data('msg-min-value') + '</label>'
                    );
                } else {
                    error_msg_td.find('label.error').remove();
                }
            }
        });

        if (!is_msp_valid) {
            return false;
        }

        if ($(this).attr('id') == 'save-and-print') {
            $('#is_save_and_print').val(1);
        } else {
            $('#is_save_and_print').val(0);
        }

        if ($('#reward_point_enabled').length) {
            var validate_rp = isValidatRewardPoint();
            if (!validate_rp['is_valid']) {
                toastr.error(validate_rp['msg']);
                return false;
            }
        }

        if ($('.enable_cash_denomination_for_payment_methods').length) {
            var payment_row = $('.enable_cash_denomination_for_payment_methods').closest(
                '.payment_row'
            );
            var is_valid = true;
            var payment_type = payment_row.find('.payment_types_dropdown').val();
            var denomination_for_payment_types = JSON.parse(
                $('.enable_cash_denomination_for_payment_methods').val()
            );
            if (
                denomination_for_payment_types.includes(payment_type) &&
                payment_row.find('.is_strict').length &&
                payment_row.find('.is_strict').val() === '1'
            ) {
                var payment_amount = __read_number(payment_row.find('.payment-amount'));
                var total_denomination = payment_row.find('input.denomination_total_amount').val();
                if (payment_amount != total_denomination) {
                    is_valid = false;
                }
            }

            if (!is_valid) {
                payment_row.find('.cash_denomination_error').removeClass('hide');
                toastr.error(payment_row.find('.cash_denomination_error').text());
                e.preventDefault();
                return false;
            } else {
                payment_row.find('.cash_denomination_error').addClass('hide');
            }
        }

        if (sell_form.valid()) {
            window.onbeforeunload = null;
            $(this).attr('disabled', true);
            $('#pos-loader').css('display', 'inline-flex')
            sell_form.submit();
        }
    });

    //REPAIR MODULE:check if repair module field is present send data to filter product
    var is_enabled_stock = null;
    if ($('#is_enabled_stock').length) {
        is_enabled_stock = $('#is_enabled_stock').val();
    }

    var device_model_id = null;
    if ($('#repair_model_id').length) {
        device_model_id = $('#repair_model_id').val();
    }

    //Show product list.
    get_product_suggestion_list(
        $('select#product_category').val(),
        $('select#product_brand').val(),
        $('input#location_id').val(),
        null,
        is_enabled_stock,
        device_model_id
    );
    $('select#product_category, select#product_brand, select#select_location_id, select#product_display').on(
        'change',
        function (e) {
            $('input#suggestion_page').val(1);
            var location_id = $('input#location_id').val();
            if (location_id != '' || location_id != undefined) {
                /* get_product_suggestion_list(
                $('select#product_category').val(),
                $('select#product_brand').val(),
                $('input#location_id').val(),
                null
            ); */                
                localStorage.setItem('display_option_selected', $('select#product_display').val());
                if($('select#product_display').val() == 'featured') {
                    $('select#product_category').multiselect("disable");
                } else {
                    $('select#product_category').multiselect("enable");
                    /* $('select#product_category').multiselect({
                        nonSelectedText:'Category Options',
                        selectAllValue: 'multiselect-all',
                        // enableCaseInsensitiveFiltering: true,
                        // enableFiltering: true,
                        maxHeight: '300',
                        buttonWidth: '235',
                        onChange: function(element, checked) {
                            var brands = $('#multiselect1 option:selected');
                            var selected = [];
                            $(brands).each(function(index, brand){
                                selected.push([$(this).val()]);
                            });

                            // // console.logselected);
                        }
                    }); */
                    $('.modal-backdrop').remove();
                }
                get_cash_registers_list(
                    $('input#location_id').val(),
                    $('#cash_register_list_id').val()
                );
                get_featured_products();
            }
        }
    );

    $(document).on('click', 'div.product_box', function () {
        //Check if location is not set then show error message.
        if ($('input#location_id').val() == '') {
            toastr.warning(LANG.select_location);
        } else {
            pos_product_row($(this).data('variation_id'));
        }
    });

    $(document).on('shown.bs.modal', '.row_description_modal', function () {
        $(this).find('textarea').first().focus();
    });

    //Press enter on search product to jump into last quantty and vice-versa
    $('#search_product').keydown(function (e) {
        var key = e.which;
        if (key == 9) {
            // the tab key code
            e.preventDefault();
            if ($('#pos_table tbody tr').length > 0) {
                $('#pos_table tbody tr:last').find('input.pos_quantity').focus().select();
            }
        }
    });
    $('#pos_table').on('keypress', 'input.pos_quantity', function (e) {
        var key = e.which;
        if (key == 13) {
            // the enter key code
            $('#search_product').focus();
        }
    });

    $('#exchange_rate').change(function () {
        var curr_exchange_rate = 1;
        if ($(this).val()) {
            curr_exchange_rate = __read_number($(this));
        }
        var total_payable = __read_number($('input#final_total_input'));
        var shown_total = total_payable * curr_exchange_rate;
        $('span#total_payable').text(__currency_trans_from_en(shown_total, false));
    });

    $('#search_recent_transaction').on('keyup paste', function() {
        var val = $(this).val();
        $('tr.cursor-pointer').each(function(k, v) {
            var a = $(this).find("td").eq(1).html();                        
            if(val) {
                if(a.includes(val)) {
                    // // // // console.log'block')
                    $(this).css('display', 'table-row')
                } else {
                    // // // // console.log'none')
                    $(this).css('display', 'none')
                }                
            } else {                    
                $(this).css('display', 'content')
            }
        })
    });

    $('select#price_group').change(function () {
        $('input#hidden_price_group').val($(this).val());
    });

    //Quick add product
    $(document).on('click', 'button.pos_add_quick_product', function () {
        var url = $(this).data('href');
        var container = $(this).data('container');
        $.ajax({
            url: url + '?product_for=pos',
            dataType: 'html',
            success: function (result) {
                $(container).html(result).modal('show');
                $('.os_exp_date').datepicker({
                    autoclose: true,
                    format: 'dd-mm-yyyy',
                    clearBtn: true,
                });
            },
        });
    });

    $(document).on('change', 'form#quick_add_product_form input#single_dpp', function () {
        var unit_price = __read_number($(this));
        $('table#quick_product_opening_stock_table tbody tr').each(function () {
            var input = $(this).find('input.unit_price');
            __write_number(input, unit_price);
            input.change();
        });
    });

    $(document).on('quickProductAdded', function (e) {
        //Check if location is not set then show error message.
        if ($('input#location_id').val() == '') {
            toastr.warning(LANG.select_location);
        } else {
            pos_product_row(e.variation.id);
        }
    });

    $('div.view_modal').on('show.bs.modal', function () {
        __currency_convert_recursively($(this));
    });

    $('table#pos_table').on('change', 'select.sub_unit', function () {
        var tr = $(this).closest('tr');
        var base_unit_selling_price = tr.find('input.hidden_base_unit_sell_price').val();

        var selected_option = $(this).find(':selected');

        var multiplier = parseFloat(selected_option.data('multiplier'));

        var allow_decimal = parseInt(selected_option.data('allow_decimal'));

        tr.find('input.base_unit_multiplier').val(multiplier);

        var unit_sp = base_unit_selling_price * multiplier;

        var sp_element = tr.find('input.pos_unit_price');
        __write_number(sp_element, unit_sp);

        sp_element.change();

        var qty_element = tr.find('input.pos_quantity');
        var base_max_avlbl = qty_element.data('qty_available');
        var error_msg_line = 'pos_max_qty_error';

        if (tr.find('select.lot_number').length > 0) {
            var lot_select = tr.find('select.lot_number');
            if (lot_select.val()) {
                base_max_avlbl = lot_select.find(':selected').data('qty_available');
                error_msg_line = 'lot_max_qty_error';
            }
        }

        qty_element.attr('data-decimal', allow_decimal);
        var abs_digit = true;
        if (allow_decimal) {
            abs_digit = false;
        }
        qty_element.rules('add', {
            abs_digit: abs_digit,
        });

        if (base_max_avlbl) {
            var max_avlbl = parseFloat(base_max_avlbl) / multiplier;
            var formated_max_avlbl = __number_f(max_avlbl);
            var unit_name = selected_option.data('unit_name');
            var max_err_msg = __translate(error_msg_line, {
                max_val: formated_max_avlbl,
                unit_name: unit_name,
            });
            qty_element.attr('data-rule-max-value', max_avlbl);
            qty_element.attr('data-msg-max-value', max_err_msg);
            qty_element.rules('add', {
                'max-value': max_avlbl,
                messages: {
                    'max-value': max_err_msg,
                },
            });
            qty_element.trigger('change');
        }
        adjustComboQty(tr);
    });

    //Confirmation before page load.
    window.onbeforeunload = function () {
        if ($('form#edit_pos_sell_form').length == 0) {
            if ($('table#pos_table tbody tr').length > 0) {
                return LANG.sure;
            } else {
                return null;
            }
        }
    };
    $(window).resize(function () {
        var win_height = $(window).height();
        div_height = __calculate_amount('percentage', 63, win_height);
        $('div.pos_product_div').css('min-height', div_height + 'px');
        $('div.pos_product_div').css('max-height', div_height + 'px');
    });

    //Used for weighing scale barcode
    $('#weighing_scale_modal').on('shown.bs.modal', function (e) {
        //Attach the scan event
        onScan.attachTo(document, {
            suffixKeyCodes: [13], // enter-key expected at the end of a scan
            reactToPaste: true, // Compatibility to built-in scanners in paste-mode (as opposed to keyboard-mode)
            onScan: function (sCode, iQty) {
                // // // console.log'Scanned: ' + iQty + 'x ' + sCode);
                $('input#weighing_scale_barcode').val(sCode);
                $('button#weighing_scale_submit').trigger('click');
            },
            onScanError: function (oDebug) {
                // // // // console.logoDebug);
            },
            minLength: 2,
            // onKeyDetect: function(iKeyCode){ // output all potentially relevant key events - great for debugging!
            //     // // // console.log'Pressed: ' + iKeyCode);
            // }
        });

        $('input#weighing_scale_barcode').focus();
    });

    $('#weighing_scale_modal').on('hide.bs.modal', function (e) {
        //Detach from the document once modal is closed.
        onScan.detachFrom(document);
    });

    $('button#weighing_scale_submit').click(function () {
        var price_group = '';
        if ($('#price_group').length > 0) {
            price_group = $('#price_group').val();
        }

        if ($('#weighing_scale_barcode').val().length > 0) {
            pos_product_row(null, null, $('#weighing_scale_barcode').val());
            $('#weighing_scale_modal').modal('hide');
            $('input#weighing_scale_barcode').val('');
        } else {
            $('input#weighing_scale_barcode').focus();
        }
    });    

    $('#show_featured_products').click(function () {
        if (!$('#featured_products_box').is(':visible')) {
            $('#featured_products_box').fadeIn();
        } else {
            $('#featured_products_box').fadeOut();
        }
    });
    validate_discount_field();
    set_payment_type_dropdown();
    if ($('#__is_mobile').length) {
        $('.pos_form_totals').css('margin-bottom', $('.pos-form-actions').height() - 30);
    }

    setInterval(function () {
        if ($('span.curr_datetime').length) {
            $('span.curr_datetime').html(__current_datetime());
        }
    }, 60000);

    set_search_fields();
    if(localStorage.getItem('display_option_selected')) {        
        $('select#product_display').select2().val(localStorage.getItem('display_option_selected')).trigger("change");
        if(localStorage.getItem('display_option_selected') == 'featured') {
            $('select#product_category').multiselect("disable");
        } else {            
            $('select#product_category').multiselect("enable");
            /* $('select#product_category').multiselect({
                nonSelectedText:'Category Options',
                selectAllValue: 'multiselect-all',
                // enableCaseInsensitiveFiltering: true,
                // enableFiltering: true,
                maxHeight: '300',
                buttonWidth: '235',
                onChange: function(element, checked) {
                    var brands = $('#multiselect1 option:selected');
                    var selected = [];
                    $(brands).each(function(index, brand){
                        selected.push([$(this).val()]);
                    });

                    // // console.logselected);
                }
            }); */
            $('.modal-backdrop').remove();
        }
    } else {
        $('select#product_display').select2().val('featured').trigger("change"); 
        $('select#product_category').multiselect("disable");
    }
    /* $('#product_category').select2({
        placeholder: "Category Option",
        templateSelection: formatSelect2
    }); */   
    
    $('#form_custom_modal').validate({
        debug: true,
        onkeyup: function(element) {
            $(element).valid()
        },
        onfocusout: function(element) {
            var $element = $(element);
            $element.valid();
        },
        rules: {
            product_custom_name: {
                required: true,
            },
            product_custom_quantity: {
                required: true,
                min: 1,
            },
            product_custom_amount: {
                min: 0.01,
                required: true,
            }
        },
        highlight: function (element, errorClass, validClass) {
            var $row = $(element).closest('.modal-body');
            $row.addClass('is-row-error');
            $row.removeClass('is-row-valid');
        },
        unhighlight: function (element, errorClass, validClass) {
            var $row = $(element).closest('.modal-body');
            $row.addClass('is-row-valid');
            $row.removeClass('is-row-error');
        }
    });
});

function show_numpad(row, name, element, id_input, type_numpad = 'amount') {             
    // $('input[name="'+name+'"]').val('1.00');     
    // $('#product_numpad_div' + row)        
    $('#product_numpad_div1').removeClass('hide');     
    $('#product_numpad_div1').css('top', '');   
    $('#product_numpad_div1').css('right', '');   
    $('#product_numpad_div1').css('width', '');   
    $('#product_numpad_div1').css('left', '');   
    $('#product_numpad_div1').css('z-index', '');   
    if(id_input == 'sell_return') {
        $('#product_numpad_div1').css('top', '34%');   
        $('#product_numpad_div1').css('right', '72%');   
        $('#product_numpad_div1').css('width', '20%');   
    } else if(id_input == 'row_product_edit' || id_input == 'custom_sale') {
        $('#product_numpad_div1').css('top', '10%');   
        $('#product_numpad_div1').css('left', '15%');   
        $('#product_numpad_div1').css('width', '15%');   
        $('#product_numpad_div1').css('z-index', '1051');   
        $('#product_numpad_div1').css('display', 'flex');           
    }
    // pattern = pattern_other;    
    old_numpad_name = name;
    if(type_numpad == 'amount') {
        var pattern_other = ['0','0','0','.','0','0'];
        let last_index = arr_pattern.findLastIndex((element) => (element.name = name));       
        $(document).on('click', '.numPadCashOther', function(e) {                
            let type = $(this).data('type');
            let curValue;
            switch ($(this).text()) {            
                default:            
                    if (!$('input[name="'+name+'"').val()) {
                        let last = pattern_other.findLastIndex((element) => (element = '0'));
                        pattern_other[last] = document.getElementsByClassName('payment-amount').innerText;
                        // // // console.log'pattern_other[last] : ' + pattern_other[last]);
                        curValue = pattern_other.join('');                        
                        if(old_numpad_name == name) {
                            if (pattern_other[0] == '0' && pattern_other[1] == '0') {
                                // // // console.log'basta 2 sifir');
                                $('input[name="'+name+'"').val(curValue.substring(2));
                            } else if (pattern_other[0] == '0') {
                                // // // console.log'basta 1 sifir');
                                $('input[name="'+name+'"').val(curValue.substring(1));
                            } else {
                                // // // console.log'pattern_other[0] != 0');
                                $('input[name="'+name+'"').val(curValue);
                            }
                            // calculate_balance_due();
                            $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                            // calculate_balance_due();
                            $('input.pos_unit_price').trigger('change');
                            arr_pattern.push({
                                'name': name,
                                'pattern': pattern_other
                            });
                            old_numpad_name = name;
                        }
                    } else {
                        // // // // console.log'2541');                    
                        if(old_numpad_name == name) {
                            if(type == 'top') {
                                pattern_other[pattern_other.length - 6] = '0';
                                pattern_other[pattern_other.length - 5] = '0';
                                pattern_other[pattern_other.length - 4] = $(this).text();
                                pattern_other[pattern_other.length - 2] = '0';
                                pattern_other[pattern_other.length - 1] = '0';    
                                typeCash = 'top';                                                        
                            } else {         
                                if(typeCash == 'top') {
                                    pattern_other[pattern_other.length - 6] = 0;
                                    pattern_other[pattern_other.length - 5] = 0;
                                    pattern_other[pattern_other.length - 4] = 0;
                                } else {
                                    pattern_other[pattern_other.length - 6] = pattern_other[pattern_other.length - 5];
                                    pattern_other[pattern_other.length - 5] = pattern_other[pattern_other.length - 4];                        
                                    pattern_other[pattern_other.length - 4] = pattern_other[pattern_other.length - 2];
                                }
                                pattern_other[pattern_other.length - 2] = pattern_other[pattern_other.length - 1];
                                pattern_other[pattern_other.length - 1] = $(this).text();
                                typeCash = 'middle';       
                            }
            
                            curValue = pattern_other.join('');
                            // // // console.log"curValue add");
                            // // // console.logcurValue);
                            if (pattern_other[0] == '0' && pattern_other[1] == '0') {
                                // // // console.log'basta 2 sifir');
                                //$("#amount_"+row_index).val(curValue.substring(2));
            
                                $('input[name="'+name+'"').val(curValue.substring(2));
                            } else if (pattern_other[0] == '0') {
                                $('input[name="'+name+'"').val(curValue.substring(1));
                            } else {
                                $('input[name="'+name+'"').val(curValue);
                            }
                            // calculate_balance_due();
                            $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                            // calculate_balance_due();
                            $('input.pos_unit_price').trigger('change');
                            arr_pattern.push({
                                'name': name,
                                'pattern': pattern_other
                            });
                            old_numpad_name = name;
                        }
                    }
        
                break;
            }
        })
        
        $(document).on('click', '.numPadCashOtherDel', function (e) {
            //PALIGU
            let curValue;
            if(old_numpad_name == name) {
                pattern_other[pattern_other.length - 1] = pattern_other[pattern_other.length - 2];
                pattern_other[pattern_other.length - 2] = pattern_other[pattern_other.length - 4];
                pattern_other[pattern_other.length - 4] = pattern_other[pattern_other.length - 5];
                pattern_other[pattern_other.length - 5] = pattern_other[pattern_other.length - 6];
                pattern_other[pattern_other.length - 6] = '0';
    
                curValue = pattern_other.join('');
                if (pattern_other[0] == '0' && pattern_other[1] == '0') {
                    //// // // console.log"basta 2 sifir");
                    $('input[name="'+name+'"').val(curValue.substring(2));
                } else if (pattern_other[0] == '0') {
                    //// // // console.log"basta 1 sifir");
                    $('input[name="'+name+'"').val(curValue.substring(1));
                } else {
                    //// // // console.log"pattern_other[0] != 0");
                    $('input[name="'+name+'"').val(curValue);
                }
                
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                if (Number(curValue) == 0 && curValue == "0.00") {
                    let total = __read_number($('input#final_total_input'));
                    $('input[name="'+name+'"').val(total);
                    // calculate_balance_due();
                    $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
                }
                // calculate_balance_due();
                $('input.pos_unit_price').trigger('change');
                arr_pattern.push({
                    'name': name,
                    'pattern': pattern_other
                });
    
                old_numpad_name = name;
            }
        });
        
        $(document).on('click', '.numPadCashOtherClear', function (e) {
            //PALIGU    
            // let row_index = $(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().data('row_index');
            // let initValue = __read_number($('input.pos_unit_price').val());
            // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
            // let total = $(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().find('input.hidden_base_unit_sell_price').val();
            if(old_numpad_name == name) {
                let total = $(element).next().val() ? $(element).next().val() : "0.00";     
                // // console.logtotal)   
                // // console.logname)   
                $('input[name="'+name+'"').val(total);
                // calculate_balance_due();
                $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
                // calculate_balance_due();    
                $('input.pos_unit_price').trigger('change');
                pattern_other = ['0', '0', '0', '.', '0', '0'];
                arr_pattern.push({
                    'name': name,
                    'pattern': pattern_other
                });
                old_numpad_name = name;
            }
        }); 
    } else {        
        // let last_index = arr_pattern.findLastIndex((element) => (element.name = name));       
        // old_numpad_name = name;  
        var pattern_qty = ['0','0','0','0'];      
        $(document).on('click', '.numPadCashOther', function(e) {
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().data('type');    
            name_input = name;    
            // let type = $(this).data('type');
            let curValue;
            if(old_numpad_name == name) {
                switch ($(this).text()) {            
                    default:            
                        if (!$('input[name="'+name_input+'"').val()) {
                            // let last = pattern_qty.findLastIndex((element) => (element = '0'));
                            // pattern_qty[last] = document.getElementsByClassName('payment-amount').innerText;
                            // // // console.log'pattern_qty[last] : ' + pattern_qty[last]);
                            curValue = pattern_qty.join('');
                            // // console.log"curValue if")
                            // // console.logcurValue)
                            if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                                // // // console.log'basta 2 sifir');
                                $('input[name="'+name_input+'"]').val(curValue.substring(2));
                            } else if (pattern_qty[0] == '0') {
                                // // // console.log'basta 1 sifir');
                                $('input[name="'+name_input+'"]').val(curValue.substring(1));
                            } else {
                                // // // console.log'pattern_qty[0] != 0');
                                $('input[name="'+name_input+'"]').val(curValue);
                            }
                            // calculate_balance_due();
                            // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                            // // calculate_balance_due();
                            // $('input.pos_unit_price').trigger('change');
                            old_numpad_name = name;
                        } else {
                            // // // // console.log'2541');
                            if(old_numpad_name == name) {
                                if(type == 'top') {                    
                                    pattern_qty[pattern_qty.length - 4] = '0';
                                    pattern_qty[pattern_qty.length - 3] = '0';
                                    pattern_qty[pattern_qty.length - 2] = '0';                        
                                    pattern_qty[pattern_qty.length - 1] = $(this).text();                        
                                    typeCash = 'top';                                                                            
                                } else {         
                                    if(typeCash == 'top') {                                              
                                        pattern_qty[pattern_qty.length - 4] = 0;
                                        pattern_qty[pattern_qty.length - 3] = 0;                        
                                        pattern_qty[pattern_qty.length - 2] = 0;                        
                                    } else {                                                                
                                        pattern_qty[pattern_qty.length - 4] = pattern_qty[pattern_qty.length - 3];
                                        pattern_qty[pattern_qty.length - 3] = pattern_qty[pattern_qty.length - 2];                        
                                        pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 1];                        
                                    }
                                    // pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 1];
                                    pattern_qty[pattern_qty.length - 1] = $(this).text();
                                    typeCash = 'middle';       
                                }
                                // // // console.log"pattern_qty");
                                // // // console.logpattern_qty);        
                                curValue = pattern_qty.join(''); 
                                if(type_numpad == 'quantity_with_zero') {
                                    // if (pattern_qty[0] == '0' && pattern_qty[1] == '0' && pattern_qty[1] == '0') {
                                    //     // // // console.log'basta 2 sifir');
                                    //     //$("#amount_"+row_index).val(curValue.substring(2));
                    
                                    //     $('input[name="'+name_input+'"]').val(curValue.substring(3));
                                    // } else if(pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                                    //     $('input[name="'+name_input+'"]').val(curValue.substring(2));
                                    // } else if(pattern_qty[0] == '0') {
                                    //     $('input[name="'+name_input+'"]').val(curValue.substring(1));
                                    // } else {
                                        $('input[name="'+name_input+'"]').val(curValue);
                                    // }
                                } else {
                                    if (pattern_qty[0] == '0' && pattern_qty[1] == '0' && pattern_qty[2] == '0') {
                                        // // // console.log'basta 2 sifir');
                                        //$("#amount_"+row_index).val(curValue.substring(2));
                    
                                        $('input[name="'+name_input+'"]').val(curValue.substring(3));
                                    } else if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                                        $('input[name="'+name_input+'"]').val(curValue.substring(2));
                                    } else if (pattern_qty[0] == '0') {
                                        $('input[name="'+name_input+'"]').val(curValue.substring(1));
                                    } else {
                                        $('input[name="'+name_input+'"]').val(curValue);
                                    }
                                }
                                // calculate_balance_due();
                                // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                                // calculate_balance_due();
                                // $('input.pos_unit_price').trigger('change');
                                old_numpad_name = name;
                            }
                        }
            
                    break;
                }
            }
        })
        
        $(document).on('click', '.numPadCashOtherDel', function (e) {
            //PALIGU
            let curValue;
            if(old_numpad_name == name) {
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
                name_input = name;   
                let type = $(this).data('type');
                
                pattern_qty[pattern_qty.length - 1] = pattern_qty[pattern_qty.length - 2];
                pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 3];
                pattern_qty[pattern_qty.length - 3] = pattern_qty[pattern_qty.length - 4];
                pattern_qty[pattern_qty.length - 4] = '0';
                
            
                curValue = pattern_qty.join('');
                // // // console.log"curValue del")
                // // // console.logcurValue)
                if (pattern_qty[0] == '0' && pattern_qty[1] == '0' && pattern_qty[2] == '0') {
                    // // // console.log'basta 2 sifir');
                    //$("#amount_"+row_index).val(curValue.substring(2));
            
                    $('input[name="'+name_input+'"]').val(curValue.substring(3));
                } else if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                    $('input[name="'+name_input+'"]').val(curValue.substring(2));
                } else if (pattern_qty[0] == '0') {
                    $('input[name="'+name_input+'"]').val(curValue.substring(1));
                } else {
                    $('input[name="'+name_input+'"]').val(curValue);
                }
                
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                if (Number(curValue) == 0) {        
                    let total = "0";
                    $('input[name="'+name_input+'"]').val(total);        
                    // calculate_balance_due();
                    // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
                }
                // calculate_balance_due();
                // $('input.pos_unit_price').trigger('change');
                old_numpad_name = name;
            }
        });
        
        $(document).on('click', '.numPadCashOtherClear', function (e) {
            //PALIGU    
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');    
            if(old_numpad_name == name) {
                name_input = name;
                total = "0";    
                let type = $(this).data('type');
                // let initValue = __read_number($('input.pos_unit_price').val());
                // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
                
                $('input[name="'+name_input+'"]').val(total);
                // calculate_balance_due();
                // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
                // calculate_balance_due();    
                // $('input.pos_unit_price').trigger('change');
                
                pattern_qty = ['0', '0', '0', '0'];
                old_numpad_name = name;
            }
        });
    }

    // // // console.logpattern_other)
    // // // console.logpattern_qty)
        
}

$('#send_for_sell_return_invoice_no').on('click', function() {
    if ($("#send_for_sell_return_invoice_no").next('div.popover:visible').length){
        // popover is visible
        show_numpad(1, this.name, this, `sell_return`, `quantity_with_zero`)
    } else {        
        $('#product_numpad_div1').addClass('hide');
    }
})

function set_payment_type_dropdown() {
    var payment_settings = $('#location_id').data('default_payment_accounts');
    payment_settings = payment_settings ? payment_settings : [];
    enabled_payment_types = [];
    for (var key in payment_settings) {
        if (payment_settings[key] && payment_settings[key]['is_enabled']) {
            enabled_payment_types.push(key);
        }
    }
    if (enabled_payment_types.length) {
        $('.payment_types_dropdown > option').each(function () {
            //skip if advance
            if ($(this).val() && $(this).val() != 'advance') {
                if (enabled_payment_types.indexOf($(this).val()) != -1) {
                    $(this).removeClass('hide');
                } else {
                    $(this).addClass('hide');
                }
            }
        });
    }
}

function get_featured_products() {
    var category_id = null;    
    var sub_category = null;    
    $("select#product_category :selected").map(function(i, el) {
        var type_category = $(el).data('type_category');                
        if(type_category == 'sub_category') {             
            sub_category = $('select#product_category').val();
        } else {            
            category_id = $('select#product_category').val();
        }        
    }).get();
    
    var display_option = $('select#product_display').val();
    // // // // console.log$('#featured_products_box').length);
    var location_id = $('#location_id').val();
    // // // // console.loglocation_id);
    if (location_id && $('#featured_products_box').length > 0) {
        $.ajax({
            method: 'GET',
            url: '/sells/pos/get-featured-products/' + location_id + '?category=' + category_id + '&display_option=' + display_option + '&sub_category=' + sub_category, 
            dataType: 'html',
            success: function (result) {
                // // // // console.logresult);
                if (result) {
                    $('#feature_product_div').removeClass('hide');
                    $('#featured_products_box').html(result);
                } else {
                    $('#feature_product_div').addClass('hide');
                    $('#featured_products_box').html('');
                }
            },
        });
    } else {
        $('#feature_product_div').addClass('hide');
        $('#featured_products_box').html('');
    }
}

function get_product_suggestion_list(
    category_id,
    brand_id,
    location_id,
    url = null,
    is_enabled_stock = null,
    repair_model_id = null
) {
    if ($('div#product_list_body').length == 0) {
        return false;
    }

    if (url == null) {
        url = '/sells/pos/get-product-suggestion';
    }
    $('#suggestion_page_loader').fadeIn(700);
    var page = $('input#suggestion_page').val();
    if (page == 1) {
        $('div#product_list_body').html('');
    }
    if ($('div#product_list_body').find('input#no_products_found').length > 0) {
        $('#suggestion_page_loader').fadeOut(700);
        return false;
    }
    $.ajax({
        method: 'GET',
        url: url,
        data: {
            category_id: category_id,
            brand_id: brand_id,
            location_id: location_id,
            page: page,
            is_enabled_stock: is_enabled_stock,
            repair_model_id: repair_model_id,
        },
        dataType: 'html',
        success: function (result) {
            $('div#product_list_body').append(result);
            $('#suggestion_page_loader').fadeOut(700);
        },
    });
}

function get_cash_registers_list(location_id, cash_register_list_id) {
    var arr = cash_register_list_id.split('|');
    if (arr.length == 1) {
        var crl = cash_register_list_id;
    } else {
        $.each(arr, function (k, v) {
            crl = v;
        });
    }

    // // // // console.logcrl);

    $.ajax({
        method: 'GET',
        url: '/sells/pos/get-cash-registers-list',
        data: {
            location_id: location_id,
        },
        success: function (result) {
            $('#select_cash_registers_list').html(`
                <option value=""> Please Select </option>
            `);
            $.each(result, function (placement, row) {
                if (placement == cash_register_list_id) {
                    var selected = 'selected';
                }
                $('#select_cash_registers_list').append(
                    '<option value="' + placement + '" ' + selected + '>' + row + '</option>'
                );
            });
            // $('div#product_list_body').append(result);
            $('#suggestion_page_loader').fadeOut(700);
        },
    });
}

//Get recent transactions
function get_recent_transactions(status, element_obj) {
    if (element_obj.length == 0) {
        return false;
    }
    var transaction_sub_type = $('#transaction_sub_type').val();
    var location_id = $('#location_id').val() 
    // // // // console.loglocation_id)
    $.ajax({
        method: 'GET',
        url: '/sells/pos/get-recent-transactions',
        data: { status: status, transaction_sub_type: transaction_sub_type, location_id: location_id },
        dataType: 'html',
        success: function (result) {
            element_obj.html(result);
            __currency_convert_recursively(element_obj);
        },
    });
}

//variation_id is null when weighing_scale_barcode is used.
function pos_product_row(
    variation_id = null,
    purchase_line_id = null,
    weighing_scale_barcode = null,
    quantity = 1,
    vhomni_type = null,
    other_id = null,
) {
    //Get item addition method
    /* var item_addtn_method = 0;
    var add_via_ajax = true;

    if (variation_id != null && $('#item_addition_method').length) {
        item_addtn_method = $('#item_addition_method').val();
    } */

    var default_location_id = $('#default_location').val();
    var location_id = $('#select_location_id').val();
    var id_cash_register = $("#cash_register_list_id").val();
    // // // // console.log'aman');
    var pos_layout = $('#pos_layout').val();
    if(pos_layout) {
        $.ajax({
            method: 'get',
            url: /check-cash-register-open/ + id_cash_register,
            success: function(result) {
                // // // // console.log'pos_layout true')
                // // // // console.logresult)
                if (result.count == 1) {
                    // if (default_location_id == location_id) {
                    //Get item addition method
                    pos_add_product_row(result, variation_id, purchase_line_id, weighing_scale_barcode, quantity, vhomni_type, other_id)
                } else {
                    alert('You have to open the register');
                }
            }
        })
    } else {
        // // // // console.log'pos_layout false')
        var result = [];
        pos_add_product_row(result, variation_id, purchase_line_id, weighing_scale_barcode, quantity, vhomni_type, other_id)
    }
}

function pos_add_product_row(result, variation_id, purchase_line_id, weighing_scale_barcode, quantity, vhomni_type, other_id) {
    var item_addtn_method = 0;
    var add_via_ajax = true;

    if (variation_id != null && $('#item_addition_method').length) {
        item_addtn_method = $('#item_addition_method').val();
    }
    
    if (item_addtn_method == 0) {
        add_via_ajax = true;
    } else {
        var is_added = false;                            
        var temp_cart = [];         
        // // // // console.logcart)       
        //Search for variation id in each row of pos table
        $('#pos_table tbody')
        .find('tr.product_row')
        .each(function () {
            var row_v_id = $(this).find('.row_variation_id').val();
            var enable_sr_no = $(this).find('.enable_sr_no').val();
            var modifiers_exist = false;                    
            if ($(this).find('input.modifiers_exist').length > 0) {
                modifiers_exist = true;
            }            
            
            if (
                row_v_id == variation_id &&
                enable_sr_no !== '1' &&
                !modifiers_exist &&
                !is_added
                ) {
                    add_via_ajax = false;
                    is_added = true;
                    
                    //Set value vhomni type
                    $(this).find('.vhomni_type').val(vhomni_type)
                    $(this).find('.vhomni_other_id').val(other_id)

                    //Increment product quantity
                    qty_element = $(this).find('.pos_quantity');
                    var qty = __read_number(qty_element);
                    __write_number(qty_element, qty + 1);
                    qty_element.change();
                    // // // // console.log'qty_element')
                    // // // // console.logqty_element)
                    // var get_cart = JSON.parse(localStorage.getItem('cart'));                        
                    var cart_item = {
                        'product': $(this).find('span.cursor-pointer').html(),
                        'qty': $(this).find('.pos_quantity').val(),
                        'subtotal': $(this).find('.pos_line_total_text').html()
                    }                                
                    
                    temp_cart.push(cart_item)  
                    round_row_to_iraqi_dinnar($(this));
                    pos_each_row($(this))
                    
                    $('input#search_product').focus().select();
            } else {
                var cart_item = {
                    'product': $(this).find('span.cursor-pointer').html(),
                    'qty': $(this).find('.pos_quantity').val(),
                    'subtotal': $(this).find('.pos_line_total_text').html()
                }                                
                
                temp_cart.push(cart_item)  
            }
        });
        // // // // console.logtemp_cart)
        cart = temp_cart;
        localStorage.setItem('cart', JSON.stringify(cart));
        pos_total_row();
    }

    if (add_via_ajax) {
        var product_row = $('input#product_row_count').val();
        var location_id = $('input#location_id').val();
        var customer_id = $('select#customer_id').val() ? $('select#customer_id').val() : $('input#customer_id').val();
        var is_direct_sell = false;
        if (
            $('input[name="is_direct_sale"]').length > 0 &&
            $('input[name="is_direct_sale"]').val() == 1
        ) {
            is_direct_sell = true;
        }

        var disable_qty_alert = false;

        if ($('#disable_qty_alert').length) {
            disable_qty_alert = true;
        }

        var is_sales_order =
            $('#sale_type').length && $('#sale_type').val() == 'sales_order' ? true : false;

        var price_group = '';
        if ($('#price_group').length > 0) {
            price_group = parseInt($('#price_group').val());
        }

        //If default price group present
        if ($('#default_price_group').length > 0 && price_group === '') {
            price_group = $('#default_price_group').val();
        }

        //If types of service selected give more priority
        if (
            $('#types_of_service_price_group').length > 0 &&
            $('#types_of_service_price_group').val()
        ) {
            price_group = $('#types_of_service_price_group').val();
        }

        var is_draft = false;
        if (
            $('input#status') &&
            ($('input#status').val() == 'quotation' || $('input#status').val() == 'draft')
        ) {
            is_draft = true;
        }

        var cart = [];

        $.ajax({
            method: 'GET',
            url: '/sells/pos/get_product_row/' + variation_id + '/' + location_id,
            async: false,
            data: {
                product_row: product_row,
                customer_id: customer_id,
                is_direct_sell: is_direct_sell,
                price_group: price_group,
                purchase_line_id: purchase_line_id,
                weighing_scale_barcode: weighing_scale_barcode,
                quantity: quantity,
                is_sales_order: is_sales_order,
                disable_qty_alert: disable_qty_alert,
                is_draft: is_draft,
                location_name: $('select#select_location_id').find('option:selected').text(),
            },
            dataType: 'json',
            success: function (result) {
                // // // // console.logresult.html_content)
                if (result.success) {
                    $('table#pos_table tbody')
                        .append(result.html_content)
                        .find('input.pos_quantity');
                    
                    
                    // // // // console.log$(this).find());
                    
                    //increment row count
                    $('input#product_row_count').val(parseInt(product_row) + 1);
                    var this_row = $('table#pos_table tbody').find('tr.product_row').last();
                    pos_each_row(this_row);

                    //For initial discount if present
                    var line_total = __read_number(this_row.find('input.pos_line_total'));
                    // // // console.logline_total);
                    this_row.find('span.pos_line_total_text').text(line_total);

                    pos_total_row();

                    //Check if multipler is present then multiply it when a new row is added.
                    if (__getUnitMultiplier(this_row) > 1) {
                        this_row.find('select.sub_unit').trigger('change');
                    }

                    if (result.enable_sr_no == '1') {
                        var new_row = $('table#pos_table tbody').find('tr.product_row').last();
                        new_row.find('.row_edit_product_price_model').modal('show');
                    }

                    round_row_to_iraqi_dinnar(this_row);
                    __currency_convert_recursively(this_row);

                    $('input#search_product').focus().select();

                    //Used in restaurant module
                    if (result.html_modifier) {         
                        if(is_direct_sell) {
                            $('table#pos_table tbody')
                                .find('tr.product_row')
                                .find('td:first')
                                .append(result.html_modifier)
                        } else {
                            $('table#pos_table tbody')
                                .find('tr.product_row')
                                .last()
                                .find('td:first')
                                .find('div.row_edit_product_price_model')
                                .after(result.html_modifier);                       
                        }                                                                                                       
                    }

                    var temp_cart = [];                            
                    // var cart = JSON.parse(localStorage.getItem('cart'));                            
                    $('table#pos_table tr.product_row').each(function(index) {                                
                        var cart_item = {
                            'product': $(this).find('span.cursor-pointer').html(),
                            'qty': $(this).find('.pos_quantity').val(),
                            'subtotal': $(this).find('.pos_line_total_text').html()
                        }                                
                        
                        temp_cart.push(cart_item)                                
                        // // // // console.log$(this).find('span.cursor-pointer').html);
                    });                            
                    cart = temp_cart;
                    // // // // console.log'cart add');
                    // // // // console.logcart);
                    localStorage.setItem('cart', JSON.stringify(cart));

                    var temp_location = [{
                        'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
                        'sales_tax': $('#order_tax').html(),
                        'items': $('.total_quantity').html(),
                        'sub_total': $('.price_total').html(),
                        'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
                        'location_name': $('select#select_location_id').find(':selected').text(),
                        'total': $('#final_total_input').val(),
                        'promotion_slider_speed': $('#promotion_slider_speed').val(),
                        'required_signature': $('#required_signature').val(),
                    }];
                    localStorage.setItem('location_picture', JSON.stringify(temp_location));
                    localStorage.setItem('signature-customer', JSON.stringify([]));
                    /* var get_cart = localStorage.getItem('cart');                            
                    if(get_cart) {                                
                        var json_cart = JSON.parse(get_cart);
                        // // // console.logjson_cart);
                    } else {
                        cart = [{
                            'product': this_row.find('span.cursor-pointer').html(),
                            'qty': this_row.find('.pos_quantity').val(),
                            'subtotal': this_row.find('.pos_line_total_text').html() 
                        }];
                        // localStorage.setItem('car')
                    } */
                    
                    // if(get_cart) {
                    //     /*$.each(get_cart, function(k,v) {
                    //         if(v.product == this_row.find('span.cursor-pointer').html()) {
                    //             get_cart.splice(k, 1, {
                    //                 'product': this_row.find('span.cursor-pointer').html(),
                    //                 'qty': this_row.find('.pos_quantity').val(),
                    //                 'subtotal': this_row.find('.pos_line_total_text').html()
                    //             })
                    //             cart.push({
                    //                 'product': this_row.find('span.cursor-pointer').html(),
                    //                 'qty': this_row.find('.pos_quantity').val(),
                    //                 'subtotal': this_row.find('.pos_line_total_text').html()
                    //             })
                    //             // localStorage.setItem('cart', JSON.stringify(get_cart))
                    //         } else {
                    //             get_cart[k]['product']= v.product;
                    //             get_cart[k]['qty']= v.qty;
                    //             get_cart[k]['subtotal'] = v.subtotal                                        
                    //         }
                    //     })
                    //     localStorage.setItem('cart', JSON.stringify(get_cart)) */
                    // } else {
                    //     cart.push({
                    //         'product': this_row.find('span.cursor-pointer').html(),
                    //         'qty': this_row.find('.pos_quantity').val(),
                    //         'subtotal': this_row.find('.pos_line_total_text').html()
                    //     })
                    //     localStorage.setItem('cart', JSON.stringify(cart))
                    // }

                    //scroll bottom of items list
                    $('.pos_product_div').animate(
                        { scrollTop: $('.pos_product_div').prop('scrollHeight') },
                        1000
                    );
                } else {
                    toastr.error(result.msg);
                    $('input#search_product').focus().select();
                }
            },
        });                
    }
}

function add_custom_product_row() {
    var product_name = $('#product_custom_name').val();
    var quantity = $('#product_custom_quantity').val();
    var amount = $('#product_custom_amount').val();
    var product_row = $('input#product_row_count').val();
    if($('#form_custom_modal').valid()) {    
        // $('#error-product-quantity-custom-sale').remove();
        // $('#error-product-amount-custom-sale').remove();
        // $('#error-product-name-custom-sale').remove();
        $.ajax({
            method: 'GET',
            url: '/sells/pos/add_custom_product_row?product_name=' + product_name + '&product_quantity=' + quantity + '&product_amount=' + amount,
            data: {
                product_row: product_row
            },
            async: false,
            dataType: 'json',
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex');
            },
            error: function() {
                $('#pos-loader').css('display', 'none');
            },  
            success: function (result) {
                $('#pos-loader').css('display', 'none');
                if(result.success == 1) {
                    $('#product_custom_name').val('');
                    $('#product_custom_quantity').val('');
                    $('#product_custom_amount').val('');
                    $('table#pos_table tbody')
                        .append(result.html_content)
                        .find('input.pos_quantity');                    
                                        
                    //increment row count
                    $('input#product_row_count').val(parseInt(product_row) + 1);
                    var this_row = $('table#pos_table tbody').find('tr.product_row').last();
                    pos_each_row(this_row);
        
                    //For initial discount if present
                    var line_total = __read_number(this_row.find('input.pos_line_total'));
                    this_row.find('span.pos_line_total_text').text(line_total);
        
                    pos_total_row();
        
                    //Check if multipler is present then multiply it when a new row is added.
                    if (__getUnitMultiplier(this_row) > 1) {
                        this_row.find('select.sub_unit').trigger('change');
                    }
        
                    if (result.enable_sr_no == '1') {
                        var new_row = $('table#pos_table tbody').find('tr.product_row').last();
                        new_row.find('.row_edit_product_price_model').modal('show');
                    }
        
                    round_row_to_iraqi_dinnar(this_row);
                    __currency_convert_recursively(this_row);
        
                    $('input#search_product').focus().select();                  
                    
                    var temp_cart = [];                            
                    // var cart = JSON.parse(localStorage.getItem('cart'));                            
                    $('table#pos_table tr.product_row').each(function(index) {                                
                        var cart_item = {
                            'product': $(this).find('span.cursor-pointer').html(),
                            'qty': $(this).find('.pos_quantity').val(),
                            'subtotal': $(this).find('.pos_line_total_text').html()
                        }                                
                        
                        temp_cart.push(cart_item)                                
                        // // // // console.log$(this).find('span.cursor-pointer').html);
                    });                            
                    cart = temp_cart;
                    // // // // console.log'cart add');
                    // // // // console.logcart);
                    localStorage.setItem('cart', JSON.stringify(cart));
        
                    var temp_location = [{
                        'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
                        'sales_tax': $('#order_tax').html(),
                        'items': $('.total_quantity').html(),
                        'sub_total': $('.price_total').html(),
                        'discount': $('#total_discount').html() ? $('#total_discount').html() : 0,
                        'location_name': $('select#select_location_id').find(':selected').text(),
                        'total': $('#final_total_input').val(),
                        'promotion_slider_speed': $('#promotion_slider_speed').val(),
                        'required_signature': $('#required_signature').val(),
                    }];
                    localStorage.setItem('location_picture', JSON.stringify(temp_location));
                    localStorage.setItem('signature-customer', JSON.stringify([]));
                    
                    $('.pos_product_div').animate(
                        { scrollTop: $('.pos_product_div').prop('scrollHeight') },
                        1000
                    );                    
                    $('#custom_sale_modal').modal('hide');
                } else {
                    swal({
                        title: 'Information',
                        text: 'Can\'t add custom sale product',
                    })
                }
            }
        });
    // }
    }
    // if(product_name) {
        /* if($('#error-product-name-custom-sale').length == 0) {                
            $('#product_custom_name').parent().append('<label class="error" id="error-product-name-custom-sale">Product name is required</label>')
        } */        
    // }
    /* 
    if(quantity) {
        if($('#error-product-quantity-custom-sale').length == 0) {                
            $('#product_custom_quantity').parent().append('<label class="error" id="error-product-quantity-custom-sale">Product quantity can\'t be minus</label>')
        }        
    }
    
    if(amount) {
        if($('#error-product-amount-custom-sale').length == 0) {                
            $('#product_custom_amount').parent().append('<label class="error" id="error-product-amount-custom-sale">Amount can\'t be minus</label>')
        }        
    } */

    /* swal({
        title: 'Information',
        text: 'Product name is required',
        icon: 'info'
    }) */    
}

// function delay() { // [PALIGU]
//     return new Promise(resolve => setTimeout(resolve, 1000));
// }

function doStuff() {
    // // // console.log"dostuff started");
    if(cardTransactionResult == "") {
        // // // console.log"cardTransactionResult is empty 1912");
        setTimeout(doStuff, 500);//wait 500 millisecnds then recheck
        return;
    }
}


// populate selected payment data [PALIGU]
function setSelectedPaymentData() {
    selectedPaymentData = [];
    // var methods = $('.form-control.col-md-12.payment_types_dropdown')
    var methods = $('.form-control.payment_types_dropdown')
        .map(function (idx, ele) {
            if ($(ele).prop('id') != 'change_return_method') return $(ele);
        })
        .get();

    methods.forEach((element) => {    
        let ind = element.prop('id').slice(-1);
        let amount = $('#amount_' + ind).val();
        if($(element).is(':checked')) {
            selectedPaymentData.push({ method: element.val(), amount: amount });
        }
    });
    // console.log('selectedPaymentData');
    // console.log(selectedPaymentData);
}

//credit card payments [PALIGU]
/**
 * Process card payments through CardPointe Gateway
 * Handles multiple card payments and transaction validation
 * @returns {Promise<boolean>} Success status of payment processing
 */
async function processCardPayment() {
    try {
        $('#finalize_payment_loader').fadeIn(700);
        
        const cardPayments = selectedPaymentData.filter(p => p.method === 'card');
        
        for (let i = 0; i < cardPayments.length; i++) {
            const payment = cardPayments[i];
            
            // For multiple cards, show confirmation prompt
            if (i > 0) {
                const confirmed = await showMultiCardPaymentPrompt();
                if (!confirmed) {
                    POS.cardTransactionResult = 'card payment done';
                    continue;
                }
            }

            POS.cardTransactionResult = '';
            
            // Get session data and process payment
            const sessionData = await validateCardSession();
            const result = await processCardTransaction(payment, sessionData);
            
            if (!result.success) {
                throw new Error(result.error || 'Card transaction failed');
            }
        }

        $('#finalize_payment_loader').fadeOut(700);
        return true;

    } catch (error) {
        console.error('Error processing card payment:', error);
        $('#finalize_payment_loader').fadeOut(700);
        toastr.error(error instanceof Error ? error.message : 'Error processing card payment');
        return false;
    }
}

/**
 * Show confirmation prompt for multiple card payments
 * @returns {Promise<boolean>} User confirmation result
 */
function showMultiCardPaymentPrompt() {
    return new Promise(resolve => {
        swal({
            title: 'Multiple Card Payments',
            text: 'Please click OK when ready to proceed with the next card transaction',
            icon: 'info',
            buttons: true,
        }).then((confirmed) => resolve(confirmed));
    });
}

/**
 * Validate card session and get session key
 * @returns {Promise<Object>} Session data including key
 */
async function validateCardSession() {
    const sessionKey = await getSessionKey();
    return {
        sessionKey,
        branchId: String($(SELECTORS.locationSelect).val()),
        posId: String($('#cash_register_list_id').val()),
        creditOrDebit: 'credit'
    };
}

/**
 * Get valid session key for card transaction
 * @returns {Promise<string>} Valid session key
 */
function getSessionKey() {
    const storage = window.localStorage;
    const now = new Date();
    const SESSION_TIMEOUT_MINUTES = 9;
    
    if (storage.hasOwnProperty('localClientTime')) {
        const sessionStartTime = new Date(storage.getItem('localClientTime') || '');
        const diffMinutes = (now.getTime() - sessionStartTime.getTime()) / (1000 * 60);
        
        if (diffMinutes >= SESSION_TIMEOUT_MINUTES || !storage.getItem('sessionKey')) {
            storage.setItem('localClientTime', now.toString());
            return 'Request New Session Key';
        }
        
        const sessionKey = storage.getItem('sessionKey');
        return sessionKey || 'Request New Session Key';
    }
    
    storage.setItem('localClientTime', now.toString());
    return 'Request New Session Key';
}
async function processCardTransaction(payment, sessionData) {
    try {
        const result = await $.ajax({
            type: 'POST',
            url: '/sells/pos/card_pointe_authCard',
            data: {
                amount: payment.amount,
                sessionKey: sessionData.sessionKey,
                branch_id: sessionData.branchId,
                pos_id: sessionData.posId,
                credit_or_debit: sessionData.creditOrDebit,
            }
        });

        const [sessionHeader, transactionData] = result.split('#');
        const jsonResult = JSON.parse(transactionData);

        if (jsonResult.errorMessage) {
            await saveCardTransactionResult(jsonResult, false, payment.amount);

            if (jsonResult.errorMessage === 'Operation Cancelled') {
                POS.cardTransactionResult = "Customer has cancelled the transaction!";
            } else if (jsonResult.errorMessage === 'Command Cancelled') {
                POS.cardTransactionResult = "Customer not accepted the amount!";
            } else {
                localStorage.setItem(`${Date.now()}_error`, jsonResult.errorMessage);
            }

            return {
                success: false,
                error: jsonResult.errorMessage
            };
        }

        // Handle successful transaction
        if (jsonResult.respcode === '000') {
            await saveCardTransactionResult(jsonResult, true);
            POS.cardTransactionResult = 'card payment done';
            return {
                success: true,
                data: jsonResult
            };
        } else {
            await saveCardTransactionResult(jsonResult, false, payment.amount);
            return {
                success: false,
                error: jsonResult.resptext || 'Transaction failed'
            };
        }

    } catch (error) {
        localStorage.setItem(`${Date.now()}_error`, JSON.stringify(error));
        POS.cardTransactionResult = 'Transaction failed';
        throw error;
    }
}
            // // // console.log'under ajax');
            // while (cardTransactionResult == "") {
            //     // // // console.log"2156 cardTransactionResult : " + cardTransactionResult);
            //     await delay();
            // }
           // doStuff();
            //END- Gateway Transaction
        //END- CardPointe Gateway transaction  
     //   }else { //Not card payment
            cardTransactionResult = "Not Card Payment";
     //   } 
   // });
    
    //pos_form_obj.submit();
    $('#finalize_payment_loader').fadeOut(700);
    
//}

function saveCardTransactionResult(jsonResult, success, pamount = 0){
// console.log"saveCardTransactionResult success: " + success + " pamount: " + pamount);
    let token = '';
    let expiry = '';
    let name = '';
    let retref = '';
    let respproc = '';
    let amount = '';
    let resptext = '';
    let authcode = '';
    let respcode = '';
    let merchid = '';
    let PIN = '';
    let signature = '';
    let networkLabel = '';
    let applicationPreferredName = '';
    let AID = '';
    let applicationLabel = '';
    let entrymode = '';
    let country = '';
    let bin = '';
    let issuer = '';
    let invoiceid = '';

    if(success) {
    
        try {
            let creditCardData = jsonResult;
            let emvTagData, binInfo;
    
            if (creditCardData.emvTagData) {
                emvTagData = JSON.parse(creditCardData.emvTagData);
                PIN = emvTagData.PIN;
                signature = emvTagData.Signature;
                networkLabel = emvTagData['Network Label'];
                applicationPreferredName =
                    emvTagData['Application Preferred Name'];
                AID = emvTagData.AID;
                applicationLabel = emvTagData['Application Label'];
            }
    
            if (creditCardData.binInfo) {
                binInfo = creditCardData.binInfo;
                country = binInfo.country;
                bin = binInfo.bin;
                issuer = binInfo.issuer;
            }
            if (creditCardData.token) {
                token = creditCardData.token;
            }
            if (creditCardData.expiry) {
                expiry = creditCardData.expiry;
            }
            if (creditCardData.name) {
                name = creditCardData.name;
            }
            if (creditCardData.retref) {
                retref = creditCardData.retref;
            }
            if (creditCardData.respproc) {
                respproc = creditCardData.respproc;
            }
            if (creditCardData.amount) {
                amount = creditCardData.amount;
            }
            if (creditCardData.resptext) {
                resptext = creditCardData.resptext;
            }
            if (creditCardData.authcode) {
                authcode = creditCardData.authcode;
            }
            if (creditCardData.respcode) {
                respcode = creditCardData.respcode;
            }
            if (creditCardData.merchid) {
                merchid = creditCardData.merchid;
            }
            if (creditCardData.entrymode) {
                entrymode = creditCardData.entrymode;
            }
    
            let carData = {
                token: token,
                expiry: expiry,
                name: name,
                retref: retref,
                respproc: respproc,
                amount: amount,
                resptext: resptext,
                authcode: authcode,
                respcode: respcode,
                merchid: merchid,
                PIN: PIN,
                signature: signature,
                networkLabel: networkLabel,
                applicationPreferredName: applicationPreferredName,
                AID: AID,
                applicationLabel: applicationLabel,
                invoiceid : invoiceid,
                entrymode: entrymode,
                country: country,
                bin: bin,
                issuer: issuer,
            };
    
            $.ajax({
                type: 'POST',
                url: '/sells/pos/card_pointe_saveTransaction',
                data: carData,
                success: function (result) {
                    // // // console.logresult);
                },
                error: function (error) {
                    // // // console.logerror);
                },
            });
        } catch (error) {
            // // // console.logerror);
        }
    } else {
        amount = pamount;
        respcode = jsonResult.respcode;
        resptext = jsonResult.resptext;
        
        if (jsonResult.errorMessage) {
            resptext = jsonResult.errorMessage;
        }
        let carData = {
            token: token,
            expiry: expiry,
            name: name,
            retref: retref,
            respproc: respproc,
            amount: amount,
            resptext: resptext,
            authcode: authcode,
            respcode: respcode,
            merchid: merchid,
            PIN: PIN,
            signature: signature,
            networkLabel: networkLabel,
            applicationPreferredName: applicationPreferredName,
            AID: AID,
            applicationLabel: applicationLabel,
            invoiceid : invoiceid,
            entrymode: entrymode,
            country: country,
            bin: bin,
            issuer: issuer,
        };

        $.ajax({
            type: 'POST',
            url: '/sells/pos/card_pointe_saveTransaction',
            data: carData,
            success: function (result) {
                // // // console.logresult);
            },
            error: function (error) {
                // // // console.logerror);
            },
        });
    }
    
}

//Update values for each row
function pos_each_row(row_obj) {
    var unit_price = __read_number(row_obj.find('input.pos_unit_price'));

    var discounted_unit_price = calculate_discounted_unit_price(row_obj);    
    var tax_rate = row_obj.find('select.tax_id').find(':selected').data('rate');

    var unit_price_inc_tax =
        discounted_unit_price + __calculate_amount('percentage', tax_rate, discounted_unit_price);
    __write_number(row_obj.find('input.pos_unit_price_inc_tax'), unit_price_inc_tax);

    var discount = __read_number(row_obj.find('input.row_discount_amount'));
    
    if (discount > 0) {
        var qty = __read_number(row_obj.find('input.pos_quantity'));
        var line_total = qty * unit_price_inc_tax;
        __write_number(row_obj.find('input.pos_line_total'), line_total);
    }

    //var unit_price_inc_tax = __read_number(row_obj.find('input.pos_unit_price_inc_tax'));

    __write_number(row_obj.find('input.item_tax'), unit_price_inc_tax - discounted_unit_price);
}

function pos_total_row() {
    var total_quantity = 0;
    var price_total = get_subtotal();
    var price_tax = get_pricetax();
    // // // // console.log'price_total: ' + price_total)
    // // // // console.log$('table#pos_table tbody tr.product_row'))
    $('table#pos_table tbody tr.product_row').each(function () {
        total_quantity = total_quantity + __read_number($(this).find('input.pos_quantity'));        
    });

    //updating shipping charges
    $('span#shipping_charges_amount').text(
        __currency_trans_from_en(__read_number($('input#shipping_charges_modal')), false)
    );

    $('span.total_quantity').each(function () {
        $(this).html(__currency_trans_from_en(total_quantity, false, false, __currency_precision, true));
    });

    //$('span.unit_price_total').html(unit_price_total);
    $('span.price_total').html(__currency_trans_from_en(price_total, false));
    calculate_billing_details(price_total, price_tax);
}

function get_pricetax() {
    var price_total = 0;

    $('table#pos_table tbody tr.product_row').each(function () {
        if($(this).find('.checked_zero_tax').is(':checked')) {            
        } else {
            var modifier_price = __read_number($(this).find('input.modifiers_price'));            
            price_total = price_total + __read_number($(this).find('input.pos_line_total')) + modifier_price;
        }     
        // // // // console.logprice_total)
    });
    // // // console.log"price_total")
    // // // console.logprice_total)
    // var discount = $('#total_discount').text();
    // discount = __number_f(discount, false)    
    // pos_order_tax(price_total, parseInt(discount))
    return price_total;
}

function get_subtotal() {
    var price_total = 0;

    $('table#pos_table tbody tr.product_row').each(function () {    
        price_total = price_total + __read_number($(this).find('input.pos_line_total'));                
    });

    //Go through the modifier prices.
    $('input.modifiers_price').each(function () {
        var modifier_price = __read_number($(this));
        var modifier_quantity = $(this)
            .closest('.product_modifier')
            .find('.modifiers_quantity')
            .val();
        var modifier_subtotal = modifier_price * modifier_quantity;
        price_total = price_total + modifier_subtotal;
    });

    return price_total;
}

function calculate_billing_details(price_total, price_tax) {
    var discount = pos_discount(price_total);
    if ($('#reward_point_enabled').length) {
        total_customer_reward = $('#rp_redeemed_amount').val();
        discount = parseFloat(discount) + parseFloat(total_customer_reward);

        if ($('input[name="is_direct_sale"]').length <= 0) {
            $('span#total_discount').text(__currency_trans_from_en(discount, false));
        }
    }

    // var order_tax = pos_order_tax(price_total, discount);
    var order_tax = pos_order_tax(price_tax, discount);

    //Add shipping charges.
    var shipping_charges = __read_number($('input#shipping_charges'));

    var additional_expense = 0;
    //calculate additional expenses
    if ($('input#additional_expense_value_1').length > 0) {
        additional_expense += __read_number($('input#additional_expense_value_1'));
    }
    if ($('input#additional_expense_value_2').length > 0) {
        additional_expense += __read_number($('input#additional_expense_value_2'));
    }
    if ($('input#additional_expense_value_3').length > 0) {
        additional_expense += __read_number($('input#additional_expense_value_3'));
    }
    if ($('input#additional_expense_value_4').length > 0) {
        additional_expense += __read_number($('input#additional_expense_value_4'));
    }

    //Add packaging charge
    var packing_charge = 0;
    if ($('#types_of_service_id').length > 0 && $('#types_of_service_id').val()) {
        packing_charge = __calculate_amount(
            $('#packing_charge_type').val(),
            __read_number($('input#packing_charge')),
            price_total
        );

        $('#packing_charge_text').text(__currency_trans_from_en(packing_charge, false));
    }

    var total_payable =
        price_total + order_tax - discount + shipping_charges + packing_charge + additional_expense;

    var rounding_multiple = $('#amount_rounding_method').val()
        ? parseFloat($('#amount_rounding_method').val())
        : 0;
    var round_off_data = __round(total_payable, rounding_multiple);
    var total_payable_rounded = round_off_data.number;

    var round_off_amount = round_off_data.diff;
    if (round_off_amount != 0) {
        $('span#round_off_text').text(__currency_trans_from_en(round_off_amount, false));
    } else {
        $('span#round_off_text').text(0);
    }
    $('input#round_off_amount').val(round_off_amount);

    __write_number($('input#final_total_input'), total_payable_rounded);
    var curr_exchange_rate = 1;
    if ($('#exchange_rate').length > 0 && $('#exchange_rate').val()) {
        curr_exchange_rate = __read_number($('#exchange_rate'));
    }
    
    var shown_total = total_payable_rounded * curr_exchange_rate;
    
    $('span#total_payable').text(__currency_trans_from_en(shown_total, false));

    $('span.total_payable_span').text(__currency_trans_from_en(total_payable_rounded, true));

    //Check if edit form then don't update price.
    if ($('form#edit_pos_sell_form').length == 0 && $('form#edit_sell_form').length == 0) {
        __write_number($('.payment-amount').first(), total_payable_rounded);
    }

    $(document).trigger('invoice_total_calculated');

    calculate_balance_due();
}

function pos_discount(total_amount) {
    var calculation_type = $('#discount_type').val();
    var calculation_amount = __read_number($('#discount_amount'));     
    var discount = __calculate_amount(calculation_type, calculation_amount, total_amount);    
    $('span#total_discount').text(__currency_trans_from_en(discount, false));
    // $('#discount_amount_modal').val(discount);
    return discount;
}

function pos_order_tax(price_total, discount) {
    var tax_rate_id = $('#tax_rate_id').val();
    // // // // console.logtax_rate_id)
    var calculation_type = 'percentage';
    var calculation_amount = __read_number($('#tax_calculation_amount'));
    // // // // console.log'calculation_amount')
    // // // // console.logcalculation_amount)
    var total_amount = price_total - discount;    
    if (calculation_amount) {
        var order_tax = __calculate_amount(calculation_type, calculation_amount, total_amount);
    } else {
        var order_tax = 0;
    }

    $('span#order_tax').text(__currency_trans_from_en(order_tax, false));

    return order_tax;
}

function calculate_balance_due() {
    var total_payable = __read_number($('#final_total_input'));
    var total_paying = 0;
    $('#payment_rows_div')
        .find('.payment-amount')
        .each(function () {
            if (parseFloat($(this).val())) {
                total_paying += __read_number($(this));
            }
        });
    var bal_due = total_payable - total_paying;
    var change_return = 0;

    //change_return
    if (bal_due < 0 || Math.abs(bal_due) < 0.05) {
        __write_number($('input#change_return'), bal_due * -1);
        $('span.change_return_span').text(__currency_trans_from_en(bal_due * -1, true));
        change_return = bal_due * -1;
        bal_due = 0;
    } else {
        __write_number($('input#change_return'), 0);
        $('span.change_return_span').text(__currency_trans_from_en(0, true));
        change_return = 0;
    }

    /* if (change_return !== 0) {
        $('#change_return_payment_data').removeClass('hide');
    } else { */
        $('#change_return_payment_data').addClass('hide');
    /* } */

    __write_number($('input#total_paying_input'), total_paying);
    $('span.total_paying').text(__currency_trans_from_en(total_paying, true));

    __write_number($('input#in_balance_due'), bal_due);
    $('span.balance_due').text(__currency_trans_from_en(bal_due, true));

    __highlight(bal_due * -1, $('span.balance_due'));
    __highlight(change_return * -1, $('span.change_return_span'));
}

function isValidPosForm() {
    flag = true;
    $('span.error').remove();

    if ($('select#customer_id').val() == null) {
        flag = false;
        error = '<span class="error">' + LANG.required + '</span>';
        $(error).insertAfter($('select#customer_id').parent('div'));
    }

    if ($('tr.product_row').length == 0) {
        flag = false;
        error = '<span class="error">' + LANG.no_products + '</span>';
        $(error).insertAfter($('input#search_product').parent('div'));
    }

    return flag;
}

function reset_pos_form() {
    //If on edit page then redirect to Add POS page
    if ($('form#edit_pos_sell_form').length > 0) {
        setTimeout(function () {
            window.location = $('input#pos_redirect_url').val();
        }, 4000);
        return true;
    }

    //reset all repair defects tags
    if ($('#repair_defects').length > 0) {
        tagify_repair_defects.removeAllTags();
    }

    if (pos_form_obj[0]) {
        pos_form_obj[0].reset();
    }
    if (sell_form[0]) {
        sell_form[0].reset();
    }
    set_default_customer();
    set_location();

    $('tr.product_row').remove();
    $(
        'span.total_quantity, span.price_total, span#total_discount, span#order_tax, span#total_payable, span#shipping_charges_amount'
    ).text(0);
    $('span.total_payable_span', 'span.total_paying', 'span.balance_due').text(0);

    $('#modal_payment')
        .find('.remove_payment_row')
        .each(function () {
            $(this).closest('.payment_row').remove();
        });

    if ($('#is_credit_sale').length) {
        $('#is_credit_sale').val(0);
    }

    //Reset discount
    __write_number($('input#discount_amount'), $('input#discount_amount').data('default'));
    $('input#discount_type').val($('input#discount_type').data('default'));

    //Reset tax rate
    $('input#tax_rate_id').val($('input#tax_rate_id').data('default'));
    __write_number(
        $('input#tax_calculation_amount'),
        $('input#tax_calculation_amount').data('default')
    );

    // $('select.payment_types_dropdown').val('cash').trigger('change');
    $('#price_group').trigger('change');

    //Reset shipping
    __write_number($('input#shipping_charges'), $('input#shipping_charges').data('default'));
    $('input#shipping_details').val($('input#shipping_details').data('default'));
    $('input#shipping_address, input#shipping_status, input#delivered_to').val('');
    if ($('input#is_recurring').length > 0) {
        $('input#is_recurring').iCheck('update');
    }
    if ($('#invoice_layout_id').length > 0) {
        $('#invoice_layout_id').trigger('change');
    }
    $('span#round_off_text').text(0);

    //repair module extra  fields reset
    if ($('#repair_device_id').length > 0) {
        $('#repair_device_id').val('').trigger('change');
    }

    //Status is hidden in sales order
    if ($('#status').length > 0 && $('#status').is(':visible')) {
        $('#status').val('').trigger('change');
    }
    if ($('#transaction_date').length > 0) {
        $('#transaction_date').data('DateTimePicker').date(moment());
    }
    if ($('.paid_on').length > 0) {
        $('.paid_on').data('DateTimePicker').date(moment());
    }
    if ($('#commission_agent').length > 0) {
        $('#commission_agent').val('').trigger('change');
    }

    //reset contact due
    $('.contact_due_text').find('span').text('');
    $('.contact_due_text').addClass('hide');

    $(document).trigger('sell_form_reset');
    $('#pos-loader').css('display', 'none')
}

function set_default_customer() {
    var default_customer_id = $('#default_customer_id').val();
    var default_customer_name = $('#default_customer_name').val();
    var default_customer_balance = $('#default_customer_balance').val();
    var default_customer_address = $('#default_customer_address').val();
    var exists = default_customer_id
        ? $('select#customer_id option[value=' + default_customer_id + ']').length
        : 0;
    if (exists == 0 && default_customer_id) {
        $('select#customer_id').append(
            $('<option>', { value: default_customer_id, text: default_customer_name })
        );
    }
    $('#id_contact').val(default_customer_id);
    $('#advance_balance_text').text(__currency_trans_from_en(default_customer_balance), true);
    $('#advance_balance').val(default_customer_balance);
    $('#shipping_address_modal').val(default_customer_address);
    if (default_customer_address) {
        $('#shipping_address').val(default_customer_address);
    }
    $('select#customer_id').val(default_customer_id).trigger('change');

    if ($('#default_selling_price_group').length) {
        $('#price_group').val($('#default_selling_price_group').val());
        $('#price_group').change();
    }

    //initialize tags input (tagify)
    if ($('textarea#repair_defects').length > 0 && !customer_set) {
        let suggestions = [];
        if (
            $('input#pos_repair_defects_suggestion').length > 0 &&
            $('input#pos_repair_defects_suggestion').val().length > 2
        ) {
            suggestions = JSON.parse($('input#pos_repair_defects_suggestion').val());
        }
        let repair_defects = document.querySelector('textarea#repair_defects');
        tagify_repair_defects = new Tagify(repair_defects, {
            whitelist: suggestions,
            maxTags: 100,
            dropdown: {
                maxItems: 100, // <- mixumum allowed rendered suggestions
                classname: 'tags-look', // <- custom classname for this dropdown, so it could be targeted
                enabled: 0, // <- show suggestions on focus
                closeOnSelect: false, // <- do not hide the suggestions dropdown once an item has been selected
            },
        });
    }

    customer_set = true;
}

//Set the location and initialize printer
function set_location() {
    if ($('select#select_location_id').length == 1) {
        $('input#location_id').val($('select#select_location_id').val());
        $('input#location_id').data(
            'receipt_printer_type',
            $('select#select_location_id').find(':selected').data('receipt_printer_type')
        );
        $('input#location_id').data(
            'default_payment_accounts',
            $('select#select_location_id').find(':selected').data('default_payment_accounts')
        );

        $('input#location_id').attr(
            'data-default_price_group',
            $('select#select_location_id').find(':selected').data('default_price_group')
        );
    }

    if ($('input#location_id').val()) {
        $('input#search_product').prop('disabled', false).focus();
    } else {
        $('input#search_product').prop('disabled', true);
    }

    initialize_printer();
}

function initialize_printer() {
    if ($('input#location_id').data('receipt_printer_type') == 'printer') {
        initializeSocket();
    }
}

$('body').on('click', 'label', function (e) {
    var field_id = $(this).attr('for');
    if (field_id) {
        if ($('#' + field_id).hasClass('select2')) {
            $('#' + field_id).select2('open');
            return false;
        }
    }
});

$('body').on('focus', 'select', function (e) {
    var field_id = $(this).attr('id');
    if (field_id) {
        if ($('#' + field_id).hasClass('select2')) {
            $('#' + field_id).select2('open');
            return false;
        }
    }
});

function round_row_to_iraqi_dinnar(row) {
    if (iraqi_selling_price_adjustment) {
        var element = row.find('input.pos_unit_price_inc_tax');
        var unit_price = round_to_iraqi_dinnar(__read_number(element));
        __write_number(element, unit_price);
        element.change();
    }
}

function pos_print(receipt) {
    //If printer type then connect with websocket
    if (receipt.print_type == 'printer') {
        var content = receipt;
        content.type = 'print-receipt';

        //Check if ready or not, then print.
        if (socket != null && socket.readyState == 1) {
            socket.send(JSON.stringify(content));
        } else {
            initializeSocket();
            setTimeout(function () {
                socket.send(JSON.stringify(content));
            }, 700);
        }
    } else if (receipt.html_content != '') {
        var title = document.title;
        if (typeof receipt.print_title != 'undefined') {
            document.title = receipt.print_title;
        }

        //If printer type browser then print content
        $('#receipt_section').html(receipt.html_content);
        __currency_convert_recursively($('#receipt_section'));
        __print_receipt('receipt_section');

        setTimeout(function () {
            document.title = title;
        }, 1200);
    }
}

function calculate_discounted_unit_price(row) {
    var this_unit_price = __read_number(row.find('input.pos_unit_price'));
    var row_discounted_unit_price = this_unit_price;
    var row_discount_type = row.find('select.row_discount_type').val();
    var row_discount_amount = __read_number(row.find('input.row_discount_amount'));
    if (row_discount_amount) {
        if (row_discount_type == 'fixed') {
            row_discounted_unit_price = this_unit_price - row_discount_amount;
        } else {
            row_discounted_unit_price = __substract_percent(this_unit_price, row_discount_amount);
        }
    }

    return row_discounted_unit_price;
}

function get_unit_price_from_discounted_unit_price(row, discounted_unit_price) {
    var this_unit_price = discounted_unit_price;
    var row_discount_type = row.find('select.row_discount_type').val();
    var row_discount_amount = __read_number(row.find('input.row_discount_amount'));
    if (row_discount_amount) {
        if (row_discount_type == 'fixed') {
            this_unit_price = discounted_unit_price + row_discount_amount;
        } else {
            this_unit_price = __get_principle(discounted_unit_price, row_discount_amount, true);
        }
    }

    return this_unit_price;
}

//Update quantity if line subtotal changes
$('table#pos_table tbody').on('change', 'input.pos_line_total', function () {
    var subtotal = __read_number($(this));
    var tr = $(this).parents('tr');
    var quantity_element = tr.find('input.pos_quantity');
    var unit_price_inc_tax = __read_number(tr.find('input.pos_unit_price_inc_tax'));
    var quantity = subtotal / unit_price_inc_tax;
    __write_number(quantity_element, quantity);

    if (sell_form_validator) {
        sell_form_validator.element(quantity_element);
    }
    if (pos_form_validator) {
        pos_form_validator.element(quantity_element);
    }
    tr.find('span.pos_line_total_text').text(__currency_trans_from_en(subtotal, true));

    pos_total_row();

    var temp_cart = [];
    $('table#pos_table tr.product_row').each(function() {
        var cart_item = {
            'product': $(this).find('span.cursor-pointer').html(),
            'qty': $(this).find('.pos_quantity').val(),
            'subtotal': $(this).find('.pos_line_total_text').html()
        }

        temp_cart.push(cart_item)
        // // // // console.log$(this).find('span.cursor-pointer').html);
    });
    cart = temp_cart;        

    pos_total_row();
    localStorage.setItem('cart', JSON.stringify(cart))
});

$('div#product_list_body').on('scroll', function () {
    if ($(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight) {
        var page = parseInt($('#suggestion_page').val());
        page += 1;
        $('#suggestion_page').val(page);
        var location_id = $('input#location_id').val();
        var category_id = $('select#product_category').val();
        var brand_id = $('select#product_brand').val();

        var is_enabled_stock = null;
        if ($('#is_enabled_stock').length) {
            is_enabled_stock = $('#is_enabled_stock').val();
        }

        var device_model_id = null;
        if ($('#repair_model_id').length) {
            device_model_id = $('#repair_model_id').val();
        }

        get_product_suggestion_list(
            category_id,
            brand_id,
            location_id,
            null,
            is_enabled_stock,
            device_model_id
        );
    }
});

$(document).on('ifChecked', '#is_recurring', function () {
    $('#recurringInvoiceModal').modal('show');
});

$(document).on('shown.bs.modal', '#recurringInvoiceModal', function () {
    $('input#recur_interval').focus();
});

$(document).on('click', '#select_all_service_staff', function () {
    var val = $('#res_waiter_id').val();
    $('#pos_table tbody')
        .find('select.order_line_service_staff')
        .each(function () {
            $(this).val(val).change();
        });
});

$(document).on('click', '.print-invoice-link', function (e) {
    e.preventDefault();
    $.ajax({
        url: $(this).attr('href') + '?check_location=true',
        dataType: 'json',
        success: function (result) {
            if (result.success == 1) {
                //Check if enabled or not
                if (result.receipt.is_enabled) {
                    pos_print(result.receipt);
                }
            } else {
                toastr.error(result.msg);
            }
        },
    });
});

function getCustomerRewardPoints() {
    if ($('#reward_point_enabled').length <= 0) {
        return false;
    }
    var is_edit =
        $('form#edit_sell_form').length || $('form#edit_pos_sell_form').length ? true : false;
    if (is_edit && !customer_set) {
        return false;
    }

    var customer_id = $('#customer_id').val();

    $.ajax({
        method: 'POST',
        url: '/sells/pos/get-reward-details',
        data: {
            customer_id: customer_id,
        },
        dataType: 'json',
        success: function (result) {
            $('#available_rp').text(result.points);
            $('#rp_redeemed_modal').data('max_points', result.points);
            updateRedeemedAmount();
            $('#rp_redeemed_amount').change();
        },
    });
}

function updateRedeemedAmount(argument) {
    var points = $('#rp_redeemed_modal').val().trim();
    points = points == '' ? 0 : parseInt(points);
    var amount_per_unit_point = parseFloat($('#rp_redeemed_modal').data('amount_per_unit_point'));
    var redeemed_amount = points * amount_per_unit_point;
    $('#rp_redeemed_amount_text').text(__currency_trans_from_en(redeemed_amount, true));
    $('#rp_redeemed').val(points);
    $('#rp_redeemed_amount').val(redeemed_amount);
}

$(document).on('change', 'select#customer_id', function () {
    var default_customer_id = $('#default_customer_id').val();
    if ($(this).val() == default_customer_id) {
        //Disable reward points for walkin customers
        if ($('#rp_redeemed_modal').length) {
            $('#rp_redeemed_modal').val('');
            $('#rp_redeemed_modal').change();
            $('#rp_redeemed_modal').attr('disabled', true);
            $('#available_rp').text('');
            updateRedeemedAmount();
            pos_total_row();
        }
    } else {
        if ($('#rp_redeemed_modal').length) {
            $('#rp_redeemed_modal').removeAttr('disabled');
        }
        getCustomerRewardPoints();
    }

    get_sales_orders();
});

$(document).on('change', '#rp_redeemed_modal', function () {
    var points = $(this).val().trim();
    points = points == '' ? 0 : parseInt(points);
    var amount_per_unit_point = parseFloat($(this).data('amount_per_unit_point'));
    var redeemed_amount = points * amount_per_unit_point;
    $('#rp_redeemed_amount_text').text(__currency_trans_from_en(redeemed_amount, true));
    var reward_validation = isValidatRewardPoint();
    if (!reward_validation['is_valid']) {
        toastr.error(reward_validation['msg']);
        $('#rp_redeemed_modal').select();
    }
});

$(document).on('change', '.direct_sell_rp_input', function () {
    updateRedeemedAmount();
    pos_total_row();
});

function isValidatRewardPoint() {
    var element = $('#rp_redeemed_modal');
    var points = element.val().trim();
    points = points == '' ? 0 : parseInt(points);

    var max_points = parseInt(element.data('max_points'));
    var is_valid = true;
    var msg = '';

    if (points == 0) {
        return {
            is_valid: is_valid,
            msg: msg,
        };
    }

    var rp_name = $('input#rp_name').val();
    if (points > max_points) {
        is_valid = false;
        msg = __translate('max_rp_reached_error', { max_points: max_points, rp_name: rp_name });
    }

    var min_order_total_required = parseFloat(element.data('min_order_total'));

    var order_total = __read_number($('#final_total_input'));

    if (order_total < min_order_total_required) {
        is_valid = false;
        msg = __translate('min_order_total_error', {
            min_order: __currency_trans_from_en(min_order_total_required, true),
            rp_name: rp_name,
        });
    }

    var output = {
        is_valid: is_valid,
        msg: msg,
    };

    return output;
}

function adjustComboQty(tr) {
    if (tr.find('input.product_type').val() == 'combo') {
        var qty = __read_number(tr.find('input.pos_quantity'));
        var multiplier = __getUnitMultiplier(tr);

        tr.find('input.combo_product_qty').each(function () {
            $(this).val($(this).data('unit_quantity') * qty * multiplier);
        });
    }
}

$(document).on('change', '#types_of_service_id', function () {
    var types_of_service_id = $(this).val();
    var location_id = $('#location_id').val();

    if (types_of_service_id) {
        $.ajax({
            method: 'POST',
            url: '/sells/pos/get-types-of-service-details',
            data: {
                types_of_service_id: types_of_service_id,
                location_id: location_id,
            },
            dataType: 'json',
            success: function (result) {
                //reset form if price group is changed
                var prev_price_group = $('#types_of_service_price_group').val();
                if (result.price_group_id) {
                    $('#types_of_service_price_group').val(result.price_group_id);
                    $('#price_group_text').removeClass('hide');
                    $('#price_group_text span').text(result.price_group_name);
                } else {
                    $('#types_of_service_price_group').val('');
                    $('#price_group_text').addClass('hide');
                    $('#price_group_text span').text('');
                }
                $('#types_of_service_id').val(types_of_service_id);
                $('.types_of_service_modal').html(result.modal_html);

                if (prev_price_group != result.price_group_id) {
                    if ($('form#edit_pos_sell_form').length > 0) {
                        $('table#pos_table tbody').html('');
                        pos_total_row();
                    } else {
                        reset_pos_form();
                    }
                } else {
                    pos_total_row();
                }

                $('.types_of_service_modal').modal('show');
            },
        });
    } else {
        $('.types_of_service_modal').html('');
        $('#types_of_service_price_group').val('');
        $('#price_group_text').addClass('hide');
        $('#price_group_text span').text('');
        $('#packing_charge_text').text('');
        if ($('form#edit_pos_sell_form').length > 0) {
            $('table#pos_table tbody').html('');
            pos_total_row();
        } else {
            reset_pos_form();
        }
    }
});

$(document).on(
    'change',
    'input#packing_charge, #additional_expense_value_1, #additional_expense_value_2, \
        #additional_expense_value_3, #additional_expense_value_4',
    function () {
        pos_total_row();
    }
);

$(document).on('click', '.service_modal_btn', function (e) {
    if ($('#types_of_service_id').val()) {
        $('.types_of_service_modal').modal('show');
    }
});

$(document).on('change', '.payment_types_dropdown', function (e) {         
    var default_accounts = $('select#select_location_id').length
        ? $('select#select_location_id').find(':selected').data('default_payment_accounts')
        : $('#location_id').data('default_payment_accounts');
    var payment_type = $(this).val();
    var amount_normal = $('span#total_payable').html();
    var row = $(this).parent().parent().parent().parent().parent().find('.payment_row_index').val();

    // // console.logpayment_type);
    // // console.log'masuk pa eko')    
    if(row == 0) {
        $('#amount_' + row).val(amount_normal);    
    } else {
        
    }
    calculate_balance_due();
    setSelectedPaymentData(); // Paligu
    
    var length_row_payment = $('input.payment-amount');
    if(length_row_payment.length > 1) {
        $('#add-payment-row').addClass('hide');
    } else {        
        if($('#in_balance_due').val() == '0.00' || $('#in_balance_due').val() == 0) {
            $('#add-payment-row').addClass('hide');
        } else {
            $('#add-payment-row').removeClass('hide');
        }
    }

    if($('#amount_' + row).val()) {
        $('#pos-save').removeAttr('disabled');
            $('#error-payment-amount').remove();            
    } else if($('#amount_' + row).val() <= 0) {      
        $('#pos-save').attr('disabled', true);      
        if($('#error-payment-amount').length == 0) {                
            $('#amount_' + row).parent().parent().append('<label class="error" id="error-payment-amount">Amount cannot be minus or zero</label>')
        }
    }
    var is_direct_sale = $('#is_direct_sale').val() ? $('#is_direct_sale').val() : 0;
    if(is_direct_sale == 0) {
        if(payment_type == 'cash') {                
            $(this).parent().parent().parent().parent().parent().find('div.payment_details_div[data-type=cash]').css('display', 'flex'); 
            $(this).parent().parent().parent().parent().parent().find('div.payment_details_div[data-type=cash]').removeClass('hide');         
            $('#info-payment').css('top', '51px');
        } else if(payment_type == 'card') {
            $(this).parent().parent().parent().parent().parent().find('div.payment_details_div[data-type=card]').css('display', 'block'); 
            $(this).parent().parent().parent().parent().parent().find('div.payment_details_div[data-type=card]').removeClass('hide'); 
            $('#info-payment').css('top', '51px');
        } else if(payment_row == 'debit') {
            $(this).parent().parent().parent().parent().parent().find('div.payment_details_div[data-type=debit]').css('display', 'block'); 
            $(this).parent().parent().parent().parent().parent().find('div.payment_details_div[data-type=debit]').removeClass('hide'); 
            $('#info-payment').css('top', '51px');
        }
    } else {
        $(this).parent().parent().parent().parent().parent().find('div.payment_details_div[data-type=cash]').css('display', 'none');
        $(this).parent().parent().parent().parent().parent().find('div.payment_details_div[data-type=card]').css('display', 'none');
    }

    var payment_row = $(this).closest('.payment_row');
    if (payment_type && payment_type != 'advance') {
        var default_account =
            default_accounts && default_accounts[payment_type]['account']
                ? default_accounts[payment_type]['account']
                : '';
        var row_index = payment_row.find('.payment_row_index').val();

        var account_dropdown = payment_row.find('select#account_' + row_index);
        if (account_dropdown.length && default_accounts) {
            account_dropdown.val(default_account);
            account_dropdown.change();
        }
    }

    //Validate max amount and disable account if advance
    amount_element = payment_row.find('.payment-amount');
    account_dropdown = payment_row.find('.account-dropdown');
    if (payment_type == 'advance') {
        max_value = $('#advance_balance').val();
        msg = $('#advance_balance').data('error-msg');
        amount_element.rules('add', {
            'max-value': max_value,
            messages: {
                'max-value': msg,
            },
        });
        if (account_dropdown) {
            account_dropdown.prop('disabled', true);
            account_dropdown.closest('.form-group').addClass('hide');
        }
    } else {
        amount_element.rules('remove', 'max-value');
        if (account_dropdown) {
            account_dropdown.prop('disabled', false);
            account_dropdown.closest('.form-group').removeClass('hide');
        }
    }
});

var pattern = ['0','0','0','.','0','0'];
var pattern_qty = ['0','0','0','0'];
$(document).on('click', '.numPadCashDel', function (e) {
    //PALIGU
    let curValue;
    // let row_index = $('#payment_row_index').val() - 1;    
    let row_index = $(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().find('.payment_row_index').val();
        
    pattern[pattern.length - 1] = pattern[pattern.length - 2];
    pattern[pattern.length - 2] = pattern[pattern.length - 4];
    pattern[pattern.length - 4] = pattern[pattern.length - 5];
    pattern[pattern.length - 5] = pattern[pattern.length - 6];
    pattern[pattern.length - 6] = '0';

    curValue = pattern.join('');
    if (pattern[0] == '0' && pattern[1] == '0') {
        //// // // console.log"basta 2 sifir");
        $('#amount_' + row_index).val(curValue.substring(2));
    } else if (pattern[0] == '0') {
        //// // // console.log"basta 1 sifir");
        $('#amount_' + row_index).val(curValue.substring(1));
    } else {
        //// // // console.log"pattern[0] != 0");
        $('#amount_' + row_index).val(curValue);
    }
    
    if (Number(curValue) == 0) {        
        let total = __read_number($('input#final_total_input'));
        $('#amount_' + row_index).val(total);
    }
    calculate_balance_due();
    var length_row_payment = $('input.payment-amount');
    if(length_row_payment.length > 1) {
        $('#add-payment-row').addClass('hide');
    } else {        
        if($('#in_balance_due').val() == '0.00' || $('#in_balance_due').val() == 0) {
            $('#add-payment-row').addClass('hide');
        } else {
            $('#add-payment-row').removeClass('hide');
        }
    }

    if($('#amount_' + row_index).val() > 0) {
        $('#pos-save').removeAttr('disabled');
            $('#error-payment-amount').remove();            
    } else if($('#amount_' + row_index).val() <= 0) {      
        $('#pos-save').attr('disabled', true);      
        if($('#error-payment-amount').length == 0) {                
            $('#amount_' + row_index).parent().parent().append('<label class="error" id="error-payment-amount">Amount cannot be minus or zero</label>')
        }
    }
});

$(document).on('click', '.numPadCashClear', function (e) {
    //PALIGU
    let total = __read_number($('input#final_total_input'));
    // let row_index = $('#payment_row_index').val() - 1;
    let row_index = $(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().find('.payment_row_index').val();
    // // console.log"total, row_index");
    // // console.logtotal, row_index);
    if(row_index != 0) {
        var total_paying_input = $('#amount_0').val();
        var balance_due = $('#total_payable').html();
        var total_balance = parseFloat(balance_due) - parseFloat(total_paying_input);
        $('#amount_' + row_index).val(__currency_trans_from_en(total_balance, false));
    } else {
        $('#amount_' + row_index).val(total);
    }
    calculate_balance_due();
    var length_row_payment = $('input.payment-amount');
    if(length_row_payment.length > 1) {
        $('#add-payment-row').addClass('hide');
    } else {        
        if($('#in_balance_due').val() == '0.00' || $('#in_balance_due').val() == 0) {
            $('#add-payment-row').addClass('hide');
        } else {
            $('#add-payment-row').removeClass('hide');
        }
    }

    if($('#amount_' + row_index).val() > 0) {
        $('#pos-save').removeAttr('disabled');
            $('#error-payment-amount').remove();            
    } else if($('#amount_' + row_index).val() <= 0) {      
        $('#pos-save').attr('disabled', true);      
        if($('#error-payment-amount').length == 0) {                
            $('#amount_' + row_index).parent().parent().append('<label class="error" id="error-payment-amount">Amount cannot be minus or zero</label>')
        }
    }
    pattern = ['0', '0', '0', '.', '0', '0'];
});

$(document).on('click', '.numPadCash', function (e) {
    //PALIGU    
    // var check_method = $('#payment_row_index').parent().find('.payment_details_div:visible')
    // let row_index = $('#payment_row_index').val() - 1;    
    let row_index = $(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().find('.payment_row_index').val();
    let type = $(this).data('type');    
    let curValue;
    // // console.log$(this).text());
    switch ($(this).text()) {
        case '00':            
            if(pattern[0] == '0' && pattern[1] == '0') {
                pattern[pattern.length - 6] = pattern[pattern.length - 5];
                pattern[pattern.length - 5] = pattern[pattern.length - 4];
                pattern[pattern.length - 4] = pattern[pattern.length - 2];
                pattern[pattern.length - 2] = pattern[pattern.length - 1];
                pattern[pattern.length - 1] = '0';            
                
                pattern[pattern.length - 6] = pattern[pattern.length - 5];
                pattern[pattern.length - 5] = pattern[pattern.length - 4];
                pattern[pattern.length - 4] = pattern[pattern.length - 2];
                pattern[pattern.length - 2] = pattern[pattern.length - 1];
                pattern[pattern.length - 1] = '0';            
                
            }
            curValue = pattern.join('');
            if (pattern[0] == '0' && pattern[1] == '0') {
                //// // console.log"basta 2 sifir");
                $('#amount_' + row_index).val(curValue.substring(2));
            } else if (pattern[0] == '0') {
                //// // console.log"basta 1 sifir");
                $('#amount_' + row_index).val(curValue.substring(1));
            } else {
                // // console.log'pattern[0] != 0');
                //$("#amount_"+row_index).val(curValue);
                // let row_index = $(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().find('.payment_row_index').val();
                $('#amount_' + row_index).val(curValue);
            }

            calculate_balance_due();
            var length_row_payment = $('input.payment-amount');
            if(length_row_payment.length > 1) {
                $('#add-payment-row').addClass('hide');
            } else {        
                if($('#in_balance_due').val() == '0.00' || $('#in_balance_due').val() == 0) {
                    $('#add-payment-row').addClass('hide');
                } else {
                    $('#add-payment-row').removeClass('hide');
                }
            }
            if($('#amount_' + row_index).val() > 0) {
                $('#pos-save').removeAttr('disabled');
                    $('#error-payment-amount').remove();            
            } else if($('#amount_' + row_index).val() <= 0) {      
                $('#pos-save').attr('disabled', true);      
                if($('#error-payment-amount').length == 0) {                
                    $('#amount_' + row_index).parent().parent().append('<label class="error" id="error-payment-amount">Amount cannot be minus or zero</label>')
                }
            }
            break;

        default:            
            if (!$('#amount_' + row_index).val()) {
                let last = pattern.findLastIndex((element) => (element = '0'));
                pattern[last] = document.getElementsByClassName('payment-amount').innerText;
                // // console.log"pattern");
                // // console.logpattern);
                // // console.log'pattern[last] : ' + pattern[last]);
                curValue = pattern.join('');
                
                if (pattern[0] == '0' && pattern[1] == '0') {
                    // // console.log'basta 2 sifir');
                    $('#amount_' + row_index).val(curValue.substring(2));
                } else if (pattern[0] == '0') {
                    // // console.log'basta 1 sifir');
                    $('#amount_' + row_index).val(curValue.substring(1));
                } else {
                    // // console.log'pattern[0] != 0');
                    $('#amount_' + row_index).val(curValue);
                }
                calculate_balance_due();
                var length_row_payment = $('input.payment-amount');
                if(length_row_payment.length > 1) {
                    $('#add-payment-row').addClass('hide');
                } else {        
                    if($('#in_balance_due').val() == '0.00' || $('#in_balance_due').val() == 0) {
                        $('#add-payment-row').addClass('hide');
                    } else {
                        $('#add-payment-row').removeClass('hide');
                    }
                }

                if($('#amount_' + row_index).val() > 0) {
                    $('#pos-save').removeAttr('disabled');
                        $('#error-payment-amount').remove();            
                } else if($('#amount_' + row_index).val() <= 0) {      
                    $('#pos-save').attr('disabled', true);      
                    if($('#error-payment-amount').length == 0) {                
                        $('#amount_' + row_index).parent().parent().append('<label class="error" id="error-payment-amount">Amount cannot be minus or zero</label>')
                    }
                }
            } else {                
                if(type == 'top') {
                    pattern[pattern.length - 6] = '0';
                    pattern[pattern.length - 5] = '0';
                    pattern[pattern.length - 4] = $(this).text();
                    pattern[pattern.length - 2] = '0';
                    pattern[pattern.length - 1] = '0';    
                    typeCash = 'top';                                                        
                } else {         
                    if(typeCash == 'top') {
                        pattern[pattern.length - 6] = 0;
                        pattern[pattern.length - 5] = 0;
                        pattern[pattern.length - 4] = 0;
                    } else {
                        pattern[pattern.length - 6] = pattern[pattern.length - 5];
                        pattern[pattern.length - 5] = pattern[pattern.length - 4];                        
                        pattern[pattern.length - 4] = pattern[pattern.length - 2];
                    }
                    pattern[pattern.length - 2] = pattern[pattern.length - 1];
                    pattern[pattern.length - 1] = $(this).text();
                    typeCash = 'middle';       
                }
                
                // // console.logtypeCash)                                                 
                // // console.logpattern);
                curValue = pattern.join('');

                if (pattern[0] == '0' && pattern[1] == '0') {
                    // // console.log'basta 2 sifir');
                    //$("#amount_"+row_index).val(curValue.substring(2));
                    // // console.log'substring 2');
                    // // console.logcurValue.substring(2));
                    $('#amount_' + row_index).val(curValue.substring(2));
                } else if (pattern[0] == '0') {
                    // // console.log'substring 1');
                    // // console.logcurValue.substring(1));
                    $('#amount_' + row_index).val(curValue.substring(1));
                } else {                    
                    $('#amount_' + row_index).val(curValue);
                }
                calculate_balance_due();
                var length_row_payment = $('input.payment-amount');
                if(length_row_payment.length > 1) {
                    $('#add-payment-row').addClass('hide');
                } else {        
                    if($('#in_balance_due').val() == '0.00' || $('#in_balance_due').val() == 0) {
                        $('#add-payment-row').addClass('hide');
                    } else {
                        $('#add-payment-row').removeClass('hide');
                    }
                }

                if($('#amount_' + row_index).val() > 0) {
                    $('#pos-save').removeAttr('disabled');
                        $('#error-payment-amount').remove();            
                } else if($('#amount_' + row_index).val() <= 0) {      
                    $('#pos-save').attr('disabled', true);      
                    if($('#error-payment-amount').length == 0) {                
                        $('#amount_' + row_index).parent().parent().append('<label class="error" id="error-payment-amount">Amount cannot be minus or zero</label>')
                    }
                }
            }

            break;
    }
});   


$(document).on('click', '.numPadCashDiscountModal', function(e) {
    var type_input = $(this).parent().parent().parent().parent().parent().parent().data('type');    
    name_input = 'discount_amount_modal';
    
    let type = $(this).data('type');
    let curValue;
    switch ($(this).text()) {
        case '00':            
            if(pattern[0] == '0' && pattern[1] == '0') {                
                pattern[pattern.length - 6] = pattern[pattern.length - 5];
                pattern[pattern.length - 5] = pattern[pattern.length - 4];
                pattern[pattern.length - 4] = pattern[pattern.length - 2];
                pattern[pattern.length - 2] = pattern[pattern.length - 1];
                pattern[pattern.length - 1] = '0';            
                
                pattern[pattern.length - 6] = pattern[pattern.length - 5];
                pattern[pattern.length - 5] = pattern[pattern.length - 4];
                pattern[pattern.length - 4] = pattern[pattern.length - 2];
                pattern[pattern.length - 2] = pattern[pattern.length - 1];
                pattern[pattern.length - 1] = '0';                                            
            }

            //// // // console.log"pattern");
            //// // // console.logpattern);

            curValue = pattern.join('');
            if (pattern[0] == '0' && pattern[1] == '0') {
                //// // // console.log"basta 2 sifir");
                $('input[name="'+name_input+'"]').val(curValue.substring(2));
            } else if (pattern[0] == '0') {
                //// // // console.log"basta 1 sifir");
                $('input[name="'+name_input+'"]').val(curValue.substring(1));
            } else {
                // // // console.log'pattern[0] != 0');
                //$("input[name="'+name_input+'"]"_"+row_index).val(curValue);
                let row_index = $('#payment_row_index').val();
                $('input[name="'+name_input+'"]').val(curValue);
            }

            // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))

            // calculate_balance_due();
            // $('input.pos_unit_price').trigger('change');
            break;

        default:            
            if (!$('input[name="'+name_input+'"').val()) {
                let last = pattern.findLastIndex((element) => (element = '0'));
                pattern[last] = document.getElementsByClassName('payment-amount').innerText;
                // // // console.log'pattern[last] : ' + pattern[last]);
                curValue = pattern.join('');

                if (pattern[0] == '0' && pattern[1] == '0') {
                    // // // console.log'basta 2 sifir');
                    $('input[name="'+name_input+'"]').val(curValue.substring(2));
                } else if (pattern[0] == '0') {
                    // // // console.log'basta 1 sifir');
                    $('input[name="'+name_input+'"]').val(curValue.substring(1));
                } else {
                    // // // console.log'pattern[0] != 0');
                    $('input[name="'+name_input+'"]').val(curValue);
                }
                // calculate_balance_due();
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                // calculate_balance_due();
                $('input.pos_unit_price').trigger('change');
            } else {
                // // // // console.log'2541');
                if(type == 'top') {                    
                    pattern[pattern.length - 6] = '0';
                    pattern[pattern.length - 5] = '0';
                    pattern[pattern.length - 4] = $(this).text();
                    pattern[pattern.length - 2] = '0';
                    pattern[pattern.length - 1] = '0';    
                    typeCash = 'top';                                                                            
                } else {         
                    if(typeCash == 'top') {                                              
                        pattern[pattern.length - 6] = 0;
                        pattern[pattern.length - 5] = 0;
                        pattern[pattern.length - 4] = 0;                        
                    } else {                        
                        pattern[pattern.length - 6] = pattern[pattern.length - 5];
                        pattern[pattern.length - 5] = pattern[pattern.length - 4];                        
                        pattern[pattern.length - 4] = pattern[pattern.length - 2];                        
                    }
                    pattern[pattern.length - 2] = pattern[pattern.length - 1];
                    pattern[pattern.length - 1] = $(this).text();
                    typeCash = 'middle';       
                }

                curValue = pattern.join('');

                if (pattern[0] == '0' && pattern[1] == '0') {
                    // // // console.log'basta 2 sifir');
                    //$("#amount_"+row_index).val(curValue.substring(2));

                    $('input[name="'+name_input+'"]').val(curValue.substring(2));
                } else if (pattern[0] == '0') {
                    $('input[name="'+name_input+'"]').val(curValue.substring(1));
                } else {
                    $('input[name="'+name_input+'"]').val(curValue);
                }
                // calculate_balance_due();
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                // calculate_balance_due();
                $('input.pos_unit_price').trigger('change');
            }

        break;
    }
})

$(document).on('click', '.numPadCashDiscountModalDel', function (e) {
    //PALIGU
    let curValue;
    var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
    name_input = 'discount_amount_modal';   
    let type = $(this).data('type');
    
    pattern[pattern.length - 1] = pattern[pattern.length - 2];
    pattern[pattern.length - 2] = pattern[pattern.length - 4];
    pattern[pattern.length - 4] = pattern[pattern.length - 5];
    pattern[pattern.length - 5] = pattern[pattern.length - 6];
    pattern[pattern.length - 6] = '0';

    curValue = pattern.join('');
    if (pattern[0] == '0' && pattern[1] == '0') {
        //// // // console.log"basta 2 sifir");
        $('input[name="'+name_input+'"]').val(curValue.substring(2));
    } else if (pattern[0] == '0') {
        //// // // console.log"basta 1 sifir");
        $('input[name="'+name_input+'"]').val(curValue.substring(1));
    } else {
        //// // // console.log"pattern[0] != 0");
        $('input[name="'+name_input+'"]').val(curValue);
    }
    
    $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
    if (Number(curValue) == 0) {        
        let total = "0.00";
        $('input[name="'+name_input+'"]').val(total);        
        // calculate_balance_due();
        // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
    }
    // calculate_balance_due();
    // $('input.pos_unit_price').trigger('change');
});

$(document).on('click', '.numPadCashDiscountModalClear', function (e) {
    //PALIGU    
    var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');    
    name_input = 'discount_amount_modal';
    total = "0.00";    
    let type = $(this).data('type');
    // let initValue = __read_number($('input.pos_unit_price').val());
    // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
    
    $('input[name="'+name_input+'"]').val(total);
    // calculate_balance_due();
    // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
    // calculate_balance_due();    
    // $('input.pos_unit_price').trigger('change');
    
    pattern = ['0', '0', '0', '.', '0', '0'];
});

$(document).on('show.bs.modal', '#recent_transactions_modal', function () {
    $('body').off('keypress');    
    get_recent_transactions('final', $('div#tab_final'));
});
$(document).on('hidden.bs.modal', '#recent_transactions_modal', function () {
    $('body').on('keypress', function (event) {
        document.getElementById('search_product').focus();
        var text = $('#search_product').val();
        if (text.length < 1) {
            $('#search_product').val(event.keyup);
        }
    });        
});
$(document).on('show.bs.modal', '#custom_sale_modal', function () {
    $('#custom_sale_modal').find('input').filter(':visible:first').focus().select();
        /* $(this)
            .find('input')
            .filter(':visible:first')
            .focus()
            .select(); */
    $('#error-product-name-custom-sale').remove();
    $(this).find('input#product_custom_name').val("");
    $(this).find('input#product_custom_quantity').val("0");
    $(this).find('input#product_custom_amount').val("0.00");
    pattern_qty = ['0','0','0','0'];

    /* $('#form_custom_modal').validate({
        rules: {
            product_custom_name: {
                required: true,
            },
            product_custom_quantity: {
                required: true,
                min: 0,
            },
            product_custom_amount: {
                min: 0.1,
                required: true,
            }
        },
    }); */
    $('#product_numpad_div1').addClass('hide');
    $(this).find('input#product_custom_name').trigger('click').trigger('focus');
    $('body').off('keypress');        
});

$(document).on('hidden.bs.modal', '#custom_sale_modal', function () {
    $('#product_numpad_div1').addClass('hide');
    $('body').on('keypress', function (event) {
        document.getElementById('search_product').focus();
        var text = $('#search_product').val();
        if (text.length < 1) {
            $('#search_product').val(event.keyup);
        }
    });        
});
$(document).on('shown.bs.tab', 'a[href="#tab_quotation"]', function () {
    get_recent_transactions('quotation', $('div#tab_quotation'));
});
$(document).on('shown.bs.tab', 'a[href="#tab_draft"]', function () {
    get_recent_transactions('draft', $('div#tab_draft'));
});

function disable_pos_form_actions() {
    if (!window.navigator.onLine) {
        return false;
    }

    $('div.pos-processing').show();
    $('#pos-save').attr('disabled', 'true');
    $('div.pos-form-actions').find('button').attr('disabled', 'true');
}

function enable_pos_form_actions() {
    $('div.pos-processing').hide();
    $('#pos-save').removeAttr('disabled');
    $('div.pos-form-actions').find('button').removeAttr('disabled');
}

$(document).on('change', '#recur_interval_type', function () {
    if ($(this).val() == 'months') {
        $('.subscription_repeat_on_div').removeClass('hide');
    } else {
        $('.subscription_repeat_on_div').addClass('hide');
    }
});

function validate_discount_field() {
    discount_element = $('#discount_amount_modal');
    discount_type_element = $('#discount_type_modal');

    if ($('#add_sell_form').length || $('#edit_sell_form').length) {
        discount_element = $('#discount_amount');
        discount_type_element = $('#discount_type');
    }
    var max_value = parseFloat(discount_element.data('max-discount'));
    if (discount_element.val() != '' && !isNaN(max_value)) {
        if (discount_type_element.val() == 'fixed') {
            var subtotal = get_subtotal();
            //get max discount amount
            max_value = __calculate_amount('percentage', max_value, subtotal);
        }

        discount_element.rules('add', {
            'max-value': max_value,
            messages: {
                'max-value': discount_element.data('max-discount-error_msg'),
            },
        });
    } else {
        discount_element.rules('remove', 'max-value');
    }
    discount_element.trigger('change');
}

$(document).on('change', '#discount_type_modal, #discount_type', function () {
    validate_discount_field();
});

function update_shipping_address(data) {
    if ($('#shipping_address_div').length) {
        var shipping_address = '';
        if (data.supplier_business_name) {
            shipping_address += data.supplier_business_name;
        }
        if (data.name) {
            shipping_address += ',<br>' + data.name;
        }
        if (data.text) {
            shipping_address += ',<br>' + data.text;
        }
        shipping_address += ',<br>' + data.shipping_address;
        $('#shipping_address_div').html(shipping_address);
    }
    if ($('#billing_address_div').length) {
        var address = [];
        if (data.supplier_business_name) {
            address.push(data.supplier_business_name);
        }
        if (data.name) {
            address.push('<br>' + data.name);
        }
        if (data.text) {
            address.push('<br>' + data.text);
        }
        if (data.address_line_1) {
            address.push('<br>' + data.address_line_1);
        }
        if (data.address_line_2) {
            address.push('<br>' + data.address_line_2);
        }
        if (data.city) {
            address.push('<br>' + data.city);
        }
        if (data.state) {
            address.push(data.state);
        }
        if (data.country) {
            address.push(data.country);
        }
        if (data.zip_code) {
            address.push('<br>' + data.zip_code);
        }
        var billing_address = address.join(', ');
        $('#billing_address_div').html(billing_address);
    }

    if ($('#shipping_custom_field_1').length) {
        let shipping_custom_field_1 =
            data.shipping_custom_field_details != null
                ? data.shipping_custom_field_details.shipping_custom_field_1
                : '';
        $('#shipping_custom_field_1').val(shipping_custom_field_1);
    }

    if ($('#shipping_custom_field_2').length) {
        let shipping_custom_field_2 =
            data.shipping_custom_field_details != null
                ? data.shipping_custom_field_details.shipping_custom_field_2
                : '';
        $('#shipping_custom_field_2').val(shipping_custom_field_2);
    }

    if ($('#shipping_custom_field_3').length) {
        let shipping_custom_field_3 =
            data.shipping_custom_field_details != null
                ? data.shipping_custom_field_details.shipping_custom_field_3
                : '';
        $('#shipping_custom_field_3').val(shipping_custom_field_3);
    }

    if ($('#shipping_custom_field_4').length) {
        let shipping_custom_field_4 =
            data.shipping_custom_field_details != null
                ? data.shipping_custom_field_details.shipping_custom_field_4
                : '';
        $('#shipping_custom_field_4').val(shipping_custom_field_4);
    }

    if ($('#shipping_custom_field_5').length) {
        let shipping_custom_field_5 =
            data.shipping_custom_field_details != null
                ? data.shipping_custom_field_details.shipping_custom_field_5
                : '';
        $('#shipping_custom_field_5').val(shipping_custom_field_5);
    }

    //update export fields
    if (data.is_export) {
        $('#is_export').prop('checked', true);
        $('div.export_div').show();
        if ($('#export_custom_field_1').length) {
            $('#export_custom_field_1').val(data.export_custom_field_1);
        }
        if ($('#export_custom_field_2').length) {
            $('#export_custom_field_2').val(data.export_custom_field_2);
        }
        if ($('#export_custom_field_3').length) {
            $('#export_custom_field_3').val(data.export_custom_field_3);
        }
        if ($('#export_custom_field_4').length) {
            $('#export_custom_field_4').val(data.export_custom_field_4);
        }
        if ($('#export_custom_field_5').length) {
            $('#export_custom_field_5').val(data.export_custom_field_5);
        }
        if ($('#export_custom_field_6').length) {
            $('#export_custom_field_6').val(data.export_custom_field_6);
        }
    } else {
        $(
            '#export_custom_field_1, #export_custom_field_2, #export_custom_field_3, #export_custom_field_4, #export_custom_field_5, #export_custom_field_6'
        ).val('');
        $('#is_export').prop('checked', false);
        $('div.export_div').hide();
    }

    $('#shipping_address_modal').val(data.shipping_address);
    $('#shipping_address').val(data.shipping_address);
}

function get_sales_orders() {
    if ($('#sales_order_ids').length) {
        if ($('#sales_order_ids').hasClass('not_loaded')) {
            $('#sales_order_ids').removeClass('not_loaded');
            return false;
        }
        var customer_id = $('select#customer_id').val();
        var location_id = $('input#location_id').val();
        $.ajax({
            url: '/get-sales-orders/' + customer_id + '?location_id=' + location_id,
            dataType: 'json',
            success: function (data) {
                $('#sales_order_ids').select2('destroy').empty().select2({ data: data });
                $('table#pos_table tbody')
                    .find('tr.product_row')
                    .each(function () {
                        if (typeof $(this).data('so_id') !== 'undefined') {
                            $(this).remove();
                        }
                    });
                pos_total_row();
            },
        });
    }
}

$('#sales_order_ids').on('select2:select', function (e) {
    var sales_order_id = e.params.data.id;
    var product_row = $('input#product_row_count').val();
    var location_id = $('input#location_id').val();
    $.ajax({
        method: 'GET',
        url: '/get-sales-order-lines',
        async: false,
        data: {
            product_row: product_row,
            sales_order_id: sales_order_id,
        },
        dataType: 'json',
        success: function (result) {
            if (result.html) {
                var html = result.html;
                $(html)
                    .find('tr')
                    .each(function () {
                        $('table#pos_table tbody').append($(this)).find('input.pos_quantity');

                        var this_row = $('table#pos_table tbody').find('tr.product_row').last();
                        pos_each_row(this_row);

                        product_row = parseInt(product_row) + 1;

                        //For initial discount if present
                        var line_total = __read_number(this_row.find('input.pos_line_total'));
                        this_row.find('span.pos_line_total_text').text(line_total);

                        //Check if multipler is present then multiply it when a new row is added.
                        if (__getUnitMultiplier(this_row) > 1) {
                            this_row.find('select.sub_unit').trigger('change');
                        }

                        round_row_to_iraqi_dinnar(this_row);
                        __currency_convert_recursively(this_row);
                    });

                set_so_values(result.sales_order);

                //increment row count
                $('input#product_row_count').val(product_row);

                pos_total_row();
            } else {
                toastr.error(result.msg);
                $('input#search_product').focus().select();
            }
        },
    });
});

function set_so_values(so) {
    $('textarea[name="sale_note"]').val(so.additional_notes);
    if ($('#shipping_details').is(':visible')) {
        $('#shipping_details').val(so.shipping_details);
    }
    $('#shipping_address').val(so.shipping_address);
    $('#delivered_to').val(so.delivered_to);
    $('#shipping_charges').val(__number_f(so.shipping_charges));
    $('#shipping_status').val(so.shipping_status);
    if ($('#shipping_custom_field_1').length) {
        $('#shipping_custom_field_1').val(so.shipping_custom_field_1);
    }
    if ($('#shipping_custom_field_2').length) {
        $('#shipping_custom_field_2').val(so.shipping_custom_field_2);
    }
    if ($('#shipping_custom_field_3').length) {
        $('#shipping_custom_field_3').val(so.shipping_custom_field_3);
    }
    if ($('#shipping_custom_field_4').length) {
        $('#shipping_custom_field_4').val(so.shipping_custom_field_4);
    }
    if ($('#shipping_custom_field_5').length) {
        $('#shipping_custom_field_5').val(so.shipping_custom_field_5);
    }
}

$('#sales_order_ids').on('select2:unselect', function (e) {
    var sales_order_id = e.params.data.id;
    $('table#pos_table tbody')
        .find('tr.product_row')
        .each(function () {
            if (
                typeof $(this).data('so_id') !== 'undefined' &&
                $(this).data('so_id') == sales_order_id
            ) {
                $(this).remove();
                pos_total_row();
            }
        });
});

$(document).on('click', '#add_expense', function () {
    $.ajax({
        url: '/expenses/create',
        data: {
            location_id: $('#select_location_id').val(),
        },
        dataType: 'html',
        success: function (result) {
            $('#expense_modal').html(result);
            $('#expense_modal').modal('show');
        },
    });
});

$(document).on('shown.bs.modal', '#expense_modal', function () {
    $('#expense_transaction_date').datetimepicker({
        format: moment_date_format + ' ' + moment_time_format,
        ignoreReadonly: true,
    });
    $('#expense_modal .paid_on').datetimepicker({
        format: moment_date_format + ' ' + moment_time_format,
        ignoreReadonly: true,
    });
    $(this).find('.select2').select2();
    $('#add_expense_modal_form').validate();
});

$(document).on('hidden.bs.modal', '#expense_modal', function () {
    $(this).html('');
});

$(document).on('submit', 'form#add_expense_modal_form', function (e) {
    e.preventDefault();
    var data = $(this).serialize();

    $.ajax({
        method: 'POST',
        url: $(this).attr('action'),
        dataType: 'json',
        data: data,
        success: function (result) {
            if (result.success == true) {
                $('#expense_modal').modal('hide');
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
    });
});

function get_contact_due(id) {
    $.ajax({
        method: 'get',
        url: /get-contact-due/ + id,
        dataType: 'text',
        success: function (result) {            
            if (result != '') {
                $('.contact_due_text').find('span').text(result);
                $('.contact_due_text').removeClass('hide');
            } else {
                $('.contact_due_text').find('span').text('');
                $('.contact_due_text').addClass('hide');
            }
        },
    });
}

function checkCashRegister(cash_register_list_id, location_id, id) {
    if (cash_register_list_id) {
        $.ajax({
            method: 'get',
            url: /check-cash-register-open/ + cash_register_list_id,
            success: function (result) {
                // // // console.logresult);
                if (result.count == 0) {
                    window.location.replace(
                        '/cash-register/create?cash_register_list_id=' +
                            cash_register_list_id +
                            '&location_id=' +
                            location_id
                    );
                    // window.location.href = window.location.host + '/cash-register/create';
                } else if (result.count == 1) {
                    $('#cash_register_list_id').val(cash_register_list_id);
                    $('#id_cash_register').val(result.id);

                    var urlRegister = $('#register_details').data('href');
                    $('#register_details').data(
                        'href',
                        window.location.protocol+'//' +
                            window.location.host +
                            '/cash-register/register-details' +
                            '?cash_register_list_id=' +
                            result.id
                    );
                    // // // // console.logwindow.location.host + '/cash-register/register-details' + '?cash_register_list_id='+ result.id)

                    var urlCloseRegister = $('#close_register').data('href');
                    var changeUrlClose = urlCloseRegister.split('close-register');
                    $('#close_register').data(
                        'href',
                        window.location.protocol+'//' +
                            window.location.host +
                            '/cash-register/close-register/' +
                            result.id
                    );
                    // // // // console.logwindow.location.host + '/cash-register/close-register/' + result.id)
                } else {
                    $('#select_location_id').val($('#default_location').val()).trigger('change');
                    $('#select_cash_registers_list').val($('#cash_register_list_id').val());
                    alert(result.message);
                }
            },
        });
    }
}

function submitQuickContactForm(form) {
    var data = $(form).serialize();
    $.ajax({
        method: 'POST',
        url: $(form).attr('action'),
        dataType: 'json',
        data: data,
        beforeSend: function (xhr) {
            __disable_submit_button($(form).find('button[type="submit"]'));
        },
        success: function (result) {
            if (result.success == true) {
                var name = result.data.name;

                if (result.data.supplier_business_name) {
                    name += result.data.supplier_business_name;
                }

                // // // // console.log'submit quick contact form')
                // // // // console.logresult)

                $('select#customer_id').append(
                    $('<option>', { value: result.data.id, text: name })
                );
                // $('#id_contact').val(result.data.id)
                $('select#customer_id').val(result.data.id).trigger('change');
                $('div.contact_modal').modal('hide');
                update_shipping_address(result.data);
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
    });
}

$(document).on('click', '#send_for_sell_return', function (e) {
    var invoice_no = $('#send_for_sell_return_invoice_no').val();

    if (invoice_no) {
        $.ajax({
            method: 'get',
            url: /validate-invoice-to-return/ + encodeURI(invoice_no),
            dataType: 'json',
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex');
            },
            success: function (result) {
                $('#pos-loader').css('display', 'none');
                if (result.success == true) {
                    window.location = result.redirect_url;
                } else {
                    toastr.error(result.msg);
                }
            },
        }).fail(function() {
            $('#pos-loader').css('display', 'none')
            toastr.error(LANG.something_went_wrong);
        });
    }
});

$(document).on('ifChanged', 'input[name="search_fields[]"]', function (event) {
    var search_fields = [];
    $('input[name="search_fields[]"]:checked').each(function () {
        search_fields.push($(this).val());
    });

    localStorage.setItem('pos_search_fields', search_fields);
});

function set_search_fields() {
    if ($('input[name="search_fields[]"]').length == 0) {
        return false;
    }

    var pos_search_fields = localStorage.getItem('pos_search_fields');

    if (pos_search_fields === null) {
        pos_search_fields = ['name', 'sku', 'lot'];
    }

    $('input[name="search_fields[]"]').each(function () {
        if (pos_search_fields.indexOf($(this).val()) >= 0) {
            $(this).iCheck('check');
        } else {
            $(this).iCheck('uncheck');
        }
    });
}

$(document).on('click', '#show_service_staff_availability', function () {
    loadServiceStaffAvailability();
});
$(document).on('click', '#refresh_service_staff_availability_status', function () {
    loadServiceStaffAvailability(false);
});
$(document).on('click', 'button.pause_resume_timer', function (e) {
    $('.view_modal').find('.overlay').removeClass('hide');
    $.ajax({
        method: 'get',
        url: $(this).attr('data-href'),
        dataType: 'json',
        success: function (result) {
            loadServiceStaffAvailability(false);
        },
    });
});

$(document).on('click', '.mark_as_available', function (e) {
    e.preventDefault();
    $('.view_modal').find('.overlay').removeClass('hide');
    $.ajax({
        method: 'get',
        url: $(this).attr('href'),
        dataType: 'json',
        success: function (result) {
            loadServiceStaffAvailability(false);
        },
    });
});
var service_staff_availability_interval = null;

function loadServiceStaffAvailability(show = true) {
    var location_id = $('[name="location_id"]').val();
    $.ajax({
        method: 'get',
        url: $('#show_service_staff_availability').attr('data-href'),
        dataType: 'html',
        data: { location_id: location_id },
        success: function (result) {
            $('.view_modal').html(result);
            if (show) {
                $('.view_modal').modal('show');

                //auto refresh service staff availabilty if modal is open
                service_staff_availability_interval = setInterval(function () {
                    loadServiceStaffAvailability(false);
                }, 60000);
            }
        },
    });
}

$(document).on('hidden.bs.modal', '.view_modal', function () {
    if (service_staff_availability_interval !== null) {
        clearInterval(service_staff_availability_interval);
    }
    service_staff_availability_interval = null;
});

function closeRegister() {
    var data = $('#close_register_form').serialize();    
    var url = $('#close_register_form').attr('action');
    data = data + '&id_cash_register=' + $('#id_cash_register').val();
    disable_pos_form_actions();
    $.ajax({
        method: 'POST',
        url: url,
        data: data,
        dataType: 'json',
        beforeSend: function() {
            $('#pos-loader').css('display', 'inline-flex')
        },
        success: function (result) {
            $('#pos-loader').css('display', 'none')
            // // // console.logresult, result.success, result.receipt)
            enable_pos_form_actions();
            if (result.success == 1) {
                reset_pos_form();
                toastr.success(result.msg);
                
                $('.close_register_modal').modal('hide');
                //Check if enabled or not
                if (result.receipt.is_enabled) {
                    pos_print(result.receipt);
                    $('#pos-loader').css('display', 'inline-flex')
                    setTimeout(() => {                    
                        var href = $('#btn_logout').attr('href');
                        window.location.href = href; //causes the browser to refresh and load the requested url
                    }, 10000);
                }
            } else {
                toastr.error(result.msg);
            }
        },
    });
}

// still error by Adri
function getZeroTax(row, element) {        
 
    pos_total_row()
}

function check_method(e) {
    e.preventDefault();    
    var total_payment_row = $('#total_payment_row').val();
    // console.logtotal_payment_row);
    // console.logselectedPaymentData);
    var in_balance_due = $('#in_balance_due').val();
    var cnf = true;
    if(selectedPaymentData.length > 0) {        
        if(total_payment_row == selectedPaymentData.length) {
            $.each(selectedPaymentData, function(k,v) {
                if(v.amount <= 0) {
                    swal({
                        title: 'Warning',
                        text: 'Amount cant be minus or zero',
                        icon: 'warning'
                    })

                    cnf = false;
                }
            });
            if(cnf) {
                if(in_balance_due == '0.00' || in_balance_due == 0 || in_balance_due == '0') {
                    pos_form_obj.submit();
                } else {
                    swal({
                        title: 'Warning',
                        text: "You can't finalize the payment if there is a balance",
                        icon: 'warning'
                    })
                }
            }
        } else {
            swal({
                title: 'Warning',
                text: 'Please select payment method',
                icon: 'warning'
            })
        }    
    } else {
        swal({
            title: 'Warning',
            text: 'Please select payment method',
            icon: 'warning'
        })
    }
}
