//This file contains all functions used products tab

$(document).ready(function() {
    $(document).on('ifChecked', 'input#enable_stock', function() {
        $('div#alert_quantity_div').show();
        $('div#quick_product_opening_stock_div').show();

        //Enable expiry selection
        if ($('#expiry_period_type').length) {
            $('#expiry_period_type').removeAttr('disabled');
        }

        if ($('#opening_stock_button').length) {
            $('#opening_stock_button').removeAttr('disabled');
        }
    });
    $(document).on('ifUnchecked', 'input#enable_stock', function() {
        $('div#alert_quantity_div').hide();
        $('div#quick_product_opening_stock_div').hide();
        $('input#alert_quantity').val(0);

        //Disable expiry selection
        if ($('#expiry_period_type').length) {
            $('#expiry_period_type')
                .val('')
                .change();
            $('#expiry_period_type').attr('disabled', true);
        }
        if ($('#opening_stock_button').length) {
            $('#opening_stock_button').attr('disabled', true);
        }
    });

    //Start For product type single

    //If purchase price exc tax is changed
    $(document).on('change', 'input#single_dpp', function(e) {
        var purchase_exc_tax = __read_number($('input#single_dpp'));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;        
        var tax_rate = $('select#tax')
        .find(':selected')
        .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;        
        
        var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
        __write_number($('input#single_dpp_inc_tax'), purchase_inc_tax);
        
        var profit_percent = __read_number($('#profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);        
        __write_number($('input#single_dsp'), selling_price);
        
        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
        // console.log('purchase_exc_tax, tax_rate, purchase_inc_tax, profit_percent, selling_price')
        // console.log(purchase_exc_tax, tax_rate, purchase_inc_tax, profit_percent, selling_price)        
    });

    $(document).on('click', 'input#single_dpp', function(e) {
        $('#add_product_div').removeClass('hide');
    })

    //If tax rate is changed
    $(document).on('change', 'select#tax', function() {
        if ($('select#type').val() == 'single') {
            var purchase_exc_tax = __read_number($('input#single_dpp'));
            purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

            var tax_rate = $('select#tax')
                .find(':selected')
                .data('rate');
            tax_rate = tax_rate == undefined ? 0 : tax_rate;

            var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
            __write_number($('input#single_dpp_inc_tax'), purchase_inc_tax);

            var selling_price = __read_number($('input#single_dsp'));
            var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
            __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
        }
    });

    //If purchase price inc tax is changed
    $(document).on('change', 'input#single_dpp_inc_tax', function(e) {
        var purchase_inc_tax = __read_number($('input#single_dpp_inc_tax'));
        purchase_inc_tax = purchase_inc_tax == undefined ? 0 : purchase_inc_tax;

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_exc_tax = __get_principle(purchase_inc_tax, tax_rate);
        __write_number($('input#single_dpp'), purchase_exc_tax);
        $('input#single_dpp').change();

        var profit_percent = __read_number($('#profit_percent'));
        profit_percent = profit_percent == undefined ? 0 : profit_percent;
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number($('input#single_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input#profit_percent', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_inc_tax = __read_number($('input#single_dpp_inc_tax'));
        purchase_inc_tax = purchase_inc_tax == undefined ? 0 : purchase_inc_tax;

        var purchase_exc_tax = __read_number($('input#single_dpp'));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var profit_percent = __read_number($('input#profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number($('input#single_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input#single_dsp', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var selling_price = __read_number($('input#single_dsp'));
        var purchase_exc_tax = __read_number($('input#single_dpp'));
        var profit_percent = __read_number($('input#profit_percent'));

        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number($('input#profit_percent'), profit_percent);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input#single_dsp_inc_tax', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;
        var selling_price_inc_tax = __read_number($('input#single_dsp_inc_tax'));

        var selling_price = __get_principle(selling_price_inc_tax, tax_rate);
        __write_number($('input#single_dsp'), selling_price);
        var purchase_exc_tax = __read_number($('input#single_dpp'));
        var profit_percent = __read_number($('input#profit_percent'));

        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number($('input#profit_percent'), profit_percent);
    });

    if ($('#product_add_form').length) {
        $('form#product_add_form').validate({
            rules: {
                sku: {
                    remote: {
                        url: '/products/check_product_sku',
                        type: 'post',
                        data: {
                            sku: function() {
                                return $('#sku').val();
                            },
                            product_id: function() {
                                if ($('#product_id').length > 0) {
                                    return $('#product_id').val();
                                } else {
                                    return '';
                                }
                            },
                        },
                    },
                },
                expiry_period: {
                    required: {
                        depends: function(element) {
                            return (
                                $('#expiry_period_type')
                                    .val()
                                    .trim() != ''
                            );
                        },
                    },
                },
            },
            messages: {
                sku: {
                    remote: LANG.sku_already_exists,
                },
            },
        });
    }

    $(document).on('click', '.submit_product_form', function(e) {
        e.preventDefault();

        var is_valid_product_form = true;

        var variation_skus = [];

        $('#product_form_part').find('.input_sub_sku').each( function(){
            var element = $(this);
            var row_variation_id = '';
            if ($(this).closest('tr').find('.row_variation_id')) {
                row_variation_id = $(this).closest('tr').find('.row_variation_id').val();
            }

            variation_skus.push({sku: element.val(), variation_id: row_variation_id});
            
        });        
        var submit_type = $(this).val();        
        if (variation_skus.length > 0) {
            $.ajax({
                method: 'post',
                url: '/products/validate_variation_skus',
                data: { skus: variation_skus},
                success: function(result) {
                    if (result.success == true) {                        
                        $('#submit_type').val(submit_type);
                        if ($('form#product_add_form').valid()) {
                            var category = document.createElement('input');
                            category.type = 'hidden'; 
                            category.name = 'category_name';
                            category.value = $('#category_id').find(':selected').text();
                            document.getElementById('product_add_form').appendChild(category)
                            var brand = document.createElement('input');
                            brand.type = 'hidden'; 
                            brand.name = 'brand_name';
                            brand.value = $('#brand_id').find(':selected').text();
                            document.getElementById('product_add_form').appendChild(brand)
                            $('form#product_add_form').submit()
                        }
                    } else {
                        toastr.error(__translate('skus_already_exists', {sku: result.sku}));
                        return false;
                    }
                },
            });
        } else {
            // var submit_type = $(this).attr('value');
            $('#submit_type').val(submit_type);
            if ($('form#product_add_form').valid()) {
                var category = document.createElement('input');
                category.type = 'hidden'; 
                category.name = 'category_name';
                category.value = $('#category_id').find('option:selected').text();
                document.getElementById('product_add_form').appendChild(category)
                var brand = document.createElement('input');
                brand.type = 'hidden'; 
                brand.name = 'brand_name';
                brand.value = $('#brand_id').find('option:selected').text();                
                document.getElementById('product_add_form').appendChild(brand)
                $('form#product_add_form').submit();
            }
        }
        
    });
    //End for product type single

    //Start for product type Variable
    //If purchase price exc tax is changed
    $(document).on('change', 'input.variable_dpp', function(e) {
        var tr_obj = $(this).closest('tr');

        var purchase_exc_tax = __read_number($(this));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
        __write_number(tr_obj.find('input.variable_dpp_inc_tax'), purchase_inc_tax);

        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
    });

    //If purchase price inc tax is changed
    $(document).on('change', 'input.variable_dpp_inc_tax', function(e) {
        var tr_obj = $(this).closest('tr');

        var purchase_inc_tax = __read_number($(this));
        purchase_inc_tax = purchase_inc_tax == undefined ? 0 : purchase_inc_tax;

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_exc_tax = __get_principle(purchase_inc_tax, tax_rate);
        __write_number(tr_obj.find('input.variable_dpp'), purchase_exc_tax);

        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input.variable_profit_percent', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var tr_obj = $(this).closest('tr');
        var profit_percent = __read_number($(this));

        var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input.variable_dsp', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var tr_obj = $(this).closest('tr');
        var selling_price = __read_number($(this));
        var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));

        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));

        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number(tr_obj.find('input.variable_profit_percent'), profit_percent);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
    });
    $(document).on('change', 'input.variable_dsp_inc_tax', function(e) {
        var tr_obj = $(this).closest('tr');
        var selling_price_inc_tax = __read_number($(this));

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var selling_price = __get_principle(selling_price_inc_tax, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));
        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number(tr_obj.find('input.variable_profit_percent'), profit_percent);
    });

    $(document).on('click', '.add_variation_value_row', function() {
        var variation_row_index = $(this)
            .closest('.variation_row')
            .find('.row_index')
            .val();
        var variation_value_row_index = $(this)
            .closest('table')
            .find('tr:last .variation_row_index')
            .val();

        if (
            $(this)
                .closest('.variation_row')
                .find('.row_edit').length >= 1
        ) {
            var row_type = 'edit';
        } else {
            var row_type = 'add';
        }

        var table = $(this).closest('table');

        $.ajax({
            method: 'GET',
            url: '/products/get_variation_value_row',
            data: {
                variation_row_index: variation_row_index,
                value_index: variation_value_row_index,
                row_type: row_type,
            },
            dataType: 'html',
            success: function(result) {
                if (result) {
                    table.append(result);
                    toggle_dsp_input();
                }
            },
        });
    });
    $(document).on('change', '.variation_template_values', function() {
        var tr_obj = $(this).closest('tr');
        var val = $(this).val();
        tr_obj.find('.variation_value_row').each(function(){
            if(val.includes($(this).attr('data-variation_value_id'))) {
                $(this).removeClass('hide');
                $(this).find('.is_variation_value_hidden').val(0);
            } else {
                $(this).addClass('hide');
                $(this).find('.is_variation_value_hidden').val(1);
            }
        })
    });
    $(document).on('change', '.variation_template', function() {
        tr_obj = $(this).closest('tr');

        if ($(this).val() !== '') {
            tr_obj.find('input.variation_name').val(
                $(this)
                    .find('option:selected')
                    .text()
            );

            var template_id = $(this).val();
            var row_index = $(this)
                .closest('tr')
                .find('.row_index')
                .val();
            $.ajax({
                method: 'POST',
                url: '/products/get_variation_template',
                dataType: 'json',
                data: { template_id: template_id, row_index: row_index },
                success: function(result) {
                    if (result) {
                        if(result.values.length > 0) {
                            tr_obj.find('.variation_template_values').select2();
                            tr_obj.find('.variation_template_values').empty();
                            tr_obj.find('.variation_template_values').select2({data: result.values, closeOnSelect: false});
                            tr_obj.find('.variation_template_values_div').removeClass('hide');
                            tr_obj.find('.variation_template_values').select2('open');
                        } else {
                            tr_obj.find('.variation_template_values_div').addClass('hide');
                        }
                        tr_obj
                            .find('table.variation_value_table')
                            .find('tbody')
                            .html(result.html);

                        toggle_dsp_input();
                    }
                },
            });
        }
    });

    $(document).on('click', '.remove_variation_value_row', function() {
        swal({
            title: LANG.sure,
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        }).then(willDelete => {
            if (willDelete) {
                var count = $(this)
                    .closest('table')
                    .find('.remove_variation_value_row').length;
                if (count === 1) {
                    $(this)
                        .closest('.variation_row')
                        .remove();
                } else {
                    $(this)
                        .closest('tr')
                        .remove();
                }
            }
        });
    });

    //If tax rate is changed
    $(document).on('change', 'select#tax', function() {
        if ($('select#type').val() == 'variable') {
            var tax_rate = $('select#tax')
                .find(':selected')
                .data('rate');
            tax_rate = tax_rate == undefined ? 0 : tax_rate;

            $('table.variation_value_table > tbody').each(function() {
                $(this)
                    .find('tr')
                    .each(function() {
                        var purchase_exc_tax = __read_number($(this).find('input.variable_dpp'));
                        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

                        var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
                        __write_number(
                            $(this).find('input.variable_dpp_inc_tax'),
                            purchase_inc_tax
                        );

                        var selling_price = __read_number($(this).find('input.variable_dsp'));
                        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
                        __write_number(
                            $(this).find('input.variable_dsp_inc_tax'),
                            selling_price_inc_tax
                        );
                    });
            });
        }
    });
    //End for product type Variable
    $(document).on('change', '#tax_type', function(e) {
        toggle_dsp_input();
    });
    toggle_dsp_input();

    $(document).on('change', '#expiry_period_type', function(e) {
        if ($(this).val()) {
            $('input#expiry_period').prop('disabled', false);
        } else {
            $('input#expiry_period').val('');
            $('input#expiry_period').prop('disabled', true);
        }
    });

    $(document).on('click', 'a.view-product', function(e) {
        e.preventDefault();
        $.ajax({
            url: $(this).attr('href'),
            dataType: 'html',
            success: function(result) {
                $('#view_product_modal')
                    .html(result)
                    .modal('show');
                __currency_convert_recursively($('#view_product_modal'));
            },
        });
    });
    var img_fileinput_setting = {
        showUpload: false,
        showPreview: true,
        browseLabel: LANG.file_browse_label,
        removeLabel: LANG.remove,
        previewSettings: {
            image: { width: 'auto', height: 'auto', 'max-width': '100%', 'max-height': '100%' },
        },
    };
    $('#upload_image').fileinput(img_fileinput_setting);

    if ($('textarea#product_description').length > 0) {
        tinymce.init({
            selector: 'textarea#product_description',
            height:250
        });
    }
});

function toggle_dsp_input() {
    var tax_type = $('#tax_type').val();
    if (tax_type == 'inclusive') {
        $('.dsp_label').each(function() {
            $(this).text(LANG.tax);
        });
        $('#single_dsp').addClass('hide');
        $('#single_dsp_inc_tax').removeClass('hide');

        $('.add-product-price-table')
            .find('.variable_dsp_inc_tax')
            .each(function() {
                $(this).removeClass('hide');
            });
        $('.add-product-price-table')
            .find('.variable_dsp')
            .each(function() {
                $(this).addClass('hide');
            });
    } else if (tax_type == 'exclusive') {
        $('.dsp_label').each(function() {
            $(this).text(LANG.tax);
        });
        $('#single_dsp').removeClass('hide');
        $('#single_dsp_inc_tax').addClass('hide');

        $('.add-product-price-table')
            .find('.variable_dsp_inc_tax')
            .each(function() {
                $(this).addClass('hide');
            });
        $('.add-product-price-table')
            .find('.variable_dsp')
            .each(function() {
                $(this).removeClass('hide');
            });
    }
}

function get_product_details(rowData) {
    var div = $('<div/>')
        .addClass('loading')
        .text('Loading...');

    $.ajax({
        url: '/products/' + rowData.id,
        dataType: 'html',
        success: function(data) {
            console.log('data')
            console.log(data)
            div.html(data).removeClass('loading');
        },
    });

    return div;
}

//Quick add unit
$(document).on('submit', 'form#quick_add_unit_form', function(e) {
    e.preventDefault();
    var form = $(this);
    var data = form.serialize();

    $.ajax({
        method: 'POST',
        url: $(this).attr('action'),
        dataType: 'json',
        data: data,
        beforeSend: function(xhr) {
            __disable_submit_button(form.find('button[type="submit"]'));
        },
        success: function(result) {
            if (result.success == true) {
                var newOption = new Option(result.data.short_name, result.data.id, true, true);
                // Append it to the select
                $('#unit_id')
                    .append(newOption)
                    .trigger('change');
                $('div.view_modal').modal('hide');
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
    });
});

//Quick add brand
$(document).on('submit', 'form#quick_add_brand_form', function(e) {
    e.preventDefault();
    var form = $(this);
    var data = form.serialize();       
    $.ajax({
        method: 'POST',
        url: $(this).attr('action'),
        dataType: 'json',
        data: data,
        beforeSend: function(xhr) {
            __disable_submit_button(form.find('button[type="submit"]'));
        },
        success: function(result) {
            if (result.success == true) {
                var newOption = new Option(result.data.name, result.data.id, true, true);
                // Append it to the select
                $('#brand_id')
                    .append(newOption)
                    .trigger('change');
                $('div.view_modal').modal('hide');
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
    });
});

$(document).on('click', 'button.apply-all', function(){
    var val = $(this).closest('.input-group').find('input').val();
    var target_class = $(this).data('target-class');
    $(this).closest('tbody').find('tr').each( function(){
        element =  $(this).find(target_class);
        element.val(val);
        element.change();
    });
});

var pattern_product = ['0','0','0','.','0','0'];
var arr_pattern_product = [];
var typeCashProduct = null;
$(document).on('click', '.numPadCashAddProduct', function(e) {
    // var type_input = $(this).parent().parent().parent().parent().parent().parent().data('type');    
    name_input = 'single_dpp';
    e.preventDefault();
    let type = $(this).data('type');
    // empty_denomination()
    let curValue;
    switch ($(this).text()) {
        case '00':            
            if(pattern_product[0] == '0' && pattern_product[1] == '0') {                
                pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];
                pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];
                pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                pattern_product[pattern_product.length - 1] = '0';            
                
                pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];
                pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];
                pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                pattern_product[pattern_product.length - 1] = '0';                                            
            }

            //// console.log("pattern_product");
            //// console.log(pattern_product);

            curValue = pattern_product.join('');
            if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                //// console.log("basta 2 sifir");
                $('input[name="'+name_input+'"]').val(curValue.substring(2));
            } else if (pattern_product[0] == '0') {
                //// console.log("basta 1 sifir");
                $('input[name="'+name_input+'"]').val(curValue.substring(1));
            } else {
                // console.log('pattern_product[0] != 0');
                //$("input[name="'+name_input+'"]"_"+row_index).val(curValue);
                let row_index = $('#payment_row_index').val();
                $('input[name="'+name_input+'"]').val(curValue);
            }

            // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))

            // calculate_balance_due();
            // $('input.pos_unit_price').trigger('change');
            break;

        default:            
            if (!$('input[name="'+name_input+'"').val()) {
                let last = pattern_product.findLastIndex((element) => (element = '0'));
                pattern_product[last] = document.getElementsByClassName('payment-amount').innerText;
                // console.log('pattern_product[last] : ' + pattern_product[last]);
                curValue = pattern_product.join('');

                if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                    // console.log('basta 2 sifir');
                    $('input[name="'+name_input+'"]').val(curValue.substring(2));
                } else if (pattern_product[0] == '0') {
                    // console.log('basta 1 sifir');
                    $('input[name="'+name_input+'"]').val(curValue.substring(1));
                } else {
                    // console.log('pattern_product[0] != 0');
                    $('input[name="'+name_input+'"]').val(curValue);
                }
                // calculate_balance_due();
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                // calculate_balance_due();
                $('input.pos_unit_price').trigger('change');
            } else {
                // // console.log('2541');
                if(type == 'top') {                    
                    pattern_product[pattern_product.length - 6] = '0';
                    pattern_product[pattern_product.length - 5] = '0';
                    pattern_product[pattern_product.length - 4] = $(this).text();
                    pattern_product[pattern_product.length - 2] = '0';
                    pattern_product[pattern_product.length - 1] = '0';    
                    typeCashProduct = 'top';                                                                            
                } else {         
                    if(typeCashProduct == 'top') {                                              
                        pattern_product[pattern_product.length - 6] = 0;
                        pattern_product[pattern_product.length - 5] = 0;
                        pattern_product[pattern_product.length - 4] = 0;                        
                    } else {                        
                        pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                        pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];                        
                        pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];                        
                    }
                    pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                    pattern_product[pattern_product.length - 1] = $(this).text();
                    typeCashProduct = 'middle';       
                }

                curValue = pattern_product.join('');

                if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                    // console.log('basta 2 sifir');
                    //$("#amount_"+row_index).val(curValue.substring(2));

                    $('input[name="'+name_input+'"]').val(curValue.substring(2));
                } else if (pattern_product[0] == '0') {
                    $('input[name="'+name_input+'"]').val(curValue.substring(1));
                } else {
                    $('input[name="'+name_input+'"]').val(curValue);
                }
                // calculate_balance_due();
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                // calculate_balance_due();
                $('input.pos_unit_price').trigger('change');
            }

        break;
    }

    $('input#single_dpp').trigger('change');
})

$(document).on('click', '.numPadCashAddProductDel', function (e) {
    //PALIGU
    e.preventDefault();
    let curValue;
    // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
    name_input = 'single_dpp';   
    let type = $(this).data('type');
    
    pattern_product[pattern_product.length - 1] = pattern_product[pattern_product.length - 2];
    pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 4];
    pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 5];
    pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 6];
    pattern_product[pattern_product.length - 6] = '0';

    curValue = pattern_product.join('');
    if (pattern_product[0] == '0' && pattern_product[1] == '0') {
        //// console.log("basta 2 sifir");
        $('input[name="'+name_input+'"]').val(curValue.substring(2));
    } else if (pattern_product[0] == '0') {
        //// console.log("basta 1 sifir");
        $('input[name="'+name_input+'"]').val(curValue.substring(1));
    } else {
        //// console.log("pattern_product[0] != 0");
        $('input[name="'+name_input+'"]').val(curValue);
    }
    
    $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
    if (Number(curValue) == 0) {        
        let total = "0.00";
        $('input[name="'+name_input+'"]').val(total);        
        // calculate_balance_due();
        // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
    }
    // calculate_balance_due();
    // $('input.pos_unit_price').trigger('change');
    $('input#single_dpp').trigger('change');
});

$(document).on('click', '.numPadCashAddProductClear', function (e) {
    //PALIGU    
    e.preventDefault();
    // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');    
    name_input = 'single_dpp';
    total = "0.00";    
    let type = $(this).data('type');
    // let initValue = __read_number($('input.pos_unit_price').val());
    // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
    
    $('input[name="'+name_input+'"]').val(total);
    // calculate_balance_due();
    // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
    // calculate_balance_due();    
    // $('input.pos_unit_price').trigger('change');
    
    pattern_product = ['0', '0', '0', '.', '0', '0'];
    $('input#single_dpp').trigger('change');
});

var old_numpad_name_product = null;
function show_product_numpad(e, name) {
    e.preventDefault();    
    $('#add_product_div').removeClass('hide');
    var pattern_product = ['0', '0', '0', '.', '0', '0'];
    old_numpad_name_product = name;
    $(document).on('click', '.numPadCashVariation', function(e) {
        // var index = $(this).parent().parent().parent().parent().parent().parent().data('index');    
        // var valueindex = $(this).parent().parent().parent().parent().parent().parent().data('valueindex');    
        // var index00 = $(this).parent().parent().parent().parent().parent().parent().parent().data('index')
        // var valueindex00 = $(this).parent().parent().parent().parent().parent().parent().parent().data('valueindex')
        // // product_variation[0][variations][0][default_purchase_price]  
        // pattern_product = arr_pattern_product[valueindex] ? arr_pattern_product[valueindex] : arr_pattern_product[valueindex00] ? arr_pattern_product[valueindex00] : ['0','0','0','.','0','0']; 
        // name_input = 'single_dpp';
        e.preventDefault();
        let type = $(this).data('type');
        // empty_denomination()
        let curValue;
        switch ($(this).text()) {
            case '00':            
                if(pattern_product[0] == '0' && pattern_product[1] == '0') {                
                    pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                    pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];
                    pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];
                    pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                    pattern_product[pattern_product.length - 1] = '0';            
                    
                    pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                    pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];
                    pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];
                    pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                    pattern_product[pattern_product.length - 1] = '0';                                            
                }
    
                //// console.log("pattern_product");
                //// console.log(pattern_product);
    
                curValue = pattern_product.join('');         
                if(old_numpad_name_product == name) {   
                    if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                        //// console.log("basta 2 sifir");
                        $('input[name="'+name+'"').val(curValue.substring(2));
                    } else if (pattern_product[0] == '0') {
                        //// console.log("basta 1 sifir");
                        $('input[name="'+name+'"').val(curValue.substring(1));
                    } else {
                        // console.log('pattern_product[0] != 0');
                        //$("input[name="['+name+'""_"+row_index).val(curValue);
                        let row_index = $('#payment_row_index').val();
                        $('input[name="'+name+'"').val(curValue);
                    }
                }
    
                // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
    
                // calculate_balance_due();
                // $('input.pos_unit_price').trigger('change');
                // arr_pattern_product.splice(valueindex00, 1, pattern_product);
                // console.log(arr_pattern_product);
                
                $('input[name="'+name+'"').trigger('change');
                break;
    
            default:            
                if (!$('input[name="'+name+'"').val()) {
                    let last = pattern_product.findLastIndex((element) => (element = '0'));
                    pattern_product[last] = document.getElementsByClassName('payment-amount').innerText;
                    // console.log('pattern_product[last] : ' + pattern_product[last]);
                    curValue = pattern_product.join('');
                    if(old_numpad_name_product == name) {
                        if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                            // console.log('basta 2 sifir');
                            $('input[name="'+name+'"').val(curValue.substring(2));
                        } else if (pattern_product[0] == '0') {
                            // console.log('basta 1 sifir');
                            $('input[name="'+name+'"').val(curValue.substring(1));
                        } else {
                            // console.log('pattern_product[0] != 0');
                            $('input[name="'+name+'"').val(curValue);
                        }
                        // calculate_balance_due();
                        $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                        // calculate_balance_due();
                        // arr_pattern_product.splice(valueindex, 1, pattern_product);
                        // console.log(arr_pattern_product);
                        $('input[name="'+name+'"').trigger('change');
                    }
                } else {
                    // // console.log('2541');
                    if(old_numpad_name_product == name) {
                        if(type == 'top') {                    
                            pattern_product[pattern_product.length - 6] = '0';
                            pattern_product[pattern_product.length - 5] = '0';
                            pattern_product[pattern_product.length - 4] = $(this).text();
                            pattern_product[pattern_product.length - 2] = '0';
                            pattern_product[pattern_product.length - 1] = '0';    
                            typeCashProduct = 'top';                                                                            
                        } else {         
                            if(typeCashProduct == 'top') {                                              
                                pattern_product[pattern_product.length - 6] = 0;
                                pattern_product[pattern_product.length - 5] = 0;
                                pattern_product[pattern_product.length - 4] = 0;                        
                            } else {                        
                                pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                                pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];                        
                                pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];                        
                            }
                            pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                            pattern_product[pattern_product.length - 1] = $(this).text();
                            typeCashProduct = 'middle';       
                        }
        
                        curValue = pattern_product.join('');                
                        if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                            // console.log('basta 2 sifir');
                            //$("#amount_"+row_index).val(curValue.substring(2));
        
                            $('input[name="'+name+'"').val(curValue.substring(2));
                        } else if (pattern_product[0] == '0') {
                            $('input[name="'+name+'"').val(curValue.substring(1));
                        } else {
                            $('input[name="'+name+'"').val(curValue);
                        }
                        // calculate_balance_due();
                        $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                        // calculate_balance_due();                
                        // arr_pattern_product.splice(valueindex, 1, pattern_product);
                        // console.log(arr_pattern_product);
                        $('input[name="'+name+'"').trigger('change');
                    }
                }
    
            break;
        }
    
        $('input#single_dpp').trigger('change');
    })
    
    $(document).on('click', '.numPadCashVariationDel', function (e) {
        //PALIGU
        e.preventDefault();
        let curValue;
        // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
        // var index = $(this).parent().parent().parent().parent().parent().parent().parent().data('index')
        // var valueindex = $(this).parent().parent().parent().parent().parent().parent().parent().data('valueindex')
       
        // pattern_product = arr_pattern_product[valueindex] ? arr_pattern_product[valueindex] : ['0','0','0','.','0','0']; 
        // name_input = 'single_dpp';   
        // let type = $(this).data('type');
        if(old_numpad_name_product == name) {
            pattern_product[pattern_product.length - 1] = pattern_product[pattern_product.length - 2];
            pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 4];
            pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 5];
            pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 6];
            pattern_product[pattern_product.length - 6] = '0';
        
            curValue = pattern_product.join('');
            if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                //// console.log("basta 2 sifir");
                $('input[name="'+name+'"').val(curValue.substring(2));
            } else if (pattern_product[0] == '0') {
                //// console.log("basta 1 sifir");
                $('input[name="'+name+'"').val(curValue.substring(1));
            } else {
                //// console.log("pattern_product[0] != 0");
                $('input[name="'+name+'"').val(curValue);
            }
            
            $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
            if (Number(curValue) == 0) {        
                let total = "0.00";
                $('input[name="'+name+'"').val(total);        
                // calculate_balance_due();
                // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
            }
            // calculate_balance_due();
            // $('input.pos_unit_price').trigger('change');
            // arr_pattern_product.splice(valueindex, 1, pattern_product);
            // console.log(arr_pattern_product);
            $('input[name="'+name+'"').trigger('change');
        }
    });
    
    $(document).on('click', '.numPadCashVariationClear', function (e) {
        //PALIGU    
        e.preventDefault();
        // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type'); 
        // var index = $(this).parent().parent().parent().parent().parent().parent().parent().data('index')
        // var valueindex = $(this).parent().parent().parent().parent().parent().parent().parent().data('valueindex')
        // pattern_product = arr_pattern_product[valueindex] ? arr_pattern_product[valueindex] : ['0','0','0','.','0','0']; 
        if(old_numpad_name_product == name) {
            name_input = 'single_dpp';
            total = "0.00";    
            let type = $(this).data('type');
            // let initValue = __read_number($('input.pos_unit_price').val());
            // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
            
            $('input[name="'+name+'"').val(total);
            // calculate_balance_due();
            // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
            // calculate_balance_due();    
            // $('input.pos_unit_price').trigger('change');
            
            pattern_product = ['0', '0', '0', '.', '0', '0'];
            // arr_pattern_product.splice(valueindex, 1, pattern_product);            
            $('input[name="'+name+'"').trigger('change');
        }
    });
}

function hide_product_numpad() {
    $('#add_product_div').addClass('hide');
}

$(document).on('click', '.numPadCashVariationEdit', function(e) {
    var index = $(this).parent().parent().parent().parent().parent().parent().data('index');    
    var valueindex = $(this).parent().parent().parent().parent().parent().parent().data('valueindex');    
    var index00 = $(this).parent().parent().parent().parent().parent().parent().parent().data('index');
    var valueindex00 = $(this).parent().parent().parent().parent().parent().parent().parent().data('valueindex');
    var row_index = $(this).parent().parent().parent().parent().parent().parent().data('row_index');
    var row_index00 = $(this).parent().parent().parent().parent().parent().parent().parent().data('row_index');
    // product_variation[0][variations][0][default_purchase_price]  
    pattern_product = arr_pattern_product[valueindex] ? arr_pattern_product[valueindex] : arr_pattern_product[valueindex00] ? arr_pattern_product[valueindex00] : ['0','0','0','.','0','0']; 
    // name_input = 'single_dpp';
    e.preventDefault();
    let type = $(this).data('type');
    // empty_denomination()
    let curValue;
    switch ($(this).text()) {
        case '00':            
            if(pattern_product[0] == '0' && pattern_product[1] == '0') {                
                pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];
                pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];
                pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                pattern_product[pattern_product.length - 1] = '0';            
                
                pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];
                pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];
                pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                pattern_product[pattern_product.length - 1] = '0';                                            
            }

            //// console.log("pattern_product");
            //// console.log(pattern_product);

            curValue = pattern_product.join('');            
            if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                //// console.log("basta 2 sifir");
                $('input[name="product_variation_edit['+index00+'][variations_edit]['+valueindex00+'][default_purchase_price]"').val(curValue.substring(2));
            } else if (pattern_product[0] == '0') {
                //// console.log("basta 1 sifir");
                $('input[name="product_variation_edit['+index00+'][variations_edit]['+valueindex00+'][default_purchase_price]"').val(curValue.substring(1));
            } else {
                // console.log('pattern_product[0] != 0');
                //$("input[name="[product_variation_edit['+index00+'][variations_edit]['+valueindex00+'][default_purchase_price]""_"+row_index).val(curValue);
                let row_index = $('#payment_row_index').val();
                $('input[name="product_variation_edit['+index00+'][variations_edit]['+valueindex00+'][default_purchase_price]"').val(curValue);
            }

            // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))

            // calculate_balance_due();
            // $('input.pos_unit_price').trigger('change');
            arr_pattern_product.splice(row_index00, 1, pattern_product);
            // console.log(arr_pattern_product);
            
            $('input[name="product_variation_edit['+index00+'][variations_edit]['+valueindex00+'][default_purchase_price]"').trigger('change');
            break;

        default:            
            if (!$('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val()) {
                let last = pattern_product.findLastIndex((element) => (element = '0'));
                pattern_product[last] = document.getElementsByClassName('payment-amount').innerText;
                // console.log('pattern_product[last] : ' + pattern_product[last]);
                curValue = pattern_product.join('');

                if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                    // console.log('basta 2 sifir');
                    $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(curValue.substring(2));
                } else if (pattern_product[0] == '0') {
                    // console.log('basta 1 sifir');
                    $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(curValue.substring(1));
                } else {
                    // console.log('pattern_product[0] != 0');
                    $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(curValue);
                }
                // calculate_balance_due();
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                // calculate_balance_due();
                arr_pattern_product.splice(row_index, 1, pattern_product);
                // console.log(arr_pattern_product);
                $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').trigger('change');
            } else {
                // // console.log('2541');
                if(type == 'top') {                    
                    pattern_product[pattern_product.length - 6] = '0';
                    pattern_product[pattern_product.length - 5] = '0';
                    pattern_product[pattern_product.length - 4] = $(this).text();
                    pattern_product[pattern_product.length - 2] = '0';
                    pattern_product[pattern_product.length - 1] = '0';    
                    typeCashProduct = 'top';                                                                            
                } else {         
                    if(typeCashProduct == 'top') {                                              
                        pattern_product[pattern_product.length - 6] = 0;
                        pattern_product[pattern_product.length - 5] = 0;
                        pattern_product[pattern_product.length - 4] = 0;                        
                    } else {                        
                        pattern_product[pattern_product.length - 6] = pattern_product[pattern_product.length - 5];
                        pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 4];                        
                        pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 2];                        
                    }
                    pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 1];
                    pattern_product[pattern_product.length - 1] = $(this).text();
                    typeCashProduct = 'middle';       
                }

                curValue = pattern_product.join('');                
                if (pattern_product[0] == '0' && pattern_product[1] == '0') {
                    // console.log('basta 2 sifir');
                    //$("#amount_"+row_index).val(curValue.substring(2));

                    $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(curValue.substring(2));
                } else if (pattern_product[0] == '0') {
                    $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(curValue.substring(1));
                } else {
                    $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(curValue);
                }
                // calculate_balance_due();
                $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                // calculate_balance_due();                
                arr_pattern_product.splice(row_index, 1, pattern_product);
                // console.log(arr_pattern_product);
                $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').trigger('change');
            }

        break;
    }

    $('input#single_dpp').trigger('change');
})

$(document).on('click', '.numPadCashVariationEditDel', function (e) {
    //PALIGU
    e.preventDefault();
    let curValue;
    // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
    var index = $(this).parent().parent().parent().parent().parent().parent().parent().data('index');
    var valueindex = $(this).parent().parent().parent().parent().parent().parent().parent().data('valueindex');
    var row_index00 = $(this).parent().parent().parent().parent().parent().parent().parent().data('row_index');
   
    pattern_product = arr_pattern_product[valueindex] ? arr_pattern_product[valueindex] : ['0','0','0','.','0','0']; 
    // name_input = 'single_dpp';   
    // let type = $(this).data('type');
    
    pattern_product[pattern_product.length - 1] = pattern_product[pattern_product.length - 2];
    pattern_product[pattern_product.length - 2] = pattern_product[pattern_product.length - 4];
    pattern_product[pattern_product.length - 4] = pattern_product[pattern_product.length - 5];
    pattern_product[pattern_product.length - 5] = pattern_product[pattern_product.length - 6];
    pattern_product[pattern_product.length - 6] = '0';

    curValue = pattern_product.join('');
    if (pattern_product[0] == '0' && pattern_product[1] == '0') {
        //// console.log("basta 2 sifir");
        $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(curValue.substring(2));
    } else if (pattern_product[0] == '0') {
        //// console.log("basta 1 sifir");
        $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(curValue.substring(1));
    } else {
        //// console.log("pattern_product[0] != 0");
        $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(curValue);
    }
    
    $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
    if (Number(curValue) == 0) {        
        let total = "0.00";
        $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(total);        
        // calculate_balance_due();
        // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
    }
    // calculate_balance_due();
    // $('input.pos_unit_price').trigger('change');
    arr_pattern_product.splice(row_index00, 1, pattern_product);
    // console.log(arr_pattern_product);
    $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').trigger('change');
});

$(document).on('click', '.numPadCashVariationEditClear', function (e) {
    //PALIGU    
    e.preventDefault();
    // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type'); 
    var index = $(this).parent().parent().parent().parent().parent().parent().parent().data('index');
    var valueindex = $(this).parent().parent().parent().parent().parent().parent().parent().data('valueindex');
    var row_index00 = $(this).parent().parent().parent().parent().parent().parent().parent().data('row_index');
    
    pattern_product = arr_pattern_product[valueindex] ? arr_pattern_product[valueindex] : ['0','0','0','.','0','0']; 
    name_input = 'single_dpp';
    total = "0.00";    
    let type = $(this).data('type');
    // let initValue = __read_number($('input.pos_unit_price').val());
    // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
    
    $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').val(total);
    // calculate_balance_due();
    // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
    // calculate_balance_due();    
    // $('input.pos_unit_price').trigger('change');
    
    pattern_product = ['0', '0', '0', '.', '0', '0'];
    arr_pattern_product.splice(row_index00, 1, pattern_product);            
    $('input[name="product_variation_edit['+index+'][variations_edit]['+valueindex+'][default_purchase_price]"').trigger('change');
});
