$(document).ready(function() {
    //If location is set then show tables.
    getLocationTables($('input#location_id').val());

    $('select#select_location_id').change(function() {
        var location_id = $(this).val();
        getLocationTables(location_id);
    });

    $(document).on('click', 'button.add_modifier', function() {
        var checkbox = $(this)
            .closest('div.modal-content')
            .find('input:checked');
        selected = [];
        checkbox.each(function() {
            selected.push($(this).val());
        });

        var index = $(this)
            .closest('div.modal-content')
            .find('input.index')
            .val();

        var quantity = __read_number($(this).closest('tr.product_row').find('input.pos_quantity'));
        
        add_selected_modifiers(selected, index, quantity);
    });
    $(document).on('click', '#refresh_orders', function() {
        refresh_orders();
    });

    //Auto refresh orders
    if ($('#refresh_orders').length > 0) {
        var refresh_interval = parseInt($('#__orders_refresh_interval').val()) * 1000;

        setInterval(function(){ 
            refresh_orders();
        }, refresh_interval);
    }
});

function getLocationTables(location_id) {
    var transaction_id = $('span#restaurant_module_span').data('transaction_id');

    if (location_id != '') {
        $.ajax({
            method: 'GET',
            url: '/modules/data/get-pos-details',
            data: { location_id: location_id, transaction_id: transaction_id },
            dataType: 'html',
            success: function(result) {
                $('span#restaurant_module_span').html(result);
                //REPAIR MODULE:set technician from repair module
                if ($("#repair_technician").length) {
                    $("select#res_waiter_id").val($("#repair_technician").val()).change();
                }
            },
        });
    }
}

function add_selected_modifiers(selected, index, quantity = 1) {
    if (selected.length > 0) {
        $.ajax({
            method: 'GET',
            url: $('button.add_modifier').data('url'),
            data: { selected: selected, index: index, quantity: quantity },
            dataType: 'html',
            success: function(result) {
                // console.log(result);
                if (result != '') {
                    $('table#pos_table tbody')
                        .find('tr.product_row')
                        .each(function() {
                            if ($(this).data('row_index') == index) {                                                             
                                $(this)                                            
                                    .find('td:first span.selected_modifiers')
                                    .html(result);
                                return false;
                            }
                        });

                    //Update total price.
                    pos_total_row();                    

                    var temp_cart = [];
                    $('table#pos_table tr.product_row').each(function() {
                        var cart_item = {
                            'product': $(this).find('span.cursor-pointer').html(),
                            'qty': $(this).find('.pos_quantity').val(),
                            'subtotal': $(this).find('.pos_line_total_text').html()
                        }
                
                        temp_cart.push(cart_item)
                        // console.log($(this).find('span.cursor-pointer').html);
                    });
                    cart = temp_cart;                
                    localStorage.setItem('cart', JSON.stringify(cart))
                
                    var temp_location = [{
                        'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
                        'sales_tax': $('#order_tax').html(),
                        'items': $('.total_quantity').html(),
                        'sub_total': $('.price_total').html(),
                        'discount': $('.total_discount').html() ? $('.total_discount').html() : 0,
                        'location_name': $('select#select_location_id').find(':selected').text(),
                        'total': $('#final_total_input').val(),
                    }];
                    localStorage.setItem('location_picture', JSON.stringify(temp_location));
                }
            },
        });
    } else {
        $('table#pos_table tbody')
            .find('tr.product_row')
            .each(function() {
                if ($(this).data('row_index') == index) {
                    $(this)
                        .find('td:first .selected_modifiers')
                        .html('');
                    return false;
                }
            });

        //Update total price.
        pos_total_row();        

        var temp_cart = [];
        $('table#pos_table tr.product_row').each(function() {
            var cart_item = {
                'product': $(this).find('span.cursor-pointer').html(),
                'qty': $(this).find('.pos_quantity').val(),
                'subtotal': $(this).find('.pos_line_total_text').html()
            }
    
            temp_cart.push(cart_item)
            // console.log($(this).find('span.cursor-pointer').html);
        });
        cart = temp_cart;                
        localStorage.setItem('cart', JSON.stringify(cart))
    
        var temp_location = [{
            'location_picture': $('select#select_location_id').find(':selected').data('default_picture'),
            'sales_tax': $('#order_tax').html(),
            'items': $('.total_quantity').html(),
            'sub_total': $('.price_total').html(),
            'discount': $('.total_discount').html() ? $('.total_discount').html() : 0,
            'location_name': $('select#select_location_id').find(':selected').text(),
            'total': $('#final_total_input').val(),
        }];
        localStorage.setItem('location_picture', JSON.stringify(temp_location));
    }
}

function refresh_orders() {
    $('.overlay').removeClass('hide');
    var orders_for = $('input#orders_for').val();
    var service_staff_id = '';
    if ($('select#service_staff_id').val()) {
        service_staff_id = $('select#service_staff_id').val();
    }
    $.ajax({
        method: 'POST',
        url: '/modules/refresh-orders-list',
        data: { orders_for: orders_for, service_staff_id: service_staff_id },
        dataType: 'html',
        success: function(data) {
            $('#orders_div').html(data);
            $('.overlay').addClass('hide');
        },
    });

    $.ajax({
        method: 'POST',
        url: '/modules/refresh-line-orders-list',
        data: { orders_for: orders_for, service_staff_id: service_staff_id },
        dataType: 'html',
        success: function(data) {
            $('#line_orders_div').html(data);
            $('.overlay').addClass('hide');
        },
    });
}
