$(document).ready(function() {
    //For edit pos form
    if ($('form#sell_return_form').length > 0) {
        pos_form_obj = $('form#sell_return_form');
    } else {
        pos_form_obj = $('form#add_pos_sell_form');
    }
    if ($('form#sell_return_form').length > 0 || $('form#add_pos_sell_form').length > 0) {
        initialize_printer();
    }

    //Date picker
    $('#transaction_date').datetimepicker({
        format: moment_date_format + ' ' + moment_time_format,
        ignoreReadonly: true,
    });

    pos_form_validator = pos_form_obj.validate({
        submitHandler: function(form) {
            var cnf = true;
            var voidable = false;

            $.when(checkRefundableOrVoidable()).done(function(result) {
                if(result.refundable == 'Y') {
                    cnf = true;
                } else {
                    if(result.voidable == 'Y') {
                        cnf = true;
                        voidable = true;
                    } else {
                        swal({
                            title: 'Information',
                            text: "Non Refundable and Non Voidable!",
                            icon: 'warning',
                            // buttons: true,
                            dangerMode: true,
                        })
                        cnf = false;
                    }
                }             
                if (cnf) {
                    if(voidable) {
                        swal({
                            title: 'Information',
                            text: "This transaction is not refundable yet, do you want me to void whole transaction?",
                            icon: 'warning',
                            // buttons: true,
                            buttons: {
                                cancel: "CANCEL",
                                confirm: "OK"
                            },
                        }).then((confirm) => {                                
                            //Check if enabled or not
                            if(confirm) {
                                $('table#sell_return_table tbody').find('tr').each(function () {
                                    var qtyMax = $(this).find('input.return_qty').data('rule-max-value');
                                    $(this).find('input.return_qty').val(qtyMax).trigger('change');                                    
                                });
                                var data = $(form).serialize();
                                var url = $(form).attr('action');                
                                url = url + '?return_subtotal=' + $('#net_return_input').val() + '&voidable=' + voidable + '&total_return_discount=' + $('#total_return_discount').val();
                                $.ajax({
                                    method: 'POST',
                                    url: url,
                                    data: data,
                                    dataType: 'json',
                                    beforeSend: function() {
                                        $('#pos-loader').css('display', 'flex');
                                    },
                                    success: function(result) {
                                        $('#pos-loader').css('display', 'none');
                                        if (result.success == 1) {
                                            // toastr.success(result.msg);
                                            swal({
                                                title: 'Success',
                                                // text: result.msg,
                                                icon: 'success',
                                                // buttons: true,
                                                dangerMode: true,
                                            }).then((confirm) => {                                
                                                //Check if enabled or not
                                                if (result.receipt.is_enabled) {
                                                    pos_print(result.receipt);
                                                }
                                                
                                                setTimeout(() => {
                                                    $('#pos-loader').css('display', 'flex');
                                                    $('table#pos_table tbody').remove();
                                                    window.location.href = base_path + '/sells';
                                                }, 5000);
                                            });                            
                                        } else {
                                            // toastr.error(result.msg);
                                            swal({
                                                title: 'Information',
                                                text: result.msg,
                                                icon: 'warning',
                                                // buttons: true,
                                                dangerMode: true,
                                            })
                                        }
                                    },                    
                                    error: function() {
                                        $('#pos-loader').css('display', 'none');
                                    },
                                }).fail(function(xhr, ajaxStatus, response) {
                                    $('#pos-loader').css('display', 'none');
                                });
                            }
                        });
                    } else {
                        var data = $(form).serialize();
                        var url = $(form).attr('action');                
                        url = url + '?return_subtotal=' + $('#net_return_input').val() + '&voidable=' + voidable;
                        $.ajax({
                            method: 'POST',
                            url: url,
                            data: data,
                            dataType: 'json',
                            beforeSend: function() {
                                $('#pos-loader').css('display', 'flex');
                            },
                            success: function(result) {
                                $('#pos-loader').css('display', 'none');
                                if (result.success == 1) {
                                    // toastr.success(result.msg);
                                    swal({
                                        title: 'Success',
                                        // text: result.msg,
                                        icon: 'success',
                                        // buttons: true,
                                        dangerMode: true,
                                    }).then((confirm) => {                                
                                        //Check if enabled or not
                                        if (result.receipt.is_enabled) {
                                            pos_print(result.receipt);
                                        }
                                        
                                        setTimeout(() => {
                                            $('#pos-loader').css('display', 'flex');
                                            $('table#pos_table tbody').remove();
                                            window.location.href = base_path + '/sells';
                                        }, 5000);
                                    });                            
                                } else {
                                    // toastr.error(result.msg);
                                    swal({
                                        title: 'Information',
                                        text: result.msg,
                                        icon: 'warning',
                                        // buttons: true,
                                        dangerMode: true,
                                    })
                                }
                            },                    
                            error: function() {
                                $('#pos-loader').css('display', 'none');
                            },
                        }).fail(function(xhr, ajaxStatus, response) {
                            $('#pos-loader').css('display', 'none');
                        });
                    }
                }
                return false;
            })
        },
    });
});

function initialize_printer() {
    if ($('input#location_id').data('receipt_printer_type') == 'printer') {
        initializeSocket();
    }
}

function pos_print(receipt) {
    //If printer type then connect with websocket
    if (receipt.print_type == 'printer') {
        var content = receipt;
        content.type = 'print-receipt';

        //Check if ready or not, then print.
        if (socket.readyState != 1) {
            initializeSocket();
            setTimeout(function() {
                socket.send(JSON.stringify(content));
            }, 700);
        } else {
            socket.send(JSON.stringify(content));
        }
    } else if (receipt.html_content != '') {
        var title = document.title;
        if (typeof receipt.print_title != 'undefined') {
            document.title = receipt.print_title;
        }

        //If printer type browser then print content
        $('#receipt_section').html(receipt.html_content);
        __currency_convert_recursively($('#receipt_section'));
        setTimeout(function() {
            window.print();
            document.title = title;
        }, 1000);
    }
}

function checkRefundableOrVoidable(e) {    
    if($('#exchange_checkbox').prop('checked') == true) {
        return {
            'refundable': 'Y',
            'voidable': 'N',
        };
    } else {
        return $.ajax({
            method: 'GET',        
            url: base_path + '/sell-return/inquiry-card-payment/' + $('#invoice_no_pos').val(),
            beforeSend: function() {
                $('#pos-loader').css('display', 'flex');
            },
            success: function(result) {
                $('#pos-loader').css('display', 'none');
                // console.log(result);            
            },                    
            error: function() {
                $('#pos-loader').css('display', 'none');
            },
        }).fail(function(xhr, ajaxStatus, response) {
            $('#pos-loader').css('display', 'none');
        });
    }
}

function checkAmount(e) {
    e.preventDefault();
    var return_total =  parseFloat($('#net_return_input').val()).toFixed(2);
    var total_exchange = parseFloat($('#final_total_input').val()).toFixed(2);
    
    if(parseFloat(total_exchange) > parseFloat(return_total)) {
        /* console.log('lebih dari')
        console.log(return_total)
        console.log(total_exchange) */
        swal({
            title: 'Information',
            text: 'Total amount is more than return total amount, are you sure?',
            icon: 'info',
            buttons: {
                cancel: "CANCEL",
                confirm: "OK"
            },                      
        }).then((confirmed) => {
            if(confirmed) {
                $('#sell_return_form').trigger('submit');
            }
        });
    } else if(parseFloat(total_exchange) < parseFloat(return_total)) {
        /* console.log('kurang dari')
        console.log(return_total)
        console.log(total_exchange) */
        swal({
            title: 'Information',
            text: 'Total amount is less than return total amount, are you sure?',
            icon: 'info',
            buttons: {
                cancel: "CANCEL",
                confirm: "OK"
            },                      
        }).then((confirmed) => {
            if(confirmed) {
                $('#sell_return_form').trigger('submit');
            }
        });
    } else {
        $('#sell_return_form').trigger('submit');
    }
}

function exchangeCheckbox(v) {        
    if($(v).prop('checked') == true) {
        $('table#sell_return_table tbody').find('tr').each(function () {
            var qtyMax = $(this).find('input.return_qty').data('rule-max-value');
            $(this).find('input.return_qty').val(qtyMax).trigger('change');
            // $(this).find('input.return_qty').attr('readonly', true);
        });
        
        // "Total amount is less than return total amount, are you sure?"
        // "Total amount is more than return total amount, are you sure?"
        $('#complete_return_submit').attr('disabled', true);
        $('#componen_exchange').removeClass('hide');
    } else {
        $('table#sell_return_table tbody').find('tr').each(function () {            
            $(this).find('input.return_qty').val(0).trigger('change');
            // $(this).find('input.return_qty').removeAttr('readonly');
        });
        $('#complete_return_submit').removeAttr('disabled');
        $('#componen_exchange').addClass('hide');
    }
}

// //Set the location and initialize printer
// function set_location(){
// 	if($('input#location_id').length == 1){
// 	       $('input#location_id').val($('select#select_location_id').val());
// 	       //$('input#location_id').data('receipt_printer_type', $('select#select_location_id').find(':selected').data('receipt_printer_ty
// 	}

// 	if($('input#location_id').val()){
// 	       $('input#search_product').prop( "disabled", false ).focus();
// 	} else {
// 	       $('input#search_product').prop( "disabled", true );
// 	}

// 	initialize_printer();
// }
