/*!
 * Signature Pad v1.3.4
 * https://github.com/szimek/signature_pad
 *
 * Copyright 2014 Szymon Nowak
 * Released under the MIT license
 *
 * The main idea and some parts of the code (e.g. drawing variable width Bézier curve) are taken from:
 * http://corner.squareup.com/2012/07/smoother-signatures.html
 *
 * Implementation of interpolation using cubic Bézier curves is taken from:
 * http://benknowscode.wordpress.com/2012/09/14/path-interpolation-using-cubic-bezier-and-control-point-estimation-in-javascript
 *
 * Algorithm for approximated length of a Bézier curve is taken from:
 * http://www.lemoda.net/maths/bezier-length/index.html
 *
 */ var SignaturePad=function(t){"use strict";var i=function(t,i){var o=i||{};this.velocityFilterWeight=o.velocityFilterWeight||.7,this.minWidth=o.minWidth||.5,this.maxWidth=o.maxWidth||2.5,this.dotSize=o.dotSize||function(){return(this.minWidth+this.maxWidth)/2},this.penColor=o.penColor||"black",this.backgroundColor=o.backgroundColor||"rgba(0,0,0,0)",this.onEnd=o.onEnd,this.onBegin=o.onBegin,this._canvas=t,this._ctx=t.getContext("2d"),this.clear(),this._handleMouseEvents(),this._handleTouchEvents()};i.prototype.clear=function(){var t=this._ctx,i=this._canvas;t.fillStyle=this.backgroundColor,t.clearRect(0,0,i.width,i.height),t.fillRect(0,0,i.width,i.height),this._reset()},i.prototype.toDataURL=function(t,i){var o=this._canvas;return o.toDataURL.apply(o,arguments)},i.prototype.fromDataURL=function(t){var i=this,o=new Image,n=window.devicePixelRatio||1,e=this._canvas.width/n,s=this._canvas.height/n;this._reset(),o.src=t,o.onload=function(){i._ctx.drawImage(o,0,0,e,s)},this._isEmpty=!1},i.prototype._strokeUpdate=function(t){var i=this._createPoint(t);this._addPoint(i)},i.prototype._strokeBegin=function(t){this._reset(),this._strokeUpdate(t),"function"==typeof this.onBegin&&this.onBegin(t)},i.prototype._strokeDraw=function(t){var i=this._ctx,o="function"==typeof this.dotSize?this.dotSize():this.dotSize;i.beginPath(),this._drawPoint(t.x,t.y,o),i.closePath(),i.fill()},i.prototype._strokeEnd=function(t){var i=this.points.length>2,o=this.points[0];!i&&o&&this._strokeDraw(o),"function"==typeof this.onEnd&&this.onEnd(t)},i.prototype._handleMouseEvents=function(){var i=this;this._mouseButtonDown=!1,this._canvas.addEventListener("mousedown",function(t){1===t.which&&(i._mouseButtonDown=!0,i._strokeBegin(t))}),this._canvas.addEventListener("mousemove",function(t){i._mouseButtonDown&&i._strokeUpdate(t)}),t.addEventListener("mouseup",function(t){1===t.which&&i._mouseButtonDown&&(i._mouseButtonDown=!1,i._strokeEnd(t))})},i.prototype._handleTouchEvents=function(){var i=this;this._canvas.style.msTouchAction="none",this._canvas.addEventListener("touchstart",function(t){var o=t.changedTouches[0];i._strokeBegin(o)}),this._canvas.addEventListener("touchmove",function(t){t.preventDefault();var o=t.changedTouches[0];i._strokeUpdate(o)}),t.addEventListener("touchend",function(t){t.target===i._canvas&&i._strokeEnd(t)})},i.prototype.isEmpty=function(){return this._isEmpty},i.prototype._reset=function(){this.points=[],this._lastVelocity=0,this._lastWidth=(this.minWidth+this.maxWidth)/2,this._isEmpty=!0,this._ctx.fillStyle=this.penColor},i.prototype._createPoint=function(t){var i=this._canvas.getBoundingClientRect();return new o(t.clientX-i.left,t.clientY-i.top)},i.prototype._addPoint=function(t){var i,o,e,s,r=this.points;r.push(t),r.length>2&&(3===r.length&&r.unshift(r[0]),i=(s=this._calculateCurveControlPoints(r[0],r[1],r[2])).c2,o=(s=this._calculateCurveControlPoints(r[1],r[2],r[3])).c1,e=new n(r[1],i,o,r[2]),this._addCurve(e),r.shift())},i.prototype._calculateCurveControlPoints=function(t,i,n){var e=t.x-i.x,s=t.y-i.y,r=i.x-n.x,h=i.y-n.y,a={x:(t.x+i.x)/2,y:(t.y+i.y)/2},c={x:(i.x+n.x)/2,y:(i.y+n.y)/2},u=Math.sqrt(r*r+h*h),d=a.x-c.x,l=a.y-c.y,p=u/(Math.sqrt(e*e+s*s)+u),y={x:c.x+d*p,y:c.y+l*p},v=i.x-y.x,f=i.y-y.y;return{c1:new o(a.x+v,a.y+f),c2:new o(c.x+v,c.y+f)}},i.prototype._addCurve=function(t){var i,o,n=t.startPoint;i=t.endPoint.velocityFrom(n),i=this.velocityFilterWeight*i+(1-this.velocityFilterWeight)*this._lastVelocity,o=this._strokeWidth(i),this._drawCurve(t,this._lastWidth,o),this._lastVelocity=i,this._lastWidth=o},i.prototype._drawPoint=function(t,i,o){var n=this._ctx;n.moveTo(t,i),n.arc(t,i,o,0,2*Math.PI,!1),this._isEmpty=!1},i.prototype._drawCurve=function(t,i,o){var n,e,s,r,h,a,c,u,d,l,p,y=this._ctx,v=o-i;for(n=Math.floor(t.length()),y.beginPath(),s=0;s<n;s++)a=(h=(r=s/n)*r)*r,l=(d=(u=(c=1-r)*c)*c)*t.startPoint.x,l+=3*u*r*t.control1.x,l+=3*c*h*t.control2.x,l+=a*t.endPoint.x,p=d*t.startPoint.y,p+=3*u*r*t.control1.y,p+=3*c*h*t.control2.y,p+=a*t.endPoint.y,e=i+a*v,this._drawPoint(l,p,e);y.closePath(),y.fill()},i.prototype._strokeWidth=function(t){return Math.max(this.maxWidth/(t+1),this.minWidth)};var o=function(t,i,o){this.x=t,this.y=i,this.time=o||new Date().getTime()};o.prototype.velocityFrom=function(t){return this.time!==t.time?this.distanceTo(t)/(this.time-t.time):1},o.prototype.distanceTo=function(t){return Math.sqrt(Math.pow(this.x-t.x,2)+Math.pow(this.y-t.y,2))};var n=function(t,i,o,n){this.startPoint=t,this.control1=i,this.control2=o,this.endPoint=n};return n.prototype.length=function(){var t,i,o,n,e,s,r,h,a=0;for(t=0;t<=10;t++)i=t/10,o=this._point(i,this.startPoint.x,this.control1.x,this.control2.x,this.endPoint.x),n=this._point(i,this.startPoint.y,this.control1.y,this.control2.y,this.endPoint.y),t>0&&(a+=Math.sqrt((r=o-e)*r+(h=n-s)*h)),e=o,s=n;return a},n.prototype._point=function(t,i,o,n,e){return i*(1-t)*(1-t)*(1-t)+3*o*(1-t)*(1-t)*t+3*n*(1-t)*t*t+e*t*t*t},i}(document);