@extends('layouts.app')
@section('title', __('business.login_management'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('business.login_management')</h1>
    {{-- <br> --}}
    {{-- @include('layouts.partials.search_settings') --}}
</section>

<!-- Main content -->
<section class="content">
{!! Form::open(['url' => action([\App\Http\Controllers\BusinessController::class, 'postBusinessLoginManagement']), 'method' => 'post', 'id' => 'bussiness_login_management_form',
               'files' => true ]) !!}
    <div class="row">
        <div class="col-xs-12">
    <!--  <pos-tab-container> -->
        <div class="col-xs-12 pos-tab-container">
            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2 pos-tab-menu">
                <div class="list-group">
                    <a href="#" class="list-group-item text-center active">@lang('business.authorization')</a>                
                    <a href="#" class="list-group-item text-center">@lang('business.session_management')</a>                    
                    <a href="#" class="list-group-item text-center">@lang('business.login_restrictions')</a>                    
                </div>
            </div>
            <div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 pos-tab">
                <!-- tab 1 start -->
                @include('business.partials.settings_authorization')
                <!-- tab 1 end -->
                <!-- tab 2 start -->
                @include('business.partials.session_management')
                <!-- tab 2 end -->                
                <!-- tab 3 start -->
                @include('business.partials.login_restrictions')
                <!-- tab 3 end -->                
            </div>
        </div>
        <!--  </pos-tab-container> -->
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <button class="btn btn-danger pull-right" type="submit">@lang('business.update_settings')</button>
        </div>
    </div>
{!! Form::close() !!}
</section>
<!-- /.content -->

@stop
@section('javascript')
<script type="text/javascript">
    __page_leave_confirmation('#bussiness_login_management_form');

    $(document).ready(function() {
        $('.working_hours').datetimepicker({
            // format: moment_date_format + ' ' + moment_time_format,                        
            format: moment_time_format,                        
            ignoreReadonly: true,
        });

        /* $('#enable_working_hours').on('click', function() {
            if($(this).prop('checked') == true) {
                $('#working_hour_section').removeClass('hide');
            } else {
                $('#working_hour_section').addClass('hide');
            }
        }) */
        showView($('input[name="enable_working_hours"]:checked').val(), 'working_hours');
    });

    function showView(val, type) {        
        if(type == 'working_hours') {
            if(val == 1) {
                $('#working_hour_section').removeClass('hide');
            } else {
                $('#working_hour_section').addClass('hide');
            }
        }
    }
</script>
@endsection