@extends('layouts.app')
@section('title', __('lang_v1.omni_channel_services'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('lang_v1.omni_channel_services')</h1>
    <br>
    {{-- @include('layouts.partials.search_settings') --}}
</section>

<!-- Main content -->
<section class="content">
{!! Form::open(['url' => action([\App\Http\Controllers\OmniChannelServicesController::class, 'postMarketplaceOmni']), 'method' => 'post', 'id' => 'omni_edit_form',
    'files' => true ]) !!}  
    <div class="row">
        <div class="col-xs-12">
       <!--  <pos-tab-container> -->
        <div class="col-xs-12 pos-tab-container">
            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2 pos-tab-menu">
                <div class="list-group">
                    <a href="#" class="list-group-item text-center" onclick="table_hide('etsy')">@lang('lang_v1.etsy')</a>
                    <a href="#" class="list-group-item text-center active" onclick="table_hide('walmart')">@lang('lang_v1.walmart')</a>
                    <a href="#" class="list-group-item text-center" onclick="table_hide('amazon')">@lang('lang_v1.amazon')</a>
                    {{-- <a href="#" class="list-group-item text-center">@lang('lang_v1.ebay')</a> --}}
                </div>
            </div>
            <div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 pos-tab">
                <!-- tab 1 start -->
                @include('business.partials.settings_etsy')
                <!-- tab 1 end -->
                <!-- tab 2 start -->
                @include('business.partials.settings_walmart')
                <!-- tab 2 end -->
                <!-- tab 3 start -->
                @include('business.partials.settings_amazon')
                <!-- tab 3 end -->
                <!-- tab 4 start -->
                {{-- @include('business.partials.settings_ebay') --}}
                <!-- tab 4 end -->
            </div>
        </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <button class="btn btn-danger pull-right" type="submit">@lang('business.update_settings')</button>
            <button type="button" class="btn btn-primary btn-flat pull-right btn-sync hide" id="etsy_test_btn" onclick="sync_etsy()">@lang('lang_v1.sync_etsy_data')</button>
            <button type="button" class="btn btn-primary btn-flat pull-right btn-sync hide" id="walmart_test_btn">@lang('lang_v1.sync_walmart_data')</button>
            <button type="button" class="btn btn-primary btn-flat pull-right btn-sync hide" onclick="sync_amazon()" id="amazon_test_btn">@lang('lang_v1.sync_amazon_data')</button>
        </div>
    </div>   
    <div class="row" style="margin-top: 20px;">



    <div class="col-sm-12 table_hide etsy_table">
            <table class="table table-bordered table-striped hide-footer" id="etsy_table" style="width: 100%;">
                <thead>
                    <tr>                    
                        <th><input type="checkbox" id="select-all-row" data-table-id="etsy_table"></th>
                        <th>&nbsp;</th>                    
                        <th>@lang('messages.action')</th>
                        <th>@lang('sale.product')</th>
                        <th>@lang('business.business_location') @show_tooltip(__('lang_v1.product_business_location_tooltip'))</th>
                        @can('access_default_selling_price')                      
                            <th>@lang('lang_v1.selling_price')</th>
                        @endcan
                        <th>@lang('report.total_stock')</th>
                        <th>@lang('product.category')</th>
                        <th>@lang('product.brand')</th>
                        <th>@lang('product.sku')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <td colspan="10">
                            <div style="display: flex; width: 100%;">
                                @can('product.delete')
                                    <form></form>
                                    {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDestroy']), 'method' => 'post', 'id' => 'mass_delete_form_walmart' ]); !!}
                                    {!! Form::hidden('selected_rows', null, ['id' => 'selected_rows_walmart']); !!}
                                    {!! Form::submit(__('lang_v1.delete_selected'), array('class' => 'btn btn-xs btn-danger', 'id' => 'delete-selected-walmart')); !!}
                                    {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))
                                @endcan
                
                                
                                    @can('product.update')
                                    
                                        @if(config('constants.enable_product_bulk_edit'))
                                            &nbsp;
                                            {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'bulkEdit']), 'method' => 'post', 'id' => 'bulk_edit_form' ]) !!}
                                            {!! Form::hidden('selected_products', null, ['id' => 'selected_products_for_edit']); !!}
                                            <button type="submit" class="btn btn-xs btn-primary" id="edit-selected"> <i class="fa fa-edit"></i>{{__('lang_v1.bulk_edit')}}</button>
                                            {!! Form::close() !!}
                                        @endif
                                        &nbsp;
                                        <button type="button" class="btn btn-xs btn-success update_product_location" data-type="add">@lang('lang_v1.add_to_location')</button>
                                        &nbsp;
                                        <button type="button" class="btn btn-xs bg-navy update_product_location" data-type="remove">@lang('lang_v1.remove_from_location')</button>
                                    @endcan
                                
                                &nbsp;
                                {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDeactivate']), 'method' => 'post', 'id' => 'mass_deactivate_form' ]); !!}
                                {!! Form::hidden('selected_products', null, ['id' => 'selected_products']); !!}
                                {!! Form::submit(__('lang_v1.deactivate_selected'), array('class' => 'btn btn-xs btn-warning', 'id' => 'deactivate-selected')); !!}
                                {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))                            
                            </div>
                        </td>
                    </tr>
                </tfoot>
            </table>            
        </div> 
        
    



        <div class="col-sm-12 table_hide walmart_table">
            <table class="table table-bordered table-striped hide-footer" id="walmart_table" style="width: 100%;">
                <thead>
                    <tr>                    
                        <th><input type="checkbox" id="select-all-row" data-table-id="walmart_table"></th>
                        <th>&nbsp;</th>                    
                        <th>@lang('messages.action')</th>
                        <th>@lang('sale.product')</th>
                        <th>@lang('business.business_location') @show_tooltip(__('lang_v1.product_business_location_tooltip'))</th>
                        @can('access_default_selling_price')                      
                            <th>@lang('lang_v1.selling_price')</th>
                        @endcan
                        <th>@lang('report.total_stock')</th>
                        <th>@lang('product.category')</th>
                        <th>@lang('product.brand')</th>
                        <th>@lang('product.sku')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <td colspan="10">
                            <div style="display: flex; width: 100%;">
                                @can('product.delete')
                                    <form></form>
                                    {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDestroy']), 'method' => 'post', 'id' => 'mass_delete_form_walmart' ]); !!}
                                    {!! Form::hidden('selected_rows', null, ['id' => 'selected_rows_walmart']); !!}
                                    {!! Form::submit(__('lang_v1.delete_selected'), array('class' => 'btn btn-xs btn-danger', 'id' => 'delete-selected-walmart')); !!}
                                    {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))
                                @endcan
                
                                
                                    @can('product.update')
                                    
                                        @if(config('constants.enable_product_bulk_edit'))
                                            &nbsp;
                                            {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'bulkEdit']), 'method' => 'post', 'id' => 'bulk_edit_form' ]) !!}
                                            {!! Form::hidden('selected_products', null, ['id' => 'selected_products_for_edit']); !!}
                                            <button type="submit" class="btn btn-xs btn-primary" id="edit-selected"> <i class="fa fa-edit"></i>{{__('lang_v1.bulk_edit')}}</button>
                                            {!! Form::close() !!}
                                        @endif
                                        &nbsp;
                                        <button type="button" class="btn btn-xs btn-success update_product_location" data-type="add">@lang('lang_v1.add_to_location')</button>
                                        &nbsp;
                                        <button type="button" class="btn btn-xs bg-navy update_product_location" data-type="remove">@lang('lang_v1.remove_from_location')</button>
                                    @endcan
                                
                                &nbsp;
                                {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDeactivate']), 'method' => 'post', 'id' => 'mass_deactivate_form' ]); !!}
                                {!! Form::hidden('selected_products', null, ['id' => 'selected_products']); !!}
                                {!! Form::submit(__('lang_v1.deactivate_selected'), array('class' => 'btn btn-xs btn-warning', 'id' => 'deactivate-selected')); !!}
                                {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))                            
                            </div>
                        </td>
                    </tr>
                </tfoot>
            </table>            
        </div> 
        <div class="col-sm-12 table_hide amazon_table">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#tab1" data-toggle="tab" aria-expanded="true"><i class="fa fa-cubes" aria-hidden="true"></i> USED BOOK DEPOT</a>
                    </li>                    
                    <li>
                        <a href="#tab2" data-toggle="tab" aria-expanded="true"><i class="fa fas fa-arrow-circle-up" aria-hidden="true"></i> The Art of Savings</a>
                    </li>               
                    <li>
                        <a href="#tab3" data-toggle="tab" aria-expanded="true"><i class="fa fa-envelope-open" aria-hidden="true"></i> Pharos Bookstore</a>
                    </li>                                                 
                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="tab1">         
                        {{-- <div class="col-md-12">
                            @component('components.filters', ['title' => __('report.filters')])
                                <div class="col-md-3">
                                    <div class="form-group">
                                        {!! Form::label('type', __('lang_v1.transaction_type') . ':') !!}
                                        {!! Form::select('type', $transaction_type, null, ['class' => 'filtervh', 'style' => 'width:100%', 'id' => 'transaction_type_qb', 'placeholder' => __('lang_v1.all')]); !!}
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        {!! Form::label('date_qb', __('lang_v1.date') . ':') !!}
                                        {!! Form::text('date_qb', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly', 'id' => 'date_qb']); !!}
                                    </div>
                                </div>
                        
                                <div class="col-md-3">
                                    <div class="form-group">
                                        {!! Form::label('payee_qb', __('lang_v1.payee') . ':') !!}
                                        {!! Form::select('payee_qb', $payee, null, ['class' => 'filtervh', 'style' => 'width:100%', 'id' => 'payee_qb', 'placeholder' => __('lang_v1.all')]); !!}
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        {!! Form::label('category_qb', __('lang_v1.category') . ':') !!}
                                        {!! Form::select('category_qb', $category, null, ['class' => 'filtervh', 'style' => 'width:100%', 'id' => 'category_qb', 'placeholder' => __('lang_v1.all')]); !!}
                                    </div>
                                </div>                                         
                            @endcomponent
                        </div> --}}
                        <table class="table table-bordered table-striped hide-footer" id="amazon_table_1" style="width: 100%;">
                            <thead>
                                <tr>                    
                                    {{-- <th><input type="checkbox" id="select-all-row" data-table-id="amazon_table_1"></th> --}}
                                    {{-- <th>&nbsp;</th>                     --}}
                                    <th>@lang('messages.action')</th>
                                    <th>@lang('lang_v1.image')</th>
                                    <!-- <th>@lang('lang_v1.amazon_store')</th> -->
                                    <th>@lang('product.asin')</th>
                                    <th>@lang('sale.product')</th>
                                    <th>@lang('product.brand')</th>
                                    <th>@lang('lang_v1.category')</th>
                                    <th>@lang('lang_v1.manufacturer')</th>
                                    <th>@lang('lang_v1.product_group')</th>
                                    <th>@lang('product.type')</th>
                                    <th>@lang('lang_v1.material')</th>
                                    <th>@lang('product.price')</th>                                
                                </tr>
                            </thead>
                            {{-- <tfoot>
                                <tr>
                                    <td colspan="10">
                                        <div style="display: flex; width: 100%;">
                                            @can('product.delete')
                                                <form></form>
                                                {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDestroy']), 'method' => 'post', 'id' => 'mass_delete_form_bigcommerce' ]); !!}
                                                {!! Form::hidden('selected_rows', null, ['id' => 'selected_rows_bigcommerce']); !!}
                                                {!! Form::submit(__('lang_v1.delete_selected'), array('class' => 'btn btn-xs btn-danger', 'id' => 'delete-selected-bigcommerce')); !!}
                                                {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))
                                            @endcan
                            
                                            
                                                @can('product.update')
                                                
                                                    @if(config('constants.enable_product_bulk_edit'))
                                                        &nbsp;
                                                        {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'bulkEdit']), 'method' => 'post', 'id' => 'bulk_edit_form' ]) !!}
                                                        {!! Form::hidden('selected_products', null, ['id' => 'selected_products_for_edit']); !!}
                                                        <button type="submit" class="btn btn-xs btn-primary" id="edit-selected"> <i class="fa fa-edit"></i>{{__('lang_v1.bulk_edit')}}</button>
                                                        {!! Form::close() !!}
                                                    @endif
                                                    &nbsp;
                                                    <button type="button" class="btn btn-xs btn-success update_product_location" data-type="add">@lang('lang_v1.add_to_location')</button>
                                                    &nbsp;
                                                    <button type="button" class="btn btn-xs bg-navy update_product_location" data-type="remove">@lang('lang_v1.remove_from_location')</button>
                                                @endcan
                                            
                                            &nbsp;
                                            {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDeactivate']), 'method' => 'post', 'id' => 'mass_deactivate_form' ]); !!}
                                            {!! Form::hidden('selected_products', null, ['id' => 'selected_products']); !!}
                                            {!! Form::submit(__('lang_v1.deactivate_selected'), array('class' => 'btn btn-xs btn-warning', 'id' => 'deactivate-selected')); !!}
                                            {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))                            
                                        </div>
                                    </td>
                                </tr>
                            </tfoot> --}}
                        </table>
                    </div>                    
                    <div class="tab-pane" id="tab2">     
                        <table class="table table-bordered table-striped hide-footer" id="amazon_table_2" style="width: 100%;">
                            <thead>
                                <tr>                    
                                    {{-- <th><input type="checkbox" id="select-all-row" data-table-id="amazon_table_2"></th> --}}
                                    {{-- <th>&nbsp;</th>                     --}}
                                    <th>@lang('messages.action')</th>
                                    <th>@lang('sale.product')</th>
                                    {{-- <th>@lang('business.business_location') @show_tooltip(__('lang_v1.product_business_location_tooltip'))</th> --}}
                                    <th>@lang('lang_v1.selling_price')</th>                                    
                                    <th>@lang('report.total_stock')</th>
                                    <th>@lang('product.sku')</th>
                                    <th>@lang('product.asin')</th>                                    
                                </tr>
                            </thead>
                            {{-- <tfoot>
                                <tr>
                                    <td colspan="10">
                                        <div style="display: flex; width: 100%;">
                                            @can('product.delete')
                                                <form></form>
                                                {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDestroy']), 'method' => 'post', 'id' => 'mass_delete_form_bigcommerce' ]); !!}
                                                {!! Form::hidden('selected_rows', null, ['id' => 'selected_rows_bigcommerce']); !!}
                                                {!! Form::submit(__('lang_v1.delete_selected'), array('class' => 'btn btn-xs btn-danger', 'id' => 'delete-selected-bigcommerce')); !!}
                                                {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))
                                            @endcan
                            
                                            
                                                @can('product.update')
                                                
                                                    @if(config('constants.enable_product_bulk_edit'))
                                                        &nbsp;
                                                        {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'bulkEdit']), 'method' => 'post', 'id' => 'bulk_edit_form' ]) !!}
                                                        {!! Form::hidden('selected_products', null, ['id' => 'selected_products_for_edit']); !!}
                                                        <button type="submit" class="btn btn-xs btn-primary" id="edit-selected"> <i class="fa fa-edit"></i>{{__('lang_v1.bulk_edit')}}</button>
                                                        {!! Form::close() !!}
                                                    @endif
                                                    &nbsp;
                                                    <button type="button" class="btn btn-xs btn-success update_product_location" data-type="add">@lang('lang_v1.add_to_location')</button>
                                                    &nbsp;
                                                    <button type="button" class="btn btn-xs bg-navy update_product_location" data-type="remove">@lang('lang_v1.remove_from_location')</button>
                                                @endcan
                                            
                                            &nbsp;
                                            {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDeactivate']), 'method' => 'post', 'id' => 'mass_deactivate_form' ]); !!}
                                            {!! Form::hidden('selected_products', null, ['id' => 'selected_products']); !!}
                                            {!! Form::submit(__('lang_v1.deactivate_selected'), array('class' => 'btn btn-xs btn-warning', 'id' => 'deactivate-selected')); !!}
                                            {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))                            
                                        </div>
                                    </td>
                                </tr>
                            </tfoot> --}}
                        </table>                                        
                    </div>
                    <div class="tab-pane" id="tab3">                                              
                        <table class="table table-bordered table-striped hide-footer" id="amazon_table_3" style="width: 100%;">
                            <thead>
                                <tr>                    
                                    {{-- <th><input type="checkbox" id="select-all-row" data-table-id="amazon_table_3"></th> --}}
                                    {{-- <th>&nbsp;</th>                     --}}
                                    <th>@lang('messages.action')</th>
                                    <th>@lang('sale.product')</th>
                                    {{-- <th>@lang('business.business_location') @show_tooltip(__('lang_v1.product_business_location_tooltip'))</th> --}}
                                    <th>@lang('lang_v1.selling_price')</th>                                    
                                    <th>@lang('report.total_stock')</th>
                                    <th>@lang('product.sku')</th>
                                    <th>@lang('product.asin')</th>                                    
                                </tr>
                            </thead>
                            {{-- <tfoot>
                                <tr>
                                    <td colspan="10">
                                        <div style="display: flex; width: 100%;">
                                            @can('product.delete')
                                                <form></form>
                                                {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDestroy']), 'method' => 'post', 'id' => 'mass_delete_form_bigcommerce' ]); !!}
                                                {!! Form::hidden('selected_rows', null, ['id' => 'selected_rows_bigcommerce']); !!}
                                                {!! Form::submit(__('lang_v1.delete_selected'), array('class' => 'btn btn-xs btn-danger', 'id' => 'delete-selected-bigcommerce')); !!}
                                                {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))
                                            @endcan
                            
                                            
                                                @can('product.update')
                                                
                                                    @if(config('constants.enable_product_bulk_edit'))
                                                        &nbsp;
                                                        {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'bulkEdit']), 'method' => 'post', 'id' => 'bulk_edit_form' ]) !!}
                                                        {!! Form::hidden('selected_products', null, ['id' => 'selected_products_for_edit']); !!}
                                                        <button type="submit" class="btn btn-xs btn-primary" id="edit-selected"> <i class="fa fa-edit"></i>{{__('lang_v1.bulk_edit')}}</button>
                                                        {!! Form::close() !!}
                                                    @endif
                                                    &nbsp;
                                                    <button type="button" class="btn btn-xs btn-success update_product_location" data-type="add">@lang('lang_v1.add_to_location')</button>
                                                    &nbsp;
                                                    <button type="button" class="btn btn-xs bg-navy update_product_location" data-type="remove">@lang('lang_v1.remove_from_location')</button>
                                                @endcan
                                            
                                            &nbsp;
                                            {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDeactivate']), 'method' => 'post', 'id' => 'mass_deactivate_form' ]); !!}
                                            {!! Form::hidden('selected_products', null, ['id' => 'selected_products']); !!}
                                            {!! Form::submit(__('lang_v1.deactivate_selected'), array('class' => 'btn btn-xs btn-warning', 'id' => 'deactivate-selected')); !!}
                                            {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))                            
                                        </div>
                                    </td>
                                </tr>
                            </tfoot> --}}
                        </table>                                          
                    </div>                    
                </div>
            </div>           
        </div> 
    </div>
{!! Form::close() !!}
</section>
<!-- /.content -->
@stop
@section('javascript')
<script type="text/javascript">
    var etsy_table,
        walmart_table,
        amazon_table1, 
        amazon_table2, 
        amazon_table3; 
    $(document).ready(function() {
        console.log('settings market place document ready');
        /* var bigenable = $("input[type='radio'][name='etsy_enable']:checked").val()        
        var amazonenable = $("input[type='radio'][name='amazon_enable']:checked").val()        
        var walmartenable = $("input[type='radio'][name='walmart_enable']:checked").val()        
        var ebayenable = $("input[type='radio'][name='ebay_enable']:checked").val()       

        if(bigenable == '1') {
            // bigcommerce
            $('#etsy_api_url').css('display', 'block')
            $('#etsy_api_access_token').css('display', 'block')
            $('#etsy_api_key').css('display', 'block')
            $('#etsy_api_secret').css('display', 'block')
            $('#etsy_space').addClass('col-sm-3')
        } else {
            // big commerce
            $('#etsy_api_url').css('display', 'none')
            $('#etsy_api_access_token').css('display', 'none')
            $('#etsy_api_key').css('display', 'none')
            $('#etsy_api_secret').css('display', 'none')
            $('#etsy_space').removeClass('col-sm-3')
        }

        if(amazonenable == '1') {
            // amazon
            $('#amazon_api_url').css('display', 'block')
            $('#amazon_api_access_token').css('display', 'block')
            $('#amazon_api_key').css('display', 'block')
            $('#amazon_api_secret').css('display', 'block')
            $('#amazon_space').addClass('col-sm-3')
        } else {
            // amazon
            $('#amazon_api_url').css('display', 'none')
            $('#amazon_api_access_token').css('display', 'none')
            $('#amazon_api_key').css('display', 'none')
            $('#amazon_api_secret').css('display', 'none')
            $('#amazon_space').removeClass('col-sm-3')
        }

        if(walmartenable == '1') {
            // woo commerce
            $('#walmart_api_url').css('display', 'block')
            $('#walmart_api_access_token').css('display', 'block')
            $('#walmart_api_key').css('display', 'block')
            $('#walmart_api_secret').css('display', 'block')
            $('#walmart_space').addClass('col-sm-3')
        } else {
            // woo commerce
            $('#walmart_api_url').css('display', 'none')
            $('#walmart_api_access_token').css('display', 'none')
            $('#walmart_api_key').css('display', 'none')
            $('#walmart_api_secret').css('display', 'none')
            $('#walmart_space').removeClass('col-sm-3')
        }
           
        if(ebayenable == '1') {
            // ebay
            $('#ebay_api_url').css('display', 'block')
            $('#ebay_api_access_token').css('display', 'block')
            $('#ebay_api_key').css('display', 'block')
            $('#ebay_api_secret').css('display', 'block')
            $('#ebay_space').addClass('col-sm-3')
        } else {                                    
            // ebay
            $('#ebay_api_url').css('display', 'none')
            $('#ebay_api_access_token').css('display', 'none')
            $('#ebay_api_key').css('display', 'none')
            $('#ebay_api_secret').css('display', 'none')
            $('#ebay_space').addClass('col-sm-3')
        } */

        etsy_table = $('#etsy_table').DataTable({
            processing: true,
            serverSide: true,
            aaSorting: [[1, 'asc']],
            // scrollY: "75vh",
            // scrollX: true,
            // scrollCollapse: true                    
            "ajax": {
                "url": "/products?vhomni_type=walmart",
            },                          
            columnDefs: [ {
                "targets": [0, 1, 2],
                "orderable": false,
                "searchable": false
            }],
            columns: [                
                { data: 'mass_delete', orderable: false, searchable: false},
                { data: 'image_vhomni', name: 'products.image_vhomni', orderable: false, searchable: false},   
                { data: 'action', name: 'action', orderable: false, searchable: false},             
                { data: 'product', name: 'products.name'  },
                { data: 'product_locations', name: 'product_locations'},
                { data: 'selling_price', name: 'max_price', searchable: false},
                { data: 'current_stock', searchable: false},
                { data: 'category', name: 'c1.name'},
                { data: 'brand', name: 'brands.name'},                    
                { data: 'sku', name: 'products.sku'},                    
            ],
        })

        walmart_table = $('#walmart_table').DataTable({
            processing: true,
            serverSide: true,
            aaSorting: [[1, 'asc']],
            // scrollY: "75vh",
            // scrollX: true,
            // scrollCollapse: true                    
            "ajax": {
                "url": "/products?vhomni_type=walmart",
            },                          
            columnDefs: [ {
                "targets": [0, 1, 2],
                "orderable": false,
                "searchable": false
            }],
            columns: [                
                { data: 'mass_delete', orderable: false, searchable: false},
                { data: 'image_vhomni', name: 'products.image_vhomni', orderable: false, searchable: false},   
                { data: 'action', name: 'action', orderable: false, searchable: false},             
                { data: 'product', name: 'products.name'  },
                { data: 'product_locations', name: 'product_locations'},
                { data: 'selling_price', name: 'max_price', searchable: false},
                { data: 'current_stock', searchable: false},
                { data: 'category', name: 'c1.name'},
                { data: 'brand', name: 'brands.name'},                    
                { data: 'sku', name: 'products.sku'},                    
            ],
        });

        // PALIGU
        amazon_table1 = $('#amazon_table_1').DataTable({
            processing: true,
            serverSide: false,
            ajax: {
                url: "/keepa/product/A2NODI4BBRA1B1",
                dataSrc: function(json) {
                    console.log('Keepa products in Our DB:', json);
                    return json || [];
                }
            },
            columns: [                
                { 
                    data: null,
                    orderable: false,
                    searchable: false,
                    render: function(data) {
                        return '<button class="btn btn-xs btn-danger delete-asin" data-asin="' + (data.asin || '') + '"><i class="fa fa-trash"></i> Delete</button>';
                    }
                },
                { 
                    data: 'image',
                    name: 'image',
                    render: function(data, type, row) {
                        //console.log('Image data:', data);
                        //return data || 'N/A';
                        return '<div style="display: flex;"><img src="https://m.media-amazon.com/images/I/'+data+'" alt="Product image" class="product-thumbnail-small"></div>';
                    }
                },
                { 
                    data: 'asin',
                    name: 'asin',
                    render: function(data, type, row) {
                        //console.log('ASIN data:', data);
                        return data || 'N/A';
                    }
                },
                { 
                    data: 'title',
                    name: 'title',
                    render: function(data, type, row) {
                        //console.log('Title data:', data);
                        return data || 'N/A';
                    }
                },
                { 
                    data: 'brand',
                    name: 'brand',
                    render: function(data, type, row) {
                        //console.log('brand data:', data);
                        return data || 'N/A';
                    }
                },
                { 
                    data: 'category',
                    name: 'category',
                    render: function(data, type, row) {
                        //console.log('category data:', data);
                        return data || 'N/A';
                    }
                },
                { 
                    data: 'manufacturer',
                    name: 'manufacturer',
                    render: function(data, type, row) {
                        //console.log('manufacturer data:', data);
                        return data || 'N/A';
                    }
                },
                { 
                    data: 'productGroup',
                    name: 'productGroup',
                    render: function(data, type, row) {
                        //console.log('productGroup data:', data);
                        return data || 'N/A';
                    }
                },
                { 
                    data: 'type',
                    name: 'type',
                    render: function(data, type, row) {
                        //console.log('type data:', data);
                        return data || 'N/A';
                    }
                },
                { 
                    data: 'binding',
                    name: 'binding',
                    render: function(data, type, row) {
                        //console.log('binding data:', data);
                        return data || 'N/A';
                    }
                },
                { 
                    data: 'current_price',
                    name: 'current_price',
                    render: function(data, type, row) {
                        //console.log('Price data:', data);
                        return data || 'N/A';
                    }
                },
            ],
            order: [[1, 'asc']]
        });
        
        // ADRI
        // amazon_table1 = $('#amazon_table_1').DataTable({
        //     processing: true,
        //     processing: true,
        //     aaSorting: [[1, 'asc']],
        //     // scrollY: "75vh",
        //     // scrollX: true,
        //     // scrollCollapse: true                    
        //     "ajax": {
        //         "url": "/products?vhomni_type=amazon&seller_id=A2NODI4BBRA1B1",
        //     },                           
        //     /* columnDefs: [ {
        //         "targets": [0, 1, 2],
        //         "orderable": false,
        //         "searchable": false
        //     }], */
        //     columns: [                
        //         // { data: 'mass_delete', orderable: false, searchable: false},
        //         // { data: 'image_vhomni', name: 'products.image_vhomni', orderable: false, searchable: false},   
        //         { data: 'action', name: 'action', orderable: false, searchable: false},             
        //         { data: 'product', name: 'products.name', "width": '300px'},
        //         // { data: 'product_locations', name: 'product_locations'},                
        //         { data: 'selling_price', name: 'max_price', searchable: false},                
        //         { data: 'current_stock', searchable: false},
        //         { data: 'sku', name: 'products.sku'},                    
        //         { data: 'amazon_asin', name: 'products.amazon_asin'},                
        //     ],
        // })
        amazon_table2 = $('#amazon_table_2').DataTable({
            processing: true,
            serverSide: true,
            aaSorting: [[1, 'asc']],
            // scrollY: "75vh",
            // scrollX: true,
            // scrollCollapse: true                    
            "ajax": {
                "url": "/products?vhomni_type=amazon&seller_id=A7YLKH07FY1LY",
            },                           
            /* columnDefs: [ {
                "targets": [0, 1, 2],
                "orderable": false,
                "searchable": false
            }], */
            columns: [                
                // { data: 'mass_delete', orderable: false, searchable: false},
                // { data: 'image_vhomni', name: 'products.image_vhomni', orderable: false, searchable: false},   
                { data: 'action', name: 'action', orderable: false, searchable: false},             
                { data: 'product', name: 'products.name', "width": '300px' },
                // { data: 'product_locations', name: 'product_locations'},                
                { data: 'selling_price', name: 'max_price', searchable: false},                
                { data: 'current_stock', searchable: false},
                { data: 'sku', name: 'products.sku'},                    
                { data: 'amazon_asin', name: 'products.amazon_asin'},                
            ],
        });
        amazon_table3 = $('#amazon_table_3').DataTable({
            processing: true,
            serverSide: true,
            aaSorting: [[1, 'asc']],
            // scrollY: "75vh",
            // scrollX: true,
            // scrollCollapse: true                    
            "ajax": {
                "url": "/products?vhomni_type=amazon&seller_id=A13Y3JSUKFVTQ5",
            },                           
            /* columnDefs: [ {
                "targets": [0, 1, 2],
                "orderable": false,
                "searchable": false
            }] ,*/
            columns: [                
                // { data: 'mass_delete', orderable: false, searchable: false},
                // { data: 'image_vhomni', name: 'products.image_vhomni', orderable: false, searchable: false},   
                { data: 'action', name: 'action', orderable: false, searchable: false},             
                { data: 'product', name: 'products.name', "width": '300px' },
                // { data: 'product_locations', name: 'product_locations'},                
                { data: 'selling_price', name: 'max_price', searchable: false},                
                { data: 'current_stock', searchable: false},
                { data: 'sku', name: 'products.sku'},                    
                { data: 'amazon_asin', name: 'products.amazon_asin'},                
            ],
        });

        $('table#walmart_table tbody').on('click', 'a.delete-product', function(e){
            e.preventDefault();
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    var href = $(this).attr('href');
                    $.ajax({
                        method: "DELETE",
                        url: href,
                        dataType: "json",
                        beforeSend: function() {
                            $('#pos-loader').css('display', 'inline-flex')
                        },
                        success: function(result){
                            $('#pos-loader').css('display', 'none')
                            if(result.success == true){
                                toastr.success(result.msg);
                                shopify_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });

        $(document).on('click', '#delete-selected-walmart', function(e){
            e.preventDefault();
            var selected_rows = getSelectedRows();
            
            if(selected_rows.length > 0){
                $('input#selected_rows_walmart').val(selected_rows);
                swal({
                    title: LANG.sure,
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        $('#pos-loader').css('display', 'inline-flex');
                        $('form#mass_delete_form_walmart').submit();
                    }
                });
            } else{
                $('input#selected_rows_walmart').val('');
                swal('@lang("lang_v1.no_row_selected")');
            }    
        });

        $('#walmart_test_btn').click(function () {
            //PALIGU
            // console.log('shopify test');
            $.ajax({
                method: 'GET',
                url: '/check-location-have-products',
                dataType: 'json',
                data: {
                    location_id: $('#product_locations_walmart').val(),
                    type: 'walmart'
                },
                beforeSend: function() {
                    $('#pos-loader').css('display', 'inline-flex')
                },
                success: function(result) {
                    $('#pos-loader').css('display', 'none')
                    if(result.rc == 1) {
                        swal({
                            title: 'Information',
                            text: "If you change WALMART product location from "+result.location+" to "+$('#product_locations_walmart').find('option:selected').text()+", all product in "+result.location+" will be moved to "+$('#product_locations_walmart').find('option:selected').text()+"?",
                            icon: 'info',
                            buttons: {
                                cancel: "No",
                                confirm: "Yes"
                            }, 
                        }).then((confirmed) => {
                            if(confirmed) {
                                sync_walmart();
                            }
                        })
                    } else if(result.rc == 2) {
                        swal({
                            title: 'Information',
                            text: result.rm,
                            icon: 'info',
                            // button: false,
                        })
                    } else {                    
                        sync_walmart();
                    }
                }
            }).fail(function(xhr, status, q) {
                Pace.stop();
                $('#pos-loader').css('display', 'none')
                // consoole.log(xhr.responseText)
                swal({
                    title: 'Information',
                    text: xhr.responseText,
                    icon: 'info',
                    // button: false,
                })
            });
        });

        // setTimeout(() => {
            $('span.select2-container').css('width', '100%');
        // }, 200);

        table_hide('walmart')
    })

    function sync_walmart() {
        swal({
            title: 'Information',
            text: 'This Process May Take littler longer than regular sync process, Please do not CLOSE or REFRESH your browser during this process.',
            icon: 'info',
            buttons: {
                cancel: "CANCEL",
                confirm: "START SYNC"
            },                      
        }).then((confirmed) => {
            if (confirmed) {   
                $.ajax({
                    method: 'GET',
                    url: '/walmart-auth',
                    dataType: 'json',
                    data: {
                        product_locations: $('#product_locations_walmart').val(),
                        checkmarks: $("input[name='checkmarks_walmart[]']:checked").serializeArray()
                    },
                    beforeSend: function() {
                        $('#pos-loader').css('display', 'inline-flex')
                        // swal('Information', 'This process may take litle bit long time, please do not close or refresh the browser', 'info')
                    },
                    success: function (result) {
                        Pace.stop();
                        $('#pos-loader').css('display', 'none')
                        // console.log(result)
                        var message = '<p>'+result.message;
                        var icon = 'info'
                        var title = 'Information'
                        if(result.data) {
                            var inserted = 0;
                            var updated = 0;
                            $.each(result.data, function(k, v) {
                                $.each(v, function(k1, v1) {
                                    // console.log(v1)
                                    if(v1.status == 2) {
                                        updated++;
                                    } else {
                                        inserted++;
                                    }                        
                                })
                            })
    
                            message+= '<br>' + inserted + ' Products Imported and Created <br>' + updated + ' Products Updated and Synced</p>';
    
                            icon = 'success'
                            title = 'Success'
                        } 
                        var msg = document.createElement('div');
                        msg.innerHTML = message;
                        swal({
                            title: title,                            
                            content: msg,
                            icon: icon,
                            // buttons: true,
                            dangerMode: true,
                        })               
                        walmart_table.ajax.reload();
                    },
                }).fail(function(xhr, status, q) {
                    Pace.stop();
                    $('#pos-loader').css('display', 'none')
                    // alert(xhr.responseText)            
                    swal({
                        title: 'Information',
                        text: xhr.responseText,
                        icon: 'info',
                        // buttons: false,
                    })
                });
                //Commented by Paligu
            }
        });
    }
///////////////////////////////////
    function sync_etsy(){
        swal({
            title: 'Information',
            text: 'This Process May Take littler longer than regular sync process, Please do not CLOSE or REFRESH your browser during this process.',
            icon: 'info',
            buttons: {
                cancel: "CANCEL",
                confirm: "START SYNC"
            },                      
        }).then((confirmed) => {
            if (confirmed) {   
                $.ajax({
                    method: 'GET',
                    url: '/etsy-auth',
                    dataType: 'json',
                    // data: {
                    //     product_locations: $('#product_locations_walmart').val(),
                    //     checkmarks: $("input[name='checkmarks_walmart[]']:checked").serializeArray()
                    // },
                    beforeSend: function() {
                        $('#pos-loader').css('display', 'inline-flex')
                        // swal('Information', 'This process may take litle bit long time, please do not close or refresh the browser', 'info')
                    },
                    success: function (result) {
                        Pace.stop();
                        $('#pos-loader').css('display', 'none')
                        // console.log(result)
                        var message = '<p>'+result.message+'</p>';
                        var icon = 'info'
                        var title = 'Information'
                        // if(result.data) {
                        //     var inserted = 0;
                        //     var updated = 0;
                        //     $.each(result.data, function(k, v) {
                        //         $.each(v, function(k1, v1) {
                        //             // console.log(v1)
                        //             if(v1.status == 2) {
                        //                 updated++;
                        //             } else {
                        //                 inserted++;
                        //             }                        
                        //         })
                        //     })
    
                        //     message+= '<br>' + inserted + ' Products Imported and Created <br>' + updated + ' Products Updated and Synced</p>';
    
                        //     icon = 'success'
                        //     title = 'Success'
                        // } 
                        var msg = document.createElement('div');
                        msg.innerHTML = message;
                        swal({
                            title: title,                            
                            content: msg,
                            icon: icon,
                            // buttons: true,
                            dangerMode: true,
                        })               
                        //walmart_table.ajax.reload();
                    },
                }).fail(function(xhr, status, q) {
                    Pace.stop();
                    $('#pos-loader').css('display', 'none')
                    // alert(xhr.responseText)            
                    swal({
                        title: 'Information',
                        text: xhr.responseText,
                        icon: 'info',
                        // buttons: false,
                    })
                });
                //Commented by Paligu
            }
        });
    }
///////////////////////////////////
    function sync_amazon() {
        swal({
            title: 'Information',
            text: 'This Process May Take littler longer than regular sync process, Please do not CLOSE or REFRESH your browser during this process.',
            icon: 'info',
            buttons: {
                cancel: "CANCEL",
                confirm: "START SYNC"
            },                      
        }).then((confirmed) => {
            if (confirmed) {   
                $.ajax({
                    method: 'GET',
                    url: '/amazon-auth',
                    dataType: 'json',
                    data: {
                        product_locations: $('#product_locations_amazon').val(),
                        checkmarks: $("input[name='checkmarks_amazon[]']:checked").serializeArray()
                    },
                    beforeSend: function() {
                        $('#pos-loader').css('display', 'inline-flex')
                        // swal('Information', 'This process may take litle bit long time, please do not close or refresh the browser', 'info')
                    },
                    success: function (result) {
                        Pace.stop();
                        $('#pos-loader').css('display', 'none')
                        // console.log(result)
                        var message = '<p>'+result.message;
                        var icon = 'info'
                        var title = 'Information'
                        /* if(result.data) {
                            var inserted = 0;
                            var updated = 0;
                            $.each(result.data, function(k, v) {
                                $.each(v, function(k1, v1) {
                                    // console.log(v1)
                                    if(v1.status == 2) {
                                        updated++;
                                    } else {
                                        inserted++;
                                    }                        
                                })
                            })
    
                            message+= '<br>' + inserted + ' Products Imported and Created <br>' + updated + ' Products Updated and Synced</p>';
    
                            icon = 'success'
                            title = 'Success'
                        }  */
                        var msg = document.createElement('div');
                        msg.innerHTML = message;
                        swal({
                            title: title,                            
                            content: msg,
                            icon: icon,
                            // buttons: true,
                            dangerMode: true,
                        })               
                        // amazon_table.ajax.reload();
                    },
                }).fail(function(xhr, status, q) {
                    Pace.stop();
                    $('#pos-loader').css('display', 'none')
                    // alert(xhr.responseText)            
                    swal({
                        title: 'Information',
                        text: xhr.responseText,
                        icon: 'info',
                        // buttons: false,
                    })
                });
                //Commented by Paligu
            }
        });
    }

    function get_input(val, tipe) {        
        if(val == '1') {
            if(tipe == 'bigcommerce') {
                // bigcommerce
                $('#etsy_api_url').css('display', 'block')
                $('#etsy_api_access_token').css('display', 'block')
                $('#etsy_api_key').css('display', 'block')
                $('#etsy_api_secret').css('display', 'block')
                $('#etsy_space').addClass('col-sm-3')
            }
            if(tipe == 'amazon') {
                // amazon
                $('#amazon_api_url').css('display', 'block')
                $('#amazon_api_access_token').css('display', 'block')
                $('#amazon_api_key').css('display', 'block')
                $('#amazon_api_secret').css('display', 'block')
                $('#amazon_space').addClass('col-sm-3')
            }
            if(tipe == 'walmart') {
                // woo commerce
                $('#walmart_api_url').css('display', 'block')
                $('#walmart_api_access_token').css('display', 'block')
                $('#walmart_api_key').css('display', 'block')
                $('#walmart_api_secret').css('display', 'block')
                $('#walmart_space').addClass('col-sm-3')
            }
            if(tipe == 'ebay') {
                // ebay
                $('#ebay_api_url').css('display', 'block')
                $('#ebay_api_access_token').css('display', 'block')
                $('#ebay_api_key').css('display', 'block')
                $('#ebay_api_secret').css('display', 'block')
                $('#ebay_space').addClass('col-sm-3')
            }
        } else {
            if(tipe == 'bigcommerce') {
                // big commerce
                $('#etsy_api_url').css('display', 'none')
                $('#etsy_api_access_token').css('display', 'none')
                $('#etsy_api_key').css('display', 'none')
                $('#etsy_api_secret').css('display', 'none')
                $('#etsy_space').removeClass('col-sm-3')
            }
            if(tipe == 'amazon') {
                // amazon
                $('#amazon_api_url').css('display', 'none')
                $('#amazon_api_access_token').css('display', 'none')
                $('#amazon_api_key').css('display', 'none')
                $('#amazon_api_secret').css('display', 'none')
                $('#amazon_space').removeClass('col-sm-3')
            }
            if(tipe == 'walmart') {
                // woo commerce
                $('#walmart_api_url').css('display', 'none')
                $('#walmart_api_access_token').css('display', 'none')
                $('#walmart_api_key').css('display', 'none')
                $('#walmart_api_secret').css('display', 'none')
                $('#walmart_space').removeClass('col-sm-3')
            }
            if(tipe == 'ebay') {
                // ebay
                $('#ebay_api_url').css('display', 'none')
                $('#ebay_api_access_token').css('display', 'none')
                $('#ebay_api_key').css('display', 'none')
                $('#ebay_api_secret').css('display', 'none')
                $('#ebay_space').removeClass('col-sm-3')
            }
        }
    }

    function getOption(type, val, order) {
        if(val == 1 && type == 1) {
            $('#option_marketplace_collapse_' + order).css('display', 'block')            
            // $('#option_marketplace_collapse_amazon_1').css('display', 'block')            
        } else if(val == 0 && type == 1) {
            $('#option_marketplace_collapse_' + order).css('display', 'none') 
            // $('#option_marketplace_collapse_amazon_1').css('display', 'none') 
            $('#checkmarks_marketplace_11').removeAttr('checked');           
            $('#checkmarks_marketplace_12').removeAttr('checked');
            $('#checkmarks_marketplace_13').removeAttr('checked');           
            $('#checkmarks_marketplace_14').removeAttr('checked');                       
        }
         
        if(val == 1 && type == 2) {            
            $('#option_marketplace_collapse_' + order).css('display', 'block')            
        } else if(val == 0 && type == 2) {
            $('#option_marketplace_collapse_' + order).css('display', 'none')            
            $('#checkmarks_marketplace_21').removeAttr('checked');           
            $('#checkmarks_marketplace_22').removeAttr('checked');
            $('#checkmarks_marketplace_23').removeAttr('checked');           
            $('#checkmarks_marketplace_24').removeAttr('checked');
        }
    } 

    function getOptionAmazon(type, val, order) {
        if(val == 1 && type == 1) {
            // $('#option_marketplace_collapse_amazon_' + order).css('display', 'block')            
            $('#option_marketplace_collapse_amazon_1').css('display', 'block')            
        } else if(val == 0 && type == 1) {
            // $('#option_marketplace_collapse_amazon_' + order).css('display', 'none') 
            $('#option_marketplace_collapse_amazon_1').css('display', 'none') 
            $('#checkmarks_marketplace_amazon_11').removeAttr('checked');           
            $('#checkmarks_marketplace_amazon_12').removeAttr('checked');
            $('#checkmarks_marketplace_amazon_13').removeAttr('checked');           
            $('#checkmarks_marketplace_amazon_14').removeAttr('checked');                       
        }
         
        if(val == 1 && type == 2) {            
            $('#option_marketplace_collapse_amazon_2').css('display', 'block')  
            // $('#option_marketplace_collapse_amazon_' + order).css('display', 'block')            
        } else if(val == 0 && type == 2) {
            $('#option_marketplace_collapse_amazon_2').css('display', 'none')  
            // $('#option_marketplace_collapse_amazon_' + order).css('display', 'none')            
            $('#checkmarks_marketplace_amazon_21').removeAttr('checked');           
            $('#checkmarks_marketplace_amazon_22').removeAttr('checked');
            $('#checkmarks_marketplace_amazon_23').removeAttr('checked');           
            $('#checkmarks_marketplace_amazon_24').removeAttr('checked');
        }
    }

    function table_hide(x) {
        $('.table_hide').addClass('hide');
        $('.' + x + '_table').removeClass('hide');
        $('.btn-sync').addClass('hide');
        var btn = $('#' + x + '_test_btn');
        if (btn.length) {
            btn.removeClass('hide');
        }
    }
</script>
@endsection
