<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    {!! Form::open(['url' => action([\App\Http\Controllers\CashRegisterController::class, 'postCloseRegister']), 'method' => 'post', 'id' => 'close_register_form' ]) !!}

    {!! Form::hidden('user_id', $register_details->user_id); !!}
    {!! Form::hidden('cash_register_list_id', $register_details->cash_register_list_id); !!}
    {!! Form::hidden('post_type', null, ['id' => 'pos_type']); !!}
    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h3 class="modal-title">@lang( 'cash_register.current_register' ) ( {{ \Carbon::createFromFormat('Y-m-d H:i:s', $register_details->open_time)->format('jS M, Y h:i A') }} - {{ \Carbon::now('GMT')->format('jS M, Y h:i A') }})</h3>
    </div>

    <div class="modal-body">
        @include('cash_register.payment_details')
        <hr>
      <div class="row">
        <div class="col-sm-4">
          <div class="form-group">
            {!! Form::label('closing_amount', __( 'cash_register.total_cash' ) . ':*') !!}
              {!! Form::text('closing_amount', @num_format($register_details->cash_in_hand + $register_details->total_cash + $sell_no_registers['nonRegister']->total_cash_non_register - ($register_details->total_cash_refund > 0 ? $register_details->total_cash_refund : $details['transaction_return']->total_cash_refund) - $register_details->total_cash_expense), ['class' => 'form-control input_number', 'required', 'placeholder' => __( 'cash_register.total_cash' ), 'onfocus' => "show_close_register_numpad(1, this.name, this, 'close_register', 'amount')" ]); !!}
              <input type="hidden" id="old_closing_amount" value="{{@num_format($register_details->cash_in_hand + $register_details->total_cash + $sell_no_registers['nonRegister']->total_cash_non_register - ($register_details->total_cash_refund > 0 ? $register_details->total_cash_refund : $details['transaction_return']->total_cash_refund) - $register_details->total_cash_expense)}}">
          </div>
        </div>
        <div class="col-sm-4">
          <div class="form-group">
            {!! Form::label('total_card_slips', __( 'cash_register.total_card_slips' ) . ':*') !!} @show_tooltip(__('tooltip.total_card_slips'))
              {!! Form::number('total_card_slips', $register_details->total_card_slips, ['class' => 'form-control', 'required', 'placeholder' => __( 'cash_register.total_card_slips' ), 'onfocus' => "show_close_register_numpad(1, this.name, this, 'close_register', 'quantity')", 'min' => 0 ]); !!}
          </div>
        </div> 
        <div class="col-sm-4">
          <div class="form-group">
            {!! Form::label('total_cheques', __( 'cash_register.total_cheques' ) . ':*') !!} @show_tooltip(__('tooltip.total_cheques'))
              {!! Form::number('total_cheques', $register_details->total_cheques, ['class' => 'form-control', 'required', 'placeholder' => __( 'cash_register.total_cheques' ), 'onfocus' => "show_close_register_numpad(1, this.name, this, 'close_register', 'quantity')", 'min' => 0 ]); !!}
          </div>
        </div>         
        <hr>
        <div class="col-md-8 col-sm-12" onclick="hide_numpad(1)">
          <h3>@lang( 'lang_v1.cash_denominations' )</h3>
          @if(!empty($pos_settings['cash_denominations']))
            <table class="table table-slim">
              <thead>
                <tr>
                  <th width="20%" class="text-right">@lang('lang_v1.denomination')</th>
                  <th width="20%">&nbsp;</th>
                  <th width="20%" class="text-center">@lang('lang_v1.count')</th>
                  <th width="20%">&nbsp;</th>
                  <th width="20%" class="text-left">@lang('sale.subtotal')</th>
                </tr>
              </thead>
              <tbody>
                @foreach(explode(',', $pos_settings['cash_denominations']) as $dnm)
                <tr>
                  <td class="text-right">{{$dnm}}</td>
                  <td class="text-center" >X</td>
                  <td>{!! Form::number("denominations[$dnm]", null, ['class' => 'form-control cash_denomination input-sm', 'min' => 0, 'data-denomination' => $dnm, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                  <td class="text-center">=</td>
                  <td class="text-left">
                    <span class="denomination_subtotal">0</span>
                  </td>
                </tr>
                @endforeach
              </tbody>
              <tfoot>
                <tr>
                  <th colspan="4" class="text-center">@lang('sale.total')</th>
                  <td><span class="denomination_total">0</span></td>
                </tr>
              </tfoot>
            </table>
          @else
            <p class="help-block">@lang('lang_v1.denomination_add_help_text')</p>
          @endif
        </div>
        <hr>
        <div class="col-sm-12" onclick="hide_numpad(1)">
          <div class="form-group">
            {!! Form::label('closing_note', __( 'cash_register.closing_note' ) . ':') !!}
              {!! Form::textarea('closing_note', null, ['class' => 'form-control', 'placeholder' => __( 'cash_register.closing_note' ), 'rows' => 3 ]); !!}
          </div>
        </div>
      </div> 

      <div class="row" onclick="hide_numpad(1)">
        <div class="col-xs-6">
          <b>@lang('report.user'):</b> {{ $register_details->user_name}}<br>
          <b>@lang('business.email'):</b> {{ $register_details->email}}<br>
          <b>@lang('business.business_location'):</b> {{ $register_details->location_name}}<br>
          <b>@lang('cash_register.cash_register_name'):</b> {{ $register_details->cash_registers_name}}<br>
        </div>
        @if(!empty($register_details->closing_note))
          <div class="col-xs-6">
            <strong>@lang('cash_register.closing_note'):</strong><br>
            {{$register_details->closing_note}}
          </div>
        @endif
      </div>
    </div>
    <div class="modal-footer" onclick="hide_numpad(1)">
      <button type="button" class="btn btn-default" data-dismiss="modal">@lang( 'messages.cancel' )</button>      
      <button type="button" onclick="closeRegister()" class="btn btn-primary" id="close_register_button">@lang( 'cash_register.close_register' )</button>            
    </div>
    {!! Form::close() !!}
  </div><!-- /.modal-content -->
  {{-- @if (true)	
		<div class="numpad_div col-xs-12 hide" id="product_numpad_div1" data-type="cash" style="
			/* display: flex;
			align-items: center;
			justify-content: center; */
			padding-right: 25px;
			position: absolute;
			top: 32%;
			right: 100%;
			width: 40%;">							
			<div class="form-group">									
				<div class="easy-numpad-number-container">
					<table id="product_numpad1">
						<thead>						
							<tr>
								
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">1</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">2</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">3</a></td>							
							</tr>
							<tr>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">4</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">5</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">6</a></td>
							</tr>
							<tr>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">7</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">8</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">9</a></td>
							</tr>						
							<tr>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">0</a></td>														
								<td style="padding: 10px;"><a href="#" class="numPadCashOtherClear" id="numPadCashOtherClear" style="padding: 10px ; width: 90px !important; height: 70px !important;">Clr</a></td>
								<td style="padding: 10px;"><a href="#" class="numPadCashOtherDel" id="numPadCashOtherDel" style="padding: 10px ; width: 90px !important; height: 70px !important;">DEL</a></td>									
							</tr>
						</thead>
					</table>
				</div>									
			</div>							
		</div>
	@endif --}}
</div><!-- /.modal-dialog -->