@extends('layouts.app')
@section('title',  __('cash_register.open_cash_register'))
@inject('request', 'Illuminate\Http\Request')
@section('content')
<style type="text/css">



</style>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('cash_register.open_cash_register')</h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
{!! Form::open(['url' => action([\App\Http\Controllers\CashRegisterController::class, 'store']), 'method' => 'post', 
'id' => 'add_cash_register_form' ]) !!}
  <div class="box box-solid">
    <div class="box-body">
    <br><br><br>
    <input type="hidden" name="sub_type" value="{{$sub_type}}">
    <div class="row">            
        @if (session('errors'))
            <div class="alert alert-danger alert-dismissible col-sm-8 col-sm-offset-2" role="alert">
                <button type="button" class="close" data-dismiss="alert">
                    <i class="fa fa-times"></i>
                </button>
                <strong>Warning !</strong> {{ session('errors') }}
            </div>
        @endif        
        <div class="col-sm-8 col-sm-offset-2">
          <button type="button" class="vh-pos-btn-recnt-trnsc m-6 btn-xs m-5" style="margin-left: 0" id="open_drawer" title="@lang('lang_v1.open_cash_drawer')">
            <strong><i class="fa fa-info-circle fa-lg"></i> @lang('lang_v1.open_cash_drawer') </strong>
          </button>
        </div>
        @if($business_locations)
        <div class="col-sm-8 col-sm-offset-2">
          <div class="form-group">
            {!! Form::label('amount', __('cash_register.cash_in_hand') . ':*') !!}
            {!! Form::text('amount', old('amount') ? old('amount') : "0.00", ['class' => 'form-control input_number',
              'placeholder' => __('cash_register.enter_amount'), 'required', 'onChange' => 'empty_denomination()']); !!}
            {!! Form::hidden('cash_register_list_id', $cash_register_list_id) !!}
          </div>
        </div>
        <div class="numpad_div col-xs-12 " id="discount_modal_div" data-type="discount" style="
						display: flex;
						align-items: center;
						justify-content: center;
						padding-right: 25px;">							
						<div class="form-group">									
							<div class="easy-numpad-number-container">
								<table id="discount_modal">
									<thead>
										<tr>
											<td class="numPadCash" style="padding: 10px;" data-type="top"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">5</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="top"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">10</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="top"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">20</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="top"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">50</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="top"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">100</a></td>
										</tr>
										<tr>
											
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">1</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">2</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">3</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">4</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">5</a></td>
										</tr>
										<tr>
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">6</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">7</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">8</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">9</a></td>
											<td class="numPadCash" style="padding: 10px;" data-type="middle"><a href="javascript:void(0);"  style="padding: 10px !important;width: 60px;height: 50px;">0</a></td>
										</tr>
										<tr>
											<!-- <td><a href="."  style="padding: 10px ;">.</a></td> -->
											<td colspan="2"><a href="javascript:void(0);" class="numPadCash" style="padding: 10px ; width: calc(95% + -10px); margin-top:2px; margin-left: 10px;">00</a></td>
											<td colspan="2"><a href="javascript:void(0);" class="numPadCashClear" id="numPadCashClear" style="padding: 10px ; width: calc(100% + -10px); margin-top:2px;">Clear</a></td>
											<td><a href="javascript:void(0);" class="numPadCashDel" id="numPadCashDel" style="padding: 10px ; width: calc(100% + -10px); margin-top:2px;">DEL</a></td>									
										</tr>
									</thead>
								</table>
							</div>									
						</div>
        </div>
        @if($business_locations)
        <div class="clearfix"></div>
        <div class="col-sm-8 col-sm-offset-2">
          <div class="form-group">
            {!! Form::label('location_id', __('business.business_location') . ':') !!}
              {!! Form::select('location_id', $business_locations, old('location_id', $location_id), ['class' => 'form-control select2',
              'placeholder' => __('lang_v1.select_location'), 'onChange' => 'getCashRegister(this.value)']); !!}
          </div>
        </div>
        @else
          {!! Form::hidden('location_id', array_key_first($business_locations->toArray()) ); !!}
        @endif
        <div class="clearfix"></div>
        <div class="col-sm-8 col-sm-offset-2">
          <div class="form-group">
            {!! Form::label('cash_register_list_id', __('cash_register.cash_register_name') . ':') !!}
              {!! Form::select('cash_register_list_id', $cash_registers_list, old('cash_register_list_id', $cash_register_list_id), ['class' => 'form-control select2',
              'placeholder' => __('lang_v1.select_cash_register')]); !!}
          </div>
        </div>        
        <div class="col-md-8 col-sm-offset-2">
          <h3>@lang( 'lang_v1.cash_denominations' )</h3>
          <table class="table table-slim">
            <thead>
              <tr>
                <th width="0.1%" class="text-center">@lang('lang_v1.denomination')</th>
                <th width="1%">&nbsp;</th>
                <th width="1%" class="text-center">@lang('lang_v1.count')</th>
                <th width="1%">&nbsp;</th>
                <th width="10%" class="text-left">@lang('sale.subtotal')</th>
              </tr>
            </thead>
            <tbody>
              @foreach(explode(',', $pos_settings['cash_denominations']) as $dnm)
                <tr>
                  <td class="text-right">{{$dnm}}</td>
                  <td class="text-center" >X</td>
                  <td>{!! Form::number("denominations[$dnm]", old("denominations[$dnm]"), ['class' => 'form-control cash_denomination input-sm', 'onkeyup' => 'getTotal(this.value, '.$dnm.')', 'min' => 0, 'data-denomination' => $dnm, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                  <td class="text-center">=</td>
                  <td class="text-left">
                    <span class="denomination_subtotal">0</span>
                  </td>
                </tr>
              @endforeach
              {{-- <tr>                                
                <td class="text-center">0.10</td>
                <td class="text-center">X</td>
                <td class="text-center" style="width: 100px !important;">{!! Form::number("denominations[0.1]", old('denominations[0.1]'), ['class' => 'form-control cash_denomination input-sm', 'onkeyup' => 'getTotal(this.value, 5)','min' => 0, 'data-denomination' => 5, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                <td class="text-center">=</td>
                <td class="text-left" style="padding-left: 9px;" id="sub_total0_1">
                  @format_currency(0)
                </td>
              </tr>                
              <tr>                                
                <td class="text-center">0.25</td>
                <td class="text-center">X</td>
                <td class="text-center" style="width: 100px !important;">{!! Form::number("denominations[0.25]", old('denominations[0.25]'), ['class' => 'form-control cash_denomination input-sm', 'onkeyup' => 'getTotal(this.value, 5)','min' => 0, 'data-denomination' => 5, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                <td class="text-center">=</td>
                <td class="text-left" style="padding-left: 9px;" id="sub_total0_25">
                  @format_currency(0)
                </td>
              </tr>                
              <tr>                                
                <td class="text-center">1</td>
                <td class="text-center">X</td>
                <td class="text-center" style="width: 100px !important;">{!! Form::number("denominations[1]", old('denominations[1]'), ['class' => 'form-control cash_denomination input-sm', 'onkeyup' => 'getTotal(this.value, 5)','min' => 0, 'data-denomination' => 5, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                <td class="text-center">=</td>
                <td class="text-left" style="padding-left: 9px;" id="sub_total1">
                  @format_currency(0)
                </td>
              </tr>                
              <tr>                                
                <td class="text-center">5</td>
                <td class="text-center">X</td>
                <td class="text-center" style="width: 100px !important;">{!! Form::number("denominations[5]", old('denominations[5]'), ['class' => 'form-control cash_denomination input-sm', 'onkeyup' => 'getTotal(this.value, 5)','min' => 0, 'data-denomination' => 5, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                <td class="text-center">=</td>
                <td class="text-left" style="padding-left: 9px;" id="sub_total5">
                  @format_currency(0)
                </td>
              </tr>                
              <tr>                
                <td class="text-center">10</td>
                <td class="text-center">X</td>
                <td class="text-center" style="width: 100px !important;">{!! Form::number("denominations[10]", old('denominations[10]'), ['class' => 'form-control cash_denomination input-sm', 'onkeyup' => 'getTotal(this.value, 10)','min' => 0, 'data-denomination' => 10, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                <td class="text-center">=</td>
                <td class="text-left" style="padding-left: 9px;" id="sub_total10">
                  @format_currency(0)
                </td>
              </tr>                
              <tr>                
                <td class="text-center">20</td>
                <td class="text-center">X</td>
                <td class="text-center" style="width: 100px !important;">{!! Form::number("denominations[20]", old('denominations[20]'), ['class' => 'form-control cash_denomination input-sm', 'onkeyup' => 'getTotal(this.value, 20)','min' => 0, 'data-denomination' => 20, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                <td class="text-center">=</td>
                <td class="text-left" style="padding-left: 9px;" id="sub_total20">
                  @format_currency(0)
                </td>
              </tr>                
              <tr>
                <td class="text-center">50</td>
                <td class="text-center">X</td>
                <td class="text-center" style="width: 100px !important;">{!! Form::number("denominations[50]", old('denominations[50]'), ['class' => 'form-control cash_denomination input-sm', 'onkeyup' => 'getTotal(this.value, 50)','min' => 0, 'data-denomination' => 50, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                <td class="text-center">=</td>
                <td class="text-left" style="padding-left: 9px;" id="sub_total50">
                  @format_currency(0)
                </td>
              </tr>                
              <tr>                
                <td class="text-center">100</td>
                <td class="text-center">X</td>
                <td class="text-center" style="width: 100px !important;">{!! Form::number("denominations[100]", old('denominations[100]'), ['class' => 'form-control cash_denomination input-sm', 'onkeyup' => 'getTotal(this.value, 100)','min' => 0, 'data-denomination' => 100, 'style' => 'width: 100px; margin:auto;' ]); !!}</td>
                <td class="text-center">=</td>
                <td class="text-left" style="padding-left: 9px;" id="sub_total100">
                  @format_currency(0)
                </td>
              </tr>  --}}               
            </tbody>
            <tfoot>
              <tr>
                <th colspan="4" class="text-center">@lang('sale.total')</th>
                <td id="sub_total_all" style="padding-left: 9px;">@format_currency(0)</td>
              </tr>
            </tfoot>
          </table>
        </div>        
        <div class="col-sm-8 col-sm-offset-2">
          <button type="submit" class="btn btn-primary pull-right">@lang('cash_register.open_register')</button>
        </div>
        @else
        <div class="col-sm-8 col-sm-offset-2 text-center">
          <h3>@lang('lang_v1.no_location_access_found')</h3>
        </div>
      @endif
      </div>
      <br><br><br>
    </div>
  </div>
  @include('sale_pos.partials.modal_drawers_opening')
  {!! Form::close() !!}
</section>
<!-- /.content -->
@endsection
@section('javascript')
<script type="text/javascript">
  $(document).ready(function() {
    var location_id = $('#location_id').val();
    if(location_id) {
      getCashRegister(location_id, '{{old('cash_register_list_id')}}')
    }
  })

  function getTotal(v, nominal) {
    // console.log(v)
    // console.log((parseFloat(v) * parseFloat(nominal)))
    setTimeout(() => {
      var amount = 0; 
      $('.cash_denomination').map(function() {
          if($(this).val()) {
            var denomination = $(this).data('denomination');
            var value = $(this).val();
            amount = parseFloat(amount) + (parseFloat(denomination) * parseFloat(value));
            $('#sub_total_all').html(__currency_trans_from_en(amount, true));
            $('#amount').val(parseFloat(amount).toFixed(2));
          }
      }).get();      
    }, 100);
  }

  function empty_denomination() {
    $('.cash_denomination').map(function() {
      if($(this).val()) {            
        $(this).val('');    
        $('.denomination_subtotal').html(__currency_trans_from_en(0, true))                    
      }
    }).get();
    $('#sub_total_all').html(__currency_trans_from_en(0, true))
  }

  var pattern = ['0','0','0','.','0','0'];
  var typeCash = null;
  $(document).on('click', '.numPadCash', function(e) {
      // var type_input = $(this).parent().parent().parent().parent().parent().parent().data('type');    
      name_input = 'amount';
      
      let type = $(this).data('type');
      empty_denomination()
      let curValue;
      switch ($(this).text()) {
          case '00':            
              if(pattern[0] == '0' && pattern[1] == '0') {                
                  pattern[pattern.length - 6] = pattern[pattern.length - 5];
                  pattern[pattern.length - 5] = pattern[pattern.length - 4];
                  pattern[pattern.length - 4] = pattern[pattern.length - 2];
                  pattern[pattern.length - 2] = pattern[pattern.length - 1];
                  pattern[pattern.length - 1] = '0';            
                  
                  pattern[pattern.length - 6] = pattern[pattern.length - 5];
                  pattern[pattern.length - 5] = pattern[pattern.length - 4];
                  pattern[pattern.length - 4] = pattern[pattern.length - 2];
                  pattern[pattern.length - 2] = pattern[pattern.length - 1];
                  pattern[pattern.length - 1] = '0';                                            
              }

              //// console.log("pattern");
              //// console.log(pattern);

              curValue = pattern.join('');
              if (pattern[0] == '0' && pattern[1] == '0') {
                  //// console.log("basta 2 sifir");
                  $('input[name="'+name_input+'"]').val(curValue.substring(2));
              } else if (pattern[0] == '0') {
                  //// console.log("basta 1 sifir");
                  $('input[name="'+name_input+'"]').val(curValue.substring(1));
              } else {
                  // console.log('pattern[0] != 0');
                  //$("input[name="'+name_input+'"]"_"+row_index).val(curValue);
                  let row_index = $('#payment_row_index').val();
                  $('input[name="'+name_input+'"]').val(curValue);
              }

              // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))

              // calculate_balance_due();
              // $('input.pos_unit_price').trigger('change');
              break;

          default:            
              if (!$('input[name="'+name_input+'"').val()) {
                  let last = pattern.findLastIndex((element) => (element = '0'));
                  pattern[last] = document.getElementsByClassName('payment-amount').innerText;
                  // console.log('pattern[last] : ' + pattern[last]);
                  curValue = pattern.join('');

                  if (pattern[0] == '0' && pattern[1] == '0') {
                      // console.log('basta 2 sifir');
                      $('input[name="'+name_input+'"]').val(curValue.substring(2));
                  } else if (pattern[0] == '0') {
                      // console.log('basta 1 sifir');
                      $('input[name="'+name_input+'"]').val(curValue.substring(1));
                  } else {
                      // console.log('pattern[0] != 0');
                      $('input[name="'+name_input+'"]').val(curValue);
                  }
                  // calculate_balance_due();
                  $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                  // calculate_balance_due();
                  $('input.pos_unit_price').trigger('change');
              } else {
                  // // console.log('2541');
                  if(type == 'top') {                    
                      pattern[pattern.length - 6] = '0';
                      pattern[pattern.length - 5] = '0';
                      pattern[pattern.length - 4] = $(this).text();
                      pattern[pattern.length - 2] = '0';
                      pattern[pattern.length - 1] = '0';    
                      typeCash = 'top';                                                                            
                  } else {         
                      if(typeCash == 'top') {                                              
                          pattern[pattern.length - 6] = 0;
                          pattern[pattern.length - 5] = 0;
                          pattern[pattern.length - 4] = 0;                        
                      } else {                        
                          pattern[pattern.length - 6] = pattern[pattern.length - 5];
                          pattern[pattern.length - 5] = pattern[pattern.length - 4];                        
                          pattern[pattern.length - 4] = pattern[pattern.length - 2];                        
                      }
                      pattern[pattern.length - 2] = pattern[pattern.length - 1];
                      pattern[pattern.length - 1] = $(this).text();
                      typeCash = 'middle';       
                  }

                  curValue = pattern.join('');

                  if (pattern[0] == '0' && pattern[1] == '0') {
                      // console.log('basta 2 sifir');
                      //$("#amount_"+row_index).val(curValue.substring(2));

                      $('input[name="'+name_input+'"]').val(curValue.substring(2));
                  } else if (pattern[0] == '0') {
                      $('input[name="'+name_input+'"]').val(curValue.substring(1));
                  } else {
                      $('input[name="'+name_input+'"]').val(curValue);
                  }
                  // calculate_balance_due();
                  $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                  // calculate_balance_due();
                  $('input.pos_unit_price').trigger('change');
              }

          break;
      }
  })

  $(document).on('click', '.numPadCashDel', function (e) {
      //PALIGU
      let curValue;
      // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
      name_input = 'amount';   
      let type = $(this).data('type');
      
      pattern[pattern.length - 1] = pattern[pattern.length - 2];
      pattern[pattern.length - 2] = pattern[pattern.length - 4];
      pattern[pattern.length - 4] = pattern[pattern.length - 5];
      pattern[pattern.length - 5] = pattern[pattern.length - 6];
      pattern[pattern.length - 6] = '0';

      curValue = pattern.join('');
      if (pattern[0] == '0' && pattern[1] == '0') {
          //// console.log("basta 2 sifir");
          $('input[name="'+name_input+'"]').val(curValue.substring(2));
      } else if (pattern[0] == '0') {
          //// console.log("basta 1 sifir");
          $('input[name="'+name_input+'"]').val(curValue.substring(1));
      } else {
          //// console.log("pattern[0] != 0");
          $('input[name="'+name_input+'"]').val(curValue);
      }
      
      $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
      if (Number(curValue) == 0) {        
          let total = "0.00";
          $('input[name="'+name_input+'"]').val(total);        
          // calculate_balance_due();
          // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
      }
      empty_denomination();
      // calculate_balance_due();
      // $('input.pos_unit_price').trigger('change');
  });

  $(document).on('click', '.numPadCashClear', function (e) {
      //PALIGU    
      // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');    
      name_input = 'amount';
      total = "0.00";    
      let type = $(this).data('type');
      // let initValue = __read_number($('input.pos_unit_price').val());
      // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
      
      $('input[name="'+name_input+'"]').val(total);
      // calculate_balance_due();
      // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
      // calculate_balance_due();    
      // $('input.pos_unit_price').trigger('change');
      empty_denomination();
      pattern = ['0', '0', '0', '.', '0', '0'];
  });
</script>
@endsection