@extends('layouts.app')
@section('title', __('invoice.invoice_settings'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang( 'invoice.invoice_settings' )
        <small>@lang( 'invoice.manage_your_invoices' )</small>
    </h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
          <!-- Custom Tabs -->
          <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
              <li class="active"><a href="#tab_1" data-toggle="tab" aria-expanded="true">@lang('invoice.invoice_schemes')</a></li>
              <li class=""><a href="#tab_2" data-toggle="tab" aria-expanded="false">@lang('invoice.invoice_layouts')</a></li>
            </ul>
            <div class="tab-content">
              <div class="tab-pane active" id="tab_1">
                <div class="row">
                    <div class="col-md-12">
                        <h4>@lang( 'invoice.all_your_invoice_schemes' ) <button type="button" class="btn btn-primary btn-modal pull-right" 
                                data-href="{{action([\App\Http\Controllers\InvoiceSchemeController::class, 'create'])}}" 
                                data-container=".invoice_modal">
                                <i class="fa fa-plus"></i> @lang( 'messages.add' )</button></h4>
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="invoice_table">
                            <thead>
                                <tr>
                                    <th>@lang( 'invoice.name' ) @show_tooltip(__('tooltip.invoice_scheme_name'))</th>
                                    <th>@lang( 'invoice.prefix' ) @show_tooltip(__('tooltip.invoice_scheme_prefix'))</th>
                                    <th>@lang( 'invoice.start_number' ) @show_tooltip(__('tooltip.invoice_scheme_start_number'))</th>
                                    <th>@lang( 'invoice.invoice_count' ) @show_tooltip(__('tooltip.invoice_scheme_count'))</th>
                                    <th>@lang( 'invoice.total_digits' ) @show_tooltip(__('tooltip.invoice_scheme_total_digits'))</th>
                                    <th>@lang( 'messages.action' )</th>
                                </tr>
                            </thead>
                        </table>
                        </div>
                    </div>
                </div>
              </div>
              <!-- /.tab-pane -->
              <div class="tab-pane" id="tab_2">
                <div class="row">
                    <div class="col-md-12">
                        <h4>@lang( 'invoice.all_your_invoice_layouts' ) <a class="btn btn-primary pull-right" href="{{action([\App\Http\Controllers\InvoiceLayoutController::class, 'create'])}}">
                                <i class="fa fa-plus"></i> @lang( 'messages.add' )</a></h4>
                    </div>
                    <div class="col-md-12">
                        @foreach( $invoice_layouts as $layout)
                        <div class="col-md-3">
                            <div class="icon-link">
                                <a href="{{action([\App\Http\Controllers\InvoiceLayoutController::class, 'edit'], [$layout->id])}}">
                                    <i class="fa fa-file-alt fa-4x"></i> 
                                    {{ $layout->name }}
                                </a>
                                @if( $layout->is_default )
                                    <span class="badge bg-green">@lang("barcode.default")</span>
                                @endif
                                @if($layout->locations->count())
                                    <span class="link-des">
                                    <b>@lang('invoice.used_in_locations'): </b><br>
                                    @foreach($layout->locations as $location)
                                        {{ $location->name }}
                                        @if (!$loop->last)
                                            ,
                                        @endif
                                        &nbsp;
                                    @endforeach
                                    </span>
                                @endif
                            </div>
                        </div>
                        @if( $loop->iteration % 4 == 0 )
                                    <div class="clearfix"></div>
                                @endif
                        @endforeach
                    </div>
                </div>
                <br>
              </div>
              <!-- /.tab-pane -->
            </div>
            <!-- /.tab-content -->
          </div>
          <!-- nav-tabs-custom -->
        </div>
    </div>
	
    <div class="modal fade invoice_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>
    <div class="modal fade invoice_edit_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

@endsection
@section('javascript')
    <script>
        var pattern_qty = ['0', '0', '0', '.', '0', '0'];
        var typeCash = null;
        $(document).on('click', '.numPadCash', function(e) {
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().data('type');    
            name_input = 'start_number';    
            let type = $(this).data('type');
            let curValue;
            switch ($(this).text()) {
                case '00':            
                    if(pattern_qty[0] == '0' && pattern_qty[1] == '0') {                
                        pattern_qty[pattern_qty.length - 4] = pattern_qty[pattern_qty.length - 3];
                        pattern_qty[pattern_qty.length - 3] = pattern_qty[pattern_qty.length - 2];
                        pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 1];                
                        pattern_qty[pattern_qty.length - 1] = '00';                                                                                        
                    }

                    //// console.log("pattern");
                    //// console.log(pattern);

                    curValue = pattern_qty.join('');
                    if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                        //// console.log("basta 2 sifir");
                        $('input[name="'+name_input+'"]').val(curValue.substring(2));
                    } else if (pattern_qty[0] == '0') {
                        //// console.log("basta 1 sifir");
                        $('input[name="'+name_input+'"]').val(curValue.substring(1));
                    } else {
                        // console.log('pattern_qty[0] != 0');
                        //$("input[name="'+name_input+'"]"_"+row_index).val(curValue);
                        let row_index = $('#payment_row_index').val();
                        $('input[name="'+name_input+'"]').val(curValue);
                    }

                    // $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))

                    // calculate_balance_due();
                    // $('input.pos_unit_price').trigger('change');
                    break;

                default:            
                    if (!$('input[name="'+name_input+'"').val()) {
                        let last = pattern_qty.findLastIndex((element) => (element = '0'));
                        pattern_qty[last] = document.getElementsByClassName('payment-amount').innerText;
                        // console.log('pattern_qty[last] : ' + pattern_qty[last]);
                        curValue = pattern_qty.join('');
                        if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                            // console.log('basta 2 sifir');
                            $('input[name="'+name_input+'"]').val(curValue.substring(2));
                        } else if (pattern_qty[0] == '0') {
                            // console.log('basta 1 sifir');
                            $('input[name="'+name_input+'"]').val(curValue.substring(1));
                        } else {
                            // console.log('pattern_qty[0] != 0');
                            $('input[name="'+name_input+'"]').val(curValue);
                        }
                        // calculate_balance_due();
                        $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                        // calculate_balance_due();
                        $('input.pos_unit_price').trigger('change');
                    } else {
                        // // console.log('2541');
                        if(type == 'top') {                    
                            pattern_qty[pattern_qty.length - 4] = '0';
                            pattern_qty[pattern_qty.length - 3] = '0';
                            pattern_qty[pattern_qty.length - 2] = '0';                        
                            pattern_qty[pattern_qty.length - 1] = $(this).text();                        
                            typeCash = 'top';                                                                            
                        } else {         
                            if(typeCash == 'top') {                                              
                                pattern_qty[pattern_qty.length - 4] = 0;
                                pattern_qty[pattern_qty.length - 3] = 0;                        
                                pattern_qty[pattern_qty.length - 2] = 0;                        
                            } else {                        
                                pattern_qty[pattern_qty.length - 4] = pattern_qty[pattern_qty.length - 3];
                                pattern_qty[pattern_qty.length - 3] = pattern_qty[pattern_qty.length - 2];                        
                                pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 1];                        
                            }
                            // pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 1];
                            pattern_qty[pattern_qty.length - 1] = $(this).text();
                            typeCash = 'middle';       
                        }

                        curValue = pattern_qty.join('');
                        if (pattern_qty[0] == '0' && pattern_qty[1] == '0' && pattern_qty[2] == '0') {
                            // console.log('basta 2 sifir');
                            //$("#amount_"+row_index).val(curValue.substring(2));

                            $('input[name="'+name_input+'"]').val(curValue.substring(3));
                        } else if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                            $('input[name="'+name_input+'"]').val(curValue.substring(2));
                        } else if (pattern_qty[0] == '0') {
                            $('input[name="'+name_input+'"]').val(curValue.substring(1));
                        } else {
                            $('input[name="'+name_input+'"]').val(curValue);
                        }
                        // calculate_balance_due();
                        $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
                        // calculate_balance_due();
                        $('input.pos_unit_price').trigger('change');
                    }

                break;
            }
        })

        $(document).on('click', '.numPadCashQtyDel', function (e) {
            //PALIGU
            let curValue;
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
            name_input = 'start_number';   
            // let type = $(this).data('type');
            
            pattern_qty[pattern_qty.length - 1] = pattern_qty[pattern_qty.length - 2];
            pattern_qty[pattern_qty.length - 2] = pattern_qty[pattern_qty.length - 3];
            pattern_qty[pattern_qty.length - 3] = pattern_qty[pattern_qty.length - 4];
            pattern_qty[pattern_qty.length - 4] = '0';
            

            curValue = pattern_qty.join('');
            if (pattern_qty[0] == '0' && pattern_qty[1] == '0' && pattern_qty[2] == '0') {
                // console.log('basta 2 sifir');
                //$("#amount_"+row_index).val(curValue.substring(2));

                $('input[name="'+name_input+'"]').val(curValue.substring(3));
            } else if (pattern_qty[0] == '0' && pattern_qty[1] == '0') {
                $('input[name="'+name_input+'"]').val(curValue.substring(2));
            } else if (pattern_qty[0] == '0') {
                $('input[name="'+name_input+'"]').val(curValue.substring(1));
            } else {
                $('input[name="'+name_input+'"]').val(curValue);
            }
            
            $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
            if (Number(curValue) == 0) {        
                let total = "0";
                $('input[name="'+name_input+'"]').val(total);        
                // calculate_balance_due();
                // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
            }
            // calculate_balance_due();
            // $('input.pos_unit_price').trigger('change');
        });

        $(document).on('click', '.numPadCashClear', function (e) {
            //PALIGU    
            // var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');    
            name_input = 'start_number';            
            // let type = $(this).data('type');
            // let initValue = __read_number($('input.pos_unit_price').val());
            // let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
            let total = $('#start_number_old').val();
            
            $('input[name="'+name_input+'"]').val(total);
            // calculate_balance_due();
            // $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
            // calculate_balance_due();    
            // $('input.pos_unit_price').trigger('change');
            
            pattern_qty = ['0', '0', '0', '0'];
        });
    </script>
@endsection