@inject('request', 'Illuminate\Http\Request')
<!-- default value -->
@php
    $go_back_url = action([\App\Http\Controllers\SellPosController::class, 'index']);
    $transaction_sub_type = '';
    $view_suspended_sell_url = action([\App\Http\Controllers\SellController::class, 'index']).'?suspended=1';
    $pos_redirect_url = action([\App\Http\Controllers\SellPosController::class, 'create']);
    $salesCustomerScreen = $request->segment(1) == 'salesCustomerScreen' ? 'none' : '';
@endphp

@if(!empty($pos_module_data))
    @foreach($pos_module_data as $key => $value)
        @php
            if(!empty($value['go_back_url'])) {
                $go_back_url = $value['go_back_url'];
            }

            if(!empty($value['transaction_sub_type'])) {
                $transaction_sub_type = $value['transaction_sub_type'];
                $view_suspended_sell_url .= '&transaction_sub_type='.$transaction_sub_type;
                $pos_redirect_url .= '?sub_type='.$transaction_sub_type;
            }
        @endphp
    @endforeach
@endif
<input type="hidden" name="transaction_sub_type" id="transaction_sub_type" value="{{$transaction_sub_type}}">
@inject('request', 'Illuminate\Http\Request')
<div class="col-md-12 no-print pos-header" style="display: {{ $salesCustomerScreen }}">
  <input type="hidden" id="pos_redirect_url" value="{{$pos_redirect_url}}">
  <div class="container-screen-pos" id="pos-loader" style="display: none;">
    <div class="pos-loader">
      <div class="dot"></div>
      <div class="dot"></div>
      <div class="dot"></div>
    </div>  
  </div>
  <div class="row">
    <div class="col-md-6">

      <div style="float: left;">
      <a href="{{url('/home')}}" title="{{ __('lang_v1.go_back') }}" id="go-back-url" class="vh-pos-btn-home pull-right">
        <strong><i class="fa fa-house"></i>&nbsp; Dashboard</strong>
      </a>
          </div>

      <div class="m-6 mt-5" style="display: flex;">
        {{-- <p ><strong>@lang('sale.location'): &nbsp;</strong> --}}
          @if(empty($transaction->location_id))          
            {{-- @if(count($business_locations) > 1) --}}
            @if ($business_locations)              
              <div style="margin-bottom: 5px; margin-left: 10px;">
                {!! Form::select('select_location_id', $business_locations, $default_location->id ?? null , ['class' => 'vh-pos-btn-home',
                  'id' => 'select_location_id', 'style' => 'margin: 0;',
                  'required', 'autofocus'], $bl_attributes); !!}
              </div>
            @endif
          @else
            @if ($business_locations) 
              <div style="margin-bottom: 5px; margin-left: 10px;  width: 30%;">
                {!! Form::select('select_location_id', $business_locations, $location_id ?? null , ['class' => 'vh-pos-btn-home',
                  'id' => 'select_location_id', 'style' => 'margin: 0;  width: 100%',
                  'required', 'autofocus', 'disabled']); !!}
              </div>
            @endif
          @endif
          @if(empty($transaction->cash_register_list_id))
            @if($cash_register_list)
            <div style="margin-bottom: 5px;margin-left: 10px;">
               {!! Form::select('select_cash_registers_list', $cash_register_list, $default_cashier->id ?? null , ['class' => 'vh-pos-btn-home',
                'id' => 'select_cash_registers_list', 'style' => 'margin: 0;',
                'required', 'autofocus'], $bl_attributes); !!}
            </div>
            @else
              {{$default_cashier->name}}
            @endif
          @else
            @if($cash_register_list)
            <div style="margin-bottom: 5px;margin-left: 10px;">
              {!! Form::select('select_cash_registers_list', $cash_register_list, $default_cashier->id ?? null , ['class' => 'vh-pos-btn-home',
                'id' => 'select_cash_registers_list', 'style' => 'margin: 0;',
                'required', 'autofocus', 'disabled']); !!}
            </div>
            @else
              {{$default_cashier->name}}
            @endif
          @endif

          <div class="form-group" style="margin-left: 10px; width: 45%;">
            <div class="input-group">
              <!-- <span class="input-group-addon">
                <i class="fa fa-user"></i>
              </span> -->
              <input type="hidden" id="default_customer_id" 
              value="{{ $walk_in_customer['id'] ?? ''}}" >
              <input type="hidden" id="default_customer_name" 
              value="{{ $walk_in_customer['name'] ?? ''}}" >
              <input type="hidden" id="default_customer_balance" 
              value="{{ $walk_in_customer['balance'] ?? ''}}" >
              <input type="hidden" id="default_customer_address" 
              value="{{ $walk_in_customer['shipping_address'] ?? ''}}" >
              @if(!empty($walk_in_customer['price_calculation_type']) && $walk_in_customer['price_calculation_type'] == 'selling_price_group')
                <input type="hidden" id="default_selling_price_group" 
              value="{{ $walk_in_customer['selling_price_group_id'] ?? ''}}" >
              @endif
              {!! Form::select('contact_id', 
                [], null, ['class' => 'form-control mousetrap', 'id' => 'customer_id', 'placeholder' => 'Enter Customer name / phone', 'required']); !!}
              <span class="input-group-btn">
                <button type="button" class="btn btn-default bg-white btn-flat add_new_customer" data-name="" style="margin: 0;"  @if(!auth()->user()->can('customer.create')) disabled @endif><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
              </span>
            </div>
            {{-- <small class="text-danger hide contact_due_text"><strong>@lang('account.customer_due'):</strong> <span></span></small> --}}
            <small class="text-danger @if(empty($customer_due)) hide @endif contact_due_text"><strong>@lang('account.customer_due'):</strong> <span>{{$customer_due ?? ''}}</span></small>
          </div>

          {{-- @if(!empty($transaction->location_id)) {{$transaction->location->name}} @endif &nbsp;  --}}
          {{-- <span class="curr_datetime">{{ @format_datetime('now') }}</span>  --}}          
        </p>
      </div>
    </div>    

    <div class="col-md-6">      
      {{-- @if ($role_user_id == 2) --}}
        {{-- <a href="{{action([\App\Http\Controllers\Auth\LoginController::class, 'logout'])}}" class="btn btn-danger btn-flat m-6 btn-xs m-5 pull-right" title="{{ __('lang_v1.sign_out') }}">
          <strong><i class="fa fa-power-off"></i></strong>
        </a> --}}      
      {{-- @endif --}}      
      <div class="vh-pos-btn-profile-header dropdown user user-menu pull-right dropdown user user-menu" style="background-color: #f3b0b0;">
        <a href="#" class="vh-pos-btn-profile dropdown-toggle" style="font-size: 11px;" data-toggle="dropdown">
          @php
          $profile_photo = auth()->user()->media;
          @endphp
          @if(!empty($profile_photo))
            <img src="{{$profile_photo->display_url}}" class="user-image" alt="User Image" style="width: 18px; display: none;">
          @endif
          <input type="hidden" id="user_id_pos" value="{{ Auth::user()->id }}">
          <!-- hidden-xs hides the username on small devices so only the image appears. -->
          <span>{{ Auth::User()->first_name }} {{ Auth::User()->last_name }}</span>
        </a>      
        <ul class="dropdown-menu" style="width: 256px; background-color: #f3b0b0;">    
          <!-- The user image in the menu -->
          <li class="user-header" style="text-align: center;">
            @if(!empty(Session::get('business.logo')))
              <img src="{{ asset( 'uploads/business_logos/' . Session::get('business.logo') ) }}" alt="Logo" style="display: none;">
            @endif
            <p>
              {{ Auth::User()->first_name }} {{ Auth::User()->last_name }}
            </p>
          </li>
          <!-- Menu Body -->                          
          <!-- Menu Footer-->
          <li class="user-footer">
            <div class="pull-left">
              <a href="{{action([\App\Http\Controllers\UserController::class, 'getProfile'])}}" class="btn btn-default btn-flat" style="margin-left: 5px;">@lang('lang_v1.profile')</a>
            </div>
            <div class="pull-right">
              <a href="{{action([\App\Http\Controllers\Auth\LoginController::class, 'logout'])}}" id="btn_logout" class="btn btn-default btn-flat">@lang('lang_v1.sign_out')</a>
            </div>
          </li>
        </ul>
      </div>

     {{-- <a href="{{url('/home')}}" title="{{ __('lang_v1.go_back') }}" id="go-back-url" class="btn btn-info btn-flat m-6 btn-xs m-5 pull-right">
        <strong><i class="fa fa-backward fa-lg"></i></strong>
      </a> --}}


      @if(!empty($pos_settings['inline_service_staff']))
        <button type="button" id="show_service_staff_availability" title="{{ __('lang_v1.service_staff_availability') }}" class="btn btn-primary btn-flat m-6 btn-xs m-5 pull-right" data-container=".view_modal" 
          data-href="{{ action([\App\Http\Controllers\SellPosController::class, 'showServiceStaffAvailibility'])}}">
            <strong><i class="fa fa-users fa-lg"></i></strong>
        </button>
      @endif
      <button type="button" title="{{ __('lang_v1.full_screen') }}" class="vh-pos-btn-recnt-trnsc  m-6 hidden-xs btn-xs m-5 pull-right" id="full_screen">
            <strong><i class="fa fa-tv"></i>&nbsp;FuLL</strong>
      </button>

      @can('close_cash_register')
      <button type="button" id="close_register" title="{{ __('cash_register.close_register') }}" class="vh-pos-btn-recnt-trnsc m-6 btn-xs m-5 btn-modal pull-right" data-container=".close_register_modal" 
          data-href="{{ action([\App\Http\Controllers\CashRegisterController::class, 'getCloseRegister'])}}">
            <strong><i class="fa fa-window-close fa-lg"></i>&nbsp;Close Register</strong>
      </button>
      @endcan
      
      @can('view_cash_register')
      <button type="button" id="register_details" title="{{ __('cash_register.register_details') }}" class="vh-pos-btn-recnt-trnsc m-6 btn-xs m-5 btn-modal pull-right" data-container=".register_details_modal" 
          data-href="{{ action([\App\Http\Controllers\CashRegisterController::class, 'getRegisterDetails'])}}">
            <strong><i class="fa fa-briefcase fa-lg" aria-hidden="true"></i>&nbsp;Register Details</strong>
      </button>
      @endcan

      {{-- <button title="@lang('lang_v1.calculator')" id="btnCalculator" type="button" class="btn btn-success btn-flat pull-right m-5 btn-xs mt-10 popover-default" data-toggle="popover" data-trigger="click" data-content='@include("layouts.partials.calculator")' data-html="true" data-placement="bottom">
            <strong><i class="fa fa-calculator fa-lg" aria-hidden="true"></i></strong>
      </button> --}}

      {{--<button type="button" class="btn btn-danger btn-flat m-6 btn-xs m-5 pull-right popover-default" id="return_sale" title="@lang('lang_v1.sell_return')" data-toggle="popover" data-trigger="click" data-content='<div class="m-8"><input type="text" class="form-control" placeholder="@lang("sale.invoice_no")" id="send_for_sell_return_invoice_no"></div><div class="w-100 text-center"><button type="button" class="btn btn-danger" id="send_for_sell_return">@lang("lang_v1.send")</button></div>' data-html="true" data-placement="bottom">
            <strong><i class="fas fa-undo fa-lg"></i></strong>
      </button> --}}



      {{-- <button type="button" id="view_suspended_sales" 
           title="{{ __('lang_v1.view_suspended_sales') }}" 
           class="btn bg-yellow btn-flat m-6 btn-xs m-5 btn-modal pull-right" data-container=".view_modal" 
           data-href="{{$view_suspended_sell_url}}">
            <strong><i class="fa fa-pause-circle fa-lg"></i></strong>
      </button> --}}
      @if(empty($pos_settings['hide_product_suggestion']) && isMobile())
        <button type="button" title="{{ __('lang_v1.view_products') }}"   
          data-placement="bottom" class="btn btn-success btn-flat m-6 btn-xs m-5 btn-modal pull-right" data-toggle="modal" data-target="#mobile_product_suggestion_modal">
            <strong><i class="fa fa-cubes fa-lg"></i></strong>
        </button>
      @endif

      @if(Module::has('Repair') && $transaction_sub_type != 'repair')
        @include('repair::layouts.partials.pos_header')
      @endif

        @if(in_array('pos_sale', $enabled_modules) && !empty($transaction_sub_type))
          @can('sell.create')
            <a href="{{action([\App\Http\Controllers\SellPosController::class, 'create'])}}" title="@lang('sale.pos_sale')" class="btn btn-success btn-flat m-6 btn-xs m-5 pull-right">
              <strong><i class="fa fa-th-large"></i> &nbsp; @lang('sale.pos_sale')</strong>
            </a>
          @endcan
        @endif
        @can('expense.add')
        <!-- <button type="button" title="{{ __('expense.add_expense') }}"   
          data-placement="bottom" class="btn bg-purple btn-flat m-6 btn-xs m-5 btn-modal pull-right" id="add_expense">
            <strong><i class="fa fas fa-minus-circle"></i> @lang('expense.add_expense')</strong>
        </button> -->
        @endcan

        {{-- <div class="vh-pos-rightside-bottom-div">
                  <button type="button" class="vh-pos-btn-recnt-trnsc m-6 btn-xs m-5 pull-right popover-default" id="return_sale" title="@lang('lang_v1.sell_return')" data-toggle="popover" data-trigger="click" data-content='<div class="m-8"><input type="text" class="form-control" placeholder="@lang("sale.invoice_no")" id="send_for_sell_return_invoice_no"></div><div class="w-100 text-center"><button type="button" class="btn btn-danger" id="send_for_sell_return">@lang("lang_v1.send")</button></div>' data-html="true" data-placement="bottom">
                    <strong><i class="fas fa-undo fa-lg"></i> Sale Return </strong>
              </button>
        </div> --}}

       {{-- <div class="pull-right" style="margin-top: 20px;margin-right: 5px;">
        <div class="pull-right" style="margin-top: 20px;margin-right: 5px;">
          <i class="fa fa-keyboard hover-q text-muted" aria-hidden="true" data-container="body" data-toggle="popover" data-placement="bottom" data-content="@include('sale_pos.partials.keyboard_shortcuts_details')" data-html="true" data-trigger="hover" data-original-title="" title=""></i>
        </div>--}}

    </div>
    
  </div>
</div>
