@extends('layouts.app')
@section('title', __('report.register_report'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>{{ __('report.register_report')}}</h1>
</section>
<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'getStockReport']), 'method' => 'get', 'id' => 'register_report_filter_form' ]) !!}
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('business.business_location') . ':') !!}
                        {!! Form::select('location_id', $location, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('messages.all')]); !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('cash_register_list_id',  __('cash_register.cash_register_name') . ':') !!}
                        {!! Form::select('cash_register_list_id', $crl, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('messages.all')]); !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('register_user_id',  __('report.user') . ':') !!}
                        {!! Form::select('register_user_id', $users, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('report.all_users')]); !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('register_status',  __('sale.status') . ':') !!}
                        {!! Form::select('register_status', ['open' => __('cash_register.open'), 'close' => __('cash_register.close')], null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('report.all')]); !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('register_report_date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('register_report_date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'register_report_date_range', 'readonly']); !!}
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                @if ($payment_types)
                    @foreach ($payment_types as $key => $pt)                        
                        <input type="hidden" id="{{$key}}" value="{{$pt}}">
                    @endforeach
                @endif
                {{-- <table class="table table-bordered table-striped" id="register_report_table">
                    <thead>
                        <tr>
                            <th>@lang('report.open_time')</th>
                            <th>@lang('report.close_time')</th>
                            <th>@lang('sale.location')</th>
                            <th>@lang('cash_register.cash_register_name')</th>
                            <th>@lang('report.user')</th>
                            <!-- <th>@lang('cash_register.total_card_slips')</th> -->
                            @if ($payment_types['card'])
                                <th>{{$payment_types['card']}}</th>
                            @endif
                            <!-- <th>@lang('cash_register.total_cheques')</th> -->
                            @if ($payment_types['cheque'])                                
                                <th>{{$payment_types['cheque']}}</th>
                            @endif
                            <!-- <th>@lang('cash_register.total_cash')</th> -->
                            @if ($payment_types['cash'])                                
                                <th>{{$payment_types['cash']}}</th>
                            @endif
                            <!-- <th>@lang('lang_v1.total_bank_transfer')</th> -->
                            @if ($payment_types['bank_transfer'])                                
                                <th>{{$payment_types['bank_transfer']}}</th>
                            @endif
                            <th>@lang('lang_v1.total_advance_payment')</th>
                            @if ($payment_types['custom_pay_1'])                            
                                <th>{{$payment_types['custom_pay_1']}}</th>
                            @endif
                            @if ($payment_types['custom_pay_2'])
                                <th>{{$payment_types['custom_pay_2']}}</th>
                            @endif
                            @if ($payment_types['custom_pay_3'])
                                <th>{{$payment_types['custom_pay_3']}}</th>
                            @endif
                            @if ($payment_types['custom_pay_4'])                                
                                <th>{{$payment_types['custom_pay_4']}}</th>
                            @endif
                            @if ($payment_types['custom_pay_5'])                                
                                <th>{{$payment_types['custom_pay_5']}}</th>
                            @endif
                            @if ($payment_types['custom_pay_6'])                                
                                <th>{{$payment_types['custom_pay_6']}}</th>
                            @endif
                            @if ($payment_types['custom_pay_7'])                                
                                <th>{{$payment_types['custom_pay_7']}}</th>
                            @endif
                            <!-- <th>@lang('cash_register.other_payments')</th> -->
                            @if ($payment_types['other'])                                
                                <th>{{$payment_types['other']}}</th>
                            @endif
                            <th>@lang('sale.total')</th>
                            <th>@lang('messages.action')</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <td colspan="5"><strong>@lang('sale.total'):</strong></td>
                            @if ($payment_types['card'])                                
                                <td class="footer_total_card_payment"></td>
                            @endif
                            @if ($payment_types['cheque'])                                
                                <td class="footer_total_cheque_payment"></td>
                            @endif
                            @if ($payment_types['cash'])                                
                                <td class="footer_total_cash_payment"></td>
                            @endif
                            @if ($payment_types['bank_transfer'])                                
                                <td class="footer_total_bank_transfer_payment"></td>
                            @endif
                            <td class="footer_total_advance_payment"></td>
                            @if ($payment_types['custom_pay_1'])
                                <td class="footer_total_custom_pay_1"></td>                                
                            @endif
                            @if ($payment_types['custom_pay_2'])                                
                                <td class="footer_total_custom_pay_2"></td>
                            @endif
                            @if ($payment_types['custom_pay_3'])                                
                                <td class="footer_total_custom_pay_3"></td>
                            @endif
                            @if ($payment_types['custom_pay_4'])                                
                                <td class="footer_total_custom_pay_4"></td>
                            @endif
                            @if ($payment_types['custom_pay_5'])                                
                                <td class="footer_total_custom_pay_5"></td>
                            @endif
                            @if ($payment_types['custom_pay_6'])                                
                                <td class="footer_total_custom_pay_6"></td>
                            @endif
                            @if ($payment_types['custom_pay_7'])                                
                                <td class="footer_total_custom_pay_7"></td>
                            @endif
                            @if ($payment_types['other'])                                
                                <td class="footer_total_other_payments"></td>
                            @endif
                            <td class="footer_total"></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table> --}}
                <table class="table table-bordered table-striped" id="register_report_table" style="width: 100%;">
                    <thead>
                        <tr>
                            <th>@lang('report.open_time')</th>
                            <th>@lang('report.close_time')</th>
                            <th>@lang('sale.location')</th>
                            <th>@lang('cash_register.cash_register_name')</th>
                            <th>@lang('report.user')</th>
                            <th>@lang('cash_register.total_card_slips')</th>
                            <th>@lang('cash_register.total_cheques')</th>                            
                            <th>@lang('cash_register.total_cash')</th>     
                            <th>@lang('lang_v1.total_bank_transfer')</th>                                                   
                            <th>@lang('lang_v1.total_advance_payment')</th>
                            <th>{{$payment_types['custom_pay_1']}}</th>
                            <th>{{$payment_types['custom_pay_2']}}</th>
                            <th>{{$payment_types['custom_pay_3']}}</th>
                            <th>{{$payment_types['custom_pay_4']}}</th>
                            <th>{{$payment_types['custom_pay_5']}}</th>
                            <th>{{$payment_types['custom_pay_6']}}</th>
                            <th>{{$payment_types['custom_pay_7']}}</th>
                            <th>{{$payment_types['other']}}</th>                            
                            <th>@lang('sale.total')</th>
                            <th>@lang('messages.action')</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <td colspan="5"><strong>@lang('sale.total'):</strong></td>
                            <td class="footer_total_card_payment"></td>
                            <td class="footer_total_cheque_payment"></td>
                            <td class="footer_total_cash_payment"></td>
                            <td class="footer_total_bank_transfer_payment"></td>                            
                            <td class="footer_total_advance_payment"></td>
                            <td class="footer_total_custom_pay_1"></td>                                
                            <td class="footer_total_custom_pay_2"></td>
                            <td class="footer_total_custom_pay_3"></td>
                            <td class="footer_total_custom_pay_4"></td>
                            <td class="footer_total_custom_pay_5"></td>
                            <td class="footer_total_custom_pay_6"></td>
                            <td class="footer_total_custom_pay_7"></td>
                            <td class="footer_total_other_payments"></td>
                            <td class="footer_total"></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->
<div class="modal fade view_register" style="overflow-y: auto;" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>
<div class="modal fade z_report_modal" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>

@if (true)	
    <div class="numpad_div col-xs-12 hide" id="product_numpad_div1" data-type="cash" style="			
        /* display: flex; */
        /* align-items: center; */
        /* justify-content: center; */
        /* padding-right: 25px; */
        position: absolute;
        ">							
        <div class="form-group">									
            <div class="easy-numpad-number-container">
                <table id="product_numpad1">
                    <thead>						
                        <tr>
                            
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">1</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">2</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">3</a></td>							
                        </tr>
                        <tr>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">4</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">5</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">6</a></td>
                        </tr>
                        <tr>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">7</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">8</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">9</a></td>
                        </tr>						
                        <tr>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">0</a></td>														
                            <td style="padding: 10px;"><a href="#" class="numPadCashOtherClear" id="numPadCashOtherClear" style="padding: 10px ; width: 90px !important; height: 70px !important;">Clr</a></td>
                            <td style="padding: 10px;"><a href="#" class="numPadCashOtherDel" id="numPadCashOtherDel" style="padding: 10px ; width: 90px !important; height: 70px !important;">DEL</a></td>									
                        </tr>
                    </thead>
                </table>
            </div>									
        </div>							
    </div>
@endif

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
@endsection