@extends('layouts.app')
@section('title', __( 'report.sell_summary' ))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang( 'report.sell_summary' )
        <small>@lang( 'report.sell_summary_msg' )</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="print_section"><h2>{{session()->get('business.name')}} - @lang( 'report.sell_summary' )</h2></div>
    <div class="row no-print">
        <div class="col-md-3 col-md-offset-5 col-xs-6">
            <div class="input-group">
                <span class="input-group-addon bg-light-blue"><i class="fa fa-map-marker"></i></span>
                 <select class="form-control select2" id="sell_summary_location_filter">
                    @foreach($business_locations as $key => $value)
                        <option value="{{ $key }}">{{ $value }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-2 col-xs-3">
            <div class="form-group pull-right">
                <div class="input-group">
                  <button type="button" class="btn btn-primary" id="sell_summary_date_filter">
                    <span>
                      <i class="fa fa-calendar"></i> {{ __('messages.filter_by_date') }}
                    </span>
                    <i class="fa fa-caret-down"></i>
                  </button>
                </div>
            </div>
        </div>
        <div class="col-md-2 col-xs-6">
            <div class="input-group">
                <span class="input-group-addon bg-light-blue"><i class="fa fa-dollar-sign"></i></span>
                 <select class="form-control select2" id="sell_summary_payment_type_filter">                    
                    <option value="">Payment Type</option>                    
                    <option value="cash">Cash</option>                    
                    <option value="card">Card</option>                    
                </select>
            </div>
        </div>
    </div>
    <br>
    <div class="row">        
        <div class="col-xs-12">
            @component('components.widget', ['title' => __('sale.sells')])
                <table class="table table-striped">
                    <tr>
                        <th>{{ __('report.total_sale_without_tax') }}:</th>
                        <td>
                            <span class="total_sell_without_tax">
                                <i class="fas fa-sync fa-spin fa-fw"></i>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>{{ __('report.total_tax_amount') }}:</th>
                        <td>
                             <span class="total_tax_amount">
                                <i class="fas fa-sync fa-spin fa-fw"></i>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>{{ __('report.total_sell_inc_tax') }}:</th>
                        <td>
                            <span class="total_sell">
                                <i class="fas fa-sync fa-spin fa-fw"></i>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>{{ __('lang_v1.total_sell_return_inc_tax') }}:</th>
                        <td>
                             <span class="total_sell_return">
                                <i class="fas fa-sync fa-spin fa-fw"></i>
                            </span>
                        </td>
                    </tr>
                    {{-- <tr>
                        <th>{{ __('report.sell_due') }}: @show_tooltip(__('tooltip.sell_due'))</th>
                        <td>
                            <span class="sell_due">
                                <i class="fas fa-sync fa-spin fa-fw"></i>
                            </span>
                        </td>
                    </tr> --}}
                </table>
            @endcomponent
        </div>
    </div>	
    <div class="row">
        <div class="col-xs-12">
            @component('components.widget')
                @slot('title')
                    {{ __('lang_v1.overall') }} 
                    ((@lang('report.total_sell_inc_tax') - @lang('lang_v1.total_sell_return_inc_tax'))) 
                    {{-- @show_tooltip(__('tooltip.over_all_sell_purchase')) --}}
                @endslot
                <h3 class="text-muted">
                    {{ __('report.sale_total') }}: 
                    <span class="sale_total">
                        <i class="fas fa-sync fa-spin fa-fw"></i>
                    </span>
                </h3>                
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->
@stop
@section('javascript')
<script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>

@endsection
