<div class="modal-dialog" role="document">
	<div class="modal-content">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title" id="myModalLabel">{{$product->product_name}} - {{$product->sub_sku}}</h4>
		</div>
		<div class="modal-body">
			<div class="row">
				<div class="form-group col-xs-12 @if(!auth()->user()->can('edit_product_price_from_sale_screen')) hide @endif">
					@php
						$pos_unit_price = $product->tax_type == 'inclusive' ? $product->sell_price_inc_tax : $product->default_sell_price;
						$pos_unit_price = $product->default_sell_price;
						 
					@endphp
					<label>@lang('sale.unit_price')</label>						
						<input type="text" name="products[{{$row_count}}][unit_price]" class="form-control pos_unit_price input_number mousetrap" value="{{@num_format($pos_unit_price)}}" onfocus="show_numpad({{$row_count}},this.name, this, 'row_product_edit')" @if(!empty($pos_settings['enable_msp'])) data-rule-min-value="{{$pos_unit_price}}" data-msg-min-value="{{__('lang_v1.minimum_selling_price_error_msg', ['price' => @num_format($pos_unit_price)])}}" @endif>
						<input type="hidden" id="old_unit_price" value="{{number_format($pos_unit_price,2)}}">											
				</div>
				@if(!auth()->user()->can('edit_product_price_from_sale_screen'))
					<div class="form-group col-xs-12" onclick="hide_numpad({{$row_count}})">
						<strong>@lang('sale.unit_price'):</strong> {{@num_format(!empty($product->unit_price_before_discount) ? $product->unit_price_before_discount : $product->default_sell_price)}}
					</div>
				@endif
				@if(!empty($discount))
					<div class="form-group col-xs-12">
						<p class="help-block">{!! __('lang_v1.applied_discount_text', ['discount_name' => $discount->name, 'starts_at' => $discount->formated_starts_at, 'ends_at' => $discount->formated_ends_at, 'onclick' => "hide_numpad({$row_count})"]) !!}</p>
					</div>
				@endif
				<div class="form-group col-xs-12 col-sm-6 @if(!$edit_discount) hide @endif" onclick="hide_numpad({{$row_count}})">
					<label>@lang('sale.discount_type')</label>
						{!! Form::select("products[$row_count][line_discount_type]", ['fixed' => __('lang_v1.fixed'), 'percentage' => __('lang_v1.percentage')], $discount_type , ['class' => 'form-control row_discount_type', 'onclick' => "hide_numpad({$row_count})"]); !!}
				</div>
				<div class="form-group col-xs-12 col-sm-6 @if(!$edit_discount) hide @endif">
					<label>@lang('sale.discount_amount')</label>
						{!! Form::text("products[$row_count][line_discount_amount]", @num_format($discount_amount), ['class' => 'form-control input_number row_discount_amount', 'onfocus' => "show_numpad({$row_count}, this.name, this, 'row_product_edit')"]); !!}					
				</div>								
				<div class="form-group col-xs-12" onclick="hide_numpad({{$row_count}})">
					<div class="checkbox" style="margin: 0px 0px 0px 2px;">						
						<label style="margin-bottom: 10px;">
							{!! Form::checkbox("products[$row_count][item_tax]", 0, null , 
							[ 'class' => 'input-icheck checked_zero_tax' , 'onChange' => "getZeroTax($row_count, this)", 'onclick' => "hide_numpad({$row_count})"]); !!} {{ __( 'lang_v1.zero_tax' ) }}								
						</label>
					</div>					
				</div>
				<div class="form-group col-xs-12 {{$hide_tax}}" onclick="hide_numpad({{$row_count}})">
					<label>@lang('sale.tax')</label>

					{!! Form::hidden("products[$row_count][item_tax]", @num_format($item_tax), ['class' => 'item_tax']); !!}
		
					{!! Form::select("products[$row_count][tax_id]", $tax_dropdown['tax_rates'], $tax_id, ['placeholder' => 'Select', 'class' => 'form-control tax_id'], $tax_dropdown['attributes']); !!}
				</div>
				@if(!empty($warranties))
					<div class="form-group col-xs-12">
						<label>@lang('lang_v1.warranty')</label>
						{!! Form::select("products[$row_count][warranty_id]", $warranties, $warranty_id, ['placeholder' => __('messages.please_select'), 'class' => 'form-control', 'onclick' => "hide_numpad({$row_count})"]); !!}
					</div>
				@endif
				<div class="form-group col-xs-12">
		      		<label>@lang('lang_v1.description')</label>
		      		<textarea class="form-control" name="products[{{$row_count}}][sell_line_note]" rows="3" onclick="hide_numpad({{$row_count}})">{{$sell_line_note}}</textarea>
		      		<p class="help-block">@lang('lang_v1.sell_line_description_help')</p>
		      	</div>
			</div>
		</div>
		<div class="modal-footer">
			<button type="button" class="btn btn-default" data-dismiss="modal" onclick="hide_numpad({{$row_count}})">@lang('messages.apply')</button>
		</div>
	</div>
	{{-- Show Numpad if cash selected --}}
	{{-- @if (true)	
		<div class="numpad_div col-xs-12 hide" id="product_numpad_div{{$row_count}}" data-type="cash" style="
			/* display: flex;
			align-items: center;
			justify-content: center; */
			padding-right: 25px;
			position: absolute;
			top: 18%;
			right: 98%;
			width: 60%;">							
			<div class="form-group">									
				<div class="easy-numpad-number-container">
					<table id="product_numpad{{$row_count}}">
						<thead>						
							<tr>
								
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">1</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">2</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">3</a></td>							
							</tr>
							<tr>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">4</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">5</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">6</a></td>
							</tr>
							<tr>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">7</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">8</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">9</a></td>
							</tr>						
							<tr>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">0</a></td>														
								<td style="padding: 10px;"><a href="#" class="numPadCashOtherClear" id="numPadCashOtherClear" style="padding: 10px ; width: 90px !important; height: 70px !important;">Clr</a></td>
								<td style="padding: 10px;"><a href="#" class="numPadCashOtherDel" id="numPadCashOtherDel" style="padding: 10px ; width: 90px !important; height: 70px !important;">DEL</a></td>									
							</tr>
						</thead>
					</table>
				</div>									
			</div>							
		</div>
	@endif						 --}}
	{{-- END Show Numpad if cash selected --}}
</div>