@extends('layouts.app')
@section('title', __('sale.pos_sale'))
@section('css')
    <link rel="stylesheet" href="{{asset('css/splide.min.css')}}">
@endsection
@section('content')
<section class="content no-print">
<div class="row mb-12"> 
    <div class="col-md-12">
        <div class="row" style="margin-left:-5px;">	
            <input type="hidden" id="promotion_slider_speed" value="5000">
            <div class="col-sm-7" style="display: none;" id="location_picture_div">
                {{-- <img src="" id="location_picture1" style="margin-left: auto;margin-right: auto;display: block;width: 100%;height: 865px;"> --}}
                <div class="splide" role="group" aria-label="Splide Basic HTML Example">
                    <div class="splide__track">
                          <ul class="splide__list">
                              <li class="splide__slide" id="slider1"><img src="" id="location_picture1" style="margin-left: auto;margin-right: auto;display: block;width: 100%;height: 785px;"></li>
                              <li class="splide__slide" id="slider2"><img src="" id="location_picture2" style="margin-left: auto;margin-right: auto;display: block;width: 100%;height: 785px;"></li>
                              <li class="splide__slide" id="slider3"><img src="" id="location_picture3" style="margin-left: auto;margin-right: auto;display: block;width: 100%;height: 785px;"></li>
                          </ul>
                    </div>
                  </div>
                <table style="width: 100%;border: 1px solid;height: 145px;background: #fff;" id="box_signature">
                    <tr>
                        <td style="width: 75%;border: 1px solid #0000007e; padding: 10px;"></td>
                        <td style="border: 1px solid #0000007e; padding: 10px;" onclick="getDataUrl()">
                            <canvas id="signature-pad" width="250" height="100"></canvas>
                        </td>
                        <td style="padding: 5px; background: #f3b0b0; color: #333; width: 5%;" id="clear-signature" onclick="remove_signature()">Clear</td>
                    </tr>
                </table>
            </div>
            <div class="col-sm-12 vh-pos-leftside-productdiv" id="product_div" style="background: #fff; border-radius: 10px; padding: 0; min-height: 90vh !important;">                
                <!-- Keeps count of product rows -->
                <input type="hidden" id="product_row_count" 
                    value="0">
                @php
                    $hide_tax = '';
                    if( session()->get('business.enable_inline_tax') == 0){
                        $hide_tax = 'hide';
                    }
                @endphp
                <table class="table table-condensed table-bordered table-striped table-responsive" id="pos_table" style="border-radius: 12px; background: #e6e6fd;">
                    <thead>
                        <tr>
                            <th colspan="3" class="text-center col-md-12" style="font-size: large;" id="default_location_name"></th>
                        </tr>
                        <tr>
                            <th class="text-center col-md-4" style="font-size: large;">	
                                @lang('sale.product') 
                                {{-- @show_tooltip(__('lang_v1.tooltip_sell_product_column')) --}}
                            </th>
                            <th class="text-center col-md-4" style="font-size: large;">
                                @lang('sale.qty')
                            </th>
                            {{-- @if(!empty($pos_settings['inline_service_staff']))
                                <th class="text-center col-md-2">
                                    @lang('restaurant.service_staff')
                                </th>
                            @endif --}}
                            {{-- <th class="text-center col-md-2 {{$hide_tax}}">
                                @lang('sale.price_inc_tax')
                            </th> --}}
                            <th colspan="2" class="text-center col-md-4" style="font-size: large;">
                                @lang('sale.subtotal')
                            </th>
                            {{-- <th class="text-center"><i class="fas fa-times" aria-hidden="true"></i></th> --}}
                        </tr>
                    </thead>
                    <tbody id="body_table"></tbody>
                </table>
                <div style="position: absolute; bottom: 0; padding: 10px;">
                    <table id="footer" class="table table-condensed table-bordered table-striped table-responsive" style="width: 100%; bottom: 0;">
                        <tr>
                            <td colspan="2" style="width: 6%;">&nbsp;</td>
                            <td style="font-size: large; font-weight: 600; text-align: right;">Sub Total:&nbsp;</td>
                            <td style="text-align: right; font-size: large; font-weight: 600; width: 5%;" id="sub_total_price"></td>
                        </tr>                        
                        <tr>
                            <td colspan="2">&nbsp;</td>
                            <td style="font-size: large; font-weight: 600; text-align: right;">Tax:&nbsp;</td>
                            <td style="text-align: right; font-size: large; font-weight: 600;" id="total_sales_tax"></td>
                        </tr>
                        <tr>
                            <td style="font-size: large; font-weight: 600;">Item:&nbsp;</td>
                            <td id="total_item" style="text-align: right; font-size: large; font-weight: 600;"></td>
                            <td style="font-size: large; font-weight: 600; text-align: right;">Total:&nbsp;</td>
                            <td style="text-align: right; font-size: large; font-weight: 600;" id="total_price"></td>
                        </tr>
                    </table> 
                </div>
                               
            </div>
        </div>
        
			
		
    </div>
</div>
</section>
@stop
@section('javascript')
<script src="{{asset('js/signature_pad.js')}}"></script>
<script src="{{asset('js/splide.min.js')}}"></script>
<script>
    var signaturePad;
    localStorage.setItem('signature-customer', JSON.stringify([]));
    $(document).ready(function() {        
        $('#location_picture_div').css('display', 'none');
        $('#product_div').removeClass('col-sm-5');
        $('#product_div').addClass('col-sm-12'); 

        window.addEventListener('storage', (event) => {
            // console.log('Storage event detected:', event);            
            // console.log(event);        
            // Check the changed key and react accordingly            
            if (event.key === 'cart') {
                // console.log('event.key')
                var jsonArray = JSON.parse(event.newValue);
                var jsonArrayLocation = JSON.parse(event.newValue);            
                // console.log(jsonArray[0].product);          
                $('#body_table').html('');
                if(jsonArray) {
                    // console.log('masuk list cart if')
                    if(jsonArray.length > 0) {
                        // console.log('masuk list cart ada')
                        // console.log('event cart is not empty')
                        $.each(jsonArray, function(k,v) {
                            $('#body_table').append(`
                                <tr id="${k+1}">
                                    <td class="text-center" style="font-size: large;">${v.product}</td>
                                    <td class="text-center" style="font-size: large;">${v.qty}</td>
                                    <td colspan="2" class="text-center" style="font-size: large;">${v.subtotal}</td>
                                </tr>
                            `)                
                        });
                        $('#product_div').css('display', 'block');      
                        $('#product_div').removeClass('col-sm-12');      
                        $('#product_div').addClass('col-sm-5');      
                        $('#location_picture_div').removeClass('col-sm-12');
                        $('#location_picture_div').addClass('col-sm-7');

                        if(jsonArrayLocation[0].required_signature == '0') {
                            $('#box_signature').css('display', 'none');
                            setTimeout(() => {                            
                                $('#location_picture1').css('height', '934px');
                                $('#location_picture2').css('height', '934px');
                                $('#location_picture3').css('height', '934px');
                            }, 100);
                        } else {
                            $('#box_signature').css('display', '');
                            setTimeout(() => {                                                            
                                $('#location_picture1').css('height', '785px');
                                $('#location_picture2').css('height', '785px');
                                $('#location_picture3').css('height', '785px');
                            }, 100);
                        }
                    } else {
                        // console.log('masuk list cart ga ada')                        
                        $('#location_picture_div').css('display', 'block');
                        $('#location_picture_div').css('display', 'block');
                        $('#product_div').css('display', 'none');
                        $('#location_picture_div').removeClass('col-sm-7');
                        $('#location_picture_div').addClass('col-sm-12');
                        $('#box_signature').css('display', '');
                        setTimeout(() => {                                                            
                            $('#location_picture1').css('height', '785px');
                            $('#location_picture2').css('height', '785px');
                            $('#location_picture3').css('height', '785px');
                        }, 100);
                        /* if(jsonArrayLocation[0].required_signature == '0') {
                            $('#box_signature').css('display', 'none');
                            setTimeout(() => {                            
                                $('#location_picture1').css('height', '934px');
                                $('#location_picture2').css('height', '934px');
                                $('#location_picture3').css('height', '934px');
                            }, 100);
                        } else {
                        } */
                    }
                } else {
                    // console.log('masuk list cart else')
                    $('#location_picture_div').css('display', 'block');
                    $('#location_picture_div').removeClass('col-sm-7');
                    $('#location_picture_div').addClass('col-sm-12');
                    $('#product_div').css('display', 'none');

                    if(jsonArrayLocation[0].required_signature == '0') {
                        $('#box_signature').css('display', 'none');
                        setTimeout(() => {                                                            
                            $('#location_picture1').css('height', '934px');
                            $('#location_picture2').css('height', '934px');
                            $('#location_picture3').css('height', '934px');
                        }, 100);
                    } else {
                        $('#box_signature').css('display', '');
                        setTimeout(() => {                                                            
                            $('#location_picture1').css('height', '785px');
                            $('#location_picture2').css('height', '785px');
                            $('#location_picture3').css('height', '785px');
                        }, 100);
                    }
                }

            }
                        
            if(event.key === 'location_picture') {
                var jsonArrayLocation = JSON.parse(event.newValue);
                if(jsonArrayLocation) {
                    // console.log('masuk list location_picture ')                    
                    // console.log(jsonArrayLocation[0].location_picture);
                    $('#total_item').html(jsonArrayLocation[0].items+"&nbsp");
                    $('#total_price').html("$"+jsonArrayLocation[0].total+"&nbsp");
                    $('#sub_total_price').html("$"+jsonArrayLocation[0].sub_total+"&nbsp");
                    $('#total_discount').html("$"+jsonArrayLocation[0].discount+"&nbsp");
                    $('#total_sales_tax').html("$"+jsonArrayLocation[0].sales_tax+"&nbsp");
                    $('#default_location_name').html(jsonArrayLocation[0].location_name);
                    $('#promotion_slider_speed').val(parseInt(jsonArrayLocation[0].promotion_slider_speed) * 1000);                    
                    if(jsonArrayLocation[0].required_signature == '0') {
                        $('#box_signature').css('display', 'none');
                        setTimeout(() => {                                                            
                            $('#location_picture1').css('height', '934px');
                            $('#location_picture2').css('height', '934px');
                            $('#location_picture3').css('height', '934px');
                        }, 100);
                    } else {
                        $('#box_signature').css('display', '');
                        setTimeout(() => {                                                            
                            $('#location_picture1').css('height', '785px');
                            $('#location_picture2').css('height', '785px');
                            $('#location_picture3').css('height', '785px');
                        }, 100);
                    }
                                        
                    
                    if(jsonArrayLocation[0].location_picture) {
                        // console.log('masuk picture adaan ')
                        $('#location_picture_div').css('display', 'block');
                        $('#product_div').removeClass('col-sm-12');
                        $('#product_div').addClass('col-sm-5');
                        
                        var public_path = '{{asset('img/picture_location/')}}';                              
                        if(Object.keys(jsonArrayLocation[0].location_picture[0]).some(key => key === 'picture1')) {
                            if($('#splide01-list li').length == 1) {
                                $('#splide01-list li:first').remove();
                            } else {
                                $('#splide01-list li:last').remove();
                            }
                            // $('#location_picture1').attr('src', public_path+'/'+jsonArrayLocation[0].location_picture[0].picture1);
                            $('.splide__list').append(`
                                <li class="splide__slide" id="slider1"><img src="${public_path+'/'+jsonArrayLocation[0].location_picture[0].picture1}" id="location_picture1" style="margin-left: auto;margin-right: auto;display: block;width: 100%;height: 785px;"></li>
                            `)
                        } else {
                            if($('#splide01-list li').length == 1) {
                                $('#splide01-list li:first').remove();
                            } else {
                                $('#splide01-list li:last').remove();
                            }                            
                        }                        
                        if(Object.keys(jsonArrayLocation[0].location_picture[0]).some(key => key === 'picture2')) {
                            if($('#splide01-list li').length <= 2) {
                                $('#splide01-list li:eq(1)').remove();
                            } else {
                                $('#splide01-list li:last').remove();
                            }
                            $('.splide__list').append(`
                                <li class="splide__slide" id="slider2"><img src="${public_path+'/'+jsonArrayLocation[0].location_picture[0].picture2}" id="location_picture2" style="margin-left: auto;margin-right: auto;display: block;width: 100%;height: 785px;"></li>
                            `)                                                        
                        } else {
                            if($('#splide01-list li').length <= 2) {
                                $('#splide01-list li:eq(1)').remove();
                            } else {
                                $('#splide01-list li:last').remove();
                            }
                        }
                        if(Object.keys(jsonArrayLocation[0].location_picture[0]).some(key => key === 'picture3')) {                            
                            if($('#splide01-list li').length <= 3) {
                                $('#splide01-list li:eq(2)').remove();
                            } else {
                                $('#splide01-list li:last').remove();
                            }
                            $('ul.splide__list').append(`
                                <li class="splide__slide" id="slider3"><img src="${public_path+'/'+jsonArrayLocation[0].location_picture[0].picture3}" id="location_picture3" style="margin-left: auto;margin-right: auto;display: block;width: 100%;height: 785px;"></li>
                            `)                                                        
                        } else {
                            if($('#splide01-list li').length <= 3) {
                                $('#splide01-list li:eq(2)').remove();
                            } else {
                                $('#splide01-list li:last').remove();                                
                            }
                        }
                        // console.log( $('#promotion_slider_speed').val());
                        
                        var splide = new Splide( '.splide', {                                                                                   
                            pagination: false,     
                            perPage: 1,                       
                            drag: false,
                            autoplay: true,
                            arrows: false,
                            interval: $('#promotion_slider_speed').val(),     
                            rewind: true         
                        });
                        splide.mount();
                    } else {
                        // console.log('masuk picture ga ada ')
                        $('#location_picture_div').css('display', 'none');
                        $('#product_div').removeClass('col-sm-5');
                        $('#product_div').addClass('col-sm-12');                        
                    }
                }
            }

            if(event.key === 'signature-customer') {
                if(event.newValue == '[]') {
                    signaturePad.clear();
                }    
            }
        });

        var cart = localStorage.getItem('cart');
        // console.log(cart)
        if(cart.length > 2) {            
            var jsonArray = JSON.parse(cart);            
            // console.log(jsonArray[0].product);          
            $('#body_table').html('');
            if(jsonArray) {                              
                if(jsonArray.length > 0) {
                    // console.log('masuk json array cart awal');  
                    $.each(jsonArray, function(k,v) {
                        $('#body_table').append(`
                            <tr id="${k+1}">
                                <td class="text-center" style="font-size: large;">${v.product}</td>
                                <td class="text-center" style="font-size: large;">${v.qty}</td>
                                <td class="text-center" style="font-size: large;">${v.subtotal}</td>
                            </tr>
                        `)                
                    });
                    $('#product_div').css('display', 'block');  
                } else {                    
                    var location_picture = JSON.parse(localStorage.getItem('location_picture'));
                    var public_path = '{{asset('img/picture_location/')}}';            
                    $('#promotion_slider_speed').val(parseInt(location_picture[0].promotion_slider_speed) * 1000);
                    if(location_picture[0].location_picture[0].picture1) {
                        $('#location_picture1').attr('src', public_path+'/'+location_picture[0].location_picture[0].picture1);
                    } else {
                        $('#location_picture1').attr('src', public_path+'/no_img.png');
                    }
                    if(location_picture[0].location_picture[0].picture2) {
                        $('#location_picture2').attr('src', public_path+'/'+location_picture[0].location_picture[0].picture2);                       
                    } else {
                        $('#slider2').remove();
                    }
                    if(location_picture[0].location_picture[0].picture3) {
                        $('#location_picture3').attr('src', public_path+'/'+location_picture[0].location_picture[0].picture3);
                    } else {
                        $('#slider3').remove();
                    }
                    $('#location_picture_div').css('display', 'block');
                    $('#location_picture_div').removeClass('col-sm-7');
                    $('#location_picture_div').addClass('col-sm-12');
                    $('#product_div').css('display', 'none');
                }
            } else {                
                var location_picture = JSON.parse(localStorage.getItem('location_picture'));
                var public_path = '{{asset('img/picture_location/')}}';
                $('#promotion_slider_speed').val(parseInt(location_picture[0].promotion_slider_speed) * 1000);
                /* if(location_picture[0].required_signature == '0') {
                    $('#box_signature').css('display', 'none');
                    $('#location_picture1').css('height', '934px');
                    $('#location_picture2').css('height', '934px');
                    $('#location_picture3').css('height', '934px');
                } else {
                    $('#box_signature').css('display', 'block');
                    $('#location_picture1').css('height', '785px');
                    $('#location_picture2').css('height', '785px');
                    $('#location_picture3').css('height', '785px');
                } */
                if(location_picture[0].location_picture[0].picture1) {
                    $('#location_picture1').attr('src', public_path+'/'+location_picture[0].location_picture[0].picture1);
                } else {
                    $('#location_picture1').attr('src', public_path+'/no_img.png');
                }
                if(location_picture[0].location_picture[0].picture2) {
                    $('#location_picture2').attr('src', public_path+'/'+location_picture[0].location_picture[0].picture2);
                } else {
                    $('#slider2').remove();
                }
                if(location_picture[0].location_picture[0].picture3) {
                    $('#location_picture3').attr('src', public_path+'/'+location_picture[0].location_picture[0].picture3);
                } else {
                    $('#slider3').remove();
                }
                $('#default_location_name').html(location_picture[0].location_name);
                $('#location_picture_div').css('display', 'block');
                $('#location_picture_div').removeClass('col-sm-7');
                $('#location_picture_div').addClass('col-sm-12');
                $('#product_div').css('display', 'none');
            }

            var jsonArrayLocation = JSON.parse(localStorage.getItem('location_picture'));
            // console.log(jsonArrayLocation);
            $('#total_item').html(jsonArrayLocation[0].items+"&nbsp");
            $('#total_price').html("$"+jsonArrayLocation[0].total+"&nbsp");
            $('#sub_total_price').html("$"+jsonArrayLocation[0].sub_total+"&nbsp");
            $('#total_discount').html("$"+jsonArrayLocation[0].discount+"&nbsp");
            $('#total_sales_tax').html("$"+jsonArrayLocation[0].sales_tax+"&nbsp");
            $('#default_location_name').html(jsonArrayLocation[0].location_name);
            $('#promotion_slider_speed').val(parseInt(jsonArrayLocation[0].promotion_slider_speed) * 1000);
            if(jsonArrayLocation[0].required_signature == '0') {
                $('#box_signature').css('display', 'none');
                $('#location_picture1').css('height', '934px');
                $('#location_picture2').css('height', '934px');
                $('#location_picture3').css('height', '934px');
            } else {
                $('#box_signature').css('display', '');
                $('#location_picture1').css('height', '785px');
                $('#location_picture2').css('height', '785px');
                $('#location_picture3').css('height', '785px');
            }

            if(jsonArrayLocation[0].location_picture) {
                $('#location_picture_div').css('display', 'block');
                $('#product_div').removeClass('col-sm-12');
                $('#product_div').addClass('col-sm-5');
                var public_path = '{{asset('img/picture_location/')}}';
                if(jsonArrayLocation[0].location_picture[0].picture1) {
                    $('#location_picture1').attr('src', public_path+'/'+jsonArrayLocation[0].location_picture[0].picture1);
                } else {
                    $('#location_picture1').attr('src', public_path+'/no_img.png');
                }
                if(jsonArrayLocation[0].location_picture[0].picture2) {
                    $('#location_picture2').attr('src', public_path+'/'+jsonArrayLocation[0].location_picture[0].picture2);
                } else {
                    $('#slider2').remove();
                }
                if(jsonArrayLocation[0].location_picture[0].picture3) {
                    $('#location_picture3').attr('src', public_path+'/'+jsonArrayLocation[0].location_picture[0].picture3);
                } else {
                    $('#slider3').remove();
                }

                var splide = new Splide( '.splide', {            
                    perPage: 1,
                    pagination: false,                    
                    drag: false,
                    autoplay: true,
                    arrows: false,
                    interval: $('#promotion_slider_speed').val(),     
                    rewind: true             
                });
                splide.mount();
    
            } else {
                $('#location_picture_div').css('display', 'none');
                $('#product_div').removeClass('col-sm-5');
                $('#product_div').addClass('col-sm-12');
                // $('#default_location_name').html(location_picture[0].location_name);
            }

            
        } else {                        
            var location_picture = JSON.parse(localStorage.getItem('location_picture'));
            var public_path = '{{asset('img/picture_location/')}}'; 
            $('#default_location_name').html(location_picture[0].location_name);
            $('#promotion_slider_speed').val(parseInt(location_picture[0].promotion_slider_speed) * 1000);
            if(location_picture[0].required_signature == '0') {
                $('#box_signature').css('display', 'none');
                $('#location_picture1').css('height', '934px');
                $('#location_picture2').css('height', '934px');
                $('#location_picture3').css('height', '934px');
            } else {
                $('#box_signature').css('display', '');
                $('#location_picture1').css('height', '785px');
                $('#location_picture2').css('height', '785px');
                $('#location_picture3').css('height', '785px');
            }
            if(location_picture[0].location_picture.length > 0) {
                if(location_picture[0].location_picture[0].picture1) {
                    $('#location_picture1').attr('src', public_path+'/'+location_picture[0].location_picture[0].picture1);
                } else {
                    $('#location_picture1').attr('src', public_path+'/no_img.png');
                }
                if(location_picture[0].location_picture[0].picture2) {
                    $('#location_picture2').attr('src', public_path+'/'+location_picture[0].location_picture[0].picture2);
                } else {
                    $('#slider2').remove();
                }
                if(location_picture[0].location_picture[0].picture3) {
                    $('#location_picture3').attr('src', public_path+'/'+location_picture[0].location_picture[0].picture3);
                } else {
                    $('#slider3').remove();
                }
                // $('#default_location_name').html(location_picture[0].location_name);
                $('#location_picture_div').css('display', 'block');
                $('#location_picture_div').removeClass('col-sm-7');
                $('#location_picture_div').addClass('col-sm-12');
                $('#product_div').css('display', 'none');

                var splide = new Splide( '.splide', {            
                    perPage: 1,
                    pagination: false,                    
                    drag: false,
                    autoplay: true,
                    arrows: false,
                    interval: $('#promotion_slider_speed').val(),     
                    rewind: true             
                });
                splide.mount();
                                
            } else {
                $('#location_picture_div').css('display', 'none');
                $('#location_picture_div').removeClass('col-sm-12');
                $('#location_picture_div').addClass('col-sm-7');
                $('#product_div').css('display', 'block');
            }
        }

        

        // document.addEventListener( 'DOMContentLoaded', function() {                       
        // });

        var canvas = document.getElementById("signature-pad");
    
        function resizeCanvas() {
            var ratio = Math.max(window.devicePixelRatio || 1, 1);
            canvas.width = canvas.offsetWidth * ratio;
            canvas.height = canvas.offsetHeight * ratio;
            canvas.getContext("2d").scale(ratio, ratio);
        }
        window.onresize = resizeCanvas;
        resizeCanvas();
    
        signaturePad = new SignaturePad(canvas, {
            backgroundColor: 'rgb(250,250,250)'
        });                                        

    });
        
    /*  */

    function remove_signature() {        
        signaturePad.clear();
        localStorage.setItem('signature-customer', JSON.stringify([]));        
    }
    function getDataUrl() {        
        var image = signaturePad.toDataURL('image/png', 100);
        var newimage = image.replace('data:image/png;base64,', '');
        localStorage.setItem('signature-customer', JSON.stringify(newimage));                        
    }

</script>
@endsection