@extends('layouts.app')
@section('title', __( 'tax_rate.tax_rates' ))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang( 'tax_rate.tax_rates' )
        <small>@lang( 'tax_rate.manage_your_tax_rates' )</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => __( 'tax_rate.all_your_tax_rates' )])
        @can('tax_rate.create')
            @slot('tool')
                <div class="box-tools">
                    <button type="button" class="btn btn-block btn-primary btn-modal" 
                            data-href="{{action([\App\Http\Controllers\TaxRateController::class, 'create'])}}" 
                            data-container=".tax_rate_modal">
                            <i class="fa fa-plus"></i> @lang( 'messages.add' )</button>
                </div>
            @endslot
        @endcan
        @can('tax_rate.view')
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="tax_rates_table">
                    <thead>
                        <tr>
                            <th>@lang( 'tax_rate.name' )</th>
                            <th>@lang( 'tax_rate.rate' )</th>
                            <th>@lang( 'messages.action' )</th>
                        </tr>
                    </thead>
                </table>
            </div>
        @endcan
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        @slot('title')
            @lang( 'tax_rate.tax_groups' ) ( @lang('lang_v1.combination_of_taxes') ) @show_tooltip(__('tooltip.tax_groups'))
        @endslot
        @can('tax_rate.create')
            @slot('tool')
                <div class="box-tools">
                    <button type="button" class="btn btn-block btn-primary btn-modal" 
                    data-href="{{action([\App\Http\Controllers\GroupTaxController::class, 'create'])}}" 
                    data-container=".tax_group_modal">
                    <i class="fa fa-plus"></i> @lang( 'messages.add' )</button>
                </div>
            @endslot
        @endcan
        @can('tax_rate.view')
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="tax_groups_table">
                    <thead>
                        <tr>
                            <th>@lang( 'tax_rate.name' )</th>
                            <th>@lang( 'tax_rate.rate' )</th>
                            <th>@lang( 'tax_rate.sub_taxes' )</th>
                            <th>@lang( 'messages.action' )</th>
                        </tr>
                    </thead>
                </table>
            </div>
        @endcan
    @endcomponent
    
    <div class="modal fade tax_rate_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>
    <div class="modal fade tax_group_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->
@endsection
@section('javascript')
    <script>
        var pattern = ['0', '0', '0', '.', '0', '0'];
        var typeCash = null;
        $(document).on('click', '.numPadCash', function(e) {
			// var type_input = $(this).parent().parent().parent().parent().parent().parent().data('type');    
			name_input = 'amount';
			e.preventDefault();
			let type = $(this).data('type');
			// empty_denomination()
			let curValue;
			switch ($(this).text()) {
				case '00':            
					if(pattern[0] == '0' && pattern[1] == '0') {                
						pattern[pattern.length - 6] = pattern[pattern.length - 5];
						pattern[pattern.length - 5] = pattern[pattern.length - 4];
						pattern[pattern.length - 4] = pattern[pattern.length - 2];
						pattern[pattern.length - 2] = pattern[pattern.length - 1];
						pattern[pattern.length - 1] = '0';            
						
						pattern[pattern.length - 6] = pattern[pattern.length - 5];
						pattern[pattern.length - 5] = pattern[pattern.length - 4];
						pattern[pattern.length - 4] = pattern[pattern.length - 2];
						pattern[pattern.length - 2] = pattern[pattern.length - 1];
						pattern[pattern.length - 1] = '0';                                            
					}

					//// console.log("pattern");
					//// console.log(pattern);

					curValue = pattern.join('');
					if (pattern[0] == '0' && pattern[1] == '0') {
						//// console.log("basta 2 sifir");
						$('input[name="'+name_input+'"]').val(curValue.substring(2));
					} else if (pattern[0] == '0') {
						//// console.log("basta 1 sifir");
						$('input[name="'+name_input+'"]').val(curValue.substring(1));
					} else {
						// console.log('pattern[0] != 0');
						//$("input[name="'+name_input+'"]"_"+row_index).val(curValue);
						let row_index = $('#payment_row_index').val();
						$('input[name="'+name_input+'"]').val(curValue);
					}

					// $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))

					// calculate_balance_due();
					$('input.amount').trigger('change');
					break;

				default:            
					if (!$('input[name="'+name_input+'"').val()) {
						let last = pattern.findLastIndex((element) => (element = '0'));
						pattern[last] = document.getElementsByClassName('payment-amount').innerText;
						// console.log('pattern[last] : ' + pattern[last]);
						curValue = pattern.join('');

						if (pattern[0] == '0' && pattern[1] == '0') {
							// console.log('basta 2 sifir');
							$('input[name="'+name_input+'"]').val(curValue.substring(2));
						} else if (pattern[0] == '0') {
							// console.log('basta 1 sifir');
							$('input[name="'+name_input+'"]').val(curValue.substring(1));
						} else {
							// console.log('pattern[0] != 0');
							$('input[name="'+name_input+'"]').val(curValue);
						}
						// calculate_balance_due();
						$('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
						// calculate_balance_due();
						$('input.pos_unit_price').trigger('change');
					} else {
						// // console.log('2541');
						if(type == 'top') {                    
							pattern[pattern.length - 6] = '0';
							pattern[pattern.length - 5] = '0';
							pattern[pattern.length - 4] = $(this).text();
							pattern[pattern.length - 2] = '0';
							pattern[pattern.length - 1] = '0';    
							typeCash = 'top';                                                                            
						} else {         
							if(typeCash == 'top') {                                              
								pattern[pattern.length - 6] = 0;
								pattern[pattern.length - 5] = 0;
								pattern[pattern.length - 4] = 0;                        
							} else {                        
								pattern[pattern.length - 6] = pattern[pattern.length - 5];
								pattern[pattern.length - 5] = pattern[pattern.length - 4];                        
								pattern[pattern.length - 4] = pattern[pattern.length - 2];                        
							}
							pattern[pattern.length - 2] = pattern[pattern.length - 1];
							pattern[pattern.length - 1] = $(this).text();
							typeCash = 'middle';       
						}

						curValue = pattern.join('');

						if (pattern[0] == '0' && pattern[1] == '0') {
							// console.log('basta 2 sifir');
							//$("#amount_"+row_index).val(curValue.substring(2));

							$('input[name="'+name_input+'"]').val(curValue.substring(2));
						} else if (pattern[0] == '0') {
							$('input[name="'+name_input+'"]').val(curValue.substring(1));
						} else {
							$('input[name="'+name_input+'"]').val(curValue);
						}
						// calculate_balance_due();
						// $('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
						// calculate_balance_due();
						$('input.amount').trigger('change');
					}

				break;
			}

			$('input#amount').trigger('change');
		})

		$(document).on('click', '.numPadCashDel', function (e) {
			//PALIGU
			e.preventDefault();
			let curValue;
			// var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');
			name_input = 'amount';   
			let type = $(this).data('type');
			
			pattern[pattern.length - 1] = pattern[pattern.length - 2];
			pattern[pattern.length - 2] = pattern[pattern.length - 4];
			pattern[pattern.length - 4] = pattern[pattern.length - 5];
			pattern[pattern.length - 5] = pattern[pattern.length - 6];
			pattern[pattern.length - 6] = '0';

			curValue = pattern.join('');
			if (pattern[0] == '0' && pattern[1] == '0') {
				//// console.log("basta 2 sifir");
				$('input[name="'+name_input+'"]').val(curValue.substring(2));
			} else if (pattern[0] == '0') {
				//// console.log("basta 1 sifir");
				$('input[name="'+name_input+'"]').val(curValue.substring(1));
			} else {
				//// console.log("pattern[0] != 0");
				$('input[name="'+name_input+'"]').val(curValue);
			}
			
			$('.pos_line_total_text').text(__currency_trans_from_en(curValue, true))
			if (Number(curValue) == 0) {        
				let total = "0.00";
				$('input[name="'+name_input+'"]').val(total);        
				// calculate_balance_due();
				// $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
			}
			// calculate_balance_due();
			// $('input.pos_unit_price').trigger('change');
			$('input#amount').trigger('change');
		});

		$(document).on('click', '.numPadCashClear', function (e) {
			//PALIGU    
			e.preventDefault();
			// var type_input = $(this).parent().parent().parent().parent().parent().parent().parent().data('type');    
			name_input = 'amount';
			let total = $('#amount_old').val() ? $('#amount_old').val() : "0.00";    
			let type = $(this).data('type');
			// let initValue = __read_number($('input.pos_unit_price').val());
			// let total = __read_number($('input[name="products['+row_index+'][unit_price_inc_tax]"]'));
			
			$('input[name="'+name_input+'"]').val(total);
			// calculate_balance_due();
			// $('.pos_line_total_text').text(__currency_trans_from_en(total, true))
			// calculate_balance_due();    
			// $('input.pos_unit_price').trigger('change');
			
			pattern = ['0', '0', '0', '.', '0', '0'];
			$('input#amount').trigger('change');
		});
    </script>
@endsection
