<?php $request = app('Illuminate\Http\Request'); ?>
<!-- Main Header -->
  <header class="main-header no-print">
    <a href="<?php echo e(route('home'), false); ?>" class="logo">
      
      <span class="logo-lg"><?php echo e(Session::get('business.name'), false); ?> <i class="fa fa-circle text-success" id="online_indicator"></i></span> 

    </a>

    <!-- Header Navbar -->
    <nav class="navbar navbar-static-top" role="navigation">
      <!-- Sidebar toggle button-->
      <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
        &#9776;
        <span class="sr-only">Toggle navigation</span>
      </a>

      <?php if(Module::has('Superadmin')): ?>
        <?php if ($__env->exists('superadmin::layouts.partials.active_subscription')) echo $__env->make('superadmin::layouts.partials.active_subscription', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <?php endif; ?>

        <?php if(!empty(session('previous_user_id')) && !empty(session('previous_username'))): ?>
            <a href="<?php echo e(route('sign-in-as-user', session('previous_user_id')), false); ?>" class="btn btn-flat btn-danger m-8 btn-sm mt-10"><i class="fas fa-undo"></i> <?php echo app('translator')->get('lang_v1.back_to_username', ['username' => session('previous_username')] ); ?></a>
        <?php endif; ?>


          <!-- Content Header (Page header) -->
      <div class="vh-btn-group">
<div><section class="vh-welcome-title">
    <?php echo e(__('home.welcome_message', ['name' => Session::get('user.first_name')]), false); ?>

    </section></div>
    <div>
    <button 
		type="button" 
		class="vh-pos-btn-clk vh-pos-btn-2 vh-pos-btn-clc clock_in_btn	<?php if(!empty($clock_in)): ?> 	hide <?php endif; ?>	"
	    data-type="clock_in"
	    data-toggle="tooltip"
	    data-placement="bottom"
	    title="<?php echo app('translator')->get('essentials::lang.clock_in'); ?>" 
	    >
		<i class="fa fa-clock fa-beat"></i>&nbsp;Clock IN
	</button>
  <button 
		type="button" 
		class="vh-pos-btn-clk vh-pos-btn-3 vh-pos-btn-clc clock_out_btn	<?php if(empty($clock_in)): ?>	hide <?php endif; ?>	" 	
	    data-type="clock_out"
	    data-toggle="tooltip"
	    data-placement="bottom"
	    data-html="true"
	    title="<?php echo app('translator')->get('essentials::lang.clock_out'); ?> <?php if(!empty($clock_in)): ?>
                    <br>
                    <small>
                    	<b><?php echo app('translator')->get('essentials::lang.clocked_in_at'); ?>:</b> <?php echo e(\Carbon::createFromTimestamp(strtotime($clock_in->clock_in_time))->format(session('business.date_format') . ' ' . 'h:i A'), false); ?>

                    </small>
                    <br>
                    <small><b><?php echo app('translator')->get('essentials::lang.shift'); ?>:</b> <?php echo e(ucfirst($clock_in->shift_name), false); ?></small>
                    <?php if(!empty($clock_in->start_time) && !empty($clock_in->end_time)): ?>
                    	<br>
                    	<small>
                    		<b><?php echo app('translator')->get('restaurant.start_time'); ?>:</b> <?php echo e(\Carbon::createFromTimestamp(strtotime($clock_in->start_time))->format('h:i A'), false); ?><br>
                    		<b><?php echo app('translator')->get('restaurant.end_time'); ?>:</b> <?php echo e(\Carbon::createFromTimestamp(strtotime($clock_in->end_time))->format('h:i A'), false); ?>

                    	</small>
                    <?php endif; ?>
                <?php endif; ?>" 
	    >
	    <i class="fa fa-right-from-bracket fa-shake"></i>&nbsp;Clock OUT
	</button>
</div>
  </div>
<!-- Navbar Right Menu -->
      <div class="navbar-custom-menu">

        <?php if(Module::has('Essentials')): ?>
          <?php if ($__env->exists('essentials::layouts.partials.header_part')) echo $__env->make('essentials::layouts.partials.header_part', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <div class="btn-group">
          <a href="<?php echo e(route('calendar'), false); ?>"style="color: #000"><button 
		type="button" 
		class="vh-pos-btn-clk vh-pos-btn-2 vh-pos-btn-clc " 	
	     >
       
	    <i class="fa fa-calendar-plus"></i>&nbsp;Calendar
	</button></a></div>
 
        <?php if($request->segment(1) == 'pos'): ?>
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_cash_register')): ?>
          <button type="button" id="register_details" title="<?php echo e(__('cash_register.register_details'), false); ?>" data-toggle="tooltip" data-placement="bottom" class="btn btn-success btn-flat pull-left m-8 btn-sm mt-10 btn-modal" data-container=".register_details_modal" 
          data-href="<?php echo e(action([\App\Http\Controllers\CashRegisterController::class, 'getRegisterDetails']), false); ?>">
            <strong><i class="fa fa-briefcase fa-lg" aria-hidden="true"></i></strong>
          </button>
          <?php endif; ?>
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('close_cash_register')): ?>
          <button type="button" id="close_register" title="<?php echo e(__('cash_register.close_register'), false); ?>" data-toggle="tooltip" data-placement="bottom" class="btn btn-danger btn-flat pull-left m-8 btn-sm mt-10 btn-modal" data-container=".close_register_modal" 
          data-href="<?php echo e(action([\App\Http\Controllers\CashRegisterController::class, 'getCloseRegister']), false); ?>">
            <strong><i class="fa fa-window-close fa-lg"></i></strong>
          </button>
          <?php endif; ?>
        <?php endif; ?>

        <?php if(in_array('pos_sale', $enabled_modules)): ?>
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sell.create')): ?>
            <a href="<?php echo e(action([\App\Http\Controllers\SellPosController::class, 'create']), false); ?>" title="<?php echo app('translator')->get('sale.pos_sale'); ?>" data-toggle="tooltip" data-placement="bottom" class="vh-pos-btn-pos vh-pos-btn-pos">
              <strong><i class="fa fa-cash-register"></i> &nbsp; <?php echo app('translator')->get('sale.pos_sale'); ?></strong>
            </a>
          <?php endif; ?>
        <?php endif; ?>

        <?php if(Module::has('Repair')): ?>
          <?php if ($__env->exists('repair::layouts.partials.header')) echo $__env->make('repair::layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

       
   <!-- gokhan commented out -->
        <!-- <div class="m-8 pull-left mt-15 hidden-xs" style="color: #fff;"><strong><?php echo e(\Carbon::createFromTimestamp(strtotime('now'))->format(session('business.date_format')), false); ?></strong></div> -->

        <ul class="nav navbar-nav">
          <?php echo $__env->make('layouts.partials.header-notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          <!-- User Account Menu -->
          <li class="vh-pos-btn-profile-header dropdown user user-menu">
            <!-- Menu Toggle Button -->
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <!-- The user image in the navbar-->
              <?php
                $profile_photo = auth()->user()->media;
              ?>
              <?php if(!empty($profile_photo)): ?>
                <img src="<?php echo e($profile_photo->display_url, false); ?>" class="user-image" alt="User Image" style="width: 17px; display: none;">
              <?php endif; ?>
              <!-- hidden-xs hides the username on small devices so only the image appears. -->
              <span><?php echo e(Auth::User()->first_name, false); ?> <?php echo e(Auth::User()->last_name, false); ?></span>
            </a>
            <ul class="dropdown-menu">
              <!-- The user image in the menu -->
              <li class="user-header">
                <?php if(!empty(Session::get('business.logo'))): ?>
                  <img src="<?php echo e(asset( 'uploads/business_logos/' . Session::get('business.logo') ), false); ?>" alt="Logo" style="display: none;">
                <?php endif; ?>
                <p>
                  <?php echo e(Auth::User()->first_name, false); ?> <?php echo e(Auth::User()->last_name, false); ?>

                </p>
              </li>
              <!-- Menu Body -->
              <!-- Menu Footer-->
              <li class="user-footer">
                <div class="pull-left">
                  <a href="<?php echo e(action([\App\Http\Controllers\UserController::class, 'getProfile']), false); ?>" class="btn btn-default btn-flat"><?php echo app('translator')->get('lang_v1.profile'); ?></a>
                </div>
                <div class="pull-right">
                  <a href="<?php echo e(action([\App\Http\Controllers\Auth\LoginController::class, 'logout']), false); ?>" id="btn_logout" class="btn btn-default btn-flat"><?php echo app('translator')->get('lang_v1.sign_out'); ?></a>
                </div>
              </li>
            </ul>
            
          </li>
          <!-- Control Sidebar Toggle Button -->
        </ul>
      </div>
    </nav>
  </header><?php /**PATH /var/www/html/vhpos/resources/views/layouts/partials/header.blade.php ENDPATH**/ ?>