
<?php $__env->startSection('title', __('report.register_report')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(__('report.register_report'), false); ?></h1>
</section>
<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
              <?php echo Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'getStockReport']), 'method' => 'get', 'id' => 'register_report_filter_form' ]); ?>

                <div class="col-md-4">
                    <div class="form-group">
                        <?php echo Form::label('location_id',  __('business.business_location') . ':'); ?>

                        <?php echo Form::select('location_id', $location, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('messages.all')]); ?>

                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <?php echo Form::label('cash_register_list_id',  __('cash_register.cash_register_name') . ':'); ?>

                        <?php echo Form::select('cash_register_list_id', $crl, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('messages.all')]); ?>

                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <?php echo Form::label('register_user_id',  __('report.user') . ':'); ?>

                        <?php echo Form::select('register_user_id', $users, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('report.all_users')]); ?>

                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <?php echo Form::label('register_status',  __('sale.status') . ':'); ?>

                        <?php echo Form::select('register_status', ['open' => __('cash_register.open'), 'close' => __('cash_register.close')], null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('report.all')]); ?>

                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <?php echo Form::label('register_report_date_range', __('report.date_range') . ':'); ?>

                        <?php echo Form::text('register_report_date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'register_report_date_range', 'readonly']); ?>

                    </div>
                </div>
                <?php echo Form::close(); ?>

            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
                <?php if($payment_types): ?>
                    <?php $__currentLoopData = $payment_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                        
                        <input type="hidden" id="<?php echo e($key, false); ?>" value="<?php echo e($pt, false); ?>">
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                
                <table class="table table-bordered table-striped" id="register_report_table" style="width: 100%;">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('report.open_time'); ?></th>
                            <th><?php echo app('translator')->get('report.close_time'); ?></th>
                            <th><?php echo app('translator')->get('sale.location'); ?></th>
                            <th><?php echo app('translator')->get('cash_register.cash_register_name'); ?></th>
                            <th><?php echo app('translator')->get('report.user'); ?></th>
                            <th><?php echo app('translator')->get('cash_register.total_card_slips'); ?></th>
                            <th><?php echo app('translator')->get('cash_register.total_cheques'); ?></th>                            
                            <th><?php echo app('translator')->get('cash_register.total_cash'); ?></th>     
                            <th><?php echo app('translator')->get('lang_v1.total_bank_transfer'); ?></th>                                                   
                            <th><?php echo app('translator')->get('lang_v1.total_advance_payment'); ?></th>
                            <th><?php echo e($payment_types['custom_pay_1'], false); ?></th>
                            <th><?php echo e($payment_types['custom_pay_2'], false); ?></th>
                            <th><?php echo e($payment_types['custom_pay_3'], false); ?></th>
                            <th><?php echo e($payment_types['custom_pay_4'], false); ?></th>
                            <th><?php echo e($payment_types['custom_pay_5'], false); ?></th>
                            <th><?php echo e($payment_types['custom_pay_6'], false); ?></th>
                            <th><?php echo e($payment_types['custom_pay_7'], false); ?></th>
                            <th><?php echo e($payment_types['other'], false); ?></th>                            
                            <th><?php echo app('translator')->get('sale.total'); ?></th>
                            <th><?php echo app('translator')->get('messages.action'); ?></th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <td colspan="5"><strong><?php echo app('translator')->get('sale.total'); ?>:</strong></td>
                            <td class="footer_total_card_payment"></td>
                            <td class="footer_total_cheque_payment"></td>
                            <td class="footer_total_cash_payment"></td>
                            <td class="footer_total_bank_transfer_payment"></td>                            
                            <td class="footer_total_advance_payment"></td>
                            <td class="footer_total_custom_pay_1"></td>                                
                            <td class="footer_total_custom_pay_2"></td>
                            <td class="footer_total_custom_pay_3"></td>
                            <td class="footer_total_custom_pay_4"></td>
                            <td class="footer_total_custom_pay_5"></td>
                            <td class="footer_total_custom_pay_6"></td>
                            <td class="footer_total_custom_pay_7"></td>
                            <td class="footer_total_other_payments"></td>
                            <td class="footer_total"></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
</section>
<!-- /.content -->
<div class="modal fade view_register" style="overflow-y: auto;" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>
<div class="modal fade z_report_modal" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>

<?php if(true): ?>	
    <div class="numpad_div col-xs-12 hide" id="product_numpad_div1" data-type="cash" style="			
        /* display: flex; */
        /* align-items: center; */
        /* justify-content: center; */
        /* padding-right: 25px; */
        position: absolute;
        ">							
        <div class="form-group">									
            <div class="easy-numpad-number-container">
                <table id="product_numpad1">
                    <thead>						
                        <tr>
                            
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">1</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">2</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">3</a></td>							
                        </tr>
                        <tr>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">4</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">5</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">6</a></td>
                        </tr>
                        <tr>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">7</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">8</a></td>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">9</a></td>
                        </tr>						
                        <tr>
                            <td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">0</a></td>														
                            <td style="padding: 10px;"><a href="#" class="numPadCashOtherClear" id="numPadCashOtherClear" style="padding: 10px ; width: 90px !important; height: 70px !important;">Clr</a></td>
                            <td style="padding: 10px;"><a href="#" class="numPadCashOtherDel" id="numPadCashOtherDel" style="padding: 10px ; width: 90px !important; height: 70px !important;">DEL</a></td>									
                        </tr>
                    </thead>
                </table>
            </div>									
        </div>							
    </div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/report.js?v=' . $asset_v), false); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vhpos/resources/views/report/register_report.blade.php ENDPATH**/ ?>