<?php 
    $colspan = 15;
    $custom_labels = json_decode(session('business.custom_labels'), true);
?>
<!-- PALIGU-->

<table class="table table-bordered table-striped ajax_view hide-footer" id="product_table" style="width: 100%;">
    <thead>
        <tr>
            <th><input type="checkbox" id="select-all-row" data-table-id="product_table"></th>
            <th>&nbsp;</th>
            <th><?php echo app('translator')->get('messages.action'); ?></th>
            <th><?php echo app('translator')->get('sale.product'); ?></th>
            <th><?php echo app('translator')->get('business.business_location'); ?> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.product_business_location_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?></th>
            
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('access_default_selling_price')): ?>
                <?php 
                    $colspan++;
                ?>
                <th><?php echo app('translator')->get('lang_v1.selling_price'); ?></th>
            <?php endif; ?>
            <th><?php echo app('translator')->get('report.total_stock'); ?></th>
            
            <th><?php echo app('translator')->get('product.category'); ?></th>
            <th><?php echo app('translator')->get('product.brand'); ?></th>
            
            <th><?php echo app('translator')->get('product.sku'); ?></th>
            
        </tr>
    </thead>
    <tfoot>
        <tr>
            <td colspan="9">
            <div style="display: flex; width: 100%;">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.delete')): ?>
                    <?php echo Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDestroy']), 'method' => 'post', 'id' => 'mass_delete_form' ]); ?>

                    <?php echo Form::hidden('selected_rows', null, ['id' => 'selected_rows']); ?>

                    <?php echo Form::submit(__('lang_v1.delete_selected'), array('class' => 'btn btn-xs btn-danger', 'id' => 'delete-selected')); ?>

                    <?php echo Form::close(); ?>

                <?php endif; ?>

                
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.update')): ?>
                    
                        <?php if(config('constants.enable_product_bulk_edit')): ?>
                            &nbsp;
                            <?php echo Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'bulkEdit']), 'method' => 'post', 'id' => 'bulk_edit_form' ]); ?>

                            <?php echo Form::hidden('selected_products', null, ['id' => 'selected_products_for_edit']); ?>

                            <button type="submit" class="btn btn-xs btn-primary" id="edit-selected"> <i class="fa fa-edit"></i><?php echo e(__('lang_v1.bulk_edit'), false); ?></button>
                            <?php echo Form::close(); ?>

                        <?php endif; ?>
                        &nbsp;
                        <button type="button" class="btn btn-xs btn-success update_product_location" data-type="add"><?php echo app('translator')->get('lang_v1.add_to_location'); ?></button>
                        &nbsp;
                        <button type="button" class="btn btn-xs bg-navy update_product_location" data-type="remove"><?php echo app('translator')->get('lang_v1.remove_from_location'); ?></button>
                    <?php endif; ?>
                
                &nbsp;
                <?php echo Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDeactivate']), 'method' => 'post', 'id' => 'mass_deactivate_form' ]); ?>

                <?php echo Form::hidden('selected_products', null, ['id' => 'selected_products']); ?>

                <?php echo Form::submit(__('lang_v1.deactivate_selected'), array('class' => 'btn btn-xs btn-warning', 'id' => 'deactivate-selected')); ?>

                <?php echo Form::close(); ?> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.deactive_product_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                &nbsp;
                <?php if($is_woocommerce): ?>
                    <button type="button" class="btn btn-xs btn-warning toggle_woocomerce_sync">
                        <?php echo app('translator')->get('lang_v1.woocommerce_sync'); ?>
                    </button>
                <?php endif; ?>
                </div>
            </td>
        </tr>
    </tfoot>
</table>
<?php /**PATH C:\xampp\htdocs\vhpos\resources\views/product/partials/product_list.blade.php ENDPATH**/ ?>